/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.client.model.geometry.IModelGeometryPart;
import net.minecraftforge.common.model.IModelState;

public class BlockModelConfiguration
implements IModelConfiguration {
    public final BlockModel owner;
    public final VisibilityData visibilityData = new VisibilityData();
    @Nullable
    private IModelGeometry<?> customGeometry;
    @Nullable
    private IModelState customModelState;

    public BlockModelConfiguration(BlockModel owner) {
        this.owner = owner;
    }

    @Override
    @Nullable
    public IUnbakedModel getOwnerModel() {
        return this.owner;
    }

    @Override
    public String getModelName() {
        return this.owner.field_178317_b;
    }

    public boolean hasCustomGeometry() {
        return this.getCustomGeometry() != null;
    }

    @Nullable
    public IModelGeometry<?> getCustomGeometry() {
        return this.owner.field_178315_d != null && this.customGeometry == null ? this.owner.field_178315_d.customData.getCustomGeometry() : this.customGeometry;
    }

    public void setCustomGeometry(IModelGeometry<?> geometry) {
        this.customGeometry = geometry;
    }

    @Nullable
    public IModelState getCustomModelState() {
        return this.owner.field_178315_d != null && this.customModelState == null ? this.owner.field_178315_d.customData.getCustomModelState() : this.customModelState;
    }

    public void setCustomModelState(IModelState modelState) {
        this.customModelState = modelState;
    }

    @Override
    public boolean getPartVisibility(IModelGeometryPart part, boolean fallback) {
        return this.owner.field_178315_d != null && !this.visibilityData.hasCustomVisibility(part) ? this.owner.field_178315_d.customData.getPartVisibility(part, fallback) : this.visibilityData.isVisible(part, fallback);
    }

    @Override
    public boolean isTexturePresent(String name) {
        return this.owner.func_178300_b(name);
    }

    @Override
    public String resolveTexture(String name) {
        return this.owner.func_178308_c(name);
    }

    @Override
    public boolean isShadedInGui() {
        return this.owner.func_178311_c();
    }

    @Override
    public boolean useSmoothLighting() {
        return this.owner.func_178309_b();
    }

    @Override
    public ItemCameraTransforms getCameraTransforms() {
        return this.owner.func_181682_g();
    }

    @Override
    public IModelState getCombinedState() {
        IModelState state = this.getCustomModelState();
        return state != null ? new SimpleModelState(PerspectiveMapWrapper.getTransformsWithFallback(state, this.getCameraTransforms()), state.apply(Optional.empty())) : new SimpleModelState(PerspectiveMapWrapper.getTransforms(this.getCameraTransforms()));
    }

    public void copyFrom(BlockModelConfiguration other) {
        this.customGeometry = other.customGeometry;
        this.customModelState = other.customModelState;
        this.visibilityData.copyFrom(other.visibilityData);
    }

    public Collection<ResourceLocation> getTextureDependencies(Function<ResourceLocation, IUnbakedModel> modelGetter, Set<String> missingTextureErrors) {
        IModelGeometry<?> geometry = this.getCustomGeometry();
        return geometry == null ? Collections.emptySet() : geometry.getTextureDependencies(this, modelGetter, missingTextureErrors);
    }

    public IBakedModel bake(ModelBakery bakery, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter, ISprite sprite, VertexFormat format, ItemOverrideList overrides) {
        IModelGeometry<?> geometry = this.getCustomGeometry();
        if (geometry == null) {
            throw new IllegalStateException("Can not use custom baking without custom geometry");
        }
        return geometry.bake(this, bakery, bakedTextureGetter, sprite, format, overrides);
    }

    public static class VisibilityData {
        private final Map<String, Boolean> data = new HashMap<String, Boolean>();

        public boolean hasCustomVisibility(IModelGeometryPart part) {
            return this.data.containsKey(part.name());
        }

        public boolean isVisible(IModelGeometryPart part, boolean fallback) {
            return this.data.getOrDefault(part.name(), fallback);
        }

        public void setVisibilityState(String partName, boolean type) {
            this.data.put(partName, type);
        }

        public void copyFrom(VisibilityData visibilityData) {
            this.data.clear();
            this.data.putAll(visibilityData.data);
        }
    }
}

