/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NewMultiLayerModel
implements IModelGeometry<NewMultiLayerModel> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ImmutableMap<BlockRenderLayer, IUnbakedModel> models;

    public NewMultiLayerModel(ImmutableMap<BlockRenderLayer, IUnbakedModel> models) {
        this.models = models;
    }

    @Override
    public Collection<ResourceLocation> getTextureDependencies(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<String> missingTextureErrors) {
        HashSet materials = Sets.newHashSet();
        materials.add(new ResourceLocation(owner.resolveTexture("particle")));
        for (IUnbakedModel m : this.models.values()) {
            materials.addAll(m.func_209559_a(modelGetter, missingTextureErrors));
        }
        return materials;
    }

    private static ImmutableMap<BlockRenderLayer, IBakedModel> buildModels(ImmutableMap<BlockRenderLayer, IUnbakedModel> models, ISprite sprite, ModelBakery bakery, Function<ResourceLocation, TextureAtlasSprite> spriteGetter, VertexFormat format) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : models.entrySet()) {
            builder.put(entry.getKey(), (Object)((IUnbakedModel)entry.getValue()).bake(bakery, spriteGetter, sprite, format));
        }
        return builder.build();
    }

    @Override
    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<ResourceLocation, TextureAtlasSprite> spriteGetter, ISprite sprite, VertexFormat format, ItemOverrideList overrides) {
        IUnbakedModel missing = ModelLoaderRegistry.getMissingModel();
        return new MultiLayerBakedModel(owner.useSmoothLighting(), owner.isShadedInGui(), spriteGetter.apply(new ResourceLocation(owner.resolveTexture("particle"))), overrides, NewMultiLayerModel.buildModels(this.models, sprite, bakery, spriteGetter, format), missing.bake(bakery, spriteGetter, sprite, format), PerspectiveMapWrapper.getTransforms(new ModelStateComposition(owner.getCombinedState(), sprite.getState())));
    }

    public static final class Loader
    implements IModelLoader<NewMultiLayerModel> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        @Override
        public void func_195410_a(IResourceManager resourceManager) {
        }

        @Override
        public NewMultiLayerModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            JsonObject layersObject = JSONUtils.func_152754_s((JsonObject)modelContents, (String)"layers");
            for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                String layerName = layer.toString();
                if (!layersObject.has(layerName)) continue;
                builder.put((Object)layer, deserializationContext.deserialize((JsonElement)JSONUtils.func_152754_s((JsonObject)layersObject, (String)layerName), BlockModel.class));
            }
            ImmutableMap models = builder.build();
            return new NewMultiLayerModel((ImmutableMap<BlockRenderLayer, IUnbakedModel>)models);
        }
    }

    private static final class MultiLayerBakedModel
    implements IBakedModel {
        private final ImmutableMap<BlockRenderLayer, IBakedModel> models;
        private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> cameraTransforms;
        protected final boolean ambientOcclusion;
        protected final boolean gui3d;
        protected final TextureAtlasSprite particle;
        protected final ItemOverrideList overrides;
        private final IBakedModel missing;

        public MultiLayerBakedModel(boolean ambientOcclusion, boolean isGui3d, TextureAtlasSprite particle, ItemOverrideList overrides, ImmutableMap<BlockRenderLayer, IBakedModel> models, IBakedModel missing, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> cameraTransforms) {
            this.models = models;
            this.cameraTransforms = cameraTransforms;
            this.missing = missing;
            this.ambientOcclusion = ambientOcclusion;
            this.gui3d = isGui3d;
            this.particle = particle;
            this.overrides = overrides;
        }

        public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
            return this.getQuads(state, side, rand, EmptyModelData.INSTANCE);
        }

        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
            BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
            if (layer == null) {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (IBakedModel model : this.models.values()) {
                    builder.addAll((Iterable)model.func_200117_a(state, side, rand));
                }
                return builder.build();
            }
            return ((IBakedModel)this.models.getOrDefault((Object)layer, (Object)this.missing)).getQuads(state, side, rand, extraData);
        }

        public boolean func_177555_b() {
            return this.ambientOcclusion;
        }

        public boolean isAmbientOcclusion(BlockState state) {
            return this.ambientOcclusion;
        }

        public boolean func_177556_c() {
            return this.gui3d;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.particle;
        }

        public boolean doesHandlePerspectives() {
            return true;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.cameraTransforms, cameraTransformType);
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }
    }
}

