/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.geometry;

import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.ISprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.geometry.IModelGeometry;

public interface ISimpleModelGeometry<T extends ISimpleModelGeometry<T>>
extends IModelGeometry<T> {
    @Override
    default public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<ResourceLocation, TextureAtlasSprite> spriteGetter, ISprite sprite, VertexFormat format, ItemOverrideList overrides) {
        TextureAtlasSprite particle = spriteGetter.apply(new ResourceLocation(owner.resolveTexture("particle")));
        IModelBuilder<?> builder = IModelBuilder.of(owner, overrides, particle);
        this.addQuads(owner, builder, bakery, spriteGetter, sprite, format);
        return builder.build();
    }

    public void addQuads(IModelConfiguration var1, IModelBuilder<?> var2, ModelBakery var3, Function<ResourceLocation, TextureAtlasSprite> var4, ISprite var5, VertexFormat var6);

    @Override
    public Collection<ResourceLocation> getTextureDependencies(IModelConfiguration var1, Function<ResourceLocation, IUnbakedModel> var2, Set<String> var3);
}

