/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.items;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.DropperBlock;
import net.minecraft.block.HopperBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.DispenserTileEntity;
import net.minecraft.tileentity.HopperTileEntity;
import net.minecraft.tileentity.IHopper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class VanillaInventoryCodeHooks {
    @Nullable
    public static Boolean extractHook(IHopper dest) {
        return VanillaInventoryCodeHooks.getItemHandler(dest, Direction.UP).map(itemHandlerResult -> {
            IItemHandler handler = (IItemHandler)itemHandlerResult.getKey();
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack extractItem = handler.extractItem(i, 1, true);
                if (extractItem.func_190926_b()) continue;
                for (int j = 0; j < dest.func_70302_i_(); ++j) {
                    ItemStack destStack = dest.func_70301_a(j);
                    if (!dest.func_94041_b(j, extractItem) || !destStack.func_190926_b() && (destStack.func_190916_E() >= destStack.func_77976_d() || destStack.func_190916_E() >= dest.func_70297_j_() || !ItemHandlerHelper.canItemStacksStack(extractItem, destStack))) continue;
                    extractItem = handler.extractItem(i, 1, false);
                    if (destStack.func_190926_b()) {
                        dest.func_70299_a(j, extractItem);
                    } else {
                        destStack.func_190917_f(1);
                        dest.func_70299_a(j, destStack);
                    }
                    dest.func_70296_d();
                    return true;
                }
            }
            return false;
        }).orElse(null);
    }

    public static boolean dropperInsertHook(World world, BlockPos pos, DispenserTileEntity dropper, int slot, @Nonnull ItemStack stack) {
        Direction enumfacing = (Direction)world.func_180495_p(pos).func_177229_b((IProperty)DropperBlock.field_176441_a);
        BlockPos blockpos = pos.func_177972_a(enumfacing);
        return VanillaInventoryCodeHooks.getItemHandler(world, blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p(), enumfacing.func_176734_d()).map(destinationResult -> {
            ItemStack dispensedStack;
            IItemHandler itemHandler = (IItemHandler)destinationResult.getKey();
            Object destination = destinationResult.getValue();
            ItemStack remainder = VanillaInventoryCodeHooks.putStackInInventoryAllSlots((TileEntity)dropper, destination, itemHandler, dispensedStack = stack.func_77946_l().func_77979_a(1));
            if (remainder.func_190926_b()) {
                remainder = stack.func_77946_l();
                remainder.func_190918_g(1);
            } else {
                remainder = stack.func_77946_l();
            }
            dropper.func_70299_a(slot, remainder);
            return false;
        }).orElse(true);
    }

    public static boolean insertHook(HopperTileEntity hopper) {
        Direction hopperFacing = (Direction)hopper.func_195044_w().func_177229_b((IProperty)HopperBlock.field_176430_a);
        return VanillaInventoryCodeHooks.getItemHandler((IHopper)hopper, hopperFacing).map(destinationResult -> {
            IItemHandler itemHandler = (IItemHandler)destinationResult.getKey();
            Object destination = destinationResult.getValue();
            if (VanillaInventoryCodeHooks.isFull(itemHandler)) {
                return false;
            }
            for (int i = 0; i < hopper.func_70302_i_(); ++i) {
                if (hopper.func_70301_a(i).func_190926_b()) continue;
                ItemStack originalSlotContents = hopper.func_70301_a(i).func_77946_l();
                ItemStack insertStack = hopper.func_70298_a(i, 1);
                ItemStack remainder = VanillaInventoryCodeHooks.putStackInInventoryAllSlots((TileEntity)hopper, destination, itemHandler, insertStack);
                if (remainder.func_190926_b()) {
                    return true;
                }
                hopper.func_70299_a(i, originalSlotContents);
            }
            return false;
        }).orElse(false);
    }

    private static ItemStack putStackInInventoryAllSlots(TileEntity source, Object destination, IItemHandler destInventory, ItemStack stack) {
        for (int slot = 0; slot < destInventory.getSlots() && !stack.func_190926_b(); ++slot) {
            stack = VanillaInventoryCodeHooks.insertStack(source, destination, destInventory, stack, slot);
        }
        return stack;
    }

    private static ItemStack insertStack(TileEntity source, Object destination, IItemHandler destInventory, ItemStack stack, int slot) {
        ItemStack itemstack = destInventory.getStackInSlot(slot);
        if (destInventory.insertItem(slot, stack, true).func_190926_b()) {
            HopperTileEntity destinationHopper;
            boolean insertedItem = false;
            boolean inventoryWasEmpty = VanillaInventoryCodeHooks.isEmpty(destInventory);
            if (itemstack.func_190926_b()) {
                destInventory.insertItem(slot, stack, false);
                stack = ItemStack.field_190927_a;
                insertedItem = true;
            } else if (ItemHandlerHelper.canItemStacksStack(itemstack, stack)) {
                int originalSize = stack.func_190916_E();
                boolean bl = insertedItem = originalSize < (stack = destInventory.insertItem(slot, stack, false)).func_190916_E();
            }
            if (insertedItem && inventoryWasEmpty && destination instanceof HopperTileEntity && !(destinationHopper = (HopperTileEntity)destination).func_174914_o()) {
                int k = 0;
                destinationHopper.func_145896_c(8 - k);
            }
        }
        return stack;
    }

    private static LazyOptional<Pair<IItemHandler, Object>> getItemHandler(IHopper hopper, Direction hopperFacing) {
        double x = hopper.func_96107_aA() + (double)hopperFacing.func_82601_c();
        double y = hopper.func_96109_aB() + (double)hopperFacing.func_96559_d();
        double z = hopper.func_96108_aC() + (double)hopperFacing.func_82599_e();
        return VanillaInventoryCodeHooks.getItemHandler(hopper.func_145831_w(), x, y, z, hopperFacing.func_176734_d());
    }

    private static boolean isFull(IItemHandler itemHandler) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(slot);
            if (!stackInSlot.func_190926_b() && stackInSlot.func_190916_E() == stackInSlot.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    private static boolean isEmpty(IItemHandler itemHandler) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(slot);
            if (stackInSlot.func_190916_E() <= 0) continue;
            return false;
        }
        return true;
    }

    public static LazyOptional<Pair<IItemHandler, Object>> getItemHandler(World worldIn, double x, double y, double z, Direction side) {
        TileEntity tileentity;
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)x);
        BlockPos blockpos = new BlockPos(i, j = MathHelper.func_76128_c((double)y), k = MathHelper.func_76128_c((double)z));
        BlockState state = worldIn.func_180495_p(blockpos);
        if (state.hasTileEntity() && (tileentity = worldIn.func_175625_s(blockpos)) != null) {
            return tileentity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).map(capability -> ImmutablePair.of((Object)capability, (Object)tileentity));
        }
        return LazyOptional.empty();
    }
}

