/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementList;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.AdvancementTreeNode;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.EnumTypeAdapterFactory;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraftforge.common.crafting.ConditionalAdvancement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdvancementManager
extends JsonReloadListener {
    private static final Logger field_192782_a = LogManager.getLogger();
    private static final Gson field_192783_b = new GsonBuilder().registerTypeHierarchyAdapter(Advancement.Builder.class, (p_210124_0_, p_210124_1_, p_210124_2_) -> {
        JsonObject jsonobject = JSONUtils.func_151210_l((JsonElement)p_210124_0_, (String)"advancement");
        return Advancement.Builder.func_192059_a((JsonObject)jsonobject, (JsonDeserializationContext)p_210124_2_);
    }).registerTypeAdapter(AdvancementRewards.class, (Object)new AdvancementRewards.Deserializer()).registerTypeHierarchyAdapter(ITextComponent.class, (Object)new ITextComponent.Serializer()).registerTypeHierarchyAdapter(Style.class, (Object)new Style.Serializer()).registerTypeAdapterFactory((TypeAdapterFactory)new EnumTypeAdapterFactory()).create();
    private AdvancementList field_223388_c = new AdvancementList();

    public AdvancementManager() {
        super(field_192783_b, "advancements");
    }

    protected void func_212853_a_(Map<ResourceLocation, JsonObject> splashList, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        HashMap map = Maps.newHashMap();
        splashList.forEach((p_223387_1_, p_223387_2_) -> {
            try {
                Advancement.Builder advancement$builder = ConditionalAdvancement.read((Gson)field_192783_b, (ResourceLocation)p_223387_1_, (JsonObject)p_223387_2_);
                if (advancement$builder == null) {
                    field_192782_a.info("Skipping loading advancement {} as it's conditions were not met", p_223387_1_);
                    return;
                }
                map.put(p_223387_1_, advancement$builder);
            }
            catch (JsonParseException | IllegalArgumentException jsonparseexception) {
                field_192782_a.error("Parsing error loading custom advancement {}: {}", p_223387_1_, (Object)jsonparseexception.getMessage());
            }
        });
        AdvancementList advancementlist = new AdvancementList();
        advancementlist.func_192083_a(map);
        for (Advancement advancement : advancementlist.func_192088_b()) {
            if (advancement.func_192068_c() == null) continue;
            AdvancementTreeNode.func_192323_a((Advancement)advancement);
        }
        this.field_223388_c = advancementlist;
    }

    @Nullable
    public Advancement func_192778_a(ResourceLocation id) {
        return this.field_223388_c.func_192084_a(id);
    }

    public Collection<Advancement> func_195438_b() {
        return this.field_223388_c.func_195651_c();
    }
}

