/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.BlockState;
import net.minecraft.state.properties.RailShape;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class RailState {
    private final World field_196920_a;
    private final BlockPos field_196921_b;
    private final AbstractRailBlock field_196922_c;
    private BlockState field_196923_d;
    private final boolean field_208513_e;
    private final List<BlockPos> field_196924_e = Lists.newArrayList();
    private final boolean canMakeSlopes;

    public RailState(World p_i47755_1_, BlockPos p_i47755_2_, BlockState p_i47755_3_) {
        this.field_196920_a = p_i47755_1_;
        this.field_196921_b = p_i47755_2_;
        this.field_196923_d = p_i47755_3_;
        this.field_196922_c = (AbstractRailBlock)p_i47755_3_.func_177230_c();
        RailShape railshape = this.field_196922_c.getRailDirection(this.field_196923_d, (IBlockReader)p_i47755_1_, p_i47755_2_, null);
        this.field_208513_e = !this.field_196922_c.isFlexibleRail(this.field_196923_d, (IBlockReader)p_i47755_1_, p_i47755_2_);
        this.canMakeSlopes = this.field_196922_c.canMakeSlopes(this.field_196923_d, (IBlockReader)p_i47755_1_, p_i47755_2_);
        this.func_208509_a(railshape);
    }

    public List<BlockPos> func_196907_a() {
        return this.field_196924_e;
    }

    private void func_208509_a(RailShape p_208509_1_) {
        this.field_196924_e.clear();
        switch (p_208509_1_) {
            case NORTH_SOUTH: {
                this.field_196924_e.add(this.field_196921_b.func_177978_c());
                this.field_196924_e.add(this.field_196921_b.func_177968_d());
                break;
            }
            case EAST_WEST: {
                this.field_196924_e.add(this.field_196921_b.func_177976_e());
                this.field_196924_e.add(this.field_196921_b.func_177974_f());
                break;
            }
            case ASCENDING_EAST: {
                this.field_196924_e.add(this.field_196921_b.func_177976_e());
                this.field_196924_e.add(this.field_196921_b.func_177974_f().func_177984_a());
                break;
            }
            case ASCENDING_WEST: {
                this.field_196924_e.add(this.field_196921_b.func_177976_e().func_177984_a());
                this.field_196924_e.add(this.field_196921_b.func_177974_f());
                break;
            }
            case ASCENDING_NORTH: {
                this.field_196924_e.add(this.field_196921_b.func_177978_c().func_177984_a());
                this.field_196924_e.add(this.field_196921_b.func_177968_d());
                break;
            }
            case ASCENDING_SOUTH: {
                this.field_196924_e.add(this.field_196921_b.func_177978_c());
                this.field_196924_e.add(this.field_196921_b.func_177968_d().func_177984_a());
                break;
            }
            case SOUTH_EAST: {
                this.field_196924_e.add(this.field_196921_b.func_177974_f());
                this.field_196924_e.add(this.field_196921_b.func_177968_d());
                break;
            }
            case SOUTH_WEST: {
                this.field_196924_e.add(this.field_196921_b.func_177976_e());
                this.field_196924_e.add(this.field_196921_b.func_177968_d());
                break;
            }
            case NORTH_WEST: {
                this.field_196924_e.add(this.field_196921_b.func_177976_e());
                this.field_196924_e.add(this.field_196921_b.func_177978_c());
                break;
            }
            case NORTH_EAST: {
                this.field_196924_e.add(this.field_196921_b.func_177974_f());
                this.field_196924_e.add(this.field_196921_b.func_177978_c());
            }
        }
    }

    private void func_196903_f() {
        for (int i = 0; i < this.field_196924_e.size(); ++i) {
            RailState railstate = this.func_196908_a(this.field_196924_e.get(i));
            if (railstate != null && railstate.func_196919_b(this)) {
                this.field_196924_e.set(i, railstate.field_196921_b);
                continue;
            }
            this.field_196924_e.remove(i--);
        }
    }

    private boolean func_196902_d(BlockPos p_196902_1_) {
        return AbstractRailBlock.func_208488_a(this.field_196920_a, p_196902_1_) || AbstractRailBlock.func_208488_a(this.field_196920_a, p_196902_1_.func_177984_a()) || AbstractRailBlock.func_208488_a(this.field_196920_a, p_196902_1_.func_177977_b());
    }

    @Nullable
    private RailState func_196908_a(BlockPos p_196908_1_) {
        BlockState blockstate = this.field_196920_a.func_180495_p(p_196908_1_);
        if (AbstractRailBlock.func_208487_j(blockstate)) {
            return new RailState(this.field_196920_a, p_196908_1_, blockstate);
        }
        BlockPos lvt_2_1_ = p_196908_1_.func_177984_a();
        blockstate = this.field_196920_a.func_180495_p(lvt_2_1_);
        if (AbstractRailBlock.func_208487_j(blockstate)) {
            return new RailState(this.field_196920_a, lvt_2_1_, blockstate);
        }
        lvt_2_1_ = p_196908_1_.func_177977_b();
        blockstate = this.field_196920_a.func_180495_p(lvt_2_1_);
        return AbstractRailBlock.func_208487_j(blockstate) ? new RailState(this.field_196920_a, lvt_2_1_, blockstate) : null;
    }

    private boolean func_196919_b(RailState p_196919_1_) {
        return this.func_196904_b(p_196919_1_.field_196921_b);
    }

    private boolean func_196904_b(BlockPos p_196904_1_) {
        for (int i = 0; i < this.field_196924_e.size(); ++i) {
            BlockPos blockpos = this.field_196924_e.get(i);
            if (blockpos.func_177958_n() != p_196904_1_.func_177958_n() || blockpos.func_177952_p() != p_196904_1_.func_177952_p()) continue;
            return true;
        }
        return false;
    }

    protected int func_196910_b() {
        int i = 0;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!this.func_196902_d(this.field_196921_b.func_177972_a(direction))) continue;
            ++i;
        }
        return i;
    }

    private boolean func_196905_c(RailState p_196905_1_) {
        return this.func_196919_b(p_196905_1_) || this.field_196924_e.size() != 2;
    }

    private void func_208510_c(RailState p_208510_1_) {
        this.field_196924_e.add(p_208510_1_.field_196921_b);
        BlockPos blockpos = this.field_196921_b.func_177978_c();
        BlockPos blockpos1 = this.field_196921_b.func_177968_d();
        BlockPos blockpos2 = this.field_196921_b.func_177976_e();
        BlockPos blockpos3 = this.field_196921_b.func_177974_f();
        boolean flag = this.func_196904_b(blockpos);
        boolean flag1 = this.func_196904_b(blockpos1);
        boolean flag2 = this.func_196904_b(blockpos2);
        boolean flag3 = this.func_196904_b(blockpos3);
        RailShape railshape = null;
        if (flag || flag1) {
            railshape = RailShape.NORTH_SOUTH;
        }
        if (flag2 || flag3) {
            railshape = RailShape.EAST_WEST;
        }
        if (!this.field_208513_e) {
            if (flag1 && flag3 && !flag && !flag2) {
                railshape = RailShape.SOUTH_EAST;
            }
            if (flag1 && flag2 && !flag && !flag3) {
                railshape = RailShape.SOUTH_WEST;
            }
            if (flag && flag2 && !flag1 && !flag3) {
                railshape = RailShape.NORTH_WEST;
            }
            if (flag && flag3 && !flag1 && !flag2) {
                railshape = RailShape.NORTH_EAST;
            }
        }
        if (railshape == RailShape.NORTH_SOUTH && this.canMakeSlopes) {
            if (AbstractRailBlock.func_208488_a(this.field_196920_a, blockpos.func_177984_a())) {
                railshape = RailShape.ASCENDING_NORTH;
            }
            if (AbstractRailBlock.func_208488_a(this.field_196920_a, blockpos1.func_177984_a())) {
                railshape = RailShape.ASCENDING_SOUTH;
            }
        }
        if (railshape == RailShape.EAST_WEST && this.canMakeSlopes) {
            if (AbstractRailBlock.func_208488_a(this.field_196920_a, blockpos3.func_177984_a())) {
                railshape = RailShape.ASCENDING_EAST;
            }
            if (AbstractRailBlock.func_208488_a(this.field_196920_a, blockpos2.func_177984_a())) {
                railshape = RailShape.ASCENDING_WEST;
            }
        }
        if (railshape == null) {
            railshape = RailShape.NORTH_SOUTH;
        }
        this.field_196923_d = (BlockState)((Object)this.field_196923_d.func_206870_a(this.field_196922_c.func_176560_l(), (Comparable)railshape));
        this.field_196920_a.func_180501_a(this.field_196921_b, this.field_196923_d, 3);
    }

    private boolean func_208512_d(BlockPos p_208512_1_) {
        RailState railstate = this.func_196908_a(p_208512_1_);
        if (railstate == null) {
            return false;
        }
        railstate.func_196903_f();
        return railstate.func_196905_c(this);
    }

    public RailState func_208511_a(boolean powered, boolean placing) {
        BlockPos blockpos = this.field_196921_b.func_177978_c();
        BlockPos blockpos1 = this.field_196921_b.func_177968_d();
        BlockPos blockpos2 = this.field_196921_b.func_177976_e();
        BlockPos blockpos3 = this.field_196921_b.func_177974_f();
        boolean flag = this.func_208512_d(blockpos);
        boolean flag1 = this.func_208512_d(blockpos1);
        boolean flag2 = this.func_208512_d(blockpos2);
        boolean flag3 = this.func_208512_d(blockpos3);
        RailShape railshape = null;
        if ((flag || flag1) && !flag2 && !flag3) {
            railshape = RailShape.NORTH_SOUTH;
        }
        if ((flag2 || flag3) && !flag && !flag1) {
            railshape = RailShape.EAST_WEST;
        }
        if (!this.field_208513_e) {
            if (flag1 && flag3 && !flag && !flag2) {
                railshape = RailShape.SOUTH_EAST;
            }
            if (flag1 && flag2 && !flag && !flag3) {
                railshape = RailShape.SOUTH_WEST;
            }
            if (flag && flag2 && !flag1 && !flag3) {
                railshape = RailShape.NORTH_WEST;
            }
            if (flag && flag3 && !flag1 && !flag2) {
                railshape = RailShape.NORTH_EAST;
            }
        }
        if (railshape == null) {
            if (flag || flag1) {
                railshape = RailShape.NORTH_SOUTH;
            }
            if (flag2 || flag3) {
                railshape = RailShape.EAST_WEST;
            }
            if (!this.field_208513_e) {
                if (powered) {
                    if (flag1 && flag3) {
                        railshape = RailShape.SOUTH_EAST;
                    }
                    if (flag2 && flag1) {
                        railshape = RailShape.SOUTH_WEST;
                    }
                    if (flag3 && flag) {
                        railshape = RailShape.NORTH_EAST;
                    }
                    if (flag && flag2) {
                        railshape = RailShape.NORTH_WEST;
                    }
                } else {
                    if (flag && flag2) {
                        railshape = RailShape.NORTH_WEST;
                    }
                    if (flag3 && flag) {
                        railshape = RailShape.NORTH_EAST;
                    }
                    if (flag2 && flag1) {
                        railshape = RailShape.SOUTH_WEST;
                    }
                    if (flag1 && flag3) {
                        railshape = RailShape.SOUTH_EAST;
                    }
                }
            }
        }
        if (railshape == RailShape.NORTH_SOUTH && this.canMakeSlopes) {
            if (AbstractRailBlock.func_208488_a(this.field_196920_a, blockpos.func_177984_a())) {
                railshape = RailShape.ASCENDING_NORTH;
            }
            if (AbstractRailBlock.func_208488_a(this.field_196920_a, blockpos1.func_177984_a())) {
                railshape = RailShape.ASCENDING_SOUTH;
            }
        }
        if (railshape == RailShape.EAST_WEST && this.canMakeSlopes) {
            if (AbstractRailBlock.func_208488_a(this.field_196920_a, blockpos3.func_177984_a())) {
                railshape = RailShape.ASCENDING_EAST;
            }
            if (AbstractRailBlock.func_208488_a(this.field_196920_a, blockpos2.func_177984_a())) {
                railshape = RailShape.ASCENDING_WEST;
            }
        }
        if (railshape == null) {
            railshape = RailShape.NORTH_SOUTH;
        }
        this.func_208509_a(railshape);
        this.field_196923_d = (BlockState)((Object)this.field_196923_d.func_206870_a(this.field_196922_c.func_176560_l(), (Comparable)railshape));
        if (placing || this.field_196920_a.func_180495_p(this.field_196921_b) != this.field_196923_d) {
            this.field_196920_a.func_180501_a(this.field_196921_b, this.field_196923_d, 3);
            for (int i = 0; i < this.field_196924_e.size(); ++i) {
                RailState railstate = this.func_196908_a(this.field_196924_e.get(i));
                if (railstate == null) continue;
                railstate.func_196903_f();
                if (!railstate.func_196905_c(this)) continue;
                railstate.func_208510_c(this);
            }
        }
        return this;
    }

    public BlockState func_196916_c() {
        return this.field_196923_d;
    }
}

