/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import java.util.Random;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.ChestRenderer;
import net.minecraft.client.renderer.FluidBlockRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.fluid.IFluidState;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.ForgeBlockModelRenderer;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.VanillaResourceType;

@OnlyIn(value=Dist.CLIENT)
public class BlockRendererDispatcher
implements IResourceManagerReloadListener {
    private final BlockModelShapes field_175028_a;
    private final BlockModelRenderer field_175027_c;
    private final ChestRenderer field_175024_d = new ChestRenderer();
    private final FluidBlockRenderer field_175025_e;
    private final Random field_195476_e = new Random();

    public BlockRendererDispatcher(BlockModelShapes p_i46577_1_, BlockColors p_i46577_2_) {
        this.field_175028_a = p_i46577_1_;
        this.field_175027_c = new ForgeBlockModelRenderer(p_i46577_2_);
        this.field_175025_e = new FluidBlockRenderer();
    }

    public BlockModelShapes func_175023_a() {
        return this.field_175028_a;
    }

    public void func_215329_a(BlockState state, BlockPos pos, TextureAtlasSprite sprite, IEnviromentBlockReader reader) {
        if (state.func_185901_i() == BlockRenderType.MODEL) {
            IBakedModel ibakedmodel = this.field_175028_a.func_178125_b(state);
            long i = state.func_209533_a(pos);
            IBakedModel ibakedmodel1 = ForgeHooksClient.getDamageModel((IBakedModel)ibakedmodel, (TextureAtlasSprite)sprite, (BlockState)state, (IEnviromentBlockReader)reader, (BlockPos)pos, (long)i);
            this.field_175027_c.func_217631_a(reader, ibakedmodel1, state, pos, Tessellator.func_178181_a().func_178180_c(), true, this.field_195476_e, i);
        }
    }

    @Deprecated
    public boolean func_215330_a(BlockState p_215330_1_, BlockPos p_215330_2_, IEnviromentBlockReader p_215330_3_, BufferBuilder p_215330_4_, Random p_215330_5_) {
        return this.renderBlock(p_215330_1_, p_215330_2_, p_215330_3_, p_215330_4_, p_215330_5_, (IModelData)EmptyModelData.INSTANCE);
    }

    public boolean renderBlock(BlockState p_215330_1_, BlockPos p_215330_2_, IEnviromentBlockReader p_215330_3_, BufferBuilder p_215330_4_, Random p_215330_5_, IModelData modelData) {
        try {
            BlockRenderType blockrendertype = p_215330_1_.func_185901_i();
            if (blockrendertype == BlockRenderType.INVISIBLE) {
                return false;
            }
            switch (blockrendertype) {
                case MODEL: {
                    return this.field_175027_c.renderModel(p_215330_3_, this.func_184389_a(p_215330_1_), p_215330_1_, p_215330_2_, p_215330_4_, true, p_215330_5_, p_215330_1_.func_209533_a(p_215330_2_), modelData);
                }
                case ENTITYBLOCK_ANIMATED: {
                    return false;
                }
            }
            return false;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Tesselating block in world");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block being tesselated");
            CrashReportCategory.func_175750_a(crashreportcategory, p_215330_2_, p_215330_1_);
            throw new ReportedException(crashreport);
        }
    }

    public boolean func_215331_a(BlockPos p_215331_1_, IEnviromentBlockReader p_215331_2_, BufferBuilder p_215331_3_, IFluidState p_215331_4_) {
        try {
            return this.field_175025_e.func_217638_a(p_215331_2_, p_215331_1_, p_215331_3_, p_215331_4_);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Tesselating liquid in world");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Block being tesselated");
            CrashReportCategory.func_175750_a(crashreportcategory, p_215331_1_, null);
            throw new ReportedException(crashreport);
        }
    }

    public BlockModelRenderer func_175019_b() {
        return this.field_175027_c;
    }

    public IBakedModel func_184389_a(BlockState state) {
        return this.field_175028_a.func_178125_b(state);
    }

    public void func_175016_a(BlockState state, float brightness) {
        BlockRenderType blockrendertype = state.func_185901_i();
        if (blockrendertype != BlockRenderType.INVISIBLE) {
            switch (blockrendertype) {
                case MODEL: {
                    IBakedModel ibakedmodel = this.func_184389_a(state);
                    this.field_175027_c.func_178266_a(ibakedmodel, state, brightness, true);
                    break;
                }
                case ENTITYBLOCK_ANIMATED: {
                    this.field_175024_d.func_178175_a(state.func_177230_c(), brightness);
                }
            }
        }
    }

    @Override
    public void func_195410_a(IResourceManager resourceManager) {
        this.field_175025_e.func_178268_a();
    }

    @Override
    public IResourceType getResourceType() {
        return VanillaResourceType.MODELS;
    }
}

