/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Rotations;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ArmorStandEntity
extends LivingEntity {
    private static final Rotations field_175435_a = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations field_175433_b = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations field_175434_c = new Rotations(-10.0f, 0.0f, -10.0f);
    private static final Rotations field_175431_d = new Rotations(-15.0f, 0.0f, 10.0f);
    private static final Rotations field_175432_e = new Rotations(-1.0f, 0.0f, -1.0f);
    private static final Rotations field_175429_f = new Rotations(1.0f, 0.0f, 1.0f);
    public static final DataParameter<Byte> field_184801_a = EntityDataManager.func_187226_a(ArmorStandEntity.class, DataSerializers.field_187191_a);
    public static final DataParameter<Rotations> field_184802_b = EntityDataManager.func_187226_a(ArmorStandEntity.class, DataSerializers.field_187199_i);
    public static final DataParameter<Rotations> field_184803_c = EntityDataManager.func_187226_a(ArmorStandEntity.class, DataSerializers.field_187199_i);
    public static final DataParameter<Rotations> field_184804_d = EntityDataManager.func_187226_a(ArmorStandEntity.class, DataSerializers.field_187199_i);
    public static final DataParameter<Rotations> field_184805_e = EntityDataManager.func_187226_a(ArmorStandEntity.class, DataSerializers.field_187199_i);
    public static final DataParameter<Rotations> field_184806_f = EntityDataManager.func_187226_a(ArmorStandEntity.class, DataSerializers.field_187199_i);
    public static final DataParameter<Rotations> field_184807_g = EntityDataManager.func_187226_a(ArmorStandEntity.class, DataSerializers.field_187199_i);
    private static final Predicate<Entity> field_184798_bv = p_200617_0_ -> p_200617_0_ instanceof AbstractMinecartEntity && ((AbstractMinecartEntity)((Object)p_200617_0_)).canBeRidden();
    private final NonNullList<ItemStack> field_184799_bw = NonNullList.func_191197_a((int)2, (Object)((Object)ItemStack.field_190927_a));
    private final NonNullList<ItemStack> field_184800_bx = NonNullList.func_191197_a((int)4, (Object)((Object)ItemStack.field_190927_a));
    private boolean field_175436_h;
    public long field_175437_i;
    private int field_175442_bg;
    private Rotations field_175443_bh = field_175435_a;
    private Rotations field_175444_bi = field_175433_b;
    private Rotations field_175438_bj = field_175434_c;
    private Rotations field_175439_bk = field_175431_d;
    private Rotations field_175440_bl = field_175432_e;
    private Rotations field_175441_bm = field_175429_f;

    public ArmorStandEntity(EntityType<? extends ArmorStandEntity> p_i50225_1_, World p_i50225_2_) {
        super((EntityType<? extends LivingEntity>)p_i50225_1_, p_i50225_2_);
        this.field_70138_W = 0.0f;
    }

    public ArmorStandEntity(World worldIn, double posX, double posY, double posZ) {
        this((EntityType<? extends ArmorStandEntity>)EntityType.field_200789_c, worldIn);
        this.func_70107_b(posX, posY, posZ);
    }

    @Override
    public void func_213323_x_() {
        double d0 = this.field_70165_t;
        double d1 = this.field_70163_u;
        double d2 = this.field_70161_v;
        super.func_213323_x_();
        this.func_70107_b(d0, d1, d2);
    }

    private boolean func_213814_A() {
        return !this.func_181026_s() && !this.func_189652_ae();
    }

    @Override
    public boolean func_70613_aW() {
        return super.func_70613_aW() && this.func_213814_A();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184801_a, (byte)0);
        this.field_70180_af.func_187214_a(field_184802_b, field_175435_a);
        this.field_70180_af.func_187214_a(field_184803_c, field_175433_b);
        this.field_70180_af.func_187214_a(field_184804_d, field_175434_c);
        this.field_70180_af.func_187214_a(field_184805_e, field_175431_d);
        this.field_70180_af.func_187214_a(field_184806_f, field_175432_e);
        this.field_70180_af.func_187214_a(field_184807_g, field_175429_f);
    }

    @Override
    public Iterable<ItemStack> func_184214_aD() {
        return this.field_184799_bw;
    }

    @Override
    public Iterable<ItemStack> func_184193_aE() {
        return this.field_184800_bx;
    }

    @Override
    public ItemStack func_184582_a(EquipmentSlotType slotIn) {
        switch (slotIn.func_188453_a()) {
            case HAND: {
                return (ItemStack)((Object)this.field_184799_bw.get(slotIn.func_188454_b()));
            }
            case ARMOR: {
                return (ItemStack)((Object)this.field_184800_bx.get(slotIn.func_188454_b()));
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
        switch (slotIn.func_188453_a()) {
            case HAND: {
                this.func_184606_a_(stack);
                this.field_184799_bw.set(slotIn.func_188454_b(), (Object)stack);
                break;
            }
            case ARMOR: {
                this.func_184606_a_(stack);
                this.field_184800_bx.set(slotIn.func_188454_b(), (Object)stack);
            }
        }
    }

    @Override
    public boolean func_174820_d(int inventorySlot, ItemStack itemStackIn) {
        EquipmentSlotType equipmentslottype;
        if (inventorySlot == 98) {
            equipmentslottype = EquipmentSlotType.MAINHAND;
        } else if (inventorySlot == 99) {
            equipmentslottype = EquipmentSlotType.OFFHAND;
        } else if (inventorySlot == 100 + EquipmentSlotType.HEAD.func_188454_b()) {
            equipmentslottype = EquipmentSlotType.HEAD;
        } else if (inventorySlot == 100 + EquipmentSlotType.CHEST.func_188454_b()) {
            equipmentslottype = EquipmentSlotType.CHEST;
        } else if (inventorySlot == 100 + EquipmentSlotType.LEGS.func_188454_b()) {
            equipmentslottype = EquipmentSlotType.LEGS;
        } else {
            if (inventorySlot != 100 + EquipmentSlotType.FEET.func_188454_b()) {
                return false;
            }
            equipmentslottype = EquipmentSlotType.FEET;
        }
        if (!itemStackIn.func_190926_b() && !MobEntity.func_184648_b(equipmentslottype, itemStackIn) && equipmentslottype != EquipmentSlotType.HEAD) {
            return false;
        }
        this.func_184201_a(equipmentslottype, itemStackIn);
        return true;
    }

    @Override
    public boolean func_213365_e(ItemStack p_213365_1_) {
        EquipmentSlotType equipmentslottype = MobEntity.func_184640_d(p_213365_1_);
        return this.func_184582_a(equipmentslottype).func_190926_b() && !this.func_184796_b(equipmentslottype);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        ListNBT listnbt = new ListNBT();
        for (ItemStack itemstack : this.field_184800_bx) {
            CompoundNBT compoundnbt = new CompoundNBT();
            if (!itemstack.func_190926_b()) {
                itemstack.func_77955_b(compoundnbt);
            }
            listnbt.add((Object)compoundnbt);
        }
        compound.func_218657_a("ArmorItems", (INBT)listnbt);
        ListNBT listnbt1 = new ListNBT();
        for (ItemStack itemstack1 : this.field_184799_bw) {
            CompoundNBT compoundnbt1 = new CompoundNBT();
            if (!itemstack1.func_190926_b()) {
                itemstack1.func_77955_b(compoundnbt1);
            }
            listnbt1.add((Object)compoundnbt1);
        }
        compound.func_218657_a("HandItems", (INBT)listnbt1);
        compound.func_74757_a("Invisible", this.func_82150_aj());
        compound.func_74757_a("Small", this.func_175410_n());
        compound.func_74757_a("ShowArms", this.func_175402_q());
        compound.func_74768_a("DisabledSlots", this.field_175442_bg);
        compound.func_74757_a("NoBasePlate", this.func_175414_r());
        if (this.func_181026_s()) {
            compound.func_74757_a("Marker", this.func_181026_s());
        }
        compound.func_218657_a("Pose", this.func_175419_y());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("ArmorItems", 9)) {
            ListNBT listnbt = compound.func_150295_c("ArmorItems", 10);
            for (int i = 0; i < this.field_184800_bx.size(); ++i) {
                this.field_184800_bx.set(i, (Object)ItemStack.func_199557_a(listnbt.func_150305_b(i)));
            }
        }
        if (compound.func_150297_b("HandItems", 9)) {
            ListNBT listnbt1 = compound.func_150295_c("HandItems", 10);
            for (int j = 0; j < this.field_184799_bw.size(); ++j) {
                this.field_184799_bw.set(j, (Object)ItemStack.func_199557_a(listnbt1.func_150305_b(j)));
            }
        }
        this.func_82142_c(compound.func_74767_n("Invisible"));
        this.func_175420_a(compound.func_74767_n("Small"));
        this.func_175413_k(compound.func_74767_n("ShowArms"));
        this.field_175442_bg = compound.func_74762_e("DisabledSlots");
        this.func_175426_l(compound.func_74767_n("NoBasePlate"));
        this.func_181027_m(compound.func_74767_n("Marker"));
        this.field_70145_X = !this.func_213814_A();
        CompoundNBT compoundnbt = compound.func_74775_l("Pose");
        this.func_175416_h(compoundnbt);
    }

    private void func_175416_h(CompoundNBT tagCompound) {
        ListNBT listnbt = tagCompound.func_150295_c("Head", 5);
        this.func_175415_a(listnbt.isEmpty() ? field_175435_a : new Rotations(listnbt));
        ListNBT listnbt1 = tagCompound.func_150295_c("Body", 5);
        this.func_175424_b(listnbt1.isEmpty() ? field_175433_b : new Rotations(listnbt1));
        ListNBT listnbt2 = tagCompound.func_150295_c("LeftArm", 5);
        this.func_175405_c(listnbt2.isEmpty() ? field_175434_c : new Rotations(listnbt2));
        ListNBT listnbt3 = tagCompound.func_150295_c("RightArm", 5);
        this.func_175428_d(listnbt3.isEmpty() ? field_175431_d : new Rotations(listnbt3));
        ListNBT listnbt4 = tagCompound.func_150295_c("LeftLeg", 5);
        this.func_175417_e(listnbt4.isEmpty() ? field_175432_e : new Rotations(listnbt4));
        ListNBT listnbt5 = tagCompound.func_150295_c("RightLeg", 5);
        this.func_175427_f(listnbt5.isEmpty() ? field_175429_f : new Rotations(listnbt5));
    }

    private CompoundNBT func_175419_y() {
        CompoundNBT compoundnbt = new CompoundNBT();
        if (!field_175435_a.equals((Object)this.field_175443_bh)) {
            compoundnbt.func_218657_a("Head", (INBT)this.field_175443_bh.func_179414_a());
        }
        if (!field_175433_b.equals((Object)this.field_175444_bi)) {
            compoundnbt.func_218657_a("Body", (INBT)this.field_175444_bi.func_179414_a());
        }
        if (!field_175434_c.equals((Object)this.field_175438_bj)) {
            compoundnbt.func_218657_a("LeftArm", (INBT)this.field_175438_bj.func_179414_a());
        }
        if (!field_175431_d.equals((Object)this.field_175439_bk)) {
            compoundnbt.func_218657_a("RightArm", (INBT)this.field_175439_bk.func_179414_a());
        }
        if (!field_175432_e.equals((Object)this.field_175440_bl)) {
            compoundnbt.func_218657_a("LeftLeg", (INBT)this.field_175440_bl.func_179414_a());
        }
        if (!field_175429_f.equals((Object)this.field_175441_bm)) {
            compoundnbt.func_218657_a("RightLeg", (INBT)this.field_175441_bm.func_179414_a());
        }
        return compoundnbt;
    }

    @Override
    public boolean func_70104_M() {
        return false;
    }

    @Override
    protected void func_82167_n(Entity entityIn) {
    }

    @Override
    protected void func_85033_bc() {
        List<Entity> list = this.field_70170_p.func_175674_a(this, this.func_174813_aQ(), field_184798_bv);
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = list.get(i);
            if (!(this.func_70068_e(entity) <= 0.2)) continue;
            entity.func_70108_f(this);
        }
    }

    @Override
    public ActionResultType func_184199_a(PlayerEntity player, Vec3d vec, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (!this.func_181026_s() && itemstack.func_77973_b() != Items.field_151057_cb) {
            if (!this.field_70170_p.field_72995_K && !player.func_175149_v()) {
                EquipmentSlotType equipmentslottype = MobEntity.func_184640_d(itemstack);
                if (itemstack.func_190926_b()) {
                    EquipmentSlotType equipmentslottype2;
                    EquipmentSlotType equipmentslottype1 = this.func_190772_a(vec);
                    EquipmentSlotType equipmentSlotType = equipmentslottype2 = this.func_184796_b(equipmentslottype1) ? equipmentslottype : equipmentslottype1;
                    if (this.func_190630_a(equipmentslottype2)) {
                        this.func_184795_a(player, equipmentslottype2, itemstack, hand);
                    }
                } else {
                    if (this.func_184796_b(equipmentslottype)) {
                        return ActionResultType.FAIL;
                    }
                    if (equipmentslottype.func_188453_a() == EquipmentSlotType.Group.HAND && !this.func_175402_q()) {
                        return ActionResultType.FAIL;
                    }
                    this.func_184795_a(player, equipmentslottype, itemstack, hand);
                }
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected EquipmentSlotType func_190772_a(Vec3d p_190772_1_) {
        EquipmentSlotType equipmentslottype = EquipmentSlotType.MAINHAND;
        boolean flag = this.func_175410_n();
        double d0 = flag ? p_190772_1_.field_72448_b * 2.0 : p_190772_1_.field_72448_b;
        EquipmentSlotType equipmentslottype1 = EquipmentSlotType.FEET;
        if (d0 >= 0.1) {
            double d = flag ? 0.8 : 0.45;
            if (d0 < 0.1 + d && this.func_190630_a(equipmentslottype1)) {
                return EquipmentSlotType.FEET;
            }
        }
        double d = flag ? 0.3 : 0.0;
        if (d0 >= 0.9 + d) {
            double d2 = flag ? 1.0 : 0.7;
            if (d0 < 0.9 + d2 && this.func_190630_a(EquipmentSlotType.CHEST)) {
                return EquipmentSlotType.CHEST;
            }
        }
        if (d0 >= 0.4) {
            double d3 = flag ? 1.0 : 0.8;
            if (d0 < 0.4 + d3 && this.func_190630_a(EquipmentSlotType.LEGS)) {
                return EquipmentSlotType.LEGS;
            }
        }
        if (d0 >= 1.6 && this.func_190630_a(EquipmentSlotType.HEAD)) {
            return EquipmentSlotType.HEAD;
        }
        if (this.func_190630_a(EquipmentSlotType.MAINHAND)) return equipmentslottype;
        if (!this.func_190630_a(EquipmentSlotType.OFFHAND)) return equipmentslottype;
        return EquipmentSlotType.OFFHAND;
    }

    public boolean func_184796_b(EquipmentSlotType slotIn) {
        return (this.field_175442_bg & 1 << slotIn.func_188452_c()) != 0 || slotIn.func_188453_a() == EquipmentSlotType.Group.HAND && !this.func_175402_q();
    }

    private void func_184795_a(PlayerEntity player, EquipmentSlotType p_184795_2_, ItemStack p_184795_3_, Hand hand) {
        ItemStack itemstack = this.func_184582_a(p_184795_2_);
        if (!(!itemstack.func_190926_b() && (this.field_175442_bg & 1 << p_184795_2_.func_188452_c() + 8) != 0 || itemstack.func_190926_b() && (this.field_175442_bg & 1 << p_184795_2_.func_188452_c() + 16) != 0)) {
            if (player.field_71075_bZ.field_75098_d && itemstack.func_190926_b() && !p_184795_3_.func_190926_b()) {
                ItemStack itemstack2 = p_184795_3_.func_77946_l();
                itemstack2.func_190920_e(1);
                this.func_184201_a(p_184795_2_, itemstack2);
            } else if (!p_184795_3_.func_190926_b() && p_184795_3_.func_190916_E() > 1) {
                if (itemstack.func_190926_b()) {
                    ItemStack itemstack1 = p_184795_3_.func_77946_l();
                    itemstack1.func_190920_e(1);
                    this.func_184201_a(p_184795_2_, itemstack1);
                    p_184795_3_.func_190918_g(1);
                }
            } else {
                this.func_184201_a(p_184795_2_, p_184795_3_);
                player.func_184611_a(hand, itemstack);
            }
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            if (DamageSource.field_76380_i.equals(source)) {
                this.func_70106_y();
                return false;
            }
            if (!(this.func_180431_b(source) || this.field_175436_h || this.func_181026_s())) {
                if (source.func_94541_c()) {
                    this.func_213816_g(source);
                    this.func_70106_y();
                    return false;
                }
                if (DamageSource.field_76372_a.equals(source)) {
                    if (this.func_70027_ad()) {
                        this.func_213817_e(source, 0.15f);
                    } else {
                        this.func_70015_d(5);
                    }
                    return false;
                }
                if (DamageSource.field_76370_b.equals(source) && this.func_110143_aJ() > 0.5f) {
                    this.func_213817_e(source, 4.0f);
                    return false;
                }
                boolean flag = source.func_76364_f() instanceof AbstractArrowEntity;
                boolean flag1 = flag && ((AbstractArrowEntity)source.func_76364_f()).func_213874_s() > 0;
                boolean flag2 = "player".equals(source.func_76355_l());
                if (!flag2 && !flag) {
                    return false;
                }
                if (source.func_76346_g() instanceof PlayerEntity && !((PlayerEntity)source.func_76346_g()).field_71075_bZ.field_75099_e) {
                    return false;
                }
                if (source.func_180136_u()) {
                    this.func_190773_I();
                    this.func_175412_z();
                    this.func_70106_y();
                    return flag1;
                }
                long i = this.field_70170_p.func_82737_E();
                if (i - this.field_175437_i > 5L && !flag) {
                    this.field_70170_p.func_72960_a(this, (byte)32);
                    this.field_175437_i = i;
                } else {
                    this.func_213815_f(source);
                    this.func_175412_z();
                    this.func_70106_y();
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 32) {
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187707_l, this.func_184176_by(), 0.3f, 1.0f, false);
                this.field_175437_i = this.field_70170_p.func_82737_E();
            }
        } else {
            super.func_70103_a(id);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 4.0;
        if (Double.isNaN(d0) || d0 == 0.0) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    private void func_175412_z() {
        if (this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_195598_a(new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_196662_n.func_176223_P()), this.field_70165_t, this.field_70163_u + (double)this.func_213302_cg() / 1.5, this.field_70161_v, 10, this.func_213311_cf() / 4.0f, this.func_213302_cg() / 4.0f, this.func_213311_cf() / 4.0f, 0.05);
        }
    }

    private void func_213817_e(DamageSource p_213817_1_, float p_213817_2_) {
        float f = this.func_110143_aJ();
        if ((f -= p_213817_2_) <= 0.5f) {
            this.func_213816_g(p_213817_1_);
            this.func_70106_y();
        } else {
            this.func_70606_j(f);
        }
    }

    private void func_213815_f(DamageSource p_213815_1_) {
        Block.func_180635_a(this.field_70170_p, new BlockPos((Entity)this), new ItemStack(Items.field_179565_cj));
        this.func_213816_g(p_213815_1_);
    }

    private void func_213816_g(DamageSource p_213816_1_) {
        this.func_190773_I();
        this.func_213345_d(p_213816_1_);
        for (int i = 0; i < this.field_184799_bw.size(); ++i) {
            ItemStack itemstack = (ItemStack)((Object)this.field_184799_bw.get(i));
            if (itemstack.func_190926_b()) continue;
            Block.func_180635_a(this.field_70170_p, new BlockPos((Entity)this).func_177984_a(), itemstack);
            this.field_184799_bw.set(i, (Object)ItemStack.field_190927_a);
        }
        for (int j = 0; j < this.field_184800_bx.size(); ++j) {
            ItemStack itemstack1 = (ItemStack)((Object)this.field_184800_bx.get(j));
            if (itemstack1.func_190926_b()) continue;
            Block.func_180635_a(this.field_70170_p, new BlockPos((Entity)this).func_177984_a(), itemstack1);
            this.field_184800_bx.set(j, (Object)ItemStack.field_190927_a);
        }
    }

    private void func_190773_I() {
        this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187701_j, this.func_184176_by(), 1.0f, 1.0f);
    }

    @Override
    protected float func_110146_f(float p_110146_1_, float p_110146_2_) {
        this.field_70760_ar = this.field_70126_B;
        this.field_70761_aq = this.field_70177_z;
        return 0.0f;
    }

    @Override
    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * (this.func_70631_g_() ? 0.5f : 0.9f);
    }

    @Override
    public double func_70033_W() {
        return this.func_181026_s() ? 0.0 : (double)0.1f;
    }

    @Override
    public void func_213352_e(Vec3d p_213352_1_) {
        if (this.func_213814_A()) {
            super.func_213352_e(p_213352_1_);
        }
    }

    @Override
    public void func_181013_g(float offset) {
        this.field_70760_ar = this.field_70126_B = offset;
        this.field_70758_at = this.field_70759_as = offset;
    }

    @Override
    public void func_70034_d(float rotation) {
        this.field_70760_ar = this.field_70126_B = rotation;
        this.field_70758_at = this.field_70759_as = rotation;
    }

    @Override
    public void func_70071_h_() {
        Rotations rotations5;
        Rotations rotations4;
        Rotations rotations3;
        Rotations rotations2;
        Rotations rotations1;
        super.func_70071_h_();
        Rotations rotations = this.field_70180_af.func_187225_a(field_184802_b);
        if (!this.field_175443_bh.equals((Object)rotations)) {
            this.func_175415_a(rotations);
        }
        if (!this.field_175444_bi.equals((Object)(rotations1 = this.field_70180_af.func_187225_a(field_184803_c)))) {
            this.func_175424_b(rotations1);
        }
        if (!this.field_175438_bj.equals((Object)(rotations2 = this.field_70180_af.func_187225_a(field_184804_d)))) {
            this.func_175405_c(rotations2);
        }
        if (!this.field_175439_bk.equals((Object)(rotations3 = this.field_70180_af.func_187225_a(field_184805_e)))) {
            this.func_175428_d(rotations3);
        }
        if (!this.field_175440_bl.equals((Object)(rotations4 = this.field_70180_af.func_187225_a(field_184806_f)))) {
            this.func_175417_e(rotations4);
        }
        if (!this.field_175441_bm.equals((Object)(rotations5 = this.field_70180_af.func_187225_a(field_184807_g)))) {
            this.func_175427_f(rotations5);
        }
    }

    @Override
    protected void func_175135_B() {
        this.func_82142_c(this.field_175436_h);
    }

    @Override
    public void func_82142_c(boolean invisible) {
        this.field_175436_h = invisible;
        super.func_82142_c(invisible);
    }

    @Override
    public boolean func_70631_g_() {
        return this.func_175410_n();
    }

    @Override
    public void func_174812_G() {
        this.func_70106_y();
    }

    @Override
    public boolean func_180427_aV() {
        return this.func_82150_aj();
    }

    @Override
    public PushReaction func_184192_z() {
        return this.func_181026_s() ? PushReaction.IGNORE : super.func_184192_z();
    }

    private void func_175420_a(boolean small) {
        this.field_70180_af.func_187227_b(field_184801_a, this.func_184797_a(this.field_70180_af.func_187225_a(field_184801_a), 1, small));
    }

    public boolean func_175410_n() {
        return (this.field_70180_af.func_187225_a(field_184801_a) & 1) != 0;
    }

    private void func_175413_k(boolean showArms) {
        this.field_70180_af.func_187227_b(field_184801_a, this.func_184797_a(this.field_70180_af.func_187225_a(field_184801_a), 4, showArms));
    }

    public boolean func_175402_q() {
        return (this.field_70180_af.func_187225_a(field_184801_a) & 4) != 0;
    }

    private void func_175426_l(boolean noBasePlate) {
        this.field_70180_af.func_187227_b(field_184801_a, this.func_184797_a(this.field_70180_af.func_187225_a(field_184801_a), 8, noBasePlate));
    }

    public boolean func_175414_r() {
        return (this.field_70180_af.func_187225_a(field_184801_a) & 8) != 0;
    }

    private void func_181027_m(boolean marker) {
        this.field_70180_af.func_187227_b(field_184801_a, this.func_184797_a(this.field_70180_af.func_187225_a(field_184801_a), 16, marker));
    }

    public boolean func_181026_s() {
        return (this.field_70180_af.func_187225_a(field_184801_a) & 0x10) != 0;
    }

    private byte func_184797_a(byte p_184797_1_, int p_184797_2_, boolean p_184797_3_) {
        p_184797_1_ = p_184797_3_ ? (byte)(p_184797_1_ | p_184797_2_) : (byte)(p_184797_1_ & ~p_184797_2_);
        return p_184797_1_;
    }

    public void func_175415_a(Rotations vec) {
        this.field_175443_bh = vec;
        this.field_70180_af.func_187227_b(field_184802_b, vec);
    }

    public void func_175424_b(Rotations vec) {
        this.field_175444_bi = vec;
        this.field_70180_af.func_187227_b(field_184803_c, vec);
    }

    public void func_175405_c(Rotations vec) {
        this.field_175438_bj = vec;
        this.field_70180_af.func_187227_b(field_184804_d, vec);
    }

    public void func_175428_d(Rotations vec) {
        this.field_175439_bk = vec;
        this.field_70180_af.func_187227_b(field_184805_e, vec);
    }

    public void func_175417_e(Rotations vec) {
        this.field_175440_bl = vec;
        this.field_70180_af.func_187227_b(field_184806_f, vec);
    }

    public void func_175427_f(Rotations vec) {
        this.field_175441_bm = vec;
        this.field_70180_af.func_187227_b(field_184807_g, vec);
    }

    public Rotations func_175418_s() {
        return this.field_175443_bh;
    }

    public Rotations func_175408_t() {
        return this.field_175444_bi;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Rotations func_175404_u() {
        return this.field_175438_bj;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Rotations func_175411_v() {
        return this.field_175439_bk;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Rotations func_175403_w() {
        return this.field_175440_bl;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Rotations func_175407_x() {
        return this.field_175441_bm;
    }

    @Override
    public boolean func_70067_L() {
        return super.func_70067_L() && !this.func_181026_s();
    }

    @Override
    public HandSide func_184591_cq() {
        return HandSide.RIGHT;
    }

    @Override
    protected SoundEvent func_184588_d(int heightIn) {
        return SoundEvents.field_187704_k;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187707_l;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187701_j;
    }

    @Override
    public void func_70077_a(LightningBoltEntity lightningBolt) {
    }

    @Override
    public boolean func_184603_cC() {
        return false;
    }

    @Override
    public void func_184206_a(DataParameter<?> key) {
        if (field_184801_a.equals(key)) {
            this.func_213323_x_();
            this.field_70156_m = !this.func_181026_s();
        }
        super.func_184206_a(key);
    }

    @Override
    public boolean func_190631_cK() {
        return false;
    }

    @Override
    public EntitySize func_213305_a(Pose poseIn) {
        float f = this.func_181026_s() ? 0.0f : (this.func_70631_g_() ? 0.5f : 1.0f);
        return this.func_200600_R().func_220334_j().func_220313_a(f);
    }
}

