/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ArrowEntity
extends AbstractArrowEntity {
    private static final DataParameter<Integer> field_184559_f = EntityDataManager.func_187226_a(ArrowEntity.class, DataSerializers.field_187192_b);
    private Potion field_184560_g = Potions.field_185229_a;
    private final Set<EffectInstance> field_184561_h = Sets.newHashSet();
    private boolean field_191509_at;

    public ArrowEntity(EntityType<? extends ArrowEntity> p_i50172_1_, World p_i50172_2_) {
        super((EntityType<? extends AbstractArrowEntity>)p_i50172_1_, p_i50172_2_);
    }

    public ArrowEntity(World worldIn, double x, double y, double z) {
        super(EntityType.field_200790_d, x, y, z, worldIn);
    }

    public ArrowEntity(World worldIn, LivingEntity shooter) {
        super(EntityType.field_200790_d, shooter, worldIn);
    }

    public void func_184555_a(ItemStack stack) {
        if (stack.func_77973_b() == Items.field_185167_i) {
            int i;
            this.field_184560_g = PotionUtils.func_185191_c((ItemStack)stack);
            List collection = PotionUtils.func_185190_b((ItemStack)stack);
            if (!collection.isEmpty()) {
                for (EffectInstance effectinstance : collection) {
                    this.field_184561_h.add(new EffectInstance(effectinstance));
                }
            }
            if ((i = ArrowEntity.func_191508_b(stack)) == -1) {
                this.func_190548_o();
            } else {
                this.func_191507_d(i);
            }
        } else if (stack.func_77973_b() == Items.field_151032_g) {
            this.field_184560_g = Potions.field_185229_a;
            this.field_184561_h.clear();
            this.func_191507_d(-1);
        }
    }

    public static int func_191508_b(ItemStack p_191508_0_) {
        CompoundNBT compoundnbt = p_191508_0_.func_77978_p();
        return compoundnbt != null && compoundnbt.func_150297_b("CustomPotionColor", 99) ? compoundnbt.func_74762_e("CustomPotionColor") : -1;
    }

    private void func_190548_o() {
        this.field_191509_at = false;
        this.field_70180_af.func_187227_b(field_184559_f, PotionUtils.func_185181_a((Collection)PotionUtils.func_185186_a((Potion)this.field_184560_g, this.field_184561_h)));
    }

    public void func_184558_a(EffectInstance effect) {
        this.field_184561_h.add(effect);
        this.func_184212_Q().func_187227_b(field_184559_f, PotionUtils.func_185181_a((Collection)PotionUtils.func_185186_a((Potion)this.field_184560_g, this.field_184561_h)));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184559_f, -1);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70254_i) {
                if (this.field_184552_b % 5 == 0) {
                    this.func_184556_b(1);
                }
            } else {
                this.func_184556_b(2);
            }
        } else if (this.field_70254_i && this.field_184552_b != 0 && !this.field_184561_h.isEmpty() && this.field_184552_b >= 600) {
            this.field_70170_p.func_72960_a(this, (byte)0);
            this.field_184560_g = Potions.field_185229_a;
            this.field_184561_h.clear();
            this.field_70180_af.func_187227_b(field_184559_f, -1);
        }
    }

    private void func_184556_b(int particleCount) {
        int i = this.func_184557_n();
        if (i != -1 && particleCount > 0) {
            double d0 = (double)(i >> 16 & 0xFF) / 255.0;
            double d1 = (double)(i >> 8 & 0xFF) / 255.0;
            double d2 = (double)(i >> 0 & 0xFF) / 255.0;
            for (int j = 0; j < particleCount; ++j) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg(), this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), d0, d1, d2);
            }
        }
    }

    public int func_184557_n() {
        return this.field_70180_af.func_187225_a(field_184559_f);
    }

    private void func_191507_d(int p_191507_1_) {
        this.field_191509_at = true;
        this.field_70180_af.func_187227_b(field_184559_f, p_191507_1_);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.field_184560_g != Potions.field_185229_a && this.field_184560_g != null) {
            compound.func_74778_a("Potion", Registry.field_212621_j.func_177774_c((Object)this.field_184560_g).toString());
        }
        if (this.field_191509_at) {
            compound.func_74768_a("Color", this.func_184557_n());
        }
        if (!this.field_184561_h.isEmpty()) {
            ListNBT listnbt = new ListNBT();
            for (EffectInstance effectinstance : this.field_184561_h) {
                listnbt.add((Object)effectinstance.func_82719_a(new CompoundNBT()));
            }
            compound.func_218657_a("CustomPotionEffects", (INBT)listnbt);
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("Potion", 8)) {
            this.field_184560_g = PotionUtils.func_185187_c((CompoundNBT)compound);
        }
        for (EffectInstance effectinstance : PotionUtils.func_185192_b((CompoundNBT)compound)) {
            this.func_184558_a(effectinstance);
        }
        if (compound.func_150297_b("Color", 99)) {
            this.func_191507_d(compound.func_74762_e("Color"));
        } else {
            this.func_190548_o();
        }
    }

    @Override
    protected void func_184548_a(LivingEntity living) {
        super.func_184548_a(living);
        for (EffectInstance effectinstance : this.field_184560_g.func_185170_a()) {
            living.func_195064_c(new EffectInstance(effectinstance.func_188419_a(), Math.max(effectinstance.func_76459_b() / 8, 1), effectinstance.func_76458_c(), effectinstance.func_82720_e(), effectinstance.func_188418_e()));
        }
        if (!this.field_184561_h.isEmpty()) {
            for (EffectInstance effectinstance1 : this.field_184561_h) {
                living.func_195064_c(effectinstance1);
            }
        }
    }

    @Override
    protected ItemStack func_184550_j() {
        if (this.field_184561_h.isEmpty() && this.field_184560_g == Potions.field_185229_a) {
            return new ItemStack(Items.field_151032_g);
        }
        ItemStack itemstack = new ItemStack(Items.field_185167_i);
        PotionUtils.func_185188_a((ItemStack)itemstack, (Potion)this.field_184560_g);
        PotionUtils.func_185184_a((ItemStack)itemstack, this.field_184561_h);
        if (this.field_191509_at) {
            itemstack.func_196082_o().func_74768_a("CustomPotionColor", this.func_184557_n());
        }
        return itemstack;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 0) {
            int i = this.func_184557_n();
            if (i != -1) {
                double d0 = (double)(i >> 16 & 0xFF) / 255.0;
                double d1 = (double)(i >> 8 & 0xFF) / 255.0;
                double d2 = (double)(i >> 0 & 0xFF) / 255.0;
                for (int j = 0; j < 20; ++j) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg(), this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), d0, d1, d2);
                }
            }
        } else {
            super.func_70103_a(id);
        }
    }
}

