/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.text.translation;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.server.LanguageHook;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LanguageMap {
    private static final Logger field_201045_a = LogManager.getLogger();
    private static final Pattern field_111053_a = Pattern.compile("%(\\d+\\$)?[\\d\\.]*[df]");
    private static final LanguageMap field_197636_c = new LanguageMap();
    private final Map<String, String> field_74816_c = Maps.newHashMap();
    private long field_150511_e;

    public LanguageMap() {
        try (InputStream inputstream = LanguageMap.class.getResourceAsStream("/assets/minecraft/lang/en_us.json");){
            JsonElement jsonelement = (JsonElement)new Gson().fromJson((Reader)new InputStreamReader(inputstream, StandardCharsets.UTF_8), JsonElement.class);
            JsonObject jsonobject = JSONUtils.func_151210_l((JsonElement)jsonelement, (String)"strings");
            for (Map.Entry entry : jsonobject.entrySet()) {
                String s = field_111053_a.matcher(JSONUtils.func_151206_a((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey()))).replaceAll("%$1s");
                this.field_74816_c.put((String)entry.getKey(), s);
            }
            LanguageHook.captureLanguageMap(this.field_74816_c);
            this.field_150511_e = Util.func_211177_b();
        }
        catch (JsonParseException | IOException ioexception) {
            field_201045_a.error("Couldn't read strings from /assets/minecraft/lang/en_us.json", ioexception);
        }
    }

    public static LanguageMap func_74808_a() {
        return field_197636_c;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static synchronized void func_135063_a(Map<String, String> p_135063_0_) {
        LanguageMap.field_197636_c.field_74816_c.clear();
        LanguageMap.field_197636_c.field_74816_c.putAll(p_135063_0_);
        LanguageMap.field_197636_c.field_150511_e = Util.func_211177_b();
    }

    public synchronized String func_74805_b(String key) {
        return this.func_135064_c(key);
    }

    private String func_135064_c(String key) {
        String s = this.field_74816_c.get(key);
        return s == null ? key : s;
    }

    public synchronized boolean func_210813_b(String p_210813_1_) {
        return this.field_74816_c.containsKey(p_210813_1_);
    }

    public long func_150510_c() {
        return this.field_150511_e;
    }
}

