/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import java.util.BitSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.EntityClassification;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;

public abstract class ChunkGenerator<C extends GenerationSettings> {
    protected final IWorld field_222540_a;
    protected final long field_222541_b;
    protected final BiomeProvider field_222542_c;
    protected final C field_222543_d;

    public ChunkGenerator(IWorld worldIn, BiomeProvider biomeProviderIn, C generationSettingsIn) {
        this.field_222540_a = worldIn;
        this.field_222541_b = worldIn.func_72905_C();
        this.field_222542_c = biomeProviderIn;
        this.field_222543_d = generationSettingsIn;
    }

    public void func_222539_a(IChunk chunkIn) {
        ChunkPos chunkpos = chunkIn.func_76632_l();
        int i = chunkpos.field_77276_a;
        int j = chunkpos.field_77275_b;
        Biome[] abiome = this.field_222542_c.func_201539_b(i * 16, j * 16, 16, 16);
        chunkIn.func_201577_a(abiome);
    }

    protected Biome func_222534_b(IChunk chunkIn) {
        return chunkIn.func_217309_c(BlockPos.field_177992_a);
    }

    protected Biome func_222527_a(WorldGenRegion worldRegionIn, BlockPos pos) {
        return this.field_222542_c.func_222364_a(pos);
    }

    public void func_222538_a(IChunk chunkIn, GenerationStage.Carving carvingSettings) {
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
        int i = 8;
        ChunkPos chunkpos = chunkIn.func_76632_l();
        int j = chunkpos.field_77276_a;
        int k = chunkpos.field_77275_b;
        BitSet bitset = chunkIn.func_205749_a(carvingSettings);
        for (int l = j - 8; l <= j + 8; ++l) {
            for (int i1 = k - 8; i1 <= k + 8; ++i1) {
                List<ConfiguredCarver<?>> list = this.func_222534_b(chunkIn).func_203603_a(carvingSettings);
                ListIterator<ConfiguredCarver<?>> listiterator = list.listIterator();
                while (listiterator.hasNext()) {
                    int j1 = listiterator.nextIndex();
                    ConfiguredCarver<?> configuredcarver = listiterator.next();
                    sharedseedrandom.func_202425_c(this.field_222541_b + (long)j1, l, i1);
                    if (!configuredcarver.func_222730_a((Random)sharedseedrandom, l, i1)) continue;
                    configuredcarver.func_222731_a(chunkIn, (Random)sharedseedrandom, this.func_222530_f(), l, i1, j, k, bitset);
                }
            }
        }
    }

    @Nullable
    public BlockPos func_211403_a(World worldIn, String name, BlockPos pos, int radius, boolean p_211403_5_) {
        Structure structure = (Structure)Feature.field_202300_at.get((Object)name.toLowerCase(Locale.ROOT));
        return structure != null ? structure.func_211405_a(worldIn, this, pos, radius, p_211403_5_) : null;
    }

    public void func_202092_b(WorldGenRegion region) {
        int i = region.func_201679_a();
        int j = region.func_201680_b();
        int k = i * 16;
        int l = j * 16;
        BlockPos blockpos = new BlockPos(k, 0, l);
        Biome biome = this.func_222527_a(region, blockpos.func_177982_a(8, 8, 8));
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
        long i1 = sharedseedrandom.func_202424_a(region.func_72905_C(), k, l);
        for (GenerationStage.Decoration generationstage$decoration : GenerationStage.Decoration.values()) {
            try {
                biome.func_203608_a(generationstage$decoration, this, region, i1, sharedseedrandom, blockpos);
            }
            catch (Exception exception) {
                CrashReport crashreport = CrashReport.func_85055_a(exception, "Biome decoration");
                crashreport.func_85058_a("Generation").func_71507_a("CenterX", i).func_71507_a("CenterZ", j).func_71507_a("Step", generationstage$decoration).func_71507_a("Seed", i1).func_71507_a("Biome", Registry.field_212624_m.func_177774_c(biome));
                throw new ReportedException(crashreport);
            }
        }
    }

    public abstract void func_222535_c(IChunk var1);

    public void func_202093_c(WorldGenRegion region) {
    }

    public C func_201496_a_() {
        return this.field_222543_d;
    }

    public abstract int func_205470_d();

    public void func_203222_a(ServerWorld worldIn, boolean spawnHostileMobs, boolean spawnPeacefulMobs) {
    }

    public boolean func_202094_a(Biome biomeIn, Structure<? extends IFeatureConfig> structureIn) {
        return biomeIn.func_201858_a(structureIn);
    }

    @Nullable
    public <C extends IFeatureConfig> C func_202087_b(Biome biomeIn, Structure<C> structureIn) {
        return biomeIn.func_201857_b(structureIn);
    }

    public BiomeProvider func_202090_b() {
        return this.field_222542_c;
    }

    public long func_202089_c() {
        return this.field_222541_b;
    }

    public int func_207511_e() {
        return 256;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EntityClassification creatureType, BlockPos pos) {
        return this.field_222540_a.func_180494_b(pos).func_76747_a(creatureType);
    }

    public void func_222533_a(IChunk chunkIn, ChunkGenerator<?> generator, TemplateManager templateManagerIn) {
        for (Structure structure : Feature.field_202300_at.values()) {
            if (!generator.func_202090_b().func_205004_a(structure)) continue;
            SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
            ChunkPos chunkpos = chunkIn.func_76632_l();
            StructureStart structurestart = StructureStart.field_214630_a;
            if (structure.func_202372_a(generator, (Random)sharedseedrandom, chunkpos.field_77276_a, chunkpos.field_77275_b)) {
                Biome biome = this.func_202090_b().func_222364_a(new BlockPos(chunkpos.func_180334_c() + 9, 0, chunkpos.func_180333_d() + 9));
                StructureStart structurestart1 = structure.func_214557_a().create(structure, chunkpos.field_77276_a, chunkpos.field_77275_b, biome, MutableBoundingBox.func_78887_a(), 0, generator.func_202089_c());
                structurestart1.func_214625_a(this, templateManagerIn, chunkpos.field_77276_a, chunkpos.field_77275_b, biome);
                structurestart = structurestart1.func_75069_d() ? structurestart1 : StructureStart.field_214630_a;
            }
            chunkIn.func_201584_a(structure.func_143025_a(), structurestart);
        }
    }

    public void func_222528_a(IWorld worldIn, IChunk chunkIn) {
        int i = 8;
        int j = chunkIn.func_76632_l().field_77276_a;
        int k = chunkIn.func_76632_l().field_77275_b;
        int l = j << 4;
        int i1 = k << 4;
        for (int j1 = j - 8; j1 <= j + 8; ++j1) {
            for (int k1 = k - 8; k1 <= k + 8; ++k1) {
                long l1 = ChunkPos.func_77272_a((int)j1, (int)k1);
                for (Map.Entry<String, StructureStart> entry : worldIn.func_212866_a_(j1, k1).func_201609_c().entrySet()) {
                    StructureStart structurestart = entry.getValue();
                    if (structurestart == StructureStart.field_214630_a || !structurestart.func_75071_a().func_78885_a(l, i1, l + 15, i1 + 15)) continue;
                    chunkIn.func_201583_a(entry.getKey(), l1);
                    DebugPacketSender.func_218804_a((IWorld)worldIn, (StructureStart)structurestart);
                }
            }
        }
    }

    public abstract void func_222537_b(IWorld var1, IChunk var2);

    public int func_222530_f() {
        return this.field_222540_a.func_201675_m().getSeaLevel();
    }

    public abstract int func_222529_a(int var1, int var2, Heightmap.Type var3);

    public int func_222532_b(int p_222532_1_, int p_222532_2_, Heightmap.Type p_222532_3_) {
        return this.func_222529_a(p_222532_1_, p_222532_2_, p_222532_3_);
    }

    public int func_222531_c(int p_222531_1_, int p_222531_2_, Heightmap.Type p_222531_3_) {
        return this.func_222529_a(p_222531_1_, p_222531_2_, p_222531_3_) - 1;
    }
}

