/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.lighting;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import javax.annotation.Nullable;
import net.minecraft.util.Direction;
import net.minecraft.util.SectionDistanceGraph;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.LightType;
import net.minecraft.world.chunk.IChunkLightProvider;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.lighting.LightDataMap;
import net.minecraft.world.lighting.LightEngine;

public abstract class SectionLightStorage<M extends LightDataMap<M>>
extends SectionDistanceGraph {
    protected static final NibbleArray field_215534_a = new NibbleArray();
    private static final Direction[] field_215544_k = Direction.values();
    private final LightType field_215545_l;
    private final IChunkLightProvider field_215546_m;
    protected final LongSet field_215535_b = new LongOpenHashSet();
    protected final LongSet field_215536_c = new LongOpenHashSet();
    protected final LongSet field_215537_d = new LongOpenHashSet();
    protected volatile M field_215538_e;
    protected final M field_215539_f;
    protected final LongSet field_215540_g = new LongOpenHashSet();
    protected final LongSet field_215541_h = new LongOpenHashSet();
    protected final Long2ObjectMap<NibbleArray> field_215542_i = new Long2ObjectOpenHashMap();
    private final LongSet field_223114_n = new LongOpenHashSet();
    private final LongSet field_215547_n = new LongOpenHashSet();
    protected volatile boolean field_215543_j;

    protected SectionLightStorage(LightType lightTypeIn, IChunkLightProvider chunkLightProvider, M dataMap) {
        super(3, 16, 256);
        this.field_215545_l = lightTypeIn;
        this.field_215546_m = chunkLightProvider;
        this.field_215539_f = dataMap;
        this.field_215538_e = dataMap.func_212858_b_();
        this.field_215538_e.func_215644_d();
    }

    protected boolean func_215518_g(long sectionPosIn) {
        return this.func_215520_a(sectionPosIn, true) != null;
    }

    @Nullable
    protected NibbleArray func_215520_a(long sectionPosIn, boolean cached) {
        return this.func_215531_a(cached ? this.field_215539_f : this.field_215538_e, sectionPosIn);
    }

    @Nullable
    protected NibbleArray func_215531_a(M map, long sectionPosIn) {
        return map.func_215638_c(sectionPosIn);
    }

    @Nullable
    public NibbleArray func_222858_h(long sectionPosIn) {
        NibbleArray nibblearray = (NibbleArray)this.field_215542_i.get(sectionPosIn);
        return nibblearray != null ? nibblearray : this.func_215520_a(sectionPosIn, false);
    }

    protected abstract int func_215525_d(long var1);

    protected int func_215521_h(long worldPos) {
        long i = SectionPos.func_218162_e((long)worldPos);
        NibbleArray nibblearray = this.func_215520_a(i, true);
        return nibblearray.func_76582_a(SectionPos.func_218171_b((int)BlockPos.func_218290_b((long)worldPos)), SectionPos.func_218171_b((int)BlockPos.func_218274_c((long)worldPos)), SectionPos.func_218171_b((int)BlockPos.func_218282_d((long)worldPos)));
    }

    protected void func_215517_b(long worldPos, int lightLevel) {
        long i = SectionPos.func_218162_e((long)worldPos);
        if (this.field_215540_g.add(i)) {
            this.field_215539_f.func_215641_a(i);
        }
        NibbleArray nibblearray = this.func_215520_a(i, true);
        nibblearray.func_76581_a(SectionPos.func_218171_b((int)BlockPos.func_218290_b((long)worldPos)), SectionPos.func_218171_b((int)BlockPos.func_218274_c((long)worldPos)), SectionPos.func_218171_b((int)BlockPos.func_218282_d((long)worldPos)), lightLevel);
        for (int j = -1; j <= 1; ++j) {
            for (int k = -1; k <= 1; ++k) {
                for (int l = -1; l <= 1; ++l) {
                    this.field_215541_h.add(SectionPos.func_218162_e((long)BlockPos.func_218291_a((long)worldPos, (int)k, (int)l, (int)j)));
                }
            }
        }
    }

    protected int func_215471_c(long sectionPosIn) {
        if (sectionPosIn == Long.MAX_VALUE) {
            return 2;
        }
        if (this.field_215535_b.contains(sectionPosIn)) {
            return 0;
        }
        return !this.field_215547_n.contains(sectionPosIn) && this.field_215539_f.func_215642_b(sectionPosIn) ? 1 : 2;
    }

    protected int func_215516_b(long pos) {
        if (this.field_215536_c.contains(pos)) {
            return 2;
        }
        return !this.field_215535_b.contains(pos) && !this.field_215537_d.contains(pos) ? 2 : 0;
    }

    protected void func_215476_a(long sectionPosIn, int level) {
        int i = this.func_215471_c(sectionPosIn);
        if (i != 0 && level == 0) {
            this.field_215535_b.add(sectionPosIn);
            this.field_215537_d.remove(sectionPosIn);
        }
        if (i == 0 && level != 0) {
            this.field_215535_b.remove(sectionPosIn);
            this.field_215536_c.remove(sectionPosIn);
        }
        if (i >= 2 && level != 2) {
            if (this.field_215547_n.contains(sectionPosIn)) {
                this.field_215547_n.remove(sectionPosIn);
            } else {
                this.field_215539_f.func_215640_a(sectionPosIn, this.func_215530_i(sectionPosIn));
                this.field_215540_g.add(sectionPosIn);
                this.func_215524_j(sectionPosIn);
                for (int j = -1; j <= 1; ++j) {
                    for (int k = -1; k <= 1; ++k) {
                        for (int l = -1; l <= 1; ++l) {
                            this.field_215541_h.add(SectionPos.func_218162_e((long)BlockPos.func_218291_a((long)sectionPosIn, (int)k, (int)l, (int)j)));
                        }
                    }
                }
            }
        }
        if (i != 2 && level >= 2) {
            this.field_215547_n.add(sectionPosIn);
        }
        this.field_215543_j = !this.field_215547_n.isEmpty();
    }

    protected NibbleArray func_215530_i(long sectionPosIn) {
        NibbleArray nibblearray = (NibbleArray)this.field_215542_i.get(sectionPosIn);
        return nibblearray != null ? nibblearray : new NibbleArray();
    }

    protected void func_215528_a(LightEngine<?, ?> engine, long sectionPosIn) {
        int i = SectionPos.func_218142_c((int)SectionPos.func_218173_b((long)sectionPosIn));
        int j = SectionPos.func_218142_c((int)SectionPos.func_218144_c((long)sectionPosIn));
        int k = SectionPos.func_218142_c((int)SectionPos.func_218153_d((long)sectionPosIn));
        if (engine.queuedUpdateSize() < 4096) {
            engine.bulkCancel(l -> SectionPos.func_218162_e((long)l) == sectionPosIn);
            return;
        }
        for (int l2 = 0; l2 < 16; ++l2) {
            for (int i1 = 0; i1 < 16; ++i1) {
                for (int j1 = 0; j1 < 16; ++j1) {
                    long k1 = BlockPos.func_218276_a((int)(i + l2), (int)(j + i1), (int)(k + j1));
                    engine.func_215479_e(k1);
                }
            }
        }
    }

    protected boolean func_215527_a() {
        return this.field_215543_j;
    }

    protected void func_215522_a(LightEngine<M, ?> engine, boolean updateSkyLight, boolean updateBlockLight) {
        if (this.func_215527_a() || !this.field_215542_i.isEmpty()) {
            LongIterator longIterator = this.field_215547_n.iterator();
            while (longIterator.hasNext()) {
                long i = (Long)longIterator.next();
                this.func_215528_a(engine, i);
                NibbleArray nibblearray = (NibbleArray)this.field_215542_i.remove(i);
                NibbleArray nibblearray1 = this.field_215539_f.func_223130_d(i);
                if (!this.field_223114_n.contains(SectionPos.func_218169_f((long)i))) continue;
                if (nibblearray != null) {
                    this.field_215542_i.put(i, (Object)nibblearray);
                    continue;
                }
                if (nibblearray1 == null) continue;
                this.field_215542_i.put(i, (Object)nibblearray1);
            }
            this.field_215539_f.func_215643_c();
            longIterator = this.field_215547_n.iterator();
            while (longIterator.hasNext()) {
                long i2 = (Long)longIterator.next();
                this.func_215523_k(i2);
            }
            this.field_215547_n.clear();
            this.field_215543_j = false;
            for (Long2ObjectMap.Entry entry : this.field_215542_i.long2ObjectEntrySet()) {
                long j = entry.getLongKey();
                if (!this.func_215518_g(j)) continue;
                NibbleArray nibblearray2 = (NibbleArray)entry.getValue();
                if (this.field_215539_f.func_215638_c(j) == nibblearray2) continue;
                this.func_215528_a(engine, j);
                this.field_215539_f.func_215640_a(j, nibblearray2);
                this.field_215540_g.add(j);
            }
            this.field_215539_f.func_215643_c();
            if (!updateBlockLight) {
                longIterator = this.field_215542_i.keySet().iterator();
                while (longIterator.hasNext()) {
                    long j2 = (Long)longIterator.next();
                    if (!this.func_215518_g(j2)) continue;
                    int l2 = SectionPos.func_218142_c((int)SectionPos.func_218173_b((long)j2));
                    int i3 = SectionPos.func_218142_c((int)SectionPos.func_218144_c((long)j2));
                    int k = SectionPos.func_218142_c((int)SectionPos.func_218153_d((long)j2));
                    for (Direction direction : field_215544_k) {
                        long l = SectionPos.func_218172_a((long)j2, (Direction)direction);
                        if (this.field_215542_i.containsKey(l) || !this.func_215518_g(l)) continue;
                        for (int i1 = 0; i1 < 16; ++i1) {
                            for (int j1 = 0; j1 < 16; ++j1) {
                                long l1;
                                long k1;
                                switch (direction) {
                                    case DOWN: {
                                        k1 = BlockPos.func_218276_a((int)(l2 + j1), (int)i3, (int)(k + i1));
                                        l1 = BlockPos.func_218276_a((int)(l2 + j1), (int)(i3 - 1), (int)(k + i1));
                                        break;
                                    }
                                    case UP: {
                                        k1 = BlockPos.func_218276_a((int)(l2 + j1), (int)(i3 + 16 - 1), (int)(k + i1));
                                        l1 = BlockPos.func_218276_a((int)(l2 + j1), (int)(i3 + 16), (int)(k + i1));
                                        break;
                                    }
                                    case NORTH: {
                                        k1 = BlockPos.func_218276_a((int)(l2 + i1), (int)(i3 + j1), (int)k);
                                        l1 = BlockPos.func_218276_a((int)(l2 + i1), (int)(i3 + j1), (int)(k - 1));
                                        break;
                                    }
                                    case SOUTH: {
                                        k1 = BlockPos.func_218276_a((int)(l2 + i1), (int)(i3 + j1), (int)(k + 16 - 1));
                                        l1 = BlockPos.func_218276_a((int)(l2 + i1), (int)(i3 + j1), (int)(k + 16));
                                        break;
                                    }
                                    case WEST: {
                                        k1 = BlockPos.func_218276_a((int)l2, (int)(i3 + i1), (int)(k + j1));
                                        l1 = BlockPos.func_218276_a((int)(l2 - 1), (int)(i3 + i1), (int)(k + j1));
                                        break;
                                    }
                                    default: {
                                        k1 = BlockPos.func_218276_a((int)(l2 + 16 - 1), (int)(i3 + i1), (int)(k + j1));
                                        l1 = BlockPos.func_218276_a((int)(l2 + 16), (int)(i3 + i1), (int)(k + j1));
                                    }
                                }
                                engine.func_215469_a(k1, l1, engine.func_215480_b(k1, l1, engine.func_215471_c(k1)), false);
                                engine.func_215469_a(l1, k1, engine.func_215480_b(l1, k1, engine.func_215471_c(l1)), false);
                            }
                        }
                    }
                }
            }
            ObjectIterator objectiterator = this.field_215542_i.long2ObjectEntrySet().iterator();
            while (objectiterator.hasNext()) {
                Long2ObjectMap.Entry entry1 = (Long2ObjectMap.Entry)objectiterator.next();
                long k2 = entry1.getLongKey();
                if (!this.func_215518_g(k2)) continue;
                objectiterator.remove();
            }
        }
    }

    protected void func_215524_j(long p_215524_1_) {
    }

    protected void func_215523_k(long p_215523_1_) {
    }

    protected void func_215526_b(long p_215526_1_, boolean p_215526_3_) {
    }

    public void func_223113_c(long sectionColumnPos, boolean retain) {
        if (retain) {
            this.field_223114_n.add(sectionColumnPos);
        } else {
            this.field_223114_n.remove(sectionColumnPos);
        }
    }

    protected void func_215529_a(long sectionPosIn, @Nullable NibbleArray array) {
        if (array != null) {
            this.field_215542_i.put(sectionPosIn, (Object)array);
        } else {
            this.field_215542_i.remove(sectionPosIn);
        }
    }

    protected void func_215519_c(long sectionPosIn, boolean isEmpty) {
        boolean flag = this.field_215535_b.contains(sectionPosIn);
        if (!flag && !isEmpty) {
            this.field_215537_d.add(sectionPosIn);
            this.func_215469_a(Long.MAX_VALUE, sectionPosIn, 0, true);
        }
        if (flag && isEmpty) {
            this.field_215536_c.add(sectionPosIn);
            this.func_215469_a(Long.MAX_VALUE, sectionPosIn, 2, false);
        }
    }

    protected void func_215532_c() {
        if (this.func_215481_b()) {
            this.func_215483_b(Integer.MAX_VALUE);
        }
    }

    protected void func_215533_d() {
        if (!this.field_215540_g.isEmpty()) {
            LightDataMap m = this.field_215539_f.func_212858_b_();
            m.func_215644_d();
            this.field_215538_e = m;
            this.field_215540_g.clear();
        }
        if (!this.field_215541_h.isEmpty()) {
            LongIterator longiterator = this.field_215541_h.iterator();
            while (longiterator.hasNext()) {
                long i = longiterator.nextLong();
                this.field_215546_m.func_217201_a(this.field_215545_l, SectionPos.func_218170_a((long)i));
            }
            this.field_215541_h.clear();
        }
    }
}

