/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.progress;

import java.util.Locale;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.progress.ClientVisualization;

public enum EarlyProgressVisualization {
    INSTANCE;

    private Visualization visualization;

    public void accept(Dist dist) {
        if (this.visualization != null) {
            return;
        }
        boolean ismac = System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("mac");
        this.visualization = dist.isClient() && !ismac && Boolean.parseBoolean(System.getProperty("fml.earlyprogresswindow", "true")) ? new ClientVisualization() : new NoVisualization();
        this.visualization.start();
    }

    public void join() {
        this.visualization.join();
    }

    private static class NoVisualization
    implements Visualization {
        private NoVisualization() {
        }

        @Override
        public void start() {
        }

        @Override
        public void join() {
        }
    }

    static interface Visualization {
        public void start();

        public void join();
    }
}

