/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.JsonToNBT;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SNBTToNBTConverter
implements IDataProvider {
    private static final Logger field_200424_a = LogManager.getLogger();
    private final DataGenerator field_200425_b;
    private final List<ITransformer> field_225370_d = Lists.newArrayList();

    public SNBTToNBTConverter(DataGenerator dataGenerator) {
        this.field_200425_b = dataGenerator;
    }

    public SNBTToNBTConverter func_225369_a(ITransformer iTransformer) {
        this.field_225370_d.add(iTransformer);
        return this;
    }

    private CompoundNBT func_225368_a(String string, CompoundNBT compoundNBT) {
        CompoundNBT compoundNBT2;
        compoundNBT2 = compoundNBT;
        for (ITransformer iTransformer : this.field_225370_d) {
            compoundNBT2 = iTransformer.func_225371_a(string, compoundNBT2);
        }
        return compoundNBT2;
    }

    @Override
    public void func_200398_a(DirectoryCache directoryCache) throws IOException {
        Path path2 = this.field_200425_b.func_200391_b();
        for (Path path4 : this.field_200425_b.func_200389_a()) {
            Files.walk(path4, new FileVisitOption[0]).filter(path -> path.toString().endsWith(".snbt")).forEach(path3 -> this.func_208314_a(directoryCache, (Path)path3, this.func_200423_a(path4, (Path)path3), path2));
        }
    }

    @Override
    public String func_200397_b() {
        return "SNBT -> NBT";
    }

    private String func_200423_a(Path path, Path path2) {
        String string = path.relativize(path2).toString().replaceAll("\\\\", "/");
        return string.substring(0, string.length() - ".snbt".length());
    }

    private void func_208314_a(DirectoryCache directoryCache2, Path path, String string, Path path2) {
        try {
            \u2603 = path2.resolve(string + ".nbt");
            try (BufferedReader bufferedReader = Files.newBufferedReader(path);){
                DirectoryCache directoryCache2;
                String string2 = IOUtils.toString((Reader)bufferedReader);
                ByteArrayOutputStream \u26032 = new ByteArrayOutputStream();
                CompressedStreamTools.func_74799_a(this.func_225368_a(string, JsonToNBT.func_180713_a(string2)), \u26032);
                \u2603 = field_208307_a.hashBytes(\u26032.toByteArray()).toString();
                if (!Objects.equals(directoryCache2.func_208323_a(\u2603), \u2603) || !Files.exists(\u2603, new LinkOption[0])) {
                    Files.createDirectories(\u2603.getParent(), new FileAttribute[0]);
                    try (OutputStream outputStream = Files.newOutputStream(\u2603, new OpenOption[0]);){
                        outputStream.write(\u26032.toByteArray());
                    }
                }
                directoryCache2.func_208316_a(\u2603, \u2603);
            }
        }
        catch (CommandSyntaxException commandSyntaxException) {
            field_200424_a.error("Couldn't convert {} from SNBT to NBT at {} as it's invalid SNBT", (Object)string, (Object)path, (Object)commandSyntaxException);
        }
        catch (IOException iOException) {
            field_200424_a.error("Couldn't convert {} from SNBT to NBT at {}", (Object)string, (Object)path, (Object)iOException);
        }
    }

    @FunctionalInterface
    public static interface ITransformer {
        public CompoundNBT func_225371_a(String var1, CompoundNBT var2);
    }
}

