/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TargetGoal;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class VexEntity
extends MonsterEntity {
    protected static final DataParameter<Byte> field_190664_a = EntityDataManager.func_187226_a(VexEntity.class, DataSerializers.field_187191_a);
    private MobEntity field_190665_b;
    @Nullable
    private BlockPos field_190666_c;
    private boolean field_190667_bw;
    private int field_190668_bx;

    public VexEntity(EntityType<? extends VexEntity> entityType, World world) {
        super((EntityType<? extends MonsterEntity>)entityType, world);
        this.field_70765_h = new MoveHelperController(this);
        this.field_70728_aV = 3;
    }

    @Override
    public void func_213315_a(MoverType moverType, Vec3d vec3d) {
        super.func_213315_a(moverType, vec3d);
        this.func_145775_I();
    }

    @Override
    public void func_70071_h_() {
        this.field_70145_X = true;
        super.func_70071_h_();
        this.field_70145_X = false;
        this.func_189654_d(true);
        if (this.field_190667_bw && --this.field_190668_bx <= 0) {
            this.field_190668_bx = 20;
            this.func_70097_a(DamageSource.field_76366_f, 1.0f);
        }
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, new SwimGoal(this));
        this.field_70714_bg.func_75776_a(4, new ChargeAttackGoal());
        this.field_70714_bg.func_75776_a(8, new MoveRandomGoal());
        this.field_70714_bg.func_75776_a(9, new LookAtGoal(this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, new LookAtGoal(this, MobEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, new HurtByTargetGoal(this, AbstractRaiderEntity.class).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, new CopyOwnerTargetGoal(this));
        this.field_70715_bh.func_75776_a(3, new NearestAttackableTargetGoal<PlayerEntity>((MobEntity)this, PlayerEntity.class, true));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(14.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_190664_a, (byte)0);
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        if (compoundNBT.func_74764_b("BoundX")) {
            this.field_190666_c = new BlockPos(compoundNBT.func_74762_e("BoundX"), compoundNBT.func_74762_e("BoundY"), compoundNBT.func_74762_e("BoundZ"));
        }
        if (compoundNBT.func_74764_b("LifeTicks")) {
            this.func_190653_a(compoundNBT.func_74762_e("LifeTicks"));
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        if (this.field_190666_c != null) {
            compoundNBT.func_74768_a("BoundX", this.field_190666_c.func_177958_n());
            compoundNBT.func_74768_a("BoundY", this.field_190666_c.func_177956_o());
            compoundNBT.func_74768_a("BoundZ", this.field_190666_c.func_177952_p());
        }
        if (this.field_190667_bw) {
            compoundNBT.func_74768_a("LifeTicks", this.field_190668_bx);
        }
    }

    public MobEntity func_190645_o() {
        return this.field_190665_b;
    }

    @Nullable
    public BlockPos func_190646_di() {
        return this.field_190666_c;
    }

    public void func_190651_g(@Nullable BlockPos blockPos) {
        this.field_190666_c = blockPos;
    }

    private boolean func_190656_b(int n) {
        byte by = this.field_70180_af.func_187225_a(field_190664_a);
        return (by & n) != 0;
    }

    private void func_190660_a(int n, boolean bl) {
        int n2 = this.field_70180_af.func_187225_a(field_190664_a).byteValue();
        n2 = bl ? (n2 |= n) : (n2 &= ~n);
        this.field_70180_af.func_187227_b(field_190664_a, (byte)(n2 & 0xFF));
    }

    public boolean func_190647_dj() {
        return this.func_190656_b(1);
    }

    public void func_190648_a(boolean bl) {
        this.func_190660_a(1, bl);
    }

    public void func_190658_a(MobEntity mobEntity) {
        this.field_190665_b = mobEntity;
    }

    public void func_190653_a(int n) {
        this.field_190667_bw = true;
        this.field_190668_bx = n;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_191264_hc;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_191266_he;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_191267_hf;
    }

    @Override
    public float func_70013_c() {
        return 1.0f;
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IWorld iWorld, DifficultyInstance difficultyInstance, SpawnReason spawnReason, @Nullable ILivingEntityData iLivingEntityData, @Nullable CompoundNBT compoundNBT) {
        this.func_180481_a(difficultyInstance);
        this.func_180483_b(difficultyInstance);
        return super.func_213386_a(iWorld, difficultyInstance, spawnReason, iLivingEntityData, compoundNBT);
    }

    @Override
    protected void func_180481_a(DifficultyInstance difficultyInstance) {
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack(Items.field_151040_l));
        this.func_184642_a(EquipmentSlotType.MAINHAND, 0.0f);
    }

    class CopyOwnerTargetGoal
    extends TargetGoal {
        private final EntityPredicate field_220803_b;

        public CopyOwnerTargetGoal(CreatureEntity creatureEntity) {
            super(creatureEntity, false);
            this.field_220803_b = new EntityPredicate().func_221014_c().func_221010_e();
        }

        @Override
        public boolean func_75250_a() {
            return VexEntity.this.field_190665_b != null && VexEntity.this.field_190665_b.func_70638_az() != null && this.func_220777_a(VexEntity.this.field_190665_b.func_70638_az(), this.field_220803_b);
        }

        @Override
        public void func_75249_e() {
            VexEntity.this.func_70624_b(VexEntity.this.field_190665_b.func_70638_az());
            super.func_75249_e();
        }
    }

    class MoveRandomGoal
    extends Goal {
        public MoveRandomGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean func_75250_a() {
            return !VexEntity.this.func_70605_aq().func_75640_a() && VexEntity.this.field_70146_Z.nextInt(7) == 0;
        }

        @Override
        public boolean func_75253_b() {
            return false;
        }

        @Override
        public void func_75246_d() {
            BlockPos blockPos = VexEntity.this.func_190646_di();
            if (blockPos == null) {
                blockPos = new BlockPos(VexEntity.this);
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockPos2 = blockPos.func_177982_a(VexEntity.this.field_70146_Z.nextInt(15) - 7, VexEntity.this.field_70146_Z.nextInt(11) - 5, VexEntity.this.field_70146_Z.nextInt(15) - 7);
                if (!VexEntity.this.field_70170_p.func_175623_d(blockPos2)) continue;
                VexEntity.this.field_70765_h.func_75642_a((double)blockPos2.func_177958_n() + 0.5, (double)blockPos2.func_177956_o() + 0.5, (double)blockPos2.func_177952_p() + 0.5, 0.25);
                if (VexEntity.this.func_70638_az() != null) break;
                VexEntity.this.func_70671_ap().func_75650_a((double)blockPos2.func_177958_n() + 0.5, (double)blockPos2.func_177956_o() + 0.5, (double)blockPos2.func_177952_p() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    class ChargeAttackGoal
    extends Goal {
        public ChargeAttackGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean func_75250_a() {
            if (VexEntity.this.func_70638_az() != null && !VexEntity.this.func_70605_aq().func_75640_a() && VexEntity.this.field_70146_Z.nextInt(7) == 0) {
                return VexEntity.this.func_70068_e(VexEntity.this.func_70638_az()) > 4.0;
            }
            return false;
        }

        @Override
        public boolean func_75253_b() {
            return VexEntity.this.func_70605_aq().func_75640_a() && VexEntity.this.func_190647_dj() && VexEntity.this.func_70638_az() != null && VexEntity.this.func_70638_az().func_70089_S();
        }

        @Override
        public void func_75249_e() {
            LivingEntity livingEntity = VexEntity.this.func_70638_az();
            Vec3d \u26032 = livingEntity.func_174824_e(1.0f);
            VexEntity.this.field_70765_h.func_75642_a(\u26032.field_72450_a, \u26032.field_72448_b, \u26032.field_72449_c, 1.0);
            VexEntity.this.func_190648_a(true);
            VexEntity.this.func_184185_a(SoundEvents.field_191265_hd, 1.0f, 1.0f);
        }

        @Override
        public void func_75251_c() {
            VexEntity.this.func_190648_a(false);
        }

        @Override
        public void func_75246_d() {
            LivingEntity livingEntity = VexEntity.this.func_70638_az();
            if (VexEntity.this.func_174813_aQ().func_72326_a(livingEntity.func_174813_aQ())) {
                VexEntity.this.func_70652_k(livingEntity);
                VexEntity.this.func_190648_a(false);
            } else {
                double d = VexEntity.this.func_70068_e(livingEntity);
                if (d < 9.0) {
                    Vec3d vec3d = livingEntity.func_174824_e(1.0f);
                    VexEntity.this.field_70765_h.func_75642_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.0);
                }
            }
        }
    }

    class MoveHelperController
    extends MovementController {
        public MoveHelperController(VexEntity vexEntity2) {
            super(vexEntity2);
        }

        @Override
        public void func_75641_c() {
            if (this.field_188491_h != MovementController.Action.MOVE_TO) {
                return;
            }
            Vec3d vec3d = new Vec3d(this.field_75646_b - VexEntity.this.field_70165_t, this.field_75647_c - VexEntity.this.field_70163_u, this.field_75644_d - VexEntity.this.field_70161_v);
            double \u26032 = vec3d.func_72433_c();
            if (\u26032 < VexEntity.this.func_174813_aQ().func_72320_b()) {
                this.field_188491_h = MovementController.Action.WAIT;
                VexEntity.this.func_213317_d(VexEntity.this.func_213322_ci().func_186678_a(0.5));
            } else {
                VexEntity.this.func_213317_d(VexEntity.this.func_213322_ci().func_178787_e(vec3d.func_186678_a(this.field_75645_e * 0.05 / \u26032)));
                if (VexEntity.this.func_70638_az() == null) {
                    \u2603 = VexEntity.this.func_213322_ci();
                    VexEntity.this.field_70761_aq = VexEntity.this.field_70177_z = -((float)MathHelper.func_181159_b(\u2603.field_72450_a, \u2603.field_72449_c)) * 57.295776f;
                } else {
                    double d = VexEntity.this.func_70638_az().field_70165_t - VexEntity.this.field_70165_t;
                    \u2603 = VexEntity.this.func_70638_az().field_70161_v - VexEntity.this.field_70161_v;
                    VexEntity.this.field_70761_aq = VexEntity.this.field_70177_z = -((float)MathHelper.func_181159_b(d, \u2603)) * 57.295776f;
                }
            }
        }
    }
}

