/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.controller.DolphinLookController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.BreatheAirGoal;
import net.minecraft.entity.ai.goal.DolphinJumpGoal;
import net.minecraft.entity.ai.goal.FindWaterGoal;
import net.minecraft.entity.ai.goal.FollowBoatGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.GuardianEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathType;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biomes;

public class DolphinEntity
extends WaterMobEntity {
    private static final DataParameter<BlockPos> field_208014_b = EntityDataManager.func_187226_a(DolphinEntity.class, DataSerializers.field_187200_j);
    private static final DataParameter<Boolean> field_208013_bB = EntityDataManager.func_187226_a(DolphinEntity.class, DataSerializers.field_187198_h);
    private static final DataParameter<Integer> field_211138_bB = EntityDataManager.func_187226_a(DolphinEntity.class, DataSerializers.field_187192_b);
    private static final EntityPredicate field_213810_bA = new EntityPredicate().func_221013_a(10.0).func_221011_b().func_221008_a().func_221014_c();
    public static final Predicate<ItemEntity> field_205025_a = itemEntity -> !itemEntity.func_174874_s() && itemEntity.func_70089_S() && itemEntity.func_70090_H();

    public DolphinEntity(EntityType<? extends DolphinEntity> entityType, World world) {
        super((EntityType<? extends WaterMobEntity>)entityType, world);
        this.field_70765_h = new MoveHelperController(this);
        this.field_70749_g = new DolphinLookController(this, 10);
        this.func_98053_h(true);
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IWorld iWorld, DifficultyInstance difficultyInstance, SpawnReason spawnReason, @Nullable ILivingEntityData iLivingEntityData, @Nullable CompoundNBT compoundNBT) {
        this.func_70050_g(this.func_205010_bg());
        this.field_70125_A = 0.0f;
        return super.func_213386_a(iWorld, difficultyInstance, spawnReason, iLivingEntityData, compoundNBT);
    }

    @Override
    public boolean func_70648_aU() {
        return false;
    }

    @Override
    protected void func_209207_l(int n) {
    }

    public void func_208012_g(BlockPos blockPos) {
        this.field_70180_af.func_187227_b(field_208014_b, blockPos);
    }

    public BlockPos func_208010_l() {
        return this.field_70180_af.func_187225_a(field_208014_b);
    }

    public boolean func_208011_dD() {
        return this.field_70180_af.func_187225_a(field_208013_bB);
    }

    public void func_208008_s(boolean bl) {
        this.field_70180_af.func_187227_b(field_208013_bB, bl);
    }

    public int func_211136_dB() {
        return this.field_70180_af.func_187225_a(field_211138_bB);
    }

    public void func_211137_b(int n) {
        this.field_70180_af.func_187227_b(field_211138_bB, n);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_208014_b, BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(field_208013_bB, false);
        this.field_70180_af.func_187214_a(field_211138_bB, 2400);
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        compoundNBT.func_74768_a("TreasurePosX", this.func_208010_l().func_177958_n());
        compoundNBT.func_74768_a("TreasurePosY", this.func_208010_l().func_177956_o());
        compoundNBT.func_74768_a("TreasurePosZ", this.func_208010_l().func_177952_p());
        compoundNBT.func_74757_a("GotFish", this.func_208011_dD());
        compoundNBT.func_74768_a("Moistness", this.func_211136_dB());
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        int n = compoundNBT.func_74762_e("TreasurePosX");
        \u2603 = compoundNBT.func_74762_e("TreasurePosY");
        \u2603 = compoundNBT.func_74762_e("TreasurePosZ");
        this.func_208012_g(new BlockPos(n, \u2603, \u2603));
        super.func_70037_a(compoundNBT);
        this.func_208008_s(compoundNBT.func_74767_n("GotFish"));
        this.func_211137_b(compoundNBT.func_74762_e("Moistness"));
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, new BreatheAirGoal(this));
        this.field_70714_bg.func_75776_a(0, new FindWaterGoal(this));
        this.field_70714_bg.func_75776_a(1, new SwimToTreasureGoal(this));
        this.field_70714_bg.func_75776_a(2, new SwimWithPlayerGoal(this, 4.0));
        this.field_70714_bg.func_75776_a(4, new RandomSwimmingGoal(this, 1.0, 10));
        this.field_70714_bg.func_75776_a(4, new LookRandomlyGoal(this));
        this.field_70714_bg.func_75776_a(5, new LookAtGoal(this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(5, new DolphinJumpGoal(this, 10));
        this.field_70714_bg.func_75776_a(6, new MeleeAttackGoal(this, 1.2f, true));
        this.field_70714_bg.func_75776_a(8, new PlayWithItemsGoal());
        this.field_70714_bg.func_75776_a(8, new FollowBoatGoal(this));
        this.field_70714_bg.func_75776_a(9, new AvoidEntityGoal<GuardianEntity>(this, GuardianEntity.class, 8.0f, 1.0, 1.0));
        this.field_70715_bh.func_75776_a(1, new HurtByTargetGoal(this, GuardianEntity.class).func_220794_a(new Class[0]));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.2f);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
    }

    @Override
    protected PathNavigator func_175447_b(World world) {
        return new SwimmerPathNavigator(this, world);
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        boolean bl = entity.func_70097_a(DamageSource.func_76358_a(this), (int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
        if (bl) {
            this.func_174815_a(this, entity);
            this.func_184185_a(SoundEvents.field_205205_aV, 1.0f, 1.0f);
        }
        return bl;
    }

    @Override
    public int func_205010_bg() {
        return 4800;
    }

    @Override
    protected int func_207300_l(int n) {
        return this.func_205010_bg();
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize entitySize) {
        return 0.3f;
    }

    @Override
    public int func_70646_bf() {
        return 1;
    }

    @Override
    public int func_184649_cE() {
        return 1;
    }

    @Override
    protected boolean func_184228_n(Entity entity) {
        return true;
    }

    @Override
    public boolean func_213365_e(ItemStack itemStack) {
        EquipmentSlotType equipmentSlotType = MobEntity.func_184640_d(itemStack);
        if (!this.func_184582_a(equipmentSlotType).func_190926_b()) {
            return false;
        }
        return equipmentSlotType == EquipmentSlotType.MAINHAND && super.func_213365_e(itemStack);
    }

    @Override
    protected void func_175445_a(ItemEntity itemEntity) {
        if (this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b() && this.func_175448_a(\u2603 = itemEntity.func_92059_d())) {
            this.func_184201_a(EquipmentSlotType.MAINHAND, \u2603);
            this.field_82174_bp[EquipmentSlotType.MAINHAND.func_188454_b()] = 2.0f;
            this.func_71001_a(itemEntity, \u2603.func_190916_E());
            itemEntity.func_70106_y();
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_175446_cd()) {
            return;
        }
        if (this.func_203008_ap()) {
            this.func_211137_b(2400);
        } else {
            this.func_211137_b(this.func_211136_dB() - 1);
            if (this.func_211136_dB() <= 0) {
                this.func_70097_a(DamageSource.field_205132_u, 1.0f);
            }
            if (this.field_70122_E) {
                this.func_213317_d(this.func_213322_ci().func_72441_c((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.2f, 0.5, (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.2f));
                this.field_70177_z = this.field_70146_Z.nextFloat() * 360.0f;
                this.field_70122_E = false;
                this.field_70160_al = true;
            }
        }
        if (this.field_70170_p.field_72995_K && this.func_70090_H() && this.func_213322_ci().func_189985_c() > 0.03) {
            Vec3d vec3d = this.func_70676_i(0.0f);
            float \u26032 = MathHelper.func_76134_b(this.field_70177_z * ((float)Math.PI / 180)) * 0.3f;
            float \u26033 = MathHelper.func_76126_a(this.field_70177_z * ((float)Math.PI / 180)) * 0.3f;
            float \u26034 = 1.2f - this.field_70146_Z.nextFloat() * 0.7f;
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_195594_a(ParticleTypes.field_206864_X, this.field_70165_t - vec3d.field_72450_a * (double)\u26034 + (double)\u26032, this.field_70163_u - vec3d.field_72448_b, this.field_70161_v - vec3d.field_72449_c * (double)\u26034 + (double)\u26033, 0.0, 0.0, 0.0);
                this.field_70170_p.func_195594_a(ParticleTypes.field_206864_X, this.field_70165_t - vec3d.field_72450_a * (double)\u26034 - (double)\u26032, this.field_70163_u - vec3d.field_72448_b, this.field_70161_v - vec3d.field_72449_c * (double)\u26034 - (double)\u26033, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    protected boolean func_184645_a(PlayerEntity playerEntity, Hand hand) {
        ItemStack itemStack = playerEntity.func_184586_b(hand);
        if (!itemStack.func_190926_b() && itemStack.func_77973_b().func_206844_a(ItemTags.field_206964_G)) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_184185_a(SoundEvents.field_205207_aX, 1.0f, 1.0f);
            }
            this.func_208008_s(true);
            if (!playerEntity.field_71075_bZ.field_75098_d) {
                itemStack.func_190918_g(1);
            }
            return true;
        }
        return super.func_184645_a(playerEntity, hand);
    }

    public static boolean func_223364_b(EntityType<DolphinEntity> entityType, IWorld iWorld, SpawnReason spawnReason, BlockPos blockPos, Random random) {
        return blockPos.func_177956_o() > 45 && blockPos.func_177956_o() < iWorld.func_181545_F() && (iWorld.func_180494_b(blockPos) != Biomes.field_76771_b || iWorld.func_180494_b(blockPos) != Biomes.field_150575_M) && iWorld.func_204610_c(blockPos).func_206884_a(FluidTags.field_206959_a);
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_205208_aY;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_205206_aW;
    }

    @Override
    @Nullable
    protected SoundEvent func_184639_G() {
        return this.func_70090_H() ? SoundEvents.field_205204_aU : SoundEvents.field_205203_aT;
    }

    @Override
    protected SoundEvent func_184181_aa() {
        return SoundEvents.field_205212_bc;
    }

    @Override
    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_205211_bb;
    }

    protected boolean func_208006_dE() {
        BlockPos blockPos = this.func_70661_as().func_208485_j();
        if (blockPos != null) {
            return blockPos.func_218137_a(this.func_213303_ch(), 12.0);
        }
        return false;
    }

    @Override
    public void func_213352_e(Vec3d vec3d) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(this.func_70689_ay(), vec3d);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (this.func_70638_az() == null) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            }
        } else {
            super.func_213352_e(vec3d);
        }
    }

    @Override
    public boolean func_184652_a(PlayerEntity playerEntity) {
        return true;
    }

    static class SwimToTreasureGoal
    extends Goal {
        private final DolphinEntity field_208057_a;
        private boolean field_208058_b;

        SwimToTreasureGoal(DolphinEntity dolphinEntity) {
            this.field_208057_a = dolphinEntity;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        public boolean func_220685_C_() {
            return false;
        }

        @Override
        public boolean func_75250_a() {
            return this.field_208057_a.func_208011_dD() && this.field_208057_a.func_70086_ai() >= 100;
        }

        @Override
        public boolean func_75253_b() {
            BlockPos blockPos = this.field_208057_a.func_208010_l();
            return !new BlockPos((double)blockPos.func_177958_n(), this.field_208057_a.field_70163_u, (double)blockPos.func_177952_p()).func_218137_a(this.field_208057_a.func_213303_ch(), 4.0) && !this.field_208058_b && this.field_208057_a.func_70086_ai() >= 100;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void func_75249_e() {
            this.field_208058_b = false;
            this.field_208057_a.func_70661_as().func_75499_g();
            World world = this.field_208057_a.field_70170_p;
            BlockPos \u26032 = new BlockPos(this.field_208057_a);
            String \u26033 = (double)world.field_73012_v.nextFloat() >= 0.5 ? "Ocean_Ruin" : "Shipwreck";
            BlockPos \u26034 = world.func_211157_a(\u26033, \u26032, 50, false);
            if (\u26034 == null) {
                BlockPos blockPos = world.func_211157_a(\u26033.equals("Ocean_Ruin") ? "Shipwreck" : "Ocean_Ruin", \u26032, 50, false);
                if (blockPos == null) {
                    this.field_208058_b = true;
                    return;
                }
                this.field_208057_a.func_208012_g(blockPos);
            } else {
                this.field_208057_a.func_208012_g(\u26034);
            }
            world.func_72960_a(this.field_208057_a, (byte)38);
        }

        @Override
        public void func_75251_c() {
            BlockPos blockPos = this.field_208057_a.func_208010_l();
            if (new BlockPos((double)blockPos.func_177958_n(), this.field_208057_a.field_70163_u, (double)blockPos.func_177952_p()).func_218137_a(this.field_208057_a.func_213303_ch(), 4.0) || this.field_208058_b) {
                this.field_208057_a.func_208008_s(false);
            }
        }

        @Override
        public void func_75246_d() {
            BlockPos blockPos = this.field_208057_a.func_208010_l();
            World \u26032 = this.field_208057_a.field_70170_p;
            if (this.field_208057_a.func_208006_dE() || this.field_208057_a.func_70661_as().func_75500_f()) {
                Vec3d vec3d = RandomPositionGenerator.func_203155_a(this.field_208057_a, 16, 1, new Vec3d(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()), 0.3926991f);
                if (vec3d == null) {
                    vec3d = RandomPositionGenerator.func_75464_a(this.field_208057_a, 8, 4, new Vec3d(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()));
                }
                if (!(vec3d == null || \u26032.func_204610_c(\u2603 = new BlockPos(vec3d)).func_206884_a(FluidTags.field_206959_a) && \u26032.func_180495_p(\u2603).func_196957_g(\u26032, \u2603, PathType.WATER))) {
                    vec3d = RandomPositionGenerator.func_75464_a(this.field_208057_a, 8, 5, new Vec3d(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()));
                }
                if (vec3d == null) {
                    this.field_208058_b = true;
                    return;
                }
                this.field_208057_a.func_70671_ap().func_75650_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, this.field_208057_a.func_184649_cE() + 20, this.field_208057_a.func_70646_bf());
                this.field_208057_a.func_70661_as().func_75492_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1.3);
                if (\u26032.field_73012_v.nextInt(80) == 0) {
                    \u26032.func_72960_a(this.field_208057_a, (byte)38);
                }
            }
        }
    }

    static class SwimWithPlayerGoal
    extends Goal {
        private final DolphinEntity field_206834_a;
        private final double field_206835_b;
        private PlayerEntity field_206836_c;

        SwimWithPlayerGoal(DolphinEntity dolphinEntity, double d) {
            this.field_206834_a = dolphinEntity;
            this.field_206835_b = d;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        public boolean func_75250_a() {
            this.field_206836_c = this.field_206834_a.field_70170_p.func_217370_a(field_213810_bA, this.field_206834_a);
            if (this.field_206836_c == null) {
                return false;
            }
            return this.field_206836_c.func_203007_ba();
        }

        @Override
        public boolean func_75253_b() {
            return this.field_206836_c != null && this.field_206836_c.func_203007_ba() && this.field_206834_a.func_70068_e(this.field_206836_c) < 256.0;
        }

        @Override
        public void func_75249_e() {
            this.field_206836_c.func_195064_c(new EffectInstance(Effects.field_206827_D, 100));
        }

        @Override
        public void func_75251_c() {
            this.field_206836_c = null;
            this.field_206834_a.func_70661_as().func_75499_g();
        }

        @Override
        public void func_75246_d() {
            this.field_206834_a.func_70671_ap().func_75651_a(this.field_206836_c, this.field_206834_a.func_184649_cE() + 20, this.field_206834_a.func_70646_bf());
            if (this.field_206834_a.func_70068_e(this.field_206836_c) < 6.25) {
                this.field_206834_a.func_70661_as().func_75499_g();
            } else {
                this.field_206834_a.func_70661_as().func_75497_a(this.field_206836_c, this.field_206835_b);
            }
            if (this.field_206836_c.func_203007_ba() && this.field_206836_c.field_70170_p.field_73012_v.nextInt(6) == 0) {
                this.field_206836_c.func_195064_c(new EffectInstance(Effects.field_206827_D, 100));
            }
        }
    }

    class PlayWithItemsGoal
    extends Goal {
        private int field_205154_b;

        private PlayWithItemsGoal() {
        }

        @Override
        public boolean func_75250_a() {
            if (this.field_205154_b > DolphinEntity.this.field_70173_aa) {
                return false;
            }
            List<ItemEntity> list = DolphinEntity.this.field_70170_p.func_175647_a(ItemEntity.class, DolphinEntity.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0), field_205025_a);
            return !list.isEmpty() || !DolphinEntity.this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b();
        }

        @Override
        public void func_75249_e() {
            List<ItemEntity> list = DolphinEntity.this.field_70170_p.func_175647_a(ItemEntity.class, DolphinEntity.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0), field_205025_a);
            if (!list.isEmpty()) {
                DolphinEntity.this.func_70661_as().func_75497_a(list.get(0), 1.2f);
                DolphinEntity.this.func_184185_a(SoundEvents.field_205210_ba, 1.0f, 1.0f);
            }
            this.field_205154_b = 0;
        }

        @Override
        public void func_75251_c() {
            ItemStack itemStack = DolphinEntity.this.func_184582_a(EquipmentSlotType.MAINHAND);
            if (!itemStack.func_190926_b()) {
                this.func_220810_a(itemStack);
                DolphinEntity.this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
                this.field_205154_b = DolphinEntity.this.field_70173_aa + DolphinEntity.this.field_70146_Z.nextInt(100);
            }
        }

        @Override
        public void func_75246_d() {
            List<ItemEntity> list = DolphinEntity.this.field_70170_p.func_175647_a(ItemEntity.class, DolphinEntity.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0), field_205025_a);
            ItemStack \u26032 = DolphinEntity.this.func_184582_a(EquipmentSlotType.MAINHAND);
            if (!\u26032.func_190926_b()) {
                this.func_220810_a(\u26032);
                DolphinEntity.this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
            } else if (!list.isEmpty()) {
                DolphinEntity.this.func_70661_as().func_75497_a(list.get(0), 1.2f);
            }
        }

        private void func_220810_a(ItemStack itemStack) {
            if (itemStack.func_190926_b()) {
                return;
            }
            double d = DolphinEntity.this.field_70163_u - (double)0.3f + (double)DolphinEntity.this.func_70047_e();
            ItemEntity \u26032 = new ItemEntity(DolphinEntity.this.field_70170_p, DolphinEntity.this.field_70165_t, d, DolphinEntity.this.field_70161_v, itemStack);
            \u26032.func_174867_a(40);
            \u26032.func_200216_c(DolphinEntity.this.func_110124_au());
            float \u26033 = 0.3f;
            float \u26034 = DolphinEntity.this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
            float \u26035 = 0.02f * DolphinEntity.this.field_70146_Z.nextFloat();
            \u26032.func_213293_j(0.3f * -MathHelper.func_76126_a(DolphinEntity.this.field_70177_z * ((float)Math.PI / 180)) * MathHelper.func_76134_b(DolphinEntity.this.field_70125_A * ((float)Math.PI / 180)) + MathHelper.func_76134_b(\u26034) * \u26035, 0.3f * MathHelper.func_76126_a(DolphinEntity.this.field_70125_A * ((float)Math.PI / 180)) * 1.5f, 0.3f * MathHelper.func_76134_b(DolphinEntity.this.field_70177_z * ((float)Math.PI / 180)) * MathHelper.func_76134_b(DolphinEntity.this.field_70125_A * ((float)Math.PI / 180)) + MathHelper.func_76126_a(\u26034) * \u26035);
            DolphinEntity.this.field_70170_p.func_217376_c(\u26032);
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final DolphinEntity field_205138_i;

        public MoveHelperController(DolphinEntity dolphinEntity) {
            super(dolphinEntity);
            this.field_205138_i = dolphinEntity;
        }

        @Override
        public void func_75641_c() {
            if (this.field_205138_i.func_70090_H()) {
                this.field_205138_i.func_213317_d(this.field_205138_i.func_213322_ci().func_72441_c(0.0, 0.005, 0.0));
            }
            if (this.field_188491_h != MovementController.Action.MOVE_TO || this.field_205138_i.func_70661_as().func_75500_f()) {
                this.field_205138_i.func_70659_e(0.0f);
                this.field_205138_i.func_184646_p(0.0f);
                this.field_205138_i.func_70657_f(0.0f);
                this.field_205138_i.func_191989_p(0.0f);
                return;
            }
            double d = this.field_75646_b - this.field_205138_i.field_70165_t;
            \u2603 = this.field_75647_c - this.field_205138_i.field_70163_u;
            \u2603 = this.field_75644_d - this.field_205138_i.field_70161_v;
            \u2603 = d * d + \u2603 * \u2603 + \u2603 * \u2603;
            if (\u2603 < 2.500000277905201E-7) {
                this.field_75648_a.func_191989_p(0.0f);
                return;
            }
            float \u26032 = (float)(MathHelper.func_181159_b(\u2603, d) * 57.2957763671875) - 90.0f;
            this.field_205138_i.field_70761_aq = this.field_205138_i.field_70177_z = this.func_75639_a(this.field_205138_i.field_70177_z, \u26032, 10.0f);
            this.field_205138_i.field_70759_as = this.field_205138_i.field_70177_z;
            float \u26033 = (float)(this.field_75645_e * this.field_205138_i.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
            if (this.field_205138_i.func_70090_H()) {
                this.field_205138_i.func_70659_e(\u26033 * 0.02f);
                float f = -((float)(MathHelper.func_181159_b(\u2603, MathHelper.func_76133_a(d * d + \u2603 * \u2603)) * 57.2957763671875));
                f = MathHelper.func_76131_a(MathHelper.func_76142_g(f), -85.0f, 85.0f);
                this.field_205138_i.field_70125_A = this.func_75639_a(this.field_205138_i.field_70125_A, f, 5.0f);
                \u2603 = MathHelper.func_76134_b(this.field_205138_i.field_70125_A * ((float)Math.PI / 180));
                \u2603 = MathHelper.func_76126_a(this.field_205138_i.field_70125_A * ((float)Math.PI / 180));
                this.field_205138_i.field_191988_bg = \u2603 * \u26033;
                this.field_205138_i.field_70701_bs = -\u2603 * \u26033;
            } else {
                this.field_205138_i.func_70659_e(\u26033 * 0.1f);
            }
        }
    }
}

