/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.text;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.util.text.ITargetedTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;

public class TextComponentUtils {
    public static ITextComponent func_211401_a(ITextComponent iTextComponent, Style style) {
        if (style.func_150229_g()) {
            return iTextComponent;
        }
        if (iTextComponent.func_150256_b().func_150229_g()) {
            return iTextComponent.func_150255_a(style.func_150232_l());
        }
        return new StringTextComponent("").func_150257_a(iTextComponent).func_150255_a(style.func_150232_l());
    }

    public static ITextComponent func_197680_a(@Nullable CommandSource commandSource, ITextComponent iTextComponent, @Nullable Entity entity, int n) throws CommandSyntaxException {
        if (n > 100) {
            return iTextComponent;
        }
        ITextComponent iTextComponent2 = iTextComponent instanceof ITargetedTextComponent ? ((ITargetedTextComponent)((Object)iTextComponent)).func_197668_a(commandSource, entity, ++n) : iTextComponent.func_150259_f();
        for (ITextComponent iTextComponent3 : iTextComponent.func_150253_a()) {
            iTextComponent2.func_150257_a(TextComponentUtils.func_197680_a(commandSource, iTextComponent3, entity, n));
        }
        return TextComponentUtils.func_211401_a(iTextComponent2, iTextComponent.func_150256_b());
    }

    public static ITextComponent func_197679_a(GameProfile gameProfile) {
        if (gameProfile.getName() != null) {
            return new StringTextComponent(gameProfile.getName());
        }
        if (gameProfile.getId() != null) {
            return new StringTextComponent(gameProfile.getId().toString());
        }
        return new StringTextComponent("(unknown)");
    }

    public static ITextComponent func_197678_a(Collection<String> collection) {
        return TextComponentUtils.func_197675_a(collection, string -> new StringTextComponent((String)string).func_211708_a(TextFormatting.GREEN));
    }

    public static <T extends Comparable<T>> ITextComponent func_197675_a(Collection<T> collection, Function<T, ITextComponent> function) {
        if (collection.isEmpty()) {
            return new StringTextComponent("");
        }
        if (collection.size() == 1) {
            return function.apply(collection.iterator().next());
        }
        ArrayList arrayList = Lists.newArrayList(collection);
        arrayList.sort(Comparable::compareTo);
        return TextComponentUtils.func_197677_b(collection, function);
    }

    public static <T> ITextComponent func_197677_b(Collection<T> collection, Function<T, ITextComponent> function) {
        if (collection.isEmpty()) {
            return new StringTextComponent("");
        }
        if (collection.size() == 1) {
            return function.apply(collection.iterator().next());
        }
        StringTextComponent stringTextComponent = new StringTextComponent("");
        boolean \u26032 = true;
        for (T t : collection) {
            if (!\u26032) {
                stringTextComponent.func_150257_a(new StringTextComponent(", ").func_211708_a(TextFormatting.GRAY));
            }
            stringTextComponent.func_150257_a(function.apply(t));
            \u26032 = false;
        }
        return stringTextComponent;
    }

    public static ITextComponent func_197676_a(ITextComponent iTextComponent) {
        return new StringTextComponent("[").func_150257_a(iTextComponent).func_150258_a("]");
    }

    public static ITextComponent func_202465_a(Message message) {
        if (message instanceof ITextComponent) {
            return (ITextComponent)message;
        }
        return new StringTextComponent(message.getString());
    }
}

