/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.village;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.util.IDynamicSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.village.PointOfInterest;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class PointOfInterestData
implements IDynamicSerializable {
    private static final Logger field_218255_a = LogManager.getLogger();
    private final Short2ObjectMap<PointOfInterest> field_218256_b = new Short2ObjectOpenHashMap();
    private final Map<PointOfInterestType, Set<PointOfInterest>> field_218257_c = Maps.newHashMap();
    private final Runnable field_218258_d;
    private boolean field_218259_e;

    public PointOfInterestData(Runnable runnable) {
        this.field_218258_d = runnable;
        this.field_218259_e = true;
    }

    public <T> PointOfInterestData(Runnable runnable, Dynamic<T> dynamic2) {
        this.field_218258_d = runnable;
        try {
            this.field_218259_e = dynamic2.get("Valid").asBoolean(false);
            dynamic2.get("Records").asStream().forEach(dynamic -> this.func_218254_a(new PointOfInterest(dynamic, runnable)));
        }
        catch (Exception exception) {
            field_218255_a.error("Failed to load POI chunk", (Throwable)exception);
            this.func_218253_a();
            this.field_218259_e = false;
        }
    }

    public Stream<PointOfInterest> func_218247_a(Predicate<PointOfInterestType> predicate, PointOfInterestManager.Status status) {
        return this.field_218257_c.entrySet().stream().filter(entry -> predicate.test((PointOfInterestType)entry.getKey())).flatMap(entry -> ((Set)entry.getValue()).stream()).filter(status.func_221035_a());
    }

    public void func_218243_a(BlockPos blockPos, PointOfInterestType pointOfInterestType) {
        if (this.func_218254_a(new PointOfInterest(blockPos, pointOfInterestType, this.field_218258_d))) {
            field_218255_a.debug("Added POI of type {} @ {}", new Supplier[]{() -> pointOfInterestType, () -> blockPos});
            this.field_218258_d.run();
        }
    }

    private boolean func_218254_a(PointOfInterest pointOfInterest) {
        BlockPos blockPos = pointOfInterest.func_218261_f();
        PointOfInterestType \u26032 = pointOfInterest.func_218260_g();
        short \u26033 = SectionPos.func_218150_b(blockPos);
        PointOfInterest \u26034 = (PointOfInterest)this.field_218256_b.get(\u26033);
        if (\u26034 != null) {
            if (\u26032.equals(\u26034.func_218260_g())) {
                return false;
            }
            throw new IllegalStateException("POI data mismatch: already registered at " + blockPos);
        }
        this.field_218256_b.put(\u26033, (Object)pointOfInterest);
        this.field_218257_c.computeIfAbsent(\u26032, pointOfInterestType -> Sets.newHashSet()).add(pointOfInterest);
        return true;
    }

    public void func_218248_a(BlockPos blockPos) {
        PointOfInterest pointOfInterest = (PointOfInterest)this.field_218256_b.remove(SectionPos.func_218150_b(blockPos));
        if (pointOfInterest == null) {
            field_218255_a.error("POI data mismatch: never registered at " + blockPos);
            return;
        }
        this.field_218257_c.get(pointOfInterest.func_218260_g()).remove(pointOfInterest);
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = pointOfInterest::func_218260_g;
        supplierArray[1] = pointOfInterest::func_218261_f;
        field_218255_a.debug("Removed POI of type {} @ {}", supplierArray);
        this.field_218258_d.run();
    }

    public boolean func_218251_c(BlockPos blockPos) {
        PointOfInterest pointOfInterest = (PointOfInterest)this.field_218256_b.get(SectionPos.func_218150_b(blockPos));
        if (pointOfInterest == null) {
            throw new IllegalStateException("POI never registered at " + blockPos);
        }
        boolean \u26032 = pointOfInterest.func_218264_c();
        this.field_218258_d.run();
        return \u26032;
    }

    public boolean func_218245_a(BlockPos blockPos, Predicate<PointOfInterestType> predicate) {
        short s = SectionPos.func_218150_b(blockPos);
        PointOfInterest \u26032 = (PointOfInterest)this.field_218256_b.get(s);
        return \u26032 != null && predicate.test(\u26032.func_218260_g());
    }

    public Optional<PointOfInterestType> func_218244_d(BlockPos blockPos) {
        short s = SectionPos.func_218150_b(blockPos);
        PointOfInterest \u26032 = (PointOfInterest)this.field_218256_b.get(s);
        return \u26032 != null ? Optional.of(\u26032.func_218260_g()) : Optional.empty();
    }

    @Override
    public <T> T func_218175_a(DynamicOps<T> dynamicOps) {
        Object object = dynamicOps.createList(this.field_218256_b.values().stream().map(pointOfInterest -> pointOfInterest.func_218175_a(dynamicOps)));
        return (T)dynamicOps.createMap((Map)ImmutableMap.of((Object)dynamicOps.createString("Records"), (Object)object, (Object)dynamicOps.createString("Valid"), (Object)dynamicOps.createBoolean(this.field_218259_e)));
    }

    public void func_218240_a(Consumer<BiConsumer<BlockPos, PointOfInterestType>> consumer) {
        if (!this.field_218259_e) {
            Short2ObjectOpenHashMap short2ObjectOpenHashMap = new Short2ObjectOpenHashMap(this.field_218256_b);
            this.func_218253_a();
            consumer.accept((arg_0, arg_1) -> this.func_218250_a((Short2ObjectMap)short2ObjectOpenHashMap, arg_0, arg_1));
            this.field_218259_e = true;
            this.field_218258_d.run();
        }
    }

    private void func_218253_a() {
        this.field_218256_b.clear();
        this.field_218257_c.clear();
    }

    private /* synthetic */ void func_218250_a(Short2ObjectMap short2ObjectMap, BlockPos blockPos, PointOfInterestType pointOfInterestType) {
        short s = SectionPos.func_218150_b(blockPos);
        PointOfInterest \u26032 = (PointOfInterest)short2ObjectMap.computeIfAbsent(s, n -> new PointOfInterest(blockPos, pointOfInterestType, this.field_218258_d));
        this.func_218254_a(\u26032);
    }
}

