/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk.storage;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.world.ITickList;
import net.minecraft.world.LightType;
import net.minecraft.world.SerializableTickList;
import net.minecraft.world.ServerTickList;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkPrimerTickList;
import net.minecraft.world.chunk.ChunkPrimerWrapper;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.chunk.UpgradeData;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.Structures;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.ServerWorldLightManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkSerializer {
    private static final Logger field_222658_a = LogManager.getLogger();

    public static ChunkPrimer func_222656_a(ServerWorld serverWorld, TemplateManager templateManager, PointOfInterestManager pointOfInterestManager, ChunkPos chunkPos, CompoundNBT compoundNBT) {
        ChunkPrimer \u260319;
        Object object;
        Object \u260322;
        Object \u260321;
        ChunkGenerator<?> chunkGenerator = serverWorld.func_72863_F().func_201711_g();
        BiomeProvider \u26032 = chunkGenerator.func_202090_b();
        CompoundNBT \u26033 = compoundNBT.func_74775_l("Level");
        ChunkPos \u26034 = new ChunkPos(\u26033.func_74762_e("xPos"), \u26033.func_74762_e("zPos"));
        if (!Objects.equals(chunkPos, \u26034)) {
            field_222658_a.error("Chunk file at {} is in the wrong location; relocating. (Expected {}, got {})", (Object)chunkPos, (Object)chunkPos, (Object)\u26034);
        }
        Biome[] \u26035 = new Biome[256];
        BlockPos.MutableBlockPos \u26036 = new BlockPos.MutableBlockPos();
        if (\u26033.func_150297_b("Biomes", 11)) {
            int[] object2 = \u26033.func_74759_k("Biomes");
            for (int i = 0; i < object2.length; ++i) {
                \u26035[i] = (Biome)Registry.field_212624_m.func_148745_a(object2[i]);
                if (\u26035[i] != null) continue;
                \u26035[i] = \u26032.func_222364_a(\u26036.func_181079_c((i & 0xF) + chunkPos.func_180334_c(), 0, (i >> 4 & 0xF) + chunkPos.func_180333_d()));
            }
        } else {
            for (int i = 0; i < \u26035.length; ++i) {
                \u26035[i] = \u26032.func_222364_a(\u26036.func_181079_c((i & 0xF) + chunkPos.func_180334_c(), 0, (i >> 4 & 0xF) + chunkPos.func_180333_d()));
            }
        }
        UpgradeData upgradeData = \u26033.func_150297_b("UpgradeData", 10) ? new UpgradeData(\u26033.func_74775_l("UpgradeData")) : UpgradeData.field_196994_a;
        ChunkPrimerTickList<Block> \u26037 = new ChunkPrimerTickList<Block>(block -> block == null || block.func_176223_P().func_196958_f(), chunkPos, \u26033.func_150295_c("ToBeTicked", 9));
        ChunkPrimerTickList<Fluid> \u26038 = new ChunkPrimerTickList<Fluid>(fluid -> fluid == null || fluid == Fluids.field_204541_a, chunkPos, \u26033.func_150295_c("LiquidsToBeTicked", 9));
        boolean \u26039 = \u26033.func_74767_n("isLightOn");
        ListNBT \u260310 = \u26033.func_150295_c("Sections", 10);
        int \u260311 = 16;
        ChunkSection[] \u260312 = new ChunkSection[16];
        boolean \u260313 = serverWorld.func_201675_m().func_191066_m();
        ServerChunkProvider \u260314 = serverWorld.func_72863_F();
        WorldLightManager \u260315 = ((AbstractChunkProvider)\u260314).func_212863_j_();
        if (\u26039) {
            \u260315.func_223115_b(chunkPos, true);
        }
        for (int i = 0; i < \u260310.size(); ++i) {
            CompoundNBT compoundNBT2 = \u260310.func_150305_b(i);
            byte \u260316 = compoundNBT2.func_74771_c("Y");
            if (compoundNBT2.func_150297_b("Palette", 9) && compoundNBT2.func_150297_b("BlockStates", 12)) {
                \u260321 = new ChunkSection(\u260316 << 4);
                ((ChunkSection)\u260321).func_186049_g().func_222642_a(compoundNBT2.func_150295_c("Palette", 10), compoundNBT2.func_197645_o("BlockStates"));
                ((ChunkSection)\u260321).func_76672_e();
                if (!((ChunkSection)\u260321).func_76663_a()) {
                    \u260312[\u260316] = \u260321;
                }
                pointOfInterestManager.func_219139_a(chunkPos, (ChunkSection)\u260321);
            }
            if (!\u26039) continue;
            if (compoundNBT2.func_150297_b("BlockLight", 7)) {
                \u260315.func_215574_a(LightType.BLOCK, SectionPos.func_218156_a(chunkPos, \u260316), new NibbleArray(compoundNBT2.func_74770_j("BlockLight")));
            }
            if (!\u260313 || !compoundNBT2.func_150297_b("SkyLight", 7)) continue;
            \u260315.func_215574_a(LightType.SKY, SectionPos.func_218156_a(chunkPos, \u260316), new NibbleArray(compoundNBT2.func_74770_j("SkyLight")));
        }
        long l = \u26033.func_74763_f("InhabitedTime");
        ChunkStatus.Type \u260317 = ChunkSerializer.func_222651_a(compoundNBT);
        if (\u260317 == ChunkStatus.Type.LEVELCHUNK) {
            ChunkPrimerTickList<Fluid> \u260318;
            ChunkPrimerTickList<Block> iTickList;
            if (\u26033.func_150297_b("TileTicks", 9)) {
                \u260322 = SerializableTickList.func_222984_a(\u26033.func_150295_c("TileTicks", 10), Registry.field_212618_g::func_177774_c, Registry.field_212618_g::func_82594_a);
            } else {
                iTickList = \u26037;
            }
            if (\u26033.func_150297_b("LiquidTicks", 9)) {
                object = SerializableTickList.func_222984_a(\u26033.func_150295_c("LiquidTicks", 10), Registry.field_212619_h::func_177774_c, Registry.field_212619_h::func_82594_a);
            } else {
                \u260318 = \u26038;
            }
            \u260321 = new Chunk(serverWorld.func_201672_e(), chunkPos, \u26035, upgradeData, iTickList, \u260318, l, \u260312, chunk -> ChunkSerializer.func_222650_a(\u26033, chunk));
        } else {
            \u260322 = new ChunkPrimer(chunkPos, upgradeData, \u260312, \u26037, \u26038);
            \u260319 = \u260322;
            \u260319.func_201577_a(\u26035);
            \u260319.func_177415_c(l);
            ((ChunkPrimer)\u260322).func_201574_a(ChunkStatus.func_222591_a(\u26033.func_74779_i("Status")));
            if (\u260319.func_201589_g().func_209003_a(ChunkStatus.field_222613_i)) {
                ((ChunkPrimer)\u260322).func_217306_a(\u260315);
            }
            if (!\u26039 && \u260319.func_201589_g().func_209003_a(ChunkStatus.field_222614_j)) {
                for (BlockPos blockPos : BlockPos.func_191531_b(chunkPos.func_180334_c(), 0, chunkPos.func_180333_d(), chunkPos.func_180332_e(), 255, chunkPos.func_180330_f())) {
                    if (\u260319.func_180495_p(blockPos).func_185906_d() == 0) continue;
                    ((ChunkPrimer)\u260322).func_201637_h(blockPos);
                }
            }
        }
        \u260319.func_217305_b(\u26039);
        \u260322 = \u26033.func_74775_l("Heightmaps");
        object = EnumSet.noneOf(Heightmap.Type.class);
        for (Heightmap.Type object4 : \u260319.func_201589_g().func_222595_h()) {
            String string = object4.func_203500_b();
            if (((CompoundNBT)\u260322).func_150297_b(string, 12)) {
                \u260319.func_201607_a(object4, ((CompoundNBT)\u260322).func_197645_o(string));
                continue;
            }
            ((AbstractCollection)object).add(object4);
        }
        Heightmap.func_222690_a(\u260319, (Set<Heightmap.Type>)object);
        CompoundNBT compoundNBT2 = \u26033.func_74775_l("Structures");
        \u260319.func_201612_a(ChunkSerializer.func_222653_a(chunkGenerator, templateManager, \u26032, compoundNBT2));
        \u260319.func_201606_b(ChunkSerializer.func_222654_b(compoundNBT2));
        if (\u26033.func_74767_n("shouldSave")) {
            \u260319.func_177427_f(true);
        }
        ListNBT \u260323 = \u26033.func_150295_c("PostProcessing", 9);
        for (int i = 0; i < \u260323.size(); ++i) {
            ListNBT \u260320 = \u260323.func_202169_e(i);
            for (int n = 0; n < \u260320.size(); ++n) {
                \u260319.func_201636_b(\u260320.func_202170_f(n), i);
            }
        }
        if (\u260317 == ChunkStatus.Type.LEVELCHUNK) {
            return new ChunkPrimerWrapper((Chunk)((Object)\u260319));
        }
        ChunkPrimer chunkPrimer = \u260319;
        ListNBT \u260324 = \u26033.func_150295_c("Entities", 10);
        for (int i = 0; i < \u260324.size(); ++i) {
            chunkPrimer.func_201626_b(\u260324.func_150305_b(i));
        }
        ListNBT listNBT = \u26033.func_150295_c("TileEntities", 10);
        for (int i = 0; i < listNBT.size(); ++i) {
            CompoundNBT compoundNBT3 = listNBT.func_150305_b(i);
            \u260319.func_201591_a(compoundNBT3);
        }
        ListNBT listNBT2 = \u26033.func_150295_c("Lights", 9);
        for (int i = 0; i < listNBT2.size(); ++i) {
            ListNBT listNBT3 = listNBT2.func_202169_e(i);
            for (int j = 0; j < listNBT3.size(); ++j) {
                chunkPrimer.func_201646_a(listNBT3.func_202170_f(j), i);
            }
        }
        CompoundNBT compoundNBT4 = \u26033.func_74775_l("CarvingMasks");
        for (String string : compoundNBT4.func_150296_c()) {
            GenerationStage.Carving carving = GenerationStage.Carving.valueOf(string);
            chunkPrimer.func_205767_a(carving, BitSet.valueOf(compoundNBT4.func_74770_j(string)));
        }
        return chunkPrimer;
    }

    public static CompoundNBT func_222645_a(ServerWorld serverWorld, IChunk iChunk2) {
        CompoundNBT compoundNBT;
        int[] nArray;
        ChunkPos chunkPos = iChunk2.func_76632_l();
        CompoundNBT \u26032 = new CompoundNBT();
        CompoundNBT \u26033 = new CompoundNBT();
        \u26032.func_74768_a("DataVersion", SharedConstants.func_215069_a().getWorldVersion());
        \u26032.func_218657_a("Level", \u26033);
        \u26033.func_74768_a("xPos", chunkPos.field_77276_a);
        \u26033.func_74768_a("zPos", chunkPos.field_77275_b);
        \u26033.func_74772_a("LastUpdate", serverWorld.func_82737_E());
        \u26033.func_74772_a("InhabitedTime", iChunk2.func_177416_w());
        \u26033.func_74778_a("Status", iChunk2.func_201589_g().func_222596_d());
        UpgradeData \u26034 = iChunk2.func_196966_y();
        if (!\u26034.func_196988_a()) {
            \u26033.func_218657_a("UpgradeData", \u26034.func_196992_b());
        }
        ChunkSection[] \u26035 = iChunk2.func_76587_i();
        ListNBT \u26036 = new ListNBT();
        ServerWorldLightManager \u26037 = serverWorld.func_72863_F().func_212863_j_();
        boolean \u26038 = iChunk2.func_217310_r();
        for (int i = -1; i < 17; ++i) {
            int n = i;
            ChunkSection chunkSection2 = Arrays.stream(\u26035).filter(chunkSection -> chunkSection != null && chunkSection.func_222632_g() >> 4 == n).findFirst().orElse(Chunk.field_186036_a);
            NibbleArray \u26039 = \u26037.func_215569_a(LightType.BLOCK).func_215612_a(SectionPos.func_218156_a(chunkPos, n));
            NibbleArray nibbleArray = \u26037.func_215569_a(LightType.SKY).func_215612_a(SectionPos.func_218156_a(chunkPos, n));
            if (chunkSection2 == Chunk.field_186036_a && \u26039 == null && nibbleArray == null) continue;
            CompoundNBT \u260311 = new CompoundNBT();
            \u260311.func_74774_a("Y", (byte)(n & 0xFF));
            if (chunkSection2 != Chunk.field_186036_a) {
                chunkSection2.func_186049_g().func_196963_b(\u260311, "Palette", "BlockStates");
            }
            if (\u26039 != null && !\u26039.func_215655_c()) {
                \u260311.func_74773_a("BlockLight", \u26039.func_177481_a());
            }
            if (nibbleArray != null && !nibbleArray.func_215655_c()) {
                \u260311.func_74773_a("SkyLight", nibbleArray.func_177481_a());
            }
            \u26036.add(\u260311);
        }
        \u26033.func_218657_a("Sections", \u26036);
        if (\u26038) {
            \u26033.func_74757_a("isLightOn", true);
        }
        int[] nArray2 = nArray = (\u2603 = iChunk2.func_201590_e()) != null ? new int[\u2603.length] : new int[]{};
        if (\u2603 != null) {
            for (int \u260312 = 0; \u260312 < \u2603.length; ++\u260312) {
                nArray[\u260312] = Registry.field_212624_m.func_148757_b(\u2603[\u260312]);
            }
        }
        \u26033.func_74783_a("Biomes", nArray);
        ListNBT listNBT = new ListNBT();
        for (BlockPos blockPos : iChunk2.func_203066_o()) {
            compoundNBT = iChunk2.func_223134_j(blockPos);
            if (compoundNBT == null) continue;
            listNBT.add(compoundNBT);
        }
        \u26033.func_218657_a("TileEntities", listNBT);
        ListNBT listNBT2 = new ListNBT();
        if (iChunk2.func_201589_g().func_202129_d() == ChunkStatus.Type.LEVELCHUNK) {
            Chunk chunk = (Chunk)iChunk2;
            chunk.func_177409_g(false);
            for (int i = 0; i < chunk.func_177429_s().length; ++i) {
                for (Entity entity : chunk.func_177429_s()[i]) {
                    if (!entity.func_70039_c(\u2603 = new CompoundNBT())) continue;
                    chunk.func_177409_g(true);
                    listNBT2.add(\u2603);
                }
            }
        } else {
            ChunkPrimer chunkPrimer = (ChunkPrimer)iChunk2;
            listNBT2.addAll(chunkPrimer.func_201652_l());
            \u26033.func_218657_a("Lights", ChunkSerializer.func_222647_a(chunkPrimer.func_201647_i()));
            compoundNBT = new CompoundNBT();
            for (GenerationStage.Carving carving : GenerationStage.Carving.values()) {
                compoundNBT.func_74773_a(carving.toString(), iChunk2.func_205749_a(carving).toByteArray());
            }
            \u26033.func_218657_a("CarvingMasks", compoundNBT);
        }
        \u26033.func_218657_a("Entities", listNBT2);
        ITickList<Block> iTickList = iChunk2.func_205218_i_();
        if (iTickList instanceof ChunkPrimerTickList) {
            \u26033.func_218657_a("ToBeTicked", ((ChunkPrimerTickList)iTickList).func_205379_a());
        } else if (iTickList instanceof SerializableTickList) {
            \u26033.func_218657_a("TileTicks", ((SerializableTickList)iTickList).func_219498_a(serverWorld.func_82737_E()));
        } else {
            \u26033.func_218657_a("TileTicks", ((ServerTickList)serverWorld.func_205220_G_()).func_219503_a(chunkPos));
        }
        ITickList<Fluid> \u260313 = iChunk2.func_212247_j();
        if (\u260313 instanceof ChunkPrimerTickList) {
            \u26033.func_218657_a("LiquidsToBeTicked", ((ChunkPrimerTickList)\u260313).func_205379_a());
        } else if (\u260313 instanceof SerializableTickList) {
            \u26033.func_218657_a("LiquidTicks", ((SerializableTickList)\u260313).func_219498_a(serverWorld.func_82737_E()));
        } else {
            \u26033.func_218657_a("LiquidTicks", ((ServerTickList)serverWorld.func_205219_F_()).func_219503_a(chunkPos));
        }
        \u26033.func_218657_a("PostProcessing", ChunkSerializer.func_222647_a(iChunk2.func_201614_D()));
        CompoundNBT \u260314 = new CompoundNBT();
        for (Map.Entry<Heightmap.Type, Heightmap> entry : iChunk2.func_217311_f()) {
            if (!iChunk2.func_201589_g().func_222595_h().contains((Object)entry.getKey())) continue;
            \u260314.func_218657_a(entry.getKey().func_203500_b(), new LongArrayNBT(entry.getValue().func_202269_a()));
        }
        \u26033.func_218657_a("Heightmaps", \u260314);
        \u26033.func_218657_a("Structures", ChunkSerializer.func_222649_a(chunkPos, iChunk2.func_201609_c(), iChunk2.func_201604_d()));
        return \u26032;
    }

    public static ChunkStatus.Type func_222651_a(@Nullable CompoundNBT compoundNBT) {
        if (compoundNBT != null && (\u2603 = ChunkStatus.func_222591_a(compoundNBT.func_74775_l("Level").func_74779_i("Status"))) != null) {
            return \u2603.func_202129_d();
        }
        return ChunkStatus.Type.PROTOCHUNK;
    }

    private static void func_222650_a(CompoundNBT compoundNBT2, Chunk chunk) {
        CompoundNBT compoundNBT2;
        ListNBT listNBT = compoundNBT2.func_150295_c("Entities", 10);
        World \u26032 = chunk.func_177412_p();
        for (int i = 0; i < listNBT.size(); ++i) {
            CompoundNBT compoundNBT3 = listNBT.func_150305_b(i);
            EntityType.func_220335_a(compoundNBT3, \u26032, entity -> {
                chunk.func_76612_a((Entity)entity);
                return entity;
            });
            chunk.func_177409_g(true);
        }
        ListNBT \u26033 = compoundNBT2.func_150295_c("TileEntities", 10);
        for (int i = 0; i < \u26033.size(); ++i) {
            CompoundNBT compoundNBT4 = \u26033.func_150305_b(i);
            boolean \u26034 = compoundNBT4.func_74767_n("keepPacked");
            if (\u26034) {
                chunk.func_201591_a(compoundNBT4);
                continue;
            }
            TileEntity \u26035 = TileEntity.func_203403_c(compoundNBT4);
            if (\u26035 == null) continue;
            chunk.func_150813_a(\u26035);
        }
    }

    private static CompoundNBT func_222649_a(ChunkPos chunkPos, Map<String, StructureStart> map, Map<String, LongSet> map2) {
        CompoundNBT compoundNBT = new CompoundNBT();
        \u2603 = new CompoundNBT();
        for (Map.Entry<String, StructureStart> entry : map.entrySet()) {
            \u2603.func_218657_a(entry.getKey(), entry.getValue().func_143021_a(chunkPos.field_77276_a, chunkPos.field_77275_b));
        }
        compoundNBT.func_218657_a("Starts", \u2603);
        \u2603 = new CompoundNBT();
        for (Map.Entry<String, LongSet> entry : map2.entrySet()) {
            \u2603.func_218657_a(entry.getKey(), new LongArrayNBT(entry.getValue()));
        }
        compoundNBT.func_218657_a("References", \u2603);
        return compoundNBT;
    }

    private static Map<String, StructureStart> func_222653_a(ChunkGenerator<?> chunkGenerator, TemplateManager templateManager, BiomeProvider biomeProvider, CompoundNBT compoundNBT) {
        HashMap hashMap = Maps.newHashMap();
        CompoundNBT \u26032 = compoundNBT.func_74775_l("Starts");
        for (String string : \u26032.func_150296_c()) {
            hashMap.put(string, Structures.func_215142_a(chunkGenerator, templateManager, biomeProvider, \u26032.func_74775_l(string)));
        }
        return hashMap;
    }

    private static Map<String, LongSet> func_222654_b(CompoundNBT compoundNBT) {
        HashMap hashMap = Maps.newHashMap();
        CompoundNBT \u26032 = compoundNBT.func_74775_l("References");
        for (String string : \u26032.func_150296_c()) {
            hashMap.put(string, new LongOpenHashSet(\u26032.func_197645_o(string)));
        }
        return hashMap;
    }

    public static ListNBT func_222647_a(ShortList[] shortListArray) {
        ListNBT listNBT = new ListNBT();
        for (ShortList shortList : shortListArray) {
            ListNBT listNBT2 = new ListNBT();
            if (shortList != null) {
                for (Short s : shortList) {
                    listNBT2.add(new ShortNBT(s));
                }
            }
            listNBT.add(listNBT2);
        }
        return listNBT;
    }
}

