/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.Dynamic;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.BitSetVoxelShapePart;
import net.minecraft.util.math.shapes.VoxelShapePart;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.template.Template;

public abstract class AbstractTreeFeature<T extends IFeatureConfig>
extends Feature<T> {
    public AbstractTreeFeature(Function<Dynamic<?>, ? extends T> function, boolean bl) {
        super(function, bl);
    }

    protected static boolean func_214587_a(IWorldGenerationBaseReader iWorldGenerationBaseReader, BlockPos blockPos) {
        return iWorldGenerationBaseReader.func_217375_a(blockPos, blockState -> {
            Block block = blockState.func_177230_c();
            return blockState.func_196958_f() || blockState.func_203425_a(BlockTags.field_206952_E) || block == Blocks.field_196658_i || Block.func_196245_f(block) || block.func_203417_a(BlockTags.field_200031_h) || block.func_203417_a(BlockTags.field_200030_g) || block == Blocks.field_150395_bd;
        });
    }

    protected static boolean func_214574_b(IWorldGenerationBaseReader iWorldGenerationBaseReader, BlockPos blockPos) {
        return iWorldGenerationBaseReader.func_217375_a(blockPos, BlockState::func_196958_f);
    }

    protected static boolean func_214578_c(IWorldGenerationBaseReader iWorldGenerationBaseReader, BlockPos blockPos) {
        return iWorldGenerationBaseReader.func_217375_a(blockPos, blockState -> Block.func_196245_f(blockState.func_177230_c()));
    }

    protected static boolean func_214571_e(IWorldGenerationBaseReader iWorldGenerationBaseReader, BlockPos blockPos) {
        return iWorldGenerationBaseReader.func_217375_a(blockPos, blockState -> blockState.func_177230_c() == Blocks.field_150355_j);
    }

    protected static boolean func_214570_f(IWorldGenerationBaseReader iWorldGenerationBaseReader, BlockPos blockPos) {
        return iWorldGenerationBaseReader.func_217375_a(blockPos, blockState -> blockState.func_203425_a(BlockTags.field_206952_E));
    }

    protected static boolean func_214572_g(IWorldGenerationBaseReader iWorldGenerationBaseReader, BlockPos blockPos) {
        return iWorldGenerationBaseReader.func_217375_a(blockPos, blockState -> blockState.func_196958_f() || blockState.func_203425_a(BlockTags.field_206952_E));
    }

    protected static boolean func_214589_h(IWorldGenerationBaseReader iWorldGenerationBaseReader, BlockPos blockPos) {
        return iWorldGenerationBaseReader.func_217375_a(blockPos, blockState -> {
            Block block = blockState.func_177230_c();
            return Block.func_196245_f(block) || block == Blocks.field_196658_i;
        });
    }

    protected static boolean func_214585_i(IWorldGenerationBaseReader iWorldGenerationBaseReader, BlockPos blockPos) {
        return iWorldGenerationBaseReader.func_217375_a(blockPos, blockState -> {
            Block block = blockState.func_177230_c();
            return Block.func_196245_f(block) || block == Blocks.field_196658_i || block == Blocks.field_150458_ak;
        });
    }

    protected static boolean func_214576_j(IWorldGenerationBaseReader iWorldGenerationBaseReader, BlockPos blockPos) {
        return iWorldGenerationBaseReader.func_217375_a(blockPos, blockState -> {
            Material material = blockState.func_185904_a();
            return material == Material.field_151582_l;
        });
    }

    protected void func_214584_a(IWorldGenerationReader iWorldGenerationReader, BlockPos blockPos) {
        if (!AbstractTreeFeature.func_214578_c(iWorldGenerationReader, blockPos)) {
            this.func_202278_a(iWorldGenerationReader, blockPos, Blocks.field_150346_d.func_176223_P());
        }
    }

    @Override
    protected void func_202278_a(IWorldWriter iWorldWriter, BlockPos blockPos, BlockState blockState) {
        this.func_208521_b(iWorldWriter, blockPos, blockState);
    }

    protected final void func_208520_a(Set<BlockPos> set, IWorldWriter iWorldWriter, BlockPos blockPos, BlockState blockState, MutableBoundingBox mutableBoundingBox) {
        this.func_208521_b(iWorldWriter, blockPos, blockState);
        mutableBoundingBox.func_78888_b(new MutableBoundingBox(blockPos, blockPos));
        if (BlockTags.field_200031_h.func_199685_a_(blockState.func_177230_c())) {
            set.add(blockPos.func_185334_h());
        }
    }

    private void func_208521_b(IWorldWriter iWorldWriter, BlockPos blockPos, BlockState blockState) {
        if (this.field_76488_a) {
            iWorldWriter.func_180501_a(blockPos, blockState, 19);
        } else {
            iWorldWriter.func_180501_a(blockPos, blockState, 18);
        }
    }

    @Override
    public final boolean func_212245_a(IWorld iWorld2, ChunkGenerator<? extends GenerationSettings> chunkGenerator, Random random, BlockPos blockPos, T t) {
        IWorld iWorld2;
        HashSet hashSet = Sets.newHashSet();
        MutableBoundingBox \u26032 = MutableBoundingBox.func_78887_a();
        boolean \u26033 = this.func_208519_a(hashSet, iWorld2, random, blockPos, \u26032);
        if (\u26032.field_78897_a > \u26032.field_78893_d) {
            return false;
        }
        ArrayList \u26034 = Lists.newArrayList();
        int \u26035 = 6;
        for (int i = 0; i < 6; ++i) {
            \u26034.add(Sets.newHashSet());
        }
        BitSetVoxelShapePart bitSetVoxelShapePart = new BitSetVoxelShapePart(\u26032.func_78883_b(), \u26032.func_78882_c(), \u26032.func_78880_d());
        try (BlockPos.PooledMutableBlockPos \u26036 = BlockPos.PooledMutableBlockPos.func_185346_s();){
            if (\u26033 && !hashSet.isEmpty()) {
                for (Object object : Lists.newArrayList((Iterable)hashSet)) {
                    if (\u26032.func_175898_b((Vec3i)object)) {
                        ((VoxelShapePart)bitSetVoxelShapePart).func_199625_a(((Vec3i)object).func_177958_n() - \u26032.field_78897_a, ((Vec3i)object).func_177956_o() - \u26032.field_78895_b, ((Vec3i)object).func_177952_p() - \u26032.field_78896_c, true, true);
                    }
                    for (Direction direction : Direction.values()) {
                        \u26036.func_189533_g((Vec3i)object).func_189536_c(direction);
                        if (hashSet.contains(\u26036) || !(\u2603 = iWorld2.func_180495_p(\u26036)).func_196959_b(BlockStateProperties.field_208514_aa)) continue;
                        ((Set)\u26034.get(0)).add(\u26036.func_185334_h());
                        this.func_208521_b(iWorld2, \u26036, (BlockState)\u2603.func_206870_a(BlockStateProperties.field_208514_aa, 1));
                        if (!\u26032.func_175898_b(\u26036)) continue;
                        ((VoxelShapePart)bitSetVoxelShapePart).func_199625_a(\u26036.func_177958_n() - \u26032.field_78897_a, \u26036.func_177956_o() - \u26032.field_78895_b, \u26036.func_177952_p() - \u26032.field_78896_c, true, true);
                    }
                }
            }
            for (int i = 1; i < 6; ++i) {
                Object object;
                object = (Set)\u26034.get(i - 1);
                Set \u26037 = (Set)\u26034.get(i);
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    BlockPos blockPos2 = (BlockPos)iterator.next();
                    if (\u26032.func_175898_b(blockPos2)) {
                        ((VoxelShapePart)bitSetVoxelShapePart).func_199625_a(blockPos2.func_177958_n() - \u26032.field_78897_a, blockPos2.func_177956_o() - \u26032.field_78895_b, blockPos2.func_177952_p() - \u26032.field_78896_c, true, true);
                    }
                    for (Direction direction : Direction.values()) {
                        \u26036.func_189533_g(blockPos2).func_189536_c(direction);
                        if (object.contains(\u26036) || \u26037.contains(\u26036) || !(\u2603 = iWorld2.func_180495_p(\u26036)).func_196959_b(BlockStateProperties.field_208514_aa) || (\u2603 = \u2603.func_177229_b(BlockStateProperties.field_208514_aa).intValue()) <= i + 1) continue;
                        BlockState blockState = (BlockState)\u2603.func_206870_a(BlockStateProperties.field_208514_aa, i + 1);
                        this.func_208521_b(iWorld2, \u26036, blockState);
                        if (\u26032.func_175898_b(\u26036)) {
                            ((VoxelShapePart)bitSetVoxelShapePart).func_199625_a(\u26036.func_177958_n() - \u26032.field_78897_a, \u26036.func_177956_o() - \u26032.field_78895_b, \u26036.func_177952_p() - \u26032.field_78896_c, true, true);
                        }
                        \u26037.add(\u26036.func_185334_h());
                    }
                }
            }
        }
        Template.func_222857_a(iWorld2, 3, bitSetVoxelShapePart, \u26032.field_78897_a, \u26032.field_78895_b, \u26032.field_78896_c);
        return \u26033;
    }

    protected abstract boolean func_208519_a(Set<BlockPos> var1, IWorldGenerationReader var2, Random var3, BlockPos var4, MutableBoundingBox var5);
}

