/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.jigsaw;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.JigsawBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.jigsaw.IJigsawDeserializer;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class FeatureJigsawPiece
extends JigsawPiece {
    private final ConfiguredFeature<?> field_214870_a;
    private final CompoundNBT field_214871_b;

    @Deprecated
    public FeatureJigsawPiece(ConfiguredFeature<?> configuredFeature) {
        this(configuredFeature, JigsawPattern.PlacementBehaviour.RIGID);
    }

    public FeatureJigsawPiece(ConfiguredFeature<?> configuredFeature, JigsawPattern.PlacementBehaviour placementBehaviour) {
        super(placementBehaviour);
        this.field_214870_a = configuredFeature;
        this.field_214871_b = this.func_214869_b();
    }

    public <T> FeatureJigsawPiece(Dynamic<T> dynamic) {
        super(dynamic);
        this.field_214870_a = ConfiguredFeature.func_222736_a(dynamic.get("feature").orElseEmptyMap());
        this.field_214871_b = this.func_214869_b();
    }

    public CompoundNBT func_214869_b() {
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_74778_a("target_pool", "minecraft:empty");
        compoundNBT.func_74778_a("attachement_type", "minecraft:bottom");
        compoundNBT.func_74778_a("final_state", "minecraft:air");
        return compoundNBT;
    }

    public BlockPos func_214868_a(TemplateManager templateManager, Rotation rotation) {
        return BlockPos.field_177992_a;
    }

    @Override
    public List<Template.BlockInfo> func_214849_a(TemplateManager templateManager, BlockPos blockPos, Rotation rotation, Random random) {
        ArrayList arrayList = Lists.newArrayList();
        arrayList.add(new Template.BlockInfo(blockPos, (BlockState)Blocks.field_222435_lY.func_176223_P().func_206870_a(JigsawBlock.field_176387_N, Direction.DOWN), this.field_214871_b));
        return arrayList;
    }

    @Override
    public MutableBoundingBox func_214852_a(TemplateManager templateManager, BlockPos blockPos, Rotation rotation) {
        BlockPos blockPos2 = this.func_214868_a(templateManager, rotation);
        return new MutableBoundingBox(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), blockPos.func_177958_n() + blockPos2.func_177958_n(), blockPos.func_177956_o() + blockPos2.func_177956_o(), blockPos.func_177952_p() + blockPos2.func_177952_p());
    }

    @Override
    public boolean func_214848_a(TemplateManager templateManager, IWorld iWorld, BlockPos blockPos, Rotation rotation, MutableBoundingBox mutableBoundingBox, Random random) {
        ChunkGenerator<?> chunkGenerator = iWorld.func_72863_F().func_201711_g();
        return this.field_214870_a.func_222734_a(iWorld, chunkGenerator, random, blockPos);
    }

    @Override
    public <T> Dynamic<T> func_214851_a(DynamicOps<T> dynamicOps) {
        return new Dynamic(dynamicOps, dynamicOps.createMap((Map)ImmutableMap.of((Object)dynamicOps.createString("feature"), (Object)this.field_214870_a.func_222735_a(dynamicOps).getValue())));
    }

    @Override
    public IJigsawDeserializer func_214853_a() {
        return IJigsawDeserializer.field_214930_d;
    }

    public String toString() {
        return "Feature[" + Registry.field_218379_q.func_177774_c(this.field_214870_a.field_222737_a) + "]";
    }
}

