/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.jigsaw;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.state.properties.StructureMode;
import net.minecraft.util.IDynamicDeserializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.jigsaw.IJigsawDeserializer;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.JigsawReplacementStructureProcessor;
import net.minecraft.world.gen.feature.template.NopProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class SingleJigsawPiece
extends JigsawPiece {
    protected final ResourceLocation field_214861_a;
    protected final ImmutableList<StructureProcessor> field_214862_b;

    @Deprecated
    public SingleJigsawPiece(String string, List<StructureProcessor> list) {
        this(string, list, JigsawPattern.PlacementBehaviour.RIGID);
    }

    public SingleJigsawPiece(String string, List<StructureProcessor> list, JigsawPattern.PlacementBehaviour placementBehaviour) {
        super(placementBehaviour);
        this.field_214861_a = new ResourceLocation(string);
        this.field_214862_b = ImmutableList.copyOf(list);
    }

    @Deprecated
    public SingleJigsawPiece(String string) {
        this(string, (List<StructureProcessor>)ImmutableList.of());
    }

    public SingleJigsawPiece(Dynamic<?> dynamic2) {
        super(dynamic2);
        this.field_214861_a = new ResourceLocation(dynamic2.get("location").asString(""));
        this.field_214862_b = ImmutableList.copyOf((Collection)dynamic2.get("processors").asList(dynamic -> IDynamicDeserializer.func_214907_a(dynamic, Registry.field_218364_E, "processor_type", NopProcessor.field_215199_a)));
    }

    public List<Template.BlockInfo> func_214857_a(TemplateManager templateManager, BlockPos blockPos, Rotation rotation, boolean bl) {
        Template template = templateManager.func_200220_a(this.field_214861_a);
        List<Template.BlockInfo> \u26032 = template.func_215386_a(blockPos, new PlacementSettings().func_186220_a(rotation), Blocks.field_185779_df, bl);
        ArrayList \u26033 = Lists.newArrayList();
        for (Template.BlockInfo blockInfo : \u26032) {
            if (blockInfo.field_186244_c == null || (\u2603 = StructureMode.valueOf(blockInfo.field_186244_c.func_74779_i("mode"))) != StructureMode.DATA) continue;
            \u26033.add(blockInfo);
        }
        return \u26033;
    }

    @Override
    public List<Template.BlockInfo> func_214849_a(TemplateManager templateManager, BlockPos blockPos, Rotation rotation, Random random) {
        Template template = templateManager.func_200220_a(this.field_214861_a);
        List<Template.BlockInfo> \u26032 = template.func_215386_a(blockPos, new PlacementSettings().func_186220_a(rotation), Blocks.field_222435_lY, true);
        Collections.shuffle(\u26032, random);
        return \u26032;
    }

    @Override
    public MutableBoundingBox func_214852_a(TemplateManager templateManager, BlockPos blockPos, Rotation rotation) {
        Template template = templateManager.func_200220_a(this.field_214861_a);
        return template.func_215388_b(new PlacementSettings().func_186220_a(rotation), blockPos);
    }

    @Override
    public boolean func_214848_a(TemplateManager templateManager, IWorld iWorld, BlockPos blockPos, Rotation rotation, MutableBoundingBox mutableBoundingBox, Random random) {
        Template template = templateManager.func_200220_a(this.field_214861_a);
        if (template.func_189962_a(iWorld, blockPos, \u2603 = this.func_214860_a(rotation, mutableBoundingBox), 18)) {
            List<Template.BlockInfo> list = Template.func_215387_a(iWorld, blockPos, \u2603, this.func_214857_a(templateManager, blockPos, rotation, false));
            for (Template.BlockInfo blockInfo : list) {
                this.func_214846_a(iWorld, blockInfo, blockPos, rotation, random, mutableBoundingBox);
            }
            return true;
        }
        return false;
    }

    protected PlacementSettings func_214860_a(Rotation rotation, MutableBoundingBox mutableBoundingBox) {
        PlacementSettings placementSettings = new PlacementSettings();
        placementSettings.func_186223_a(mutableBoundingBox);
        placementSettings.func_186220_a(rotation);
        placementSettings.func_215223_c(true);
        placementSettings.func_186222_a(false);
        placementSettings.func_215222_a(BlockIgnoreStructureProcessor.field_215206_c);
        placementSettings.func_215222_a(JigsawReplacementStructureProcessor.field_215196_a);
        this.field_214862_b.forEach(placementSettings::func_215222_a);
        this.func_214854_c().func_214937_b().forEach(placementSettings::func_215222_a);
        return placementSettings;
    }

    @Override
    public IJigsawDeserializer func_214853_a() {
        return IJigsawDeserializer.field_214928_b;
    }

    @Override
    public <T> Dynamic<T> func_214851_a(DynamicOps<T> dynamicOps) {
        return new Dynamic(dynamicOps, dynamicOps.createMap((Map)ImmutableMap.of((Object)dynamicOps.createString("location"), (Object)dynamicOps.createString(this.field_214861_a.toString()), (Object)dynamicOps.createString("processors"), (Object)dynamicOps.createList(this.field_214862_b.stream().map(structureProcessor -> structureProcessor.func_215191_b(dynamicOps).getValue())))));
    }

    public String toString() {
        return "Single[" + this.field_214861_a + "]";
    }
}

