/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.server;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEventData;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.INPC;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.boss.dragon.EnderDragonPartEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.merchant.IReputationTracking;
import net.minecraft.entity.merchant.IReputationType;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.passive.horse.SkeletonHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateBlockBreakPacket;
import net.minecraft.network.play.server.SBlockActionPacket;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.network.play.server.SEntityStatusPacket;
import net.minecraft.network.play.server.SExplosionPacket;
import net.minecraft.network.play.server.SPlaySoundEffectPacket;
import net.minecraft.network.play.server.SPlaySoundEventPacket;
import net.minecraft.network.play.server.SSpawnGlobalEntityPacket;
import net.minecraft.network.play.server.SSpawnMovingSoundEffectPacket;
import net.minecraft.network.play.server.SSpawnParticlePacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.profiler.IProfiler;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.ServerScoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.NetworkTagManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.CSVWriter;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Unit;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.Explosion;
import net.minecraft.world.ForcedChunksSaveData;
import net.minecraft.world.GameRules;
import net.minecraft.world.ITickList;
import net.minecraft.world.IWorld;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.ServerTickList;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.listener.IChunkStatusListener;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.BonusChestFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.raid.Raid;
import net.minecraft.world.raid.RaidManager;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.TicketType;
import net.minecraft.world.spawner.WanderingTraderSpawner;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapIdTracker;
import net.minecraft.world.storage.SaveHandler;
import net.minecraft.world.storage.SessionLockException;
import net.minecraft.world.storage.WorldInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerWorld
extends World {
    private static final Logger field_147491_a = LogManager.getLogger();
    private final List<Entity> field_217497_w = Lists.newArrayList();
    private final Int2ObjectMap<Entity> field_217498_x = new Int2ObjectLinkedOpenHashMap();
    private final Map<UUID, Entity> field_175741_N = Maps.newHashMap();
    private final Queue<Entity> field_217499_z = Queues.newArrayDeque();
    private final List<ServerPlayerEntity> field_217491_A = Lists.newArrayList();
    boolean field_217492_a;
    private final MinecraftServer field_73061_a;
    private final SaveHandler field_217493_C;
    public boolean field_73058_d;
    private boolean field_73068_P;
    private int field_80004_Q;
    private final Teleporter field_85177_Q;
    private final ServerTickList<Block> field_94579_S = new ServerTickList<Block>(this, block -> block == null || block.func_176223_P().func_196958_f(), Registry.field_212618_g::func_177774_c, Registry.field_212618_g::func_82594_a, this::func_205338_b);
    private final ServerTickList<Fluid> field_205342_P = new ServerTickList<Fluid>(this, fluid -> fluid == null || fluid == Fluids.field_204541_a, Registry.field_212619_h::func_177774_c, Registry.field_212619_h::func_82594_a, this::func_205339_a);
    private final Set<PathNavigator> field_217495_I = Sets.newHashSet();
    protected final RaidManager field_217494_c;
    private final ObjectLinkedOpenHashSet<BlockEventData> field_147490_S = new ObjectLinkedOpenHashSet();
    private boolean field_211159_Q;
    @Nullable
    private final WanderingTraderSpawner field_217496_L;

    public ServerWorld(MinecraftServer minecraftServer, Executor executor, SaveHandler saveHandler, WorldInfo worldInfo, DimensionType dimensionType, IProfiler iProfiler, IChunkStatusListener iChunkStatusListener) {
        super(worldInfo, dimensionType, (world, dimension) -> new ServerChunkProvider((ServerWorld)world, saveHandler.func_75765_b(), saveHandler.func_197718_i(), saveHandler.func_186340_h(), executor, dimension.func_186060_c(), minecraftServer.func_184103_al().func_72395_o(), iChunkStatusListener, () -> minecraftServer.func_71218_a(DimensionType.field_223227_a_).func_217481_x()), iProfiler, false);
        this.field_217493_C = saveHandler;
        this.field_73061_a = minecraftServer;
        this.field_85177_Q = new Teleporter(this);
        this.func_72966_v();
        this.func_72947_a();
        this.func_175723_af().func_177725_a(minecraftServer.func_175580_aG());
        this.field_217494_c = this.func_217481_x().func_215752_a(() -> new RaidManager(this), RaidManager.func_215172_a(this.field_73011_w));
        if (!minecraftServer.func_71264_H()) {
            this.func_72912_H().func_76060_a(minecraftServer.func_71265_f());
        }
        this.field_217496_L = this.field_73011_w.func_186058_p() == DimensionType.field_223227_a_ ? new WanderingTraderSpawner(this) : null;
    }

    public void func_72835_b(BooleanSupplier booleanSupplier) {
        IProfiler iProfiler = this.func_217381_Z();
        this.field_211159_Q = true;
        iProfiler.func_76320_a("world border");
        this.func_175723_af().func_212673_r();
        iProfiler.func_219895_b("weather");
        boolean \u26032 = this.func_72896_J();
        if (this.field_73011_w.func_191066_m()) {
            if (this.func_82736_K().func_223586_b(GameRules.field_223617_t)) {
                int n = this.field_72986_A.func_176133_A();
                \u2603 = this.field_72986_A.func_76071_n();
                \u2603 = this.field_72986_A.func_76083_p();
                boolean \u26033 = this.field_72986_A.func_76061_m();
                boolean \u26034 = this.field_72986_A.func_76059_o();
                if (n > 0) {
                    --n;
                    \u2603 = \u26033 ? 0 : 1;
                    \u2603 = \u26034 ? 0 : 1;
                    \u26033 = false;
                    \u26034 = false;
                } else {
                    if (\u2603 > 0) {
                        if (--\u2603 == 0) {
                            \u26033 = !\u26033;
                        }
                    } else {
                        \u2603 = \u26033 ? this.field_73012_v.nextInt(12000) + 3600 : this.field_73012_v.nextInt(168000) + 12000;
                    }
                    if (\u2603 > 0) {
                        if (--\u2603 == 0) {
                            \u26034 = !\u26034;
                        }
                    } else {
                        \u2603 = \u26034 ? this.field_73012_v.nextInt(12000) + 12000 : this.field_73012_v.nextInt(168000) + 12000;
                    }
                }
                this.field_72986_A.func_76090_f(\u2603);
                this.field_72986_A.func_76080_g(\u2603);
                this.field_72986_A.func_176142_i(n);
                this.field_72986_A.func_76069_a(\u26033);
                this.field_72986_A.func_76084_b(\u26034);
            }
            this.field_73018_p = this.field_73017_q;
            this.field_73017_q = this.field_72986_A.func_76061_m() ? (float)((double)this.field_73017_q + 0.01) : (float)((double)this.field_73017_q - 0.01);
            this.field_73017_q = MathHelper.func_76131_a(this.field_73017_q, 0.0f, 1.0f);
            this.field_73003_n = this.field_73004_o;
            this.field_73004_o = this.field_72986_A.func_76059_o() ? (float)((double)this.field_73004_o + 0.01) : (float)((double)this.field_73004_o - 0.01);
            this.field_73004_o = MathHelper.func_76131_a(this.field_73004_o, 0.0f, 1.0f);
        }
        if (this.field_73003_n != this.field_73004_o) {
            this.field_73061_a.func_184103_al().func_148537_a(new SChangeGameStatePacket(7, this.field_73004_o), this.field_73011_w.func_186058_p());
        }
        if (this.field_73018_p != this.field_73017_q) {
            this.field_73061_a.func_184103_al().func_148537_a(new SChangeGameStatePacket(8, this.field_73017_q), this.field_73011_w.func_186058_p());
        }
        if (\u26032 != this.func_72896_J()) {
            if (\u26032) {
                this.field_73061_a.func_184103_al().func_148540_a(new SChangeGameStatePacket(2, 0.0f));
            } else {
                this.field_73061_a.func_184103_al().func_148540_a(new SChangeGameStatePacket(1, 0.0f));
            }
            this.field_73061_a.func_184103_al().func_148540_a(new SChangeGameStatePacket(7, this.field_73004_o));
            this.field_73061_a.func_184103_al().func_148540_a(new SChangeGameStatePacket(8, this.field_73017_q));
        }
        if (this.func_72912_H().func_76093_s() && this.func_175659_aa() != Difficulty.HARD) {
            this.func_72912_H().func_176144_a(Difficulty.HARD);
        }
        if (this.field_73068_P && this.field_217491_A.stream().noneMatch(serverPlayerEntity -> !serverPlayerEntity.func_175149_v() && !serverPlayerEntity.func_71026_bH())) {
            this.field_73068_P = false;
            if (this.func_82736_K().func_223586_b(GameRules.field_223607_j)) {
                long \u26035 = this.field_72986_A.func_76073_f() + 24000L;
                this.func_72877_b(\u26035 - \u26035 % 24000L);
            }
            this.field_217491_A.stream().filter(LivingEntity::func_70608_bn).forEach(serverPlayerEntity -> serverPlayerEntity.func_70999_a(false, false, true));
            if (this.func_82736_K().func_223586_b(GameRules.field_223617_t)) {
                this.func_73051_P();
            }
        }
        this.func_72966_v();
        this.func_217389_a();
        iProfiler.func_219895_b("chunkSource");
        this.func_72863_F().func_217207_a(booleanSupplier);
        iProfiler.func_219895_b("tickPending");
        if (this.field_72986_A.func_76067_t() != WorldType.field_180272_g) {
            this.field_94579_S.func_205365_a();
            this.field_205342_P.func_205365_a();
        }
        iProfiler.func_219895_b("portalForcer");
        this.field_85177_Q.func_85189_a(this.func_82737_E());
        iProfiler.func_219895_b("raid");
        this.field_217494_c.func_215171_a();
        if (this.field_217496_L != null) {
            this.field_217496_L.func_221242_a();
        }
        iProfiler.func_219895_b("blockEvents");
        this.func_147488_Z();
        this.field_211159_Q = false;
        iProfiler.func_219895_b("entities");
        boolean bl = \u2603 = !this.field_217491_A.isEmpty() || !this.func_217469_z().isEmpty();
        if (\u2603) {
            this.func_82742_i();
        }
        if (\u2603 || this.field_80004_Q++ < 300) {
            this.field_73011_w.func_186059_r();
            iProfiler.func_76320_a("global");
            for (\u2603 = 0; \u2603 < this.field_217497_w.size(); ++\u2603) {
                Entity entity2 = this.field_217497_w.get(\u2603);
                this.func_217390_a(entity -> {
                    ++entity.field_70173_aa;
                    entity.func_70071_h_();
                }, entity2);
                if (!entity2.field_70128_L) continue;
                this.field_217497_w.remove(\u2603--);
            }
            iProfiler.func_219895_b("regular");
            this.field_217492_a = true;
            ObjectIterator \u26036 = this.field_217498_x.int2ObjectEntrySet().iterator();
            while (\u26036.hasNext()) {
                Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)\u26036.next();
                Entity \u26037 = (Entity)entry.getValue();
                Entity \u26038 = \u26037.func_184187_bx();
                if (!this.field_73061_a.func_71268_U() && (\u26037 instanceof AnimalEntity || \u26037 instanceof WaterMobEntity)) {
                    \u26037.func_70106_y();
                }
                if (!this.field_73061_a.func_71220_V() && \u26037 instanceof INPC) {
                    \u26037.func_70106_y();
                }
                if (\u26038 != null) {
                    if (!\u26038.field_70128_L && \u26038.func_184196_w(\u26037)) continue;
                    \u26037.func_184210_p();
                }
                iProfiler.func_76320_a("tick");
                if (!\u26037.field_70128_L && !(\u26037 instanceof EnderDragonPartEntity)) {
                    this.func_217390_a(this::func_217479_a, \u26037);
                }
                iProfiler.func_76319_b();
                iProfiler.func_76320_a("remove");
                if (\u26037.field_70128_L) {
                    this.func_217454_n(\u26037);
                    \u26036.remove();
                    this.func_217484_g(\u26037);
                }
                iProfiler.func_76319_b();
            }
            this.field_217492_a = false;
            while ((\u2603 = this.field_217499_z.poll()) != null) {
                this.func_217465_m(\u2603);
            }
            iProfiler.func_76319_b();
            this.func_217391_K();
        }
        iProfiler.func_76319_b();
    }

    public void func_217441_a(Chunk chunk, int n) {
        BlockPos blockPos;
        ChunkPos chunkPos = chunk.func_76632_l();
        boolean \u26032 = this.func_72896_J();
        int \u26033 = chunkPos.func_180334_c();
        int \u26034 = chunkPos.func_180333_d();
        IProfiler \u26035 = this.func_217381_Z();
        \u26035.func_76320_a("thunder");
        if (\u26032 && this.func_72911_I() && this.field_73012_v.nextInt(100000) == 0 && this.func_175727_C(blockPos = this.func_175736_a(this.func_217383_a(\u26033, 0, \u26034, 15)))) {
            DifficultyInstance difficultyInstance = this.func_175649_E(blockPos);
            boolean bl = \u2603 = this.func_82736_K().func_223586_b(GameRules.field_223601_d) && this.field_73012_v.nextDouble() < (double)difficultyInstance.func_180168_b() * 0.01;
            if (\u2603) {
                SkeletonHorseEntity skeletonHorseEntity = EntityType.field_200742_ah.func_200721_a(this);
                skeletonHorseEntity.func_190691_p(true);
                skeletonHorseEntity.func_70873_a(0);
                skeletonHorseEntity.func_70107_b(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
                this.func_217376_c(skeletonHorseEntity);
            }
            this.func_217468_a(new LightningBoltEntity(this, (double)blockPos.func_177958_n() + 0.5, blockPos.func_177956_o(), (double)blockPos.func_177952_p() + 0.5, \u2603));
        }
        \u26035.func_219895_b("iceandsnow");
        if (this.field_73012_v.nextInt(16) == 0) {
            BlockPos blockPos2 = this.func_205770_a(Heightmap.Type.MOTION_BLOCKING, this.func_217383_a(\u26033, 0, \u26034, 15));
            BlockPos \u26036 = blockPos2.func_177977_b();
            Biome \u26037 = this.func_180494_b(blockPos2);
            if (\u26037.func_201848_a(this, \u26036)) {
                this.func_175656_a(\u26036, Blocks.field_150432_aD.func_176223_P());
            }
            if (\u26032 && \u26037.func_201850_b(this, blockPos2)) {
                this.func_175656_a(blockPos2, Blocks.field_150433_aE.func_176223_P());
            }
            if (\u26032 && this.func_180494_b(\u26036).func_201851_b() == Biome.RainType.RAIN) {
                this.func_180495_p(\u26036).func_177230_c().func_176224_k(this, \u26036);
            }
        }
        \u26035.func_219895_b("tickBlocks");
        if (n > 0) {
            for (ChunkSection chunkSection : chunk.func_76587_i()) {
                if (chunkSection == Chunk.field_186036_a || !chunkSection.func_206915_b()) continue;
                int n2 = chunkSection.func_222632_g();
                for (int i = 0; i < n; ++i) {
                    blockPos = this.func_217383_a(\u26033, n2, \u26034, 15);
                    \u26035.func_76320_a("randomTick");
                    BlockState \u26038 = chunkSection.func_177485_a(blockPos.func_177958_n() - \u26033, blockPos.func_177956_o() - n2, blockPos.func_177952_p() - \u26034);
                    if (\u26038.func_204519_t()) {
                        \u26038.func_196944_b(this, blockPos, this.field_73012_v);
                    }
                    if ((\u2603 = \u26038.func_204520_s()).func_206890_h()) {
                        \u2603.func_206891_b(this, blockPos, this.field_73012_v);
                    }
                    \u26035.func_76319_b();
                }
            }
        }
        \u26035.func_76319_b();
    }

    protected BlockPos func_175736_a(BlockPos blockPos) {
        BlockPos blockPos2;
        blockPos2 = this.func_205770_a(Heightmap.Type.MOTION_BLOCKING, blockPos);
        AxisAlignedBB axisAlignedBB = new AxisAlignedBB(blockPos2, new BlockPos(blockPos2.func_177958_n(), this.func_217301_I(), blockPos2.func_177952_p())).func_186662_g(3.0);
        List<LivingEntity> \u26032 = this.func_175647_a(LivingEntity.class, axisAlignedBB, livingEntity -> livingEntity != null && livingEntity.func_70089_S() && this.func_217337_f(livingEntity.func_180425_c()));
        if (!\u26032.isEmpty()) {
            return \u26032.get(this.field_73012_v.nextInt(\u26032.size())).func_180425_c();
        }
        if (blockPos2.func_177956_o() == -1) {
            blockPos2 = blockPos2.func_177981_b(2);
        }
        return blockPos2;
    }

    public boolean func_211158_j_() {
        return this.field_211159_Q;
    }

    public void func_72854_c() {
        this.field_73068_P = false;
        if (!this.field_217491_A.isEmpty()) {
            int n;
            int n2 = 0;
            n = 0;
            for (ServerPlayerEntity serverPlayerEntity : this.field_217491_A) {
                if (serverPlayerEntity.func_175149_v()) {
                    ++n2;
                    continue;
                }
                if (!serverPlayerEntity.func_70608_bn()) continue;
                ++n;
            }
            this.field_73068_P = n > 0 && n >= this.field_217491_A.size() - n2;
        }
    }

    @Override
    public ServerScoreboard func_96441_U() {
        return this.field_73061_a.func_200251_aP();
    }

    private void func_73051_P() {
        this.field_72986_A.func_76080_g(0);
        this.field_72986_A.func_76084_b(false);
        this.field_72986_A.func_76090_f(0);
        this.field_72986_A.func_76069_a(false);
    }

    public void func_82742_i() {
        this.field_80004_Q = 0;
    }

    private void func_205339_a(NextTickListEntry<Fluid> nextTickListEntry) {
        IFluidState iFluidState = this.func_204610_c(nextTickListEntry.field_180282_a);
        if (iFluidState.func_206886_c() == nextTickListEntry.func_151351_a()) {
            iFluidState.func_206880_a(this, nextTickListEntry.field_180282_a);
        }
    }

    private void func_205338_b(NextTickListEntry<Block> nextTickListEntry) {
        BlockState blockState = this.func_180495_p(nextTickListEntry.field_180282_a);
        if (blockState.func_177230_c() == nextTickListEntry.func_151351_a()) {
            blockState.func_196940_a(this, nextTickListEntry.field_180282_a, this.field_73012_v);
        }
    }

    public void func_217479_a(Entity entity) {
        if (!(entity instanceof PlayerEntity) && !this.func_72863_F().func_217204_a(entity)) {
            return;
        }
        entity.field_70142_S = entity.field_70165_t;
        entity.field_70137_T = entity.field_70163_u;
        entity.field_70136_U = entity.field_70161_v;
        entity.field_70126_B = entity.field_70177_z;
        entity.field_70127_C = entity.field_70125_A;
        if (entity.field_70175_ag) {
            ++entity.field_70173_aa;
            this.func_217381_Z().func_194340_a(() -> Registry.field_212629_r.func_177774_c(entity.func_200600_R()).toString());
            entity.func_70071_h_();
            this.func_217381_Z().func_76319_b();
        }
        this.func_217464_b(entity);
        if (entity.field_70175_ag) {
            for (Entity entity2 : entity.func_184188_bt()) {
                this.func_217459_a(entity, entity2);
            }
        }
    }

    public void func_217459_a(Entity entity, Entity entity2) {
        if (entity2.field_70128_L || entity2.func_184187_bx() != entity) {
            entity2.func_184210_p();
            return;
        }
        if (!(entity2 instanceof PlayerEntity) && !this.func_72863_F().func_217204_a(entity2)) {
            return;
        }
        entity2.field_70142_S = entity2.field_70165_t;
        entity2.field_70137_T = entity2.field_70163_u;
        entity2.field_70136_U = entity2.field_70161_v;
        entity2.field_70126_B = entity2.field_70177_z;
        entity2.field_70127_C = entity2.field_70125_A;
        if (entity2.field_70175_ag) {
            ++entity2.field_70173_aa;
            entity2.func_70098_U();
        }
        this.func_217464_b(entity2);
        if (entity2.field_70175_ag) {
            for (Entity entity3 : entity2.func_184188_bt()) {
                this.func_217459_a(entity2, entity3);
            }
        }
    }

    public void func_217464_b(Entity entity) {
        this.func_217381_Z().func_76320_a("chunkCheck");
        int n = MathHelper.func_76128_c(entity.field_70165_t / 16.0);
        \u2603 = MathHelper.func_76128_c(entity.field_70163_u / 16.0);
        \u2603 = MathHelper.func_76128_c(entity.field_70161_v / 16.0);
        if (!entity.field_70175_ag || entity.field_70176_ah != n || entity.field_70162_ai != \u2603 || entity.field_70164_aj != \u2603) {
            if (entity.field_70175_ag && this.func_217354_b(entity.field_70176_ah, entity.field_70164_aj)) {
                this.func_212866_a_(entity.field_70176_ah, entity.field_70164_aj).func_76608_a(entity, entity.field_70162_ai);
            }
            if (entity.func_184189_br() || this.func_217354_b(n, \u2603)) {
                this.func_212866_a_(n, \u2603).func_76612_a(entity);
            } else {
                entity.field_70175_ag = false;
            }
        }
        this.func_217381_Z().func_76319_b();
    }

    @Override
    public boolean func_175660_a(PlayerEntity playerEntity, BlockPos blockPos) {
        return !this.field_73061_a.func_175579_a(this, blockPos, playerEntity) && this.func_175723_af().func_177746_a(blockPos);
    }

    public void func_73052_b(WorldSettings worldSettings2) {
        WorldSettings worldSettings2;
        ChunkPos chunkPos;
        if (!this.field_73011_w.func_76567_e()) {
            this.field_72986_A.func_176143_a(BlockPos.field_177992_a.func_177981_b(this.field_73020_y.func_201711_g().func_205470_d()));
            return;
        }
        if (this.field_72986_A.func_76067_t() == WorldType.field_180272_g) {
            this.field_72986_A.func_176143_a(BlockPos.field_177992_a.func_177984_a());
            return;
        }
        BiomeProvider biomeProvider = this.field_73020_y.func_201711_g().func_202090_b();
        BlockPos \u26032 = biomeProvider.func_180630_a(0, 0, 256, \u2603 = biomeProvider.func_76932_a(), \u2603 = new Random(this.func_72905_C()));
        ChunkPos chunkPos2 = chunkPos = \u26032 == null ? new ChunkPos(0, 0) : new ChunkPos(\u26032);
        if (\u26032 == null) {
            field_147491_a.warn("Unable to find spawn biome");
        }
        boolean \u26033 = false;
        for (Block block : BlockTags.field_205599_H.func_199885_a()) {
            if (!biomeProvider.func_205706_b().contains(block.func_176223_P())) continue;
            \u26033 = true;
            break;
        }
        this.field_72986_A.func_176143_a(chunkPos.func_206849_h().func_177982_a(8, this.field_73020_y.func_201711_g().func_205470_d(), 8));
        int \u26034 = 0;
        int \u26035 = 0;
        int \u26036 = 0;
        int \u26037 = -1;
        int \u26038 = 32;
        for (int i = 0; i < 1024; ++i) {
            if (\u26034 > -16 && \u26034 <= 16 && \u26035 > -16 && \u26035 <= 16 && (\u2603 = this.field_73011_w.func_206920_a(new ChunkPos(chunkPos.field_77276_a + \u26034, chunkPos.field_77275_b + \u26035), \u26033)) != null) {
                this.field_72986_A.func_176143_a(\u2603);
                break;
            }
            if (\u26034 == \u26035 || \u26034 < 0 && \u26034 == -\u26035 || \u26034 > 0 && \u26034 == 1 - \u26035) {
                \u2603 = \u26036;
                \u26036 = -\u26037;
                \u26037 = \u2603;
            }
            \u26034 += \u26036;
            \u26035 += \u26037;
        }
        if (worldSettings2.func_77167_c()) {
            this.func_73047_i();
        }
    }

    protected void func_73047_i() {
        BonusChestFeature bonusChestFeature = Feature.field_214487_aO;
        for (int i = 0; i < 10; ++i) {
            \u2603 = this.field_72986_A.func_76079_c() + this.field_73012_v.nextInt(6) - this.field_73012_v.nextInt(6);
            \u2603 = this.field_72986_A.func_76074_e() + this.field_73012_v.nextInt(6) - this.field_73012_v.nextInt(6);
            BlockPos blockPos = this.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, new BlockPos(\u2603, 0, \u2603)).func_177984_a();
            if (bonusChestFeature.func_212245_a((IWorld)this, this.field_73020_y.func_201711_g(), this.field_73012_v, blockPos, IFeatureConfig.field_202429_e)) break;
        }
    }

    @Nullable
    public BlockPos func_180504_m() {
        return this.field_73011_w.func_177496_h();
    }

    public void func_217445_a(@Nullable IProgressUpdate iProgressUpdate, boolean bl, boolean bl2) throws SessionLockException {
        ServerChunkProvider serverChunkProvider = this.func_72863_F();
        if (bl2) {
            return;
        }
        if (iProgressUpdate != null) {
            iProgressUpdate.func_200210_a(new TranslationTextComponent("menu.savingLevel", new Object[0]));
        }
        this.func_73042_a();
        if (iProgressUpdate != null) {
            iProgressUpdate.func_200209_c(new TranslationTextComponent("menu.savingChunks", new Object[0]));
        }
        serverChunkProvider.func_217210_a(bl);
    }

    protected void func_73042_a() throws SessionLockException {
        this.func_217437_v();
        this.field_73011_w.func_186057_q();
        this.func_72863_F().func_217227_h().func_212775_b();
    }

    public List<Entity> func_217482_a(@Nullable EntityType<?> entityType, Predicate<? super Entity> predicate) {
        ArrayList arrayList = Lists.newArrayList();
        ServerChunkProvider \u26032 = this.func_72863_F();
        for (Entity entity : this.field_217498_x.values()) {
            if (entityType != null && entity.func_200600_R() != entityType || !\u26032.func_73149_a(MathHelper.func_76128_c(entity.field_70165_t) >> 4, MathHelper.func_76128_c(entity.field_70161_v) >> 4) || !predicate.test(entity)) continue;
            arrayList.add(entity);
        }
        return arrayList;
    }

    public List<EnderDragonEntity> func_217439_j() {
        ArrayList arrayList = Lists.newArrayList();
        for (Entity entity : this.field_217498_x.values()) {
            if (!(entity instanceof EnderDragonEntity) || !entity.func_70089_S()) continue;
            arrayList.add((EnderDragonEntity)entity);
        }
        return arrayList;
    }

    public List<ServerPlayerEntity> func_217490_a(Predicate<? super ServerPlayerEntity> predicate) {
        ArrayList arrayList = Lists.newArrayList();
        for (ServerPlayerEntity serverPlayerEntity : this.field_217491_A) {
            if (!predicate.test(serverPlayerEntity)) continue;
            arrayList.add(serverPlayerEntity);
        }
        return arrayList;
    }

    @Nullable
    public ServerPlayerEntity func_217472_l_() {
        List<ServerPlayerEntity> list = this.func_217490_a(LivingEntity::func_70089_S);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(this.field_73012_v.nextInt(list.size()));
    }

    public Object2IntMap<EntityClassification> func_217450_l() {
        Object2IntOpenHashMap object2IntOpenHashMap = new Object2IntOpenHashMap();
        for (Entity entity : this.field_217498_x.values()) {
            if (entity instanceof MobEntity && (((MobEntity)(\u2603 = (MobEntity)entity)).func_104002_bU() || ((MobEntity)\u2603).func_213392_I()) || (\u2603 = entity.func_200600_R().func_220339_d()) == EntityClassification.MISC || !this.func_72863_F().func_223435_b(entity)) continue;
            object2IntOpenHashMap.mergeInt(\u2603, 1, Integer::sum);
        }
        return object2IntOpenHashMap;
    }

    @Override
    public boolean func_217376_c(Entity entity) {
        return this.func_72838_d(entity);
    }

    public boolean func_217470_d(Entity entity) {
        return this.func_72838_d(entity);
    }

    public void func_217460_e(Entity entity) {
        boolean bl = entity.field_98038_p;
        entity.field_98038_p = true;
        this.func_217470_d(entity);
        entity.field_98038_p = bl;
        this.func_217464_b(entity);
    }

    public void func_217446_a(ServerPlayerEntity serverPlayerEntity) {
        this.func_217448_f(serverPlayerEntity);
        this.func_217464_b(serverPlayerEntity);
    }

    public void func_217447_b(ServerPlayerEntity serverPlayerEntity) {
        this.func_217448_f(serverPlayerEntity);
        this.func_217464_b(serverPlayerEntity);
    }

    public void func_217435_c(ServerPlayerEntity serverPlayerEntity) {
        this.func_217448_f(serverPlayerEntity);
    }

    public void func_217433_d(ServerPlayerEntity serverPlayerEntity) {
        this.func_217448_f(serverPlayerEntity);
    }

    private void func_217448_f(ServerPlayerEntity serverPlayerEntity) {
        Entity entity = this.field_175741_N.get(serverPlayerEntity.func_110124_au());
        if (entity != null) {
            field_147491_a.warn("Force-added player with duplicate UUID {}", (Object)serverPlayerEntity.func_110124_au().toString());
            entity.func_213319_R();
            this.func_217434_e((ServerPlayerEntity)entity);
        }
        this.field_217491_A.add(serverPlayerEntity);
        this.func_72854_c();
        IChunk \u26032 = this.func_217353_a(MathHelper.func_76128_c(serverPlayerEntity.field_70165_t / 16.0), MathHelper.func_76128_c(serverPlayerEntity.field_70161_v / 16.0), ChunkStatus.field_222617_m, true);
        if (\u26032 instanceof Chunk) {
            \u26032.func_76612_a(serverPlayerEntity);
        }
        this.func_217465_m(serverPlayerEntity);
    }

    private boolean func_72838_d(Entity entity) {
        if (entity.field_70128_L) {
            field_147491_a.warn("Tried to add entity {} but it was marked as removed already", (Object)EntityType.func_200718_a(entity.func_200600_R()));
            return false;
        }
        if (this.func_217478_l(entity)) {
            return false;
        }
        IChunk iChunk = this.func_217353_a(MathHelper.func_76128_c(entity.field_70165_t / 16.0), MathHelper.func_76128_c(entity.field_70161_v / 16.0), ChunkStatus.field_222617_m, entity.field_98038_p);
        if (!(iChunk instanceof Chunk)) {
            return false;
        }
        iChunk.func_76612_a(entity);
        this.func_217465_m(entity);
        return true;
    }

    public boolean func_217440_f(Entity entity) {
        if (this.func_217478_l(entity)) {
            return false;
        }
        this.func_217465_m(entity);
        return true;
    }

    private boolean func_217478_l(Entity entity) {
        \u2603 = this.field_175741_N.get(entity.func_110124_au());
        if (\u2603 == null) {
            return false;
        }
        field_147491_a.warn("Keeping entity {} that already exists with UUID {}", (Object)EntityType.func_200718_a(\u2603.func_200600_R()), (Object)entity.func_110124_au().toString());
        return true;
    }

    public void func_217466_a(Chunk chunk) {
        this.field_147483_b.addAll(chunk.func_177434_r().values());
        for (ClassInheritanceMultiMap<Entity> classInheritanceMultiMap : chunk.func_177429_s()) {
            for (Entity entity : classInheritanceMultiMap) {
                if (entity instanceof ServerPlayerEntity) continue;
                if (this.field_217492_a) {
                    throw new IllegalStateException("Removing entity while ticking!");
                }
                this.field_217498_x.remove(entity.func_145782_y());
                this.func_217484_g(entity);
            }
        }
    }

    public void func_217484_g(Entity entity2) {
        Entity entity2;
        if (entity2 instanceof EnderDragonEntity) {
            for (EnderDragonPartEntity enderDragonPartEntity : ((EnderDragonEntity)entity2).func_213404_dT()) {
                enderDragonPartEntity.func_70106_y();
            }
        }
        this.field_175741_N.remove(entity2.func_110124_au());
        this.func_72863_F().func_217226_b(entity2);
        if (entity2 instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)entity2;
            this.field_217491_A.remove(serverPlayerEntity);
        }
        this.func_96441_U().func_181140_a(entity2);
        if (entity2 instanceof MobEntity) {
            this.field_217495_I.remove(((MobEntity)entity2).func_70661_as());
        }
    }

    private void func_217465_m(Entity entity2) {
        if (this.field_217492_a) {
            this.field_217499_z.add(entity2);
        } else {
            Entity entity2;
            this.field_217498_x.put(entity2.func_145782_y(), (Object)entity2);
            if (entity2 instanceof EnderDragonEntity) {
                for (EnderDragonPartEntity enderDragonPartEntity : ((EnderDragonEntity)entity2).func_213404_dT()) {
                    this.field_217498_x.put(enderDragonPartEntity.func_145782_y(), (Object)enderDragonPartEntity);
                }
            }
            this.field_175741_N.put(entity2.func_110124_au(), entity2);
            this.func_72863_F().func_217230_c(entity2);
            if (entity2 instanceof MobEntity) {
                this.field_217495_I.add(((MobEntity)entity2).func_70661_as());
            }
        }
    }

    public void func_217467_h(Entity entity) {
        if (this.field_217492_a) {
            throw new IllegalStateException("Removing entity while ticking!");
        }
        this.func_217454_n(entity);
        this.field_217498_x.remove(entity.func_145782_y());
        this.func_217484_g(entity);
    }

    private void func_217454_n(Entity entity) {
        IChunk iChunk = this.func_217353_a(entity.field_70176_ah, entity.field_70164_aj, ChunkStatus.field_222617_m, false);
        if (iChunk instanceof Chunk) {
            ((Chunk)iChunk).func_76622_b(entity);
        }
    }

    public void func_217434_e(ServerPlayerEntity serverPlayerEntity) {
        serverPlayerEntity.func_70106_y();
        this.func_217467_h(serverPlayerEntity);
        this.func_72854_c();
    }

    public void func_217468_a(LightningBoltEntity lightningBoltEntity) {
        this.field_217497_w.add(lightningBoltEntity);
        this.field_73061_a.func_184103_al().func_148543_a(null, lightningBoltEntity.field_70165_t, lightningBoltEntity.field_70163_u, lightningBoltEntity.field_70161_v, 512.0, this.field_73011_w.func_186058_p(), new SSpawnGlobalEntityPacket(lightningBoltEntity));
    }

    @Override
    public void func_175715_c(int n, BlockPos blockPos, int n2) {
        for (ServerPlayerEntity serverPlayerEntity : this.field_73061_a.func_184103_al().func_181057_v()) {
            if (serverPlayerEntity == null || serverPlayerEntity.field_70170_p != this || serverPlayerEntity.func_145782_y() == n || !((\u2603 = (double)blockPos.func_177958_n() - serverPlayerEntity.field_70165_t) * \u2603 + (\u2603 = (double)blockPos.func_177956_o() - serverPlayerEntity.field_70163_u) * \u2603 + (\u2603 = (double)blockPos.func_177952_p() - serverPlayerEntity.field_70161_v) * \u2603 < 1024.0)) continue;
            serverPlayerEntity.field_71135_a.func_147359_a(new SAnimateBlockBreakPacket(n, blockPos, n2));
        }
    }

    @Override
    public void func_184148_a(@Nullable PlayerEntity playerEntity, double d, double d2, double d3, SoundEvent soundEvent, SoundCategory soundCategory, float f, float f2) {
        this.field_73061_a.func_184103_al().func_148543_a(playerEntity, d, d2, d3, f > 1.0f ? (double)(16.0f * f) : 16.0, this.field_73011_w.func_186058_p(), new SPlaySoundEffectPacket(soundEvent, soundCategory, d, d2, d3, f, f2));
    }

    @Override
    public void func_217384_a(@Nullable PlayerEntity playerEntity, Entity entity, SoundEvent soundEvent, SoundCategory soundCategory, float f, float f2) {
        this.field_73061_a.func_184103_al().func_148543_a(playerEntity, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, f > 1.0f ? (double)(16.0f * f) : 16.0, this.field_73011_w.func_186058_p(), new SSpawnMovingSoundEffectPacket(soundEvent, soundCategory, entity, f, f2));
    }

    @Override
    public void func_175669_a(int n, BlockPos blockPos, int n2) {
        this.field_73061_a.func_184103_al().func_148540_a(new SPlaySoundEventPacket(n, blockPos, n2, true));
    }

    @Override
    public void func_217378_a(@Nullable PlayerEntity playerEntity, int n, BlockPos blockPos, int n2) {
        this.field_73061_a.func_184103_al().func_148543_a(playerEntity, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), 64.0, this.field_73011_w.func_186058_p(), new SPlaySoundEventPacket(n, blockPos, n2, false));
    }

    @Override
    public void func_184138_a(BlockPos blockPos, BlockState blockState, BlockState blockState2, int n) {
        this.func_72863_F().func_217217_a(blockPos);
        VoxelShape voxelShape = blockState.func_196952_d(this, blockPos);
        \u2603 = blockState2.func_196952_d(this, blockPos);
        if (!VoxelShapes.func_197879_c(voxelShape, \u2603, IBooleanFunction.field_223236_g_)) {
            return;
        }
        for (PathNavigator pathNavigator : this.field_217495_I) {
            if (pathNavigator.func_188553_i()) continue;
            pathNavigator.func_220970_c(blockPos);
        }
    }

    @Override
    public void func_72960_a(Entity entity, byte by) {
        this.func_72863_F().func_217216_a(entity, new SEntityStatusPacket(entity, by));
    }

    @Override
    public ServerChunkProvider func_72863_F() {
        return (ServerChunkProvider)super.func_72863_F();
    }

    @Override
    public Explosion func_217401_a(@Nullable Entity entity, DamageSource damageSource, double d, double d2, double d3, float f, boolean bl, Explosion.Mode mode) {
        Explosion explosion = new Explosion(this, entity, d, d2, d3, f, bl, mode);
        if (damageSource != null) {
            explosion.func_199592_a(damageSource);
        }
        explosion.func_77278_a();
        explosion.func_77279_a(false);
        if (mode == Explosion.Mode.NONE) {
            explosion.func_180342_d();
        }
        for (ServerPlayerEntity serverPlayerEntity : this.field_217491_A) {
            if (!(serverPlayerEntity.func_70092_e(d, d2, d3) < 4096.0)) continue;
            serverPlayerEntity.field_71135_a.func_147359_a(new SExplosionPacket(d, d2, d3, f, explosion.func_180343_e(), explosion.func_77277_b().get(serverPlayerEntity)));
        }
        return explosion;
    }

    @Override
    public void func_175641_c(BlockPos blockPos, Block block, int n, int n2) {
        this.field_147490_S.add((Object)new BlockEventData(blockPos, block, n, n2));
    }

    private void func_147488_Z() {
        while (!this.field_147490_S.isEmpty()) {
            BlockEventData blockEventData = (BlockEventData)this.field_147490_S.removeFirst();
            if (!this.func_147485_a(blockEventData)) continue;
            this.field_73061_a.func_184103_al().func_148543_a(null, blockEventData.func_180328_a().func_177958_n(), blockEventData.func_180328_a().func_177956_o(), blockEventData.func_180328_a().func_177952_p(), 64.0, this.field_73011_w.func_186058_p(), new SBlockActionPacket(blockEventData.func_180328_a(), blockEventData.func_151337_f(), blockEventData.func_151339_d(), blockEventData.func_151338_e()));
        }
    }

    private boolean func_147485_a(BlockEventData blockEventData) {
        BlockState blockState = this.func_180495_p(blockEventData.func_180328_a());
        if (blockState.func_177230_c() == blockEventData.func_151337_f()) {
            return blockState.func_189547_a(this, blockEventData.func_180328_a(), blockEventData.func_151339_d(), blockEventData.func_151338_e());
        }
        return false;
    }

    public ServerTickList<Block> func_205220_G_() {
        return this.field_94579_S;
    }

    public ServerTickList<Fluid> func_205219_F_() {
        return this.field_205342_P;
    }

    @Override
    @Nonnull
    public MinecraftServer func_73046_m() {
        return this.field_73061_a;
    }

    public Teleporter func_85176_s() {
        return this.field_85177_Q;
    }

    public TemplateManager func_184163_y() {
        return this.field_217493_C.func_186340_h();
    }

    public <T extends IParticleData> int func_195598_a(T t, double d, double d2, double d3, int n, double d4, double d5, double d6, double d7) {
        SSpawnParticlePacket sSpawnParticlePacket = new SSpawnParticlePacket(t, false, (float)d, (float)d2, (float)d3, (float)d4, (float)d5, (float)d6, (float)d7, n);
        int \u26032 = 0;
        for (int i = 0; i < this.field_217491_A.size(); ++i) {
            ServerPlayerEntity serverPlayerEntity = this.field_217491_A.get(i);
            if (!this.func_195601_a(serverPlayerEntity, false, d, d2, d3, sSpawnParticlePacket)) continue;
            ++\u26032;
        }
        return \u26032;
    }

    public <T extends IParticleData> boolean func_195600_a(ServerPlayerEntity serverPlayerEntity, T t, boolean bl, double d, double d2, double d3, int n, double d4, double d5, double d6, double d7) {
        SSpawnParticlePacket sSpawnParticlePacket = new SSpawnParticlePacket(t, bl, (float)d, (float)d2, (float)d3, (float)d4, (float)d5, (float)d6, (float)d7, n);
        return this.func_195601_a(serverPlayerEntity, bl, d, d2, d3, sSpawnParticlePacket);
    }

    private boolean func_195601_a(ServerPlayerEntity serverPlayerEntity, boolean bl, double d, double d2, double d3, IPacket<?> iPacket) {
        if (serverPlayerEntity.func_71121_q() != this) {
            return false;
        }
        BlockPos blockPos = serverPlayerEntity.func_180425_c();
        if (blockPos.func_218137_a(new Vec3d(d, d2, d3), bl ? 512.0 : 32.0)) {
            serverPlayerEntity.field_71135_a.func_147359_a(iPacket);
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Entity func_73045_a(int n) {
        return (Entity)this.field_217498_x.get(n);
    }

    @Nullable
    public Entity func_217461_a(UUID uUID) {
        return this.field_175741_N.get(uUID);
    }

    @Override
    @Nullable
    public BlockPos func_211157_a(String string, BlockPos blockPos, int n, boolean bl) {
        return this.func_72863_F().func_201711_g().func_211403_a(this, string, blockPos, n, bl);
    }

    @Override
    public RecipeManager func_199532_z() {
        return this.field_73061_a.func_199529_aN();
    }

    @Override
    public NetworkTagManager func_205772_D() {
        return this.field_73061_a.func_199731_aO();
    }

    @Override
    public void func_82738_a(long l) {
        super.func_82738_a(l);
        this.field_72986_A.func_215763_z().func_216331_a(this.field_73061_a, l);
    }

    @Override
    public boolean func_217402_u() {
        return this.field_73058_d;
    }

    public void func_217437_v() throws SessionLockException {
        this.field_217493_C.func_75762_c();
    }

    public SaveHandler func_217485_w() {
        return this.field_217493_C;
    }

    public DimensionSavedDataManager func_217481_x() {
        return this.func_72863_F().func_217227_h();
    }

    @Override
    @Nullable
    public MapData func_217406_a(String string) {
        return this.func_73046_m().func_71218_a(DimensionType.field_223227_a_).func_217481_x().func_215753_b(() -> new MapData(string), string);
    }

    @Override
    public void func_217399_a(MapData mapData) {
        this.func_73046_m().func_71218_a(DimensionType.field_223227_a_).func_217481_x().func_215757_a(mapData);
    }

    @Override
    public int func_217395_y() {
        return this.func_73046_m().func_71218_a(DimensionType.field_223227_a_).func_217481_x().func_215752_a(MapIdTracker::new, "idcounts").func_215162_a();
    }

    @Override
    public void func_175652_B(BlockPos blockPos) {
        ChunkPos chunkPos = new ChunkPos(new BlockPos(this.field_72986_A.func_76079_c(), 0, this.field_72986_A.func_76074_e()));
        super.func_175652_B(blockPos);
        this.func_72863_F().func_217222_b(TicketType.field_219488_a, chunkPos, 11, Unit.INSTANCE);
        this.func_72863_F().func_217228_a(TicketType.field_219488_a, new ChunkPos(blockPos), 11, Unit.INSTANCE);
    }

    public LongSet func_217469_z() {
        ForcedChunksSaveData forcedChunksSaveData = this.func_217481_x().func_215753_b(ForcedChunksSaveData::new, "chunks");
        return forcedChunksSaveData != null ? LongSets.unmodifiable((LongSet)forcedChunksSaveData.func_212438_a()) : LongSets.EMPTY_SET;
    }

    public boolean func_217458_b(int n, int n2, boolean bl) {
        boolean \u26034;
        ForcedChunksSaveData forcedChunksSaveData = this.func_217481_x().func_215752_a(ForcedChunksSaveData::new, "chunks");
        ChunkPos \u26032 = new ChunkPos(n, n2);
        long \u26033 = \u26032.func_201841_a();
        if (bl) {
            \u26034 = forcedChunksSaveData.func_212438_a().add(\u26033);
            if (\u26034) {
                this.func_212866_a_(n, n2);
            }
        } else {
            \u26034 = forcedChunksSaveData.func_212438_a().remove(\u26033);
        }
        forcedChunksSaveData.func_76186_a(\u26034);
        if (\u26034) {
            this.func_72863_F().func_217206_a(\u26032, bl);
        }
        return \u26034;
    }

    public List<ServerPlayerEntity> func_217369_A() {
        return this.field_217491_A;
    }

    @Override
    public void func_217393_a(BlockPos blockPos, BlockState blockState, BlockState blockState2) {
        Optional<PointOfInterestType> optional = PointOfInterestType.func_221047_b(blockState);
        if (Objects.equals(optional, \u2603 = PointOfInterestType.func_221047_b(blockState2))) {
            return;
        }
        BlockPos \u26032 = blockPos.func_185334_h();
        optional.ifPresent(pointOfInterestType -> this.func_73046_m().execute(() -> {
            this.func_217443_B().func_219140_a(\u26032);
            DebugPacketSender.func_218805_b(this, \u26032);
        }));
        \u2603.ifPresent(pointOfInterestType -> this.func_73046_m().execute(() -> {
            this.func_217443_B().func_219135_a(\u26032, (PointOfInterestType)pointOfInterestType);
            DebugPacketSender.func_218799_a(this, \u26032);
        }));
    }

    public PointOfInterestManager func_217443_B() {
        return this.func_72863_F().func_217231_i();
    }

    public boolean func_217483_b_(BlockPos blockPos) {
        return this.func_217471_a(blockPos, 1);
    }

    public boolean func_222887_a(SectionPos sectionPos) {
        return this.func_217483_b_(sectionPos.func_218160_t());
    }

    public boolean func_217471_a(BlockPos blockPos, int n) {
        if (n > 6) {
            return false;
        }
        return this.func_217486_a(SectionPos.func_218167_a(blockPos)) <= n;
    }

    public int func_217486_a(SectionPos sectionPos) {
        return this.func_217443_B().func_219150_a(sectionPos);
    }

    public RaidManager func_217452_C() {
        return this.field_217494_c;
    }

    @Nullable
    public Raid func_217475_c_(BlockPos blockPos) {
        return this.field_217494_c.func_215174_a(blockPos, 9216);
    }

    public boolean func_217455_d_(BlockPos blockPos) {
        return this.func_217475_c_(blockPos) != null;
    }

    public void func_217489_a(IReputationType iReputationType, Entity entity, IReputationTracking iReputationTracking) {
        iReputationTracking.func_213739_a(iReputationType, entity);
    }

    public void func_225322_a(Path path2) throws IOException {
        Path path2;
        Object \u260342;
        ChunkManager chunkManager = this.func_72863_F().field_217237_a;
        try (Object \u26032 = Files.newBufferedWriter(path2.resolve("stats.txt"), new OpenOption[0]);){
            ((Writer)\u26032).write(String.format("spawning_chunks: %d\n", chunkManager.func_219246_e().func_219358_b()));
            for (Object \u260342 : this.func_217450_l().object2IntEntrySet()) {
                ((Writer)\u26032).write(String.format("spawn_count.%s: %d\n", ((EntityClassification)((Object)\u260342.getKey())).func_220363_a(), \u260342.getIntValue()));
            }
            ((Writer)\u26032).write(String.format("entities: %d\n", this.field_217498_x.size()));
            ((Writer)\u26032).write(String.format("block_entities: %d\n", this.field_147482_g.size()));
            ((Writer)\u26032).write(String.format("block_ticks: %d\n", ((ServerTickList)this.func_205220_G_()).func_225420_a()));
            ((Writer)\u26032).write(String.format("fluid_ticks: %d\n", ((ServerTickList)this.func_205219_F_()).func_225420_a()));
            ((Writer)\u26032).write("distance_manager: " + chunkManager.func_219246_e().func_225412_c() + "\n");
            ((Writer)\u26032).write(String.format("pending_tasks: %d\n", this.func_72863_F().func_225314_f()));
        }
        \u26032 = new CrashReport("Level dump", new Exception("dummy"));
        this.func_72914_a((CrashReport)\u26032);
        Object \u26033 = Files.newBufferedWriter(path2.resolve("example_crash.txt"), new OpenOption[0]);
        Object object = null;
        try {
            ((Writer)\u26033).write(((CrashReport)\u26032).func_71502_e());
        }
        catch (Throwable \u260342) {
            object = \u260342;
            throw \u260342;
        }
        finally {
            if (\u26033 != null) {
                if (object != null) {
                    try {
                        ((Writer)\u26033).close();
                    }
                    catch (Throwable \u260342) {
                        ((Throwable)object).addSuppressed(\u260342);
                    }
                } else {
                    ((Writer)\u26033).close();
                }
            }
        }
        \u26033 = path2.resolve("chunks.csv");
        Object \u26035 = Files.newBufferedWriter((Path)\u26033, new OpenOption[0]);
        \u260342 = null;
        try {
            chunkManager.func_225406_a((Writer)\u26035);
        }
        catch (Throwable throwable) {
            \u260342 = throwable;
            throw throwable;
        }
        finally {
            if (\u26035 != null) {
                if (\u260342 != null) {
                    try {
                        ((Writer)\u26035).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)\u260342).addSuppressed(throwable);
                    }
                } else {
                    ((Writer)\u26035).close();
                }
            }
        }
        \u26035 = path2.resolve("entities.csv");
        \u260342 = Files.newBufferedWriter((Path)\u26035, new OpenOption[0]);
        Throwable throwable = null;
        try {
            ServerWorld.func_225320_a((Writer)\u260342, (Iterable<Entity>)this.field_217498_x.values());
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (\u260342 != null) {
                if (throwable != null) {
                    try {
                        ((Writer)\u260342).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    ((Writer)\u260342).close();
                }
            }
        }
        \u260342 = path2.resolve("global_entities.csv");
        try (Object \u26036 = Files.newBufferedWriter((Path)\u260342, new OpenOption[0]);){
            ServerWorld.func_225320_a((Writer)\u26036, this.field_217497_w);
        }
        \u26036 = path2.resolve("block_entities.csv");
        try (BufferedWriter \u26037 = Files.newBufferedWriter((Path)\u26036, new OpenOption[0]);){
            this.func_225321_a(\u26037);
        }
    }

    private static void func_225320_a(Writer writer, Iterable<Entity> iterable) throws IOException {
        CSVWriter cSVWriter = CSVWriter.func_225428_a().func_225423_a("x").func_225423_a("y").func_225423_a("z").func_225423_a("uuid").func_225423_a("type").func_225423_a("alive").func_225423_a("display_name").func_225423_a("custom_name").func_225422_a(writer);
        for (Entity entity : iterable) {
            ITextComponent iTextComponent = entity.func_200201_e();
            \u2603 = entity.func_145748_c_();
            cSVWriter.func_225426_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.func_110124_au(), Registry.field_212629_r.func_177774_c(entity.func_200600_R()), entity.func_70089_S(), \u2603.getString(), iTextComponent != null ? iTextComponent.getString() : null);
        }
    }

    private void func_225321_a(Writer writer) throws IOException {
        CSVWriter cSVWriter = CSVWriter.func_225428_a().func_225423_a("x").func_225423_a("y").func_225423_a("z").func_225423_a("type").func_225422_a(writer);
        for (TileEntity tileEntity : this.field_147482_g) {
            BlockPos blockPos = tileEntity.func_174877_v();
            cSVWriter.func_225426_a(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), Registry.field_212626_o.func_177774_c(tileEntity.func_200662_C()));
        }
    }

    @Override
    public /* synthetic */ Scoreboard func_96441_U() {
        return this.func_96441_U();
    }

    @Override
    public /* synthetic */ AbstractChunkProvider func_72863_F() {
        return this.func_72863_F();
    }

    public /* synthetic */ ITickList func_205219_F_() {
        return this.func_205219_F_();
    }

    public /* synthetic */ ITickList func_205220_G_() {
        return this.func_205220_G_();
    }
}

