/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Multiset;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.profiler.IProfiler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.listener.IChunkStatusListener;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerMultiWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ModDimension;
import net.minecraftforge.event.world.RegisterDimensionsEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.StartupQuery;
import net.minecraftforge.fml.server.ServerModLoader;
import net.minecraftforge.registries.ClearableRegistry;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class DimensionManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker DIMMGR = MarkerManager.getMarker((String)"DIMS");
    private static final ClearableRegistry<DimensionType> REGISTRY = new ClearableRegistry<DimensionType>(new ResourceLocation("dimension_type"), DimensionType.class);
    private static final Int2ObjectMap<Data> dimensions = Int2ObjectMaps.synchronize((Int2ObjectMap)new Int2ObjectLinkedOpenHashMap());
    private static final IntSet unloadQueue = IntSets.synchronize((IntSet)new IntLinkedOpenHashSet());
    private static final ConcurrentMap<World, World> weakWorldMap = new MapMaker().weakKeys().weakValues().makeMap();
    private static final Multiset<Integer> leakedWorlds = HashMultiset.create();
    private static final Map<ResourceLocation, SavedEntry> savedEntries = new HashMap<ResourceLocation, SavedEntry>();
    private static volatile Set<World> playerWorlds = new HashSet<World>();

    public static DimensionType registerOrGetDimension(ResourceLocation name, ModDimension type, PacketBuffer data, boolean hasSkyLight) {
        return REGISTRY.func_218349_b(name).orElseGet(() -> DimensionManager.registerDimension(name, type, data, hasSkyLight));
    }

    public static DimensionType registerDimension(ResourceLocation name, ModDimension type, PacketBuffer data, boolean hasSkyLight) {
        Validate.notNull((Object)name, (String)"Can not register a dimension with null name", (Object[])new Object[0]);
        Validate.isTrue((!REGISTRY.func_212607_c(name) ? 1 : 0) != 0, (String)("Dimension: " + name + " Already registered"), (Object[])new Object[0]);
        Validate.notNull((Object)type, (String)"Can not register a null dimension type", (Object[])new Object[0]);
        int id = REGISTRY.getNextId();
        SavedEntry old = savedEntries.get(name);
        if (old != null) {
            id = old.getId();
            if (!type.getRegistryName().equals((Object)old.getType())) {
                LOGGER.info(DIMMGR, "Changing ModDimension for '{}' from '{}' to '{}'", (Object)name.toString(), (Object)(old.getType() == null ? null : old.getType().toString()), (Object)type.getRegistryName().toString());
            }
            savedEntries.remove(name);
        }
        DimensionType instance = new DimensionType(id, "", name.func_110624_b() + "/" + name.func_110623_a(), type.getFactory(), hasSkyLight, type.getMagnifier(), type, data);
        REGISTRY.func_218382_a(id, name, instance);
        LOGGER.info(DIMMGR, "Registered dimension {} of type {} and id {}", (Object)name.toString(), (Object)type.getRegistryName().toString(), (Object)id);
        return instance;
    }

    public static boolean keepLoaded(DimensionType dim, boolean value) {
        Validate.notNull((Object)dim, (String)"Dimension type must not be null", (Object[])new Object[0]);
        Data data = DimensionManager.getData(dim);
        boolean ret = data.keepLoaded;
        data.keepLoaded = value;
        return ret;
    }

    public static boolean keepLoaded(DimensionType dim) {
        Validate.notNull((Object)dim, (String)"Dimension type must not be null", (Object[])new Object[0]);
        Data data = (Data)dimensions.get(dim.func_186068_a());
        return data == null ? false : data.keepLoaded;
    }

    @Nullable
    public static ServerWorld getWorld(MinecraftServer server, DimensionType dim, boolean resetUnloadDelay, boolean forceLoad) {
        ServerWorld ret;
        Validate.notNull((Object)server, (String)"Must provide server when creating world", (Object[])new Object[0]);
        Validate.notNull((Object)dim, (String)"Dimension type must not be null", (Object[])new Object[0]);
        if (ServerModLoader.hasErrors()) {
            throw new RuntimeException("The server has failed to initialize correctly due to mod loading errors. Examine the crash report for more details.");
        }
        if (StartupQuery.pendingQuery()) {
            return null;
        }
        if (resetUnloadDelay && unloadQueue.contains(dim.func_186068_a())) {
            DimensionManager.getData((DimensionType)dim).ticksWaited = 0;
        }
        if ((ret = (ServerWorld)server.forgeGetWorldMap().get(dim)) == null && forceLoad) {
            ret = DimensionManager.initWorld(server, dim);
        }
        return ret;
    }

    public static void unregisterDimension(int id) {
        Validate.isTrue((boolean)dimensions.containsKey(id), (String)String.format("Failed to unregister dimension for id %d; No provider registered", id), (Object[])new Object[0]);
        dimensions.remove(id);
    }

    public static DimensionType registerDimensionInternal(int id, ResourceLocation name, ModDimension type, PacketBuffer data, boolean hasSkyLight) {
        Validate.notNull((Object)name, (String)"Can not register a dimension with null name", (Object[])new Object[0]);
        Validate.notNull((Object)type, (String)"Can not register a null dimension type", (Object[])new Object[0]);
        Validate.isTrue((!REGISTRY.func_212607_c(name) ? 1 : 0) != 0, (String)("Dimension: " + name + " Already registered"), (Object[])new Object[0]);
        Validate.isTrue((REGISTRY.func_148745_a(id) == null ? 1 : 0) != 0, (String)("Dimension with id " + id + " already registered as name " + REGISTRY.func_177774_c(REGISTRY.func_148745_a(id))), (Object[])new Object[0]);
        DimensionType instance = new DimensionType(id, "", name.func_110624_b() + "/" + name.func_110623_a(), type.getFactory(), hasSkyLight, type.getMagnifier(), type, data);
        REGISTRY.func_218382_a(id, name, instance);
        LOGGER.info(DIMMGR, "Registered dimension {} of type {} and id {}", (Object)name.toString(), (Object)type.getRegistryName().toString(), (Object)id);
        return instance;
    }

    public static ServerWorld initWorld(MinecraftServer server, DimensionType dim) {
        Validate.isTrue((dim != DimensionType.field_223227_a_ ? 1 : 0) != 0, (String)"Can not hotload overworld. This must be loaded at all times by main Server.", (Object[])new Object[0]);
        Validate.notNull((Object)server, (String)"Must provide server when creating world", (Object[])new Object[0]);
        Validate.notNull((Object)dim, (String)"Must provide dimension when creating world", (Object[])new Object[0]);
        ServerWorld overworld = DimensionManager.getWorld(server, DimensionType.field_223227_a_, false, false);
        Validate.notNull((Object)overworld, (String)"Cannot Hotload Dim: Overworld is not Loaded!", (Object[])new Object[0]);
        ServerMultiWorld world = new ServerMultiWorld(overworld, server, server.func_213207_aT(), overworld.func_217485_w(), dim, (IProfiler)server.func_213185_aS(), (IChunkStatusListener)new NoopChunkStatusListener());
        if (!server.func_71264_H()) {
            world.func_72912_H().func_76060_a(server.func_71265_f());
        }
        server.forgeGetWorldMap().put(dim, world);
        server.markWorldsDirty();
        MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Load((IWorld)world));
        return world;
    }

    private static boolean canUnloadWorld(ServerWorld world) {
        return world.func_201675_m().func_186058_p() != DimensionType.field_223227_a_ && world.func_217369_A().isEmpty() && world.func_217469_z().isEmpty() && !DimensionManager.getData((DimensionType)world.func_201675_m().func_186058_p()).keepLoaded && !playerWorlds.contains(world);
    }

    public static void unloadWorld(ServerWorld world) {
        if (world == null || !DimensionManager.canUnloadWorld(world)) {
            return;
        }
        int id = world.func_201675_m().func_186058_p().func_186068_a();
        if (unloadQueue.add(id)) {
            LOGGER.debug(DIMMGR, "Queueing dimension {} to unload", (Object)id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unloadWorlds(MinecraftServer server, boolean checkLeaks) {
        IntIterator queueIterator = unloadQueue.iterator();
        while (queueIterator.hasNext()) {
            int id = queueIterator.nextInt();
            DimensionType dim = DimensionType.func_186069_a((int)id);
            if (dim == null) {
                LOGGER.warn(DIMMGR, "Dimension with unknown type '{}' added to unload queue, removing", (Object)id);
                queueIterator.remove();
                continue;
            }
            Data dimension = (Data)dimensions.computeIfAbsent(id, k -> new Data());
            if (dimension.ticksWaited < (Integer)ForgeConfig.SERVER.dimensionUnloadQueueDelay.get()) {
                ++dimension.ticksWaited;
                continue;
            }
            queueIterator.remove();
            ServerWorld w = (ServerWorld)server.forgeGetWorldMap().get(dim);
            dimension.ticksWaited = 0;
            if (w == null || !DimensionManager.canUnloadWorld(w)) {
                LOGGER.debug(DIMMGR, "Aborting unload for dimension {} as status changed", (Object)id);
                continue;
            }
            try {
                w.func_217445_a(null, true, true);
            }
            catch (Exception e) {
                LOGGER.error(DIMMGR, "Caught an exception while saving all chunks:", (Throwable)e);
            }
            finally {
                MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Unload((IWorld)w));
                LOGGER.debug(DIMMGR, "Unloading dimension {}", (Object)id);
                try {
                    w.close();
                }
                catch (IOException e) {
                    LOGGER.error("Exception closing the level", (Throwable)e);
                }
                server.forgeGetWorldMap().remove(dim);
                server.markWorldsDirty();
            }
        }
        if (checkLeaks) {
            ArrayList allWorlds = Lists.newArrayList(weakWorldMap.keySet());
            allWorlds.removeAll(server.forgeGetWorldMap().values());
            allWorlds.stream().map(System::identityHashCode).forEach(arg_0 -> leakedWorlds.add(arg_0));
            for (World w : allWorlds) {
                int hash = System.identityHashCode(w);
                int leakCount = leakedWorlds.count((Object)hash);
                if (leakCount == 5) {
                    LOGGER.debug(DIMMGR, "The world {} ({}) may have leaked: first encounter (5 occurrences).\n", (Object)Integer.toHexString(hash), (Object)w.func_72912_H().func_76065_j());
                    continue;
                }
                if (leakCount % 5 != 0) continue;
                LOGGER.debug(DIMMGR, "The world {} ({}) may have leaked: seen {} times.\n", (Object)Integer.toHexString(hash), (Object)w.func_72912_H().func_76065_j(), (Object)leakCount);
            }
        }
    }

    public static void writeRegistry(CompoundNBT data) {
        data.func_74768_a("version", 1);
        ArrayList<SavedEntry> list = new ArrayList<SavedEntry>();
        Iterator<DimensionType> iterator = REGISTRY.iterator();
        while (iterator.hasNext()) {
            DimensionType type = iterator.next();
            list.add(new SavedEntry(type));
        }
        savedEntries.values().forEach(list::add);
        Collections.sort(list, (a, b) -> a.id - b.id);
        ListNBT lst = new ListNBT();
        list.forEach(e -> lst.add((Object)((SavedEntry)e).write()));
        data.func_218657_a("entries", (INBT)lst);
    }

    public static void readRegistry(CompoundNBT data) {
        int version = data.func_74762_e("version");
        if (version != 1) {
            throw new IllegalStateException("Attempted to load world with unknown Dimension data format: " + version);
        }
        LOGGER.debug(DIMMGR, "Reading Dimension Entries.");
        Map<ResourceLocation, DimensionType> vanilla = REGISTRY.func_201756_e().filter(DimensionType::isVanilla).collect(Collectors.toMap(REGISTRY::func_177774_c, v -> v));
        REGISTRY.clear();
        vanilla.forEach((key, value) -> {
            LOGGER.debug(DIMMGR, "Registering vanilla entry ID: {} Name: {} Value: {}", (Object)(value.func_186068_a() + 1), (Object)key.toString(), (Object)value.toString());
            REGISTRY.func_218382_a(value.func_186068_a() + 1, (ResourceLocation)key, value);
        });
        savedEntries.clear();
        boolean error = false;
        ListNBT list = data.func_150295_c("entries", 10);
        for (int x = 0; x < list.size(); ++x) {
            SavedEntry entry = new SavedEntry(list.func_150305_b(x));
            if (entry.type == null) {
                DimensionType type = REGISTRY.func_82594_a(entry.name);
                if (type == null) {
                    LOGGER.error(DIMMGR, "Vanilla entry '{}' id {} in save file not found in registry.", (Object)entry.name.toString(), (Object)entry.id);
                    error = true;
                    continue;
                }
                int id = REGISTRY.func_148757_b(type);
                if (id == entry.id) continue;
                LOGGER.error(DIMMGR, "Vanilla entry '{}' id {} in save file has incorrect in {} in registry.", (Object)entry.name.toString(), (Object)entry.id, (Object)id);
                error = true;
                continue;
            }
            ModDimension mod = ForgeRegistries.MOD_DIMENSIONS.getValue(entry.type);
            if (mod == null) {
                LOGGER.error(DIMMGR, "Modded dimension entry '{}' id {} type {} in save file missing ModDimension.", (Object)entry.name.toString(), (Object)entry.id, (Object)entry.type.toString());
                savedEntries.put(entry.name, entry);
                continue;
            }
            DimensionManager.registerDimensionInternal(entry.id, entry.name, mod, entry.data == null ? null : new PacketBuffer(Unpooled.wrappedBuffer((byte[])entry.data)), entry.skyLight());
        }
    }

    public static void fireRegister() {
        MinecraftForge.EVENT_BUS.post((Event)new RegisterDimensionsEvent(savedEntries));
        if (!savedEntries.isEmpty()) {
            savedEntries.values().forEach(entry -> LOGGER.warn(DIMMGR, "Missing Dimension Name: '{}' Id: {} Type: '{}", (Object)entry.name.toString(), (Object)entry.id, (Object)entry.type.toString()));
        }
    }

    @Deprecated
    public static MutableRegistry<DimensionType> getRegistry() {
        return REGISTRY;
    }

    private static Data getData(DimensionType dim) {
        return (Data)dimensions.computeIfAbsent(dim.func_186068_a(), k -> new Data());
    }

    public static boolean rebuildPlayerMap(PlayerList players, boolean changed) {
        playerWorlds = players.func_181057_v().stream().map(e -> e.field_70170_p).collect(Collectors.toSet());
        return changed;
    }

    private static class NoopChunkStatusListener
    implements IChunkStatusListener {
        private NoopChunkStatusListener() {
        }

        public void func_219509_a(ChunkPos center) {
        }

        public void func_219508_a(ChunkPos p_219508_1_, ChunkStatus p_219508_2_) {
        }

        public void func_219510_b() {
        }
    }

    public static class SavedEntry {
        int id;
        ResourceLocation name;
        ResourceLocation type;
        byte[] data;
        boolean skyLight;

        public int getId() {
            return this.id;
        }

        public ResourceLocation getName() {
            return this.name;
        }

        @Nullable
        public ResourceLocation getType() {
            return this.type;
        }

        @Nullable
        public byte[] getData() {
            return this.data;
        }

        public boolean skyLight() {
            return this.skyLight;
        }

        private SavedEntry(CompoundNBT data) {
            this.id = data.func_74762_e("id");
            this.name = new ResourceLocation(data.func_74779_i("name"));
            this.type = data.func_150297_b("type", 8) ? new ResourceLocation(data.func_74779_i("type")) : null;
            this.data = data.func_150297_b("data", 7) ? data.func_74770_j("data") : null;
            this.skyLight = data.func_150297_b("sky_light", 99) ? data.func_74767_n("sky_light") : true;
        }

        private SavedEntry(DimensionType data) {
            this.id = REGISTRY.func_148757_b(data);
            this.name = REGISTRY.func_177774_c(data);
            if (data.getModType() != null) {
                this.type = data.getModType().getRegistryName();
            }
            if (data.getData() != null) {
                this.data = data.getData().array();
            }
            this.skyLight = data.func_218272_d();
        }

        private CompoundNBT write() {
            CompoundNBT ret = new CompoundNBT();
            ret.func_74768_a("id", this.id);
            ret.func_74778_a("name", this.name.toString());
            if (this.type != null) {
                ret.func_74778_a("type", this.type.toString());
            }
            if (this.data != null) {
                ret.func_74773_a("data", this.data);
            }
            ret.func_74757_a("sky_light", this.skyLight);
            return ret;
        }
    }

    private static class Data {
        int ticksWaited = 0;
        boolean keepLoaded = false;

        private Data() {
        }
    }
}

