/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.RedstoneDiodeBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.apache.commons.lang3.Validate;

public abstract class HangingEntity
extends Entity {
    protected static final Predicate<Entity> field_184524_c = entity -> entity instanceof HangingEntity;
    private int field_70520_f;
    protected BlockPos field_174861_a;
    protected Direction field_174860_b = Direction.SOUTH;

    protected HangingEntity(EntityType<? extends HangingEntity> entityType, World world) {
        super(entityType, world);
    }

    protected HangingEntity(EntityType<? extends HangingEntity> entityType, World world, BlockPos blockPos) {
        this(entityType, world);
        this.field_174861_a = blockPos;
    }

    @Override
    protected void func_70088_a() {
    }

    protected void func_174859_a(Direction direction) {
        Validate.notNull((Object)direction);
        Validate.isTrue((boolean)direction.func_176740_k().func_176722_c());
        this.field_174860_b = direction;
        this.field_70126_B = this.field_70177_z = (float)(this.field_174860_b.func_176736_b() * 90);
        this.func_174856_o();
    }

    protected void func_174856_o() {
        if (this.field_174860_b == null) {
            return;
        }
        double d = (double)this.field_174861_a.func_177958_n() + 0.5;
        \u2603 = (double)this.field_174861_a.func_177956_o() + 0.5;
        \u2603 = (double)this.field_174861_a.func_177952_p() + 0.5;
        \u2603 = 0.46875;
        \u2603 = this.func_190202_a(this.func_82329_d());
        \u2603 = this.func_190202_a(this.func_82330_g());
        d -= (double)this.field_174860_b.func_82601_c() * 0.46875;
        \u2603 -= (double)this.field_174860_b.func_82599_e() * 0.46875;
        Direction \u26032 = this.field_174860_b.func_176735_f();
        this.func_226288_n_(d += \u2603 * (double)\u26032.func_82601_c(), \u2603 += \u2603, \u2603 += \u2603 * (double)\u26032.func_82599_e());
        \u2603 = this.func_82329_d();
        \u2603 = this.func_82330_g();
        \u2603 = this.func_82329_d();
        if (this.field_174860_b.func_176740_k() == Direction.Axis.Z) {
            \u2603 = 1.0;
        } else {
            \u2603 = 1.0;
        }
        this.func_174826_a(new AxisAlignedBB(d - (\u2603 /= 32.0), \u2603 - (\u2603 /= 32.0), \u2603 - (\u2603 /= 32.0), d + \u2603, \u2603 + \u2603, \u2603 + \u2603));
    }

    private double func_190202_a(int n) {
        return n % 32 == 0 ? 0.5 : 0.0;
    }

    @Override
    public void func_70071_h_() {
        if (this.field_70520_f++ == 100 && !this.field_70170_p.field_72995_K) {
            this.field_70520_f = 0;
            if (!this.field_70128_L && !this.func_70518_d()) {
                this.func_70106_y();
                this.func_110128_b(null);
            }
        }
    }

    public boolean func_70518_d() {
        if (!this.field_70170_p.func_226669_j_(this)) {
            return false;
        }
        int n = Math.max(1, this.func_82329_d() / 16);
        \u2603 = Math.max(1, this.func_82330_g() / 16);
        BlockPos \u26032 = this.field_174861_a.func_177972_a(this.field_174860_b.func_176734_d());
        Direction \u26033 = this.field_174860_b.func_176735_f();
        BlockPos.Mutable \u26034 = new BlockPos.Mutable();
        for (\u2603 = 0; \u2603 < n; ++\u2603) {
            for (\u2603 = 0; \u2603 < \u2603; ++\u2603) {
                \u2603 = (n - 1) / -2;
                \u2603 = (\u2603 - 1) / -2;
                \u26034.func_189533_g(\u26032).func_189534_c(\u26033, \u2603 + \u2603).func_189534_c(Direction.UP, \u2603 + \u2603);
                BlockState blockState = this.field_70170_p.func_180495_p(\u26034);
                if (blockState.func_185904_a().func_76220_a() || RedstoneDiodeBlock.func_185546_B(blockState)) continue;
                return false;
            }
        }
        return this.field_70170_p.func_175674_a(this, this.func_174813_aQ(), field_184524_c).isEmpty();
    }

    @Override
    public boolean func_70067_L() {
        return true;
    }

    @Override
    public boolean func_85031_j(Entity entity) {
        if (entity instanceof PlayerEntity) {
            return this.func_70097_a(DamageSource.func_76365_a((PlayerEntity)entity), 0.0f);
        }
        return false;
    }

    @Override
    public Direction func_174811_aO() {
        return this.field_174860_b;
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float f) {
        if (this.func_180431_b(damageSource)) {
            return false;
        }
        if (!this.field_70128_L && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
            this.func_70018_K();
            this.func_110128_b(damageSource.func_76346_g());
        }
        return true;
    }

    @Override
    public void func_213315_a(MoverType moverType, Vec3d vec3d) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L && vec3d.func_189985_c() > 0.0) {
            this.func_70106_y();
            this.func_110128_b(null);
        }
    }

    @Override
    public void func_70024_g(double d, double d2, double d3) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L && d * d + d2 * d2 + d3 * d3 > 0.0) {
            this.func_70106_y();
            this.func_110128_b(null);
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        compoundNBT.func_74774_a("Facing", (byte)this.field_174860_b.func_176736_b());
        BlockPos blockPos = this.func_174857_n();
        compoundNBT.func_74768_a("TileX", blockPos.func_177958_n());
        compoundNBT.func_74768_a("TileY", blockPos.func_177956_o());
        compoundNBT.func_74768_a("TileZ", blockPos.func_177952_p());
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        this.field_174861_a = new BlockPos(compoundNBT.func_74762_e("TileX"), compoundNBT.func_74762_e("TileY"), compoundNBT.func_74762_e("TileZ"));
        this.field_174860_b = Direction.func_176731_b(compoundNBT.func_74771_c("Facing"));
    }

    public abstract int func_82329_d();

    public abstract int func_82330_g();

    public abstract void func_110128_b(@Nullable Entity var1);

    public abstract void func_184523_o();

    @Override
    public ItemEntity func_70099_a(ItemStack itemStack, float f) {
        ItemEntity itemEntity = new ItemEntity(this.field_70170_p, this.func_226277_ct_() + (double)((float)this.field_174860_b.func_82601_c() * 0.15f), this.func_226278_cu_() + (double)f, this.func_226281_cx_() + (double)((float)this.field_174860_b.func_82599_e() * 0.15f), itemStack);
        itemEntity.func_174869_p();
        this.field_70170_p.func_217376_c(itemEntity);
        return itemEntity;
    }

    @Override
    protected boolean func_142008_O() {
        return false;
    }

    @Override
    public void func_70107_b(double d, double d2, double d3) {
        this.field_174861_a = new BlockPos(d, d2, d3);
        this.func_174856_o();
        this.field_70160_al = true;
    }

    public BlockPos func_174857_n() {
        return this.field_174861_a;
    }

    @Override
    public float func_184229_a(Rotation rotation) {
        if (this.field_174860_b.func_176740_k() != Direction.Axis.Y) {
            switch (rotation) {
                case CLOCKWISE_180: {
                    this.field_174860_b = this.field_174860_b.func_176734_d();
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    this.field_174860_b = this.field_174860_b.func_176735_f();
                    break;
                }
                case CLOCKWISE_90: {
                    this.field_174860_b = this.field_174860_b.func_176746_e();
                    break;
                }
            }
        }
        float f = MathHelper.func_76142_g(this.field_70177_z);
        switch (rotation) {
            case CLOCKWISE_180: {
                return f + 180.0f;
            }
            case COUNTERCLOCKWISE_90: {
                return f + 90.0f;
            }
            case CLOCKWISE_90: {
                return f + 270.0f;
            }
        }
        return f;
    }

    @Override
    public float func_184217_a(Mirror mirror) {
        return this.func_184229_a(mirror.func_185800_a(this.field_174860_b));
    }

    @Override
    public void func_70077_a(LightningBoltEntity lightningBoltEntity) {
    }

    @Override
    public void func_213323_x_() {
    }
}

