/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.merchant.villager;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.schedule.Activity;
import net.minecraft.entity.ai.brain.schedule.Schedule;
import net.minecraft.entity.ai.brain.sensor.Sensor;
import net.minecraft.entity.ai.brain.sensor.SensorType;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.entity.ai.brain.task.VillagerTasks;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.IReputationTracking;
import net.minecraft.entity.merchant.IReputationType;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.villager.IVillagerDataHolder;
import net.minecraft.entity.villager.IVillagerType;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.Stats;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.LongSerializable;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.village.GossipManager;
import net.minecraft.village.GossipType;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.raid.Raid;
import net.minecraft.world.server.ServerWorld;

public class VillagerEntity
extends AbstractVillagerEntity
implements IReputationTracking,
IVillagerDataHolder {
    private static final DataParameter<VillagerData> field_213775_bC = EntityDataManager.func_187226_a(VillagerEntity.class, DataSerializers.field_218813_q);
    public static final Map<Item, Integer> field_213788_bA = ImmutableMap.of((Object)Items.field_151025_P, (Object)4, (Object)Items.field_151174_bG, (Object)1, (Object)Items.field_151172_bF, (Object)1, (Object)Items.field_185164_cV, (Object)1);
    private static final Set<Item> field_213776_bD = ImmutableSet.of((Object)Items.field_151025_P, (Object)Items.field_151174_bG, (Object)Items.field_151172_bF, (Object)Items.field_151015_O, (Object)Items.field_151014_N, (Object)Items.field_185164_cV, (Object[])new Item[]{Items.field_185163_cU});
    private int field_70961_j;
    private boolean field_213777_bF;
    @Nullable
    private PlayerEntity field_213778_bG;
    private byte field_213781_bL;
    private final GossipManager field_213782_bM = new GossipManager();
    private long field_213783_bN;
    private long field_223362_bL;
    private int field_213784_bO;
    private long field_213785_bP;
    private int field_223725_bO;
    private long field_223726_bP;
    private static final ImmutableList<MemoryModuleType<?>> field_213786_bQ = ImmutableList.of(MemoryModuleType.field_220941_b, MemoryModuleType.field_220942_c, MemoryModuleType.field_220943_d, MemoryModuleType.field_220945_f, MemoryModuleType.field_220946_g, MemoryModuleType.field_220947_h, MemoryModuleType.field_220948_i, MemoryModuleType.field_220949_j, MemoryModuleType.field_220950_k, MemoryModuleType.field_220951_l, MemoryModuleType.field_220952_m, MemoryModuleType.field_220953_n, (Object[])new MemoryModuleType[]{MemoryModuleType.field_220954_o, MemoryModuleType.field_220955_p, MemoryModuleType.field_225462_q, MemoryModuleType.field_220956_q, MemoryModuleType.field_220957_r, MemoryModuleType.field_220958_s, MemoryModuleType.field_220959_t, MemoryModuleType.field_220944_e, MemoryModuleType.field_220961_v, MemoryModuleType.field_220962_w, MemoryModuleType.field_223021_x, MemoryModuleType.field_223543_y, MemoryModuleType.field_226332_A_, MemoryModuleType.field_223544_z, MemoryModuleType.field_223542_x});
    private static final ImmutableList<SensorType<? extends Sensor<? super VillagerEntity>>> field_213787_bR = ImmutableList.of(SensorType.field_220998_b, SensorType.field_220999_c, SensorType.field_221000_d, SensorType.field_221001_e, SensorType.field_221002_f, SensorType.field_221003_g, SensorType.field_221004_h, SensorType.field_221005_i, SensorType.field_223547_j);
    public static final Map<MemoryModuleType<GlobalPos>, BiPredicate<VillagerEntity, PointOfInterestType>> field_213774_bB = ImmutableMap.of(MemoryModuleType.field_220941_b, (villagerEntity, pointOfInterestType) -> pointOfInterestType == PointOfInterestType.field_221069_q, MemoryModuleType.field_220942_c, (villagerEntity, pointOfInterestType) -> villagerEntity.func_213700_eh().func_221130_b().func_221149_b() == pointOfInterestType, MemoryModuleType.field_220943_d, (villagerEntity, pointOfInterestType) -> pointOfInterestType == PointOfInterestType.field_221070_r);

    public VillagerEntity(EntityType<? extends VillagerEntity> entityType, World world) {
        this(entityType, world, IVillagerType.field_221175_c);
    }

    public VillagerEntity(EntityType<? extends VillagerEntity> entityType, World world, IVillagerType iVillagerType) {
        super((EntityType<? extends AbstractVillagerEntity>)entityType, world);
        ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
        this.func_70661_as().func_212239_d(true);
        this.func_98053_h(true);
        this.func_213753_a(this.func_213700_eh().func_221134_a(iVillagerType).func_221126_a(VillagerProfession.field_221151_a));
        this.field_213378_br = this.func_213364_a(new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)new CompoundNBT()));
    }

    public Brain<VillagerEntity> func_213375_cj() {
        return super.func_213375_cj();
    }

    @Override
    protected Brain<?> func_213364_a(Dynamic<?> dynamic) {
        Brain<VillagerEntity> brain = new Brain<VillagerEntity>((Collection<MemoryModuleType<?>>)field_213786_bQ, (Collection<SensorType<Sensor<VillagerEntity>>>)field_213787_bR, dynamic);
        this.func_213744_a(brain);
        return brain;
    }

    public void func_213770_a(ServerWorld serverWorld) {
        Brain<VillagerEntity> brain = this.func_213375_cj();
        brain.func_218227_b(serverWorld, this);
        this.field_213378_br = brain.func_218185_f();
        this.func_213744_a(this.func_213375_cj());
    }

    private void func_213744_a(Brain<VillagerEntity> brain) {
        VillagerProfession villagerProfession = this.func_213700_eh().func_221130_b();
        float \u26032 = (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
        if (this.func_70631_g_()) {
            brain.func_218203_a(Schedule.field_221385_c);
            brain.func_218208_a(Activity.field_221368_d, VillagerTasks.func_220645_a(\u26032));
        } else {
            brain.func_218203_a(Schedule.field_221386_d);
            brain.func_218224_a(Activity.field_221367_c, (ImmutableList<Pair<Integer, Task<VillagerEntity>>>)VillagerTasks.func_220639_b(villagerProfession, \u26032), (Set<Pair<MemoryModuleType<?>, MemoryModuleStatus>>)ImmutableSet.of((Object)Pair.of(MemoryModuleType.field_220942_c, (Object)((Object)MemoryModuleStatus.VALUE_PRESENT))));
        }
        brain.func_218208_a(Activity.field_221365_a, VillagerTasks.func_220638_a(villagerProfession, \u26032));
        brain.func_218224_a(Activity.field_221370_f, (ImmutableList<Pair<Integer, Task<VillagerEntity>>>)VillagerTasks.func_220637_d(villagerProfession, \u26032), (Set<Pair<MemoryModuleType<?>, MemoryModuleStatus>>)ImmutableSet.of((Object)Pair.of(MemoryModuleType.field_220943_d, (Object)((Object)MemoryModuleStatus.VALUE_PRESENT))));
        brain.func_218208_a(Activity.field_221369_e, VillagerTasks.func_220635_c(villagerProfession, \u26032));
        brain.func_218208_a(Activity.field_221366_b, VillagerTasks.func_220641_e(villagerProfession, \u26032));
        brain.func_218208_a(Activity.field_221371_g, VillagerTasks.func_220636_f(villagerProfession, \u26032));
        brain.func_218208_a(Activity.field_221373_i, VillagerTasks.func_220642_g(villagerProfession, \u26032));
        brain.func_218208_a(Activity.field_221372_h, VillagerTasks.func_220640_h(villagerProfession, \u26032));
        brain.func_218208_a(Activity.field_221374_j, VillagerTasks.func_220644_i(villagerProfession, \u26032));
        brain.func_218199_a((Set<Activity>)ImmutableSet.of((Object)Activity.field_221365_a));
        brain.func_218200_b(Activity.field_221366_b);
        brain.func_218202_a(Activity.field_221366_b);
        brain.func_218211_a(this.field_70170_p.func_72820_D(), this.field_70170_p.func_82737_E());
    }

    @Override
    protected void func_175500_n() {
        super.func_175500_n();
        if (this.field_70170_p instanceof ServerWorld) {
            this.func_213770_a((ServerWorld)this.field_70170_p);
        }
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(48.0);
    }

    @Override
    protected void func_70619_bc() {
        Raid raid;
        this.field_70170_p.func_217381_Z().func_76320_a("brain");
        this.func_213375_cj().func_218210_a((ServerWorld)this.field_70170_p, this);
        this.field_70170_p.func_217381_Z().func_76319_b();
        if (!this.func_213716_dX() && this.field_70961_j > 0) {
            --this.field_70961_j;
            if (this.field_70961_j <= 0) {
                if (this.field_213777_bF) {
                    this.func_175554_cu();
                    this.field_213777_bF = false;
                }
                this.func_195064_c(new EffectInstance(Effects.field_76428_l, 200, 0));
            }
        }
        if (this.field_213778_bG != null && this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_217489_a(IReputationType.field_221033_e, this.field_213778_bG, this);
            this.field_70170_p.func_72960_a(this, (byte)14);
            this.field_213778_bG = null;
        }
        if (!this.func_175446_cd() && this.field_70146_Z.nextInt(100) == 0 && (raid = ((ServerWorld)this.field_70170_p).func_217475_c_(new BlockPos(this))) != null && raid.func_221333_v() && !raid.func_221319_a()) {
            this.field_70170_p.func_72960_a(this, (byte)42);
        }
        if (this.func_213700_eh().func_221130_b() == VillagerProfession.field_221151_a && this.func_213716_dX()) {
            this.func_213750_eg();
        }
        super.func_70619_bc();
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_213719_ec() > 0) {
            this.func_213720_r(this.func_213719_ec() - 1);
        }
        this.func_223343_eC();
    }

    @Override
    public boolean func_184645_a(PlayerEntity playerEntity2, Hand hand) {
        PlayerEntity playerEntity2;
        ItemStack itemStack = playerEntity2.func_184586_b(hand);
        boolean bl = \u2603 = itemStack.func_77973_b() == Items.field_151057_cb;
        if (\u2603) {
            itemStack.func_111282_a(playerEntity2, this, hand);
            return true;
        }
        if (itemStack.func_77973_b() != Items.field_196172_da && this.func_70089_S() && !this.func_213716_dX() && !this.func_70608_bn()) {
            if (this.func_70631_g_()) {
                this.func_213756_es();
                return super.func_184645_a(playerEntity2, hand);
            }
            boolean bl2 = this.func_213706_dY().isEmpty();
            if (hand == Hand.MAIN_HAND) {
                if (bl2 && !this.field_70170_p.field_72995_K) {
                    this.func_213756_es();
                }
                playerEntity2.func_195066_a(Stats.field_188074_H);
            }
            if (bl2) {
                return super.func_184645_a(playerEntity2, hand);
            }
            if (!this.field_70170_p.field_72995_K && !this.field_213724_bz.isEmpty()) {
                this.func_213740_f(playerEntity2);
            }
            return true;
        }
        return super.func_184645_a(playerEntity2, hand);
    }

    private void func_213756_es() {
        this.func_213720_r(40);
        if (!this.field_70170_p.func_201670_d()) {
            this.func_184185_a(SoundEvents.field_187913_gm, this.func_70599_aP(), this.func_70647_i());
        }
    }

    private void func_213740_f(PlayerEntity playerEntity) {
        this.func_213762_g(playerEntity);
        this.func_70932_a_(playerEntity);
        this.func_213707_a(playerEntity, this.func_145748_c_(), this.func_213700_eh().func_221132_c());
    }

    @Override
    public void func_70932_a_(@Nullable PlayerEntity playerEntity) {
        boolean bl = this.func_70931_l_() != null && playerEntity == null;
        super.func_70932_a_(playerEntity);
        if (bl) {
            this.func_213750_eg();
        }
    }

    @Override
    protected void func_213750_eg() {
        super.func_213750_eg();
        this.func_213748_et();
    }

    private void func_213748_et() {
        for (MerchantOffer merchantOffer : this.func_213706_dY()) {
            merchantOffer.func_222220_k();
        }
    }

    @Override
    public boolean func_223340_ej() {
        return true;
    }

    public void func_213766_ei() {
        this.func_223715_ey();
        for (MerchantOffer merchantOffer : this.func_213706_dY()) {
            merchantOffer.func_222203_h();
        }
        if (this.func_213700_eh().func_221130_b() == VillagerProfession.field_221156_f) {
            this.func_223359_eB();
        }
        this.field_213785_bP = this.field_70170_p.func_82737_E();
        ++this.field_223725_bO;
    }

    private boolean func_223723_ev() {
        for (MerchantOffer merchantOffer : this.func_213706_dY()) {
            if (!merchantOffer.func_226654_r_()) continue;
            return true;
        }
        return false;
    }

    private boolean func_223720_ew() {
        return this.field_223725_bO == 0 || this.field_223725_bO < 2 && this.field_70170_p.func_82737_E() > this.field_213785_bP + 2400L;
    }

    public boolean func_223721_ek() {
        long l = this.field_213785_bP + 12000L;
        \u2603 = this.field_70170_p.func_82737_E();
        boolean \u26032 = \u2603 > l;
        \u2603 = this.field_70170_p.func_72820_D();
        if (this.field_223726_bP > 0L) {
            \u2603 = \u2603 / 24000L;
            \u2603 = this.field_223726_bP / 24000L;
            \u26032 |= \u2603 > \u2603;
        }
        this.field_223726_bP = \u2603;
        if (\u26032) {
            this.field_213785_bP = \u2603;
            this.func_223718_eH();
        }
        return this.func_223720_ew() && this.func_223723_ev();
    }

    private void func_223719_ex() {
        int n = 2 - this.field_223725_bO;
        if (n > 0) {
            for (MerchantOffer merchantOffer : this.func_213706_dY()) {
                merchantOffer.func_222203_h();
            }
        }
        for (int i = 0; i < n; ++i) {
            this.func_223715_ey();
        }
    }

    private void func_223715_ey() {
        for (MerchantOffer merchantOffer : this.func_213706_dY()) {
            merchantOffer.func_222222_e();
        }
    }

    private void func_213762_g(PlayerEntity playerEntity2) {
        PlayerEntity playerEntity2;
        int n = this.func_223107_f(playerEntity2);
        if (n != 0) {
            for (MerchantOffer merchantOffer : this.func_213706_dY()) {
                merchantOffer.func_222207_a(-MathHelper.func_76141_d((float)n * merchantOffer.func_222211_m()));
            }
        }
        if (playerEntity2.func_70644_a(Effects.field_220310_F)) {
            EffectInstance effectInstance = playerEntity2.func_70660_b(Effects.field_220310_F);
            int \u26032 = effectInstance.func_76458_c();
            for (MerchantOffer merchantOffer : this.func_213706_dY()) {
                double d = 0.3 + 0.0625 * (double)\u26032;
                int \u26033 = (int)Math.floor(d * (double)merchantOffer.func_222218_a().func_190916_E());
                merchantOffer.func_222207_a(-Math.max(\u26033, 1));
            }
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_213775_bC, new VillagerData(IVillagerType.field_221175_c, VillagerProfession.field_221151_a, 1));
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        compoundNBT.func_218657_a("VillagerData", this.func_213700_eh().func_221131_a(NBTDynamicOps.field_210820_a));
        compoundNBT.func_74774_a("FoodLevel", this.field_213781_bL);
        compoundNBT.func_218657_a("Gossips", (INBT)this.field_213782_bM.func_220914_a(NBTDynamicOps.field_210820_a).getValue());
        compoundNBT.func_74768_a("Xp", this.field_213784_bO);
        compoundNBT.func_74772_a("LastRestock", this.field_213785_bP);
        compoundNBT.func_74772_a("LastGossipDecay", this.field_223362_bL);
        compoundNBT.func_74768_a("RestocksToday", this.field_223725_bO);
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        if (compoundNBT.func_150297_b("VillagerData", 10)) {
            this.func_213753_a(new VillagerData(new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)compoundNBT.func_74781_a("VillagerData"))));
        }
        if (compoundNBT.func_150297_b("Offers", 10)) {
            this.field_213724_bz = new MerchantOffers(compoundNBT.func_74775_l("Offers"));
        }
        if (compoundNBT.func_150297_b("FoodLevel", 1)) {
            this.field_213781_bL = compoundNBT.func_74771_c("FoodLevel");
        }
        ListNBT listNBT = compoundNBT.func_150295_c("Gossips", 10);
        this.field_213782_bM.func_220918_a(new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)listNBT));
        if (compoundNBT.func_150297_b("Xp", 3)) {
            this.field_213784_bO = compoundNBT.func_74762_e("Xp");
        }
        this.field_213785_bP = compoundNBT.func_74763_f("LastRestock");
        this.field_223362_bL = compoundNBT.func_74763_f("LastGossipDecay");
        this.func_98053_h(true);
        if (this.field_70170_p instanceof ServerWorld) {
            this.func_213770_a((ServerWorld)this.field_70170_p);
        }
        this.field_223725_bO = compoundNBT.func_74762_e("RestocksToday");
    }

    @Override
    public boolean func_213397_c(double d) {
        return false;
    }

    @Override
    @Nullable
    protected SoundEvent func_184639_G() {
        if (this.func_70608_bn()) {
            return null;
        }
        if (this.func_213716_dX()) {
            return SoundEvents.field_187914_gn;
        }
        return SoundEvents.field_187910_gj;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187912_gl;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187911_gk;
    }

    public void func_213767_ej() {
        SoundEvent soundEvent = this.func_213700_eh().func_221130_b().func_226558_e_();
        if (soundEvent != null) {
            this.func_184185_a(soundEvent, this.func_70599_aP(), this.func_70647_i());
        }
    }

    public void func_213753_a(VillagerData villagerData) {
        \u2603 = this.func_213700_eh();
        if (\u2603.func_221130_b() != villagerData.func_221130_b()) {
            this.field_213724_bz = null;
        }
        this.field_70180_af.func_187227_b(field_213775_bC, villagerData);
    }

    @Override
    public VillagerData func_213700_eh() {
        return this.field_70180_af.func_187225_a(field_213775_bC);
    }

    @Override
    protected void func_213713_b(MerchantOffer merchantOffer) {
        int n = 3 + this.field_70146_Z.nextInt(4);
        this.field_213784_bO += merchantOffer.func_222210_n();
        this.field_213778_bG = this.func_70931_l_();
        if (this.func_213741_eu()) {
            this.field_70961_j = 40;
            this.field_213777_bF = true;
            n += 5;
        }
        if (merchantOffer.func_222221_q()) {
            this.field_70170_p.func_217376_c(new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), n));
        }
    }

    @Override
    public void func_70604_c(@Nullable LivingEntity livingEntity) {
        if (livingEntity != null && this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_217489_a(IReputationType.field_221031_c, livingEntity, this);
            if (this.func_70089_S() && livingEntity instanceof PlayerEntity) {
                this.field_70170_p.func_72960_a(this, (byte)13);
            }
        }
        super.func_70604_c(livingEntity);
    }

    @Override
    public void func_70645_a(DamageSource damageSource) {
        field_184243_a.info("Villager {} died, message: '{}'", (Object)this, (Object)damageSource.func_151519_b(this).getString());
        Entity entity = damageSource.func_76346_g();
        if (entity != null) {
            this.func_223361_a(entity);
        }
        this.func_213742_a(MemoryModuleType.field_220941_b);
        this.func_213742_a(MemoryModuleType.field_220942_c);
        this.func_213742_a(MemoryModuleType.field_220943_d);
        super.func_70645_a(damageSource);
    }

    private void func_223361_a(Entity entity) {
        if (!(this.field_70170_p instanceof ServerWorld)) {
            return;
        }
        Optional<List<LivingEntity>> optional = this.field_213378_br.func_218207_c(MemoryModuleType.field_220946_g);
        if (!optional.isPresent()) {
            return;
        }
        ServerWorld \u26032 = (ServerWorld)this.field_70170_p;
        optional.get().stream().filter(livingEntity -> livingEntity instanceof IReputationTracking).forEach(livingEntity -> \u26032.func_217489_a(IReputationType.field_221032_d, entity, (IReputationTracking)((Object)livingEntity)));
    }

    public void func_213742_a(MemoryModuleType<GlobalPos> memoryModuleType) {
        if (!(this.field_70170_p instanceof ServerWorld)) {
            return;
        }
        MinecraftServer minecraftServer = ((ServerWorld)this.field_70170_p).func_73046_m();
        this.field_213378_br.func_218207_c(memoryModuleType).ifPresent(globalPos -> {
            ServerWorld serverWorld = minecraftServer.func_71218_a(globalPos.func_218177_a());
            PointOfInterestManager \u26032 = serverWorld.func_217443_B();
            Optional<PointOfInterestType> \u26033 = \u26032.func_219148_c(globalPos.func_218180_b());
            BiPredicate<VillagerEntity, PointOfInterestType> \u26034 = field_213774_bB.get(memoryModuleType);
            if (\u26033.isPresent() && \u26034.test(this, \u26033.get())) {
                \u26032.func_219142_b(globalPos.func_218180_b());
                DebugPacketSender.func_218801_c(serverWorld, globalPos.func_218180_b());
            }
        });
    }

    public boolean func_213743_em() {
        return this.field_213781_bL + this.func_213751_ew() >= 12 && this.func_70874_b() == 0;
    }

    private boolean func_223344_ex() {
        return this.field_213781_bL < 12;
    }

    private void func_213765_en() {
        if (!this.func_223344_ex() || this.func_213751_ew() == 0) {
            return;
        }
        for (int i = 0; i < this.func_213715_ed().func_70302_i_(); ++i) {
            ItemStack itemStack = this.func_213715_ed().func_70301_a(i);
            if (itemStack.func_190926_b() || (\u2603 = field_213788_bA.get(itemStack.func_77973_b())) == null) continue;
            for (int j = \u2603 = itemStack.func_190916_E(); j > 0; --j) {
                this.field_213781_bL = (byte)(this.field_213781_bL + \u2603);
                this.func_213715_ed().func_70298_a(i, 1);
                if (this.func_223344_ex()) continue;
                return;
            }
        }
    }

    public int func_223107_f(PlayerEntity playerEntity) {
        return this.field_213782_bM.func_220921_a(playerEntity.func_110124_au(), gossipType -> true);
    }

    private void func_213758_s(int n) {
        this.field_213781_bL = (byte)(this.field_213781_bL - n);
    }

    public void func_223346_ep() {
        this.func_213765_en();
        this.func_213758_s(12);
    }

    public void func_213768_b(MerchantOffers merchantOffers) {
        this.field_213724_bz = merchantOffers;
    }

    private boolean func_213741_eu() {
        int n = this.func_213700_eh().func_221132_c();
        return VillagerData.func_221128_d(n) && this.field_213784_bO >= VillagerData.func_221127_c(n);
    }

    private void func_175554_cu() {
        this.func_213753_a(this.func_213700_eh().func_221135_a(this.func_213700_eh().func_221132_c() + 1));
        this.func_213712_ef();
    }

    @Override
    protected ITextComponent func_225513_by_() {
        return new TranslationTextComponent(this.func_200600_R().func_210760_d() + '.' + Registry.field_218370_L.func_177774_c(this.func_213700_eh().func_221130_b()).func_110623_a(), new Object[0]);
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IWorld iWorld, DifficultyInstance difficultyInstance, SpawnReason spawnReason, @Nullable ILivingEntityData iLivingEntityData, @Nullable CompoundNBT compoundNBT) {
        if (spawnReason == SpawnReason.BREEDING) {
            this.func_213753_a(this.func_213700_eh().func_221126_a(VillagerProfession.field_221151_a));
        }
        if (spawnReason == SpawnReason.COMMAND || spawnReason == SpawnReason.SPAWN_EGG || spawnReason == SpawnReason.SPAWNER || spawnReason == SpawnReason.DISPENSER) {
            this.func_213753_a(this.func_213700_eh().func_221134_a(IVillagerType.func_221170_a(iWorld.func_226691_t_(new BlockPos(this)))));
        }
        return super.func_213386_a(iWorld, difficultyInstance, spawnReason, iLivingEntityData, compoundNBT);
    }

    @Override
    public VillagerEntity func_90011_a(AgeableEntity ageableEntity) {
        double d = this.field_70146_Z.nextDouble();
        IVillagerType \u26032 = d < 0.5 ? IVillagerType.func_221170_a(this.field_70170_p.func_226691_t_(new BlockPos(this))) : (d < 0.75 ? this.func_213700_eh().func_221129_a() : ((VillagerEntity)ageableEntity).func_213700_eh().func_221129_a());
        VillagerEntity \u26033 = new VillagerEntity(EntityType.field_200756_av, this.field_70170_p, \u26032);
        \u26033.func_213386_a(this.field_70170_p, this.field_70170_p.func_175649_E(new BlockPos(\u26033)), SpawnReason.BREEDING, null, null);
        return \u26033;
    }

    @Override
    public void func_70077_a(LightningBoltEntity lightningBoltEntity) {
        WitchEntity witchEntity = EntityType.field_200759_ay.func_200721_a(this.field_70170_p);
        witchEntity.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
        witchEntity.func_213386_a(this.field_70170_p, this.field_70170_p.func_175649_E(new BlockPos(witchEntity)), SpawnReason.CONVERSION, null, null);
        witchEntity.func_94061_f(this.func_175446_cd());
        if (this.func_145818_k_()) {
            witchEntity.func_200203_b(this.func_200201_e());
            witchEntity.func_174805_g(this.func_174833_aM());
        }
        this.field_70170_p.func_217376_c(witchEntity);
        this.func_70106_y();
    }

    @Override
    protected void func_175445_a(ItemEntity itemEntity) {
        ItemStack itemStack = itemEntity.func_92059_d();
        Item \u26032 = itemStack.func_77973_b();
        if (this.func_223717_b(\u26032)) {
            ItemStack \u26035;
            int \u26034;
            Inventory inventory = this.func_213715_ed();
            boolean \u26033 = false;
            for (\u26034 = 0; \u26034 < inventory.func_70302_i_(); ++\u26034) {
                \u26035 = inventory.func_70301_a(\u26034);
                if (!\u26035.func_190926_b() && (\u26035.func_77973_b() != \u26032 || \u26035.func_190916_E() >= \u26035.func_77976_d())) continue;
                \u26033 = true;
                break;
            }
            if (!\u26033) {
                return;
            }
            \u26034 = inventory.func_213901_a(\u26032);
            if (\u26034 == 256) {
                return;
            }
            if (\u26034 > 256) {
                inventory.func_223374_a(\u26032, \u26034 - 256);
                return;
            }
            this.func_71001_a(itemEntity, itemStack.func_190916_E());
            \u26035 = inventory.func_174894_a(itemStack);
            if (\u26035.func_190926_b()) {
                itemEntity.func_70106_y();
            } else {
                itemStack.func_190920_e(\u26035.func_190916_E());
            }
        }
    }

    public boolean func_223717_b(Item item) {
        return field_213776_bD.contains(item) || this.func_213700_eh().func_221130_b().func_221146_c().contains((Object)item);
    }

    public boolean func_175555_cq() {
        return this.func_213751_ew() >= 24;
    }

    public boolean func_175557_cr() {
        return this.func_213751_ew() < 12;
    }

    private int func_213751_ew() {
        Inventory inventory = this.func_213715_ed();
        return field_213788_bA.entrySet().stream().mapToInt(entry -> inventory.func_213901_a((Item)entry.getKey()) * (Integer)entry.getValue()).sum();
    }

    private void func_223359_eB() {
        Inventory inventory = this.func_213715_ed();
        int \u26032 = inventory.func_213901_a(Items.field_151015_O);
        int \u26033 = \u26032 / 3;
        if (\u26033 == 0) {
            return;
        }
        int \u26034 = \u26033 * 3;
        inventory.func_223374_a(Items.field_151015_O, \u26034);
        ItemStack \u26035 = inventory.func_174894_a(new ItemStack(Items.field_151025_P, \u26033));
        if (!\u26035.func_190926_b()) {
            this.func_70099_a(\u26035, 0.5f);
        }
    }

    public boolean func_175556_cs() {
        Inventory inventory = this.func_213715_ed();
        return inventory.func_213902_a((Set<Item>)ImmutableSet.of((Object)Items.field_151014_N, (Object)Items.field_151174_bG, (Object)Items.field_151172_bF, (Object)Items.field_185163_cU));
    }

    @Override
    protected void func_213712_ef() {
        VillagerData villagerData = this.func_213700_eh();
        Int2ObjectMap<VillagerTrades.ITrade[]> \u26032 = VillagerTrades.field_221239_a.get(villagerData.func_221130_b());
        if (\u26032 == null || \u26032.isEmpty()) {
            return;
        }
        VillagerTrades.ITrade[] \u26033 = (VillagerTrades.ITrade[])\u26032.get(villagerData.func_221132_c());
        if (\u26033 == null) {
            return;
        }
        MerchantOffers \u26034 = this.func_213706_dY();
        this.func_213717_a(\u26034, \u26033, 2);
    }

    public void func_213746_a(VillagerEntity villagerEntity, long l) {
        if (l >= this.field_213783_bN && l < this.field_213783_bN + 1200L || l >= villagerEntity.field_213783_bN && l < villagerEntity.field_213783_bN + 1200L) {
            return;
        }
        this.field_213782_bM.func_220912_a(villagerEntity.field_213782_bM, this.field_70146_Z, 10);
        this.field_213783_bN = l;
        villagerEntity.field_213783_bN = l;
        this.func_223358_a(l, 5);
    }

    private void func_223343_eC() {
        long l = this.field_70170_p.func_82737_E();
        if (this.field_223362_bL == 0L) {
            this.field_223362_bL = l;
            return;
        }
        if (l < this.field_223362_bL + 24000L) {
            return;
        }
        this.field_213782_bM.func_223538_b();
        this.field_223362_bL = l;
    }

    public void func_223358_a(long l, int n) {
        if (!this.func_223350_a(l)) {
            return;
        }
        AxisAlignedBB axisAlignedBB = this.func_174813_aQ().func_72314_b(10.0, 10.0, 10.0);
        List<VillagerEntity> \u26032 = this.field_70170_p.func_217357_a(VillagerEntity.class, axisAlignedBB);
        List \u26033 = \u26032.stream().filter(villagerEntity -> villagerEntity.func_223350_a(l)).limit(5L).collect(Collectors.toList());
        if (\u26033.size() < n) {
            return;
        }
        IronGolemEntity \u26034 = this.func_213759_ey();
        if (\u26034 == null) {
            return;
        }
        \u26032.forEach(villagerEntity -> villagerEntity.func_223347_b(l));
    }

    private void func_223347_b(long l) {
        this.field_213378_br.func_218205_a(MemoryModuleType.field_223542_x, l);
    }

    private boolean func_223354_c(long l) {
        Optional<Long> optional = this.field_213378_br.func_218207_c(MemoryModuleType.field_223542_x);
        if (!optional.isPresent()) {
            return false;
        }
        Long \u26032 = optional.get();
        return l - \u26032 <= 600L;
    }

    public boolean func_223350_a(long l) {
        VillagerData villagerData = this.func_213700_eh();
        if (villagerData.func_221130_b() == VillagerProfession.field_221151_a || villagerData.func_221130_b() == VillagerProfession.field_221162_l) {
            return false;
        }
        if (!this.func_223352_d(this.field_70170_p.func_82737_E())) {
            return false;
        }
        return !this.func_223354_c(l);
    }

    @Nullable
    private IronGolemEntity func_213759_ey() {
        BlockPos blockPos = new BlockPos(this);
        for (int i = 0; i < 10; ++i) {
            Object object;
            double d = this.field_70170_p.field_73012_v.nextInt(16) - 8;
            \u2603 = this.field_70170_p.field_73012_v.nextInt(16) - 8;
            \u2603 = 6.0;
            for (int j = 0; j >= -12; --j) {
                object = blockPos.func_177963_a(d, \u2603 + (double)j, \u2603);
                if (!this.field_70170_p.func_180495_p((BlockPos)object).func_196958_f() && !this.field_70170_p.func_180495_p((BlockPos)object).func_185904_a().func_76224_d() || !this.field_70170_p.func_180495_p(((BlockPos)object).func_177977_b()).func_185904_a().func_76218_k()) continue;
                \u2603 += (double)j;
                break;
            }
            if ((object = EntityType.field_200757_aw.func_220349_b(this.field_70170_p, null, null, null, \u2603 = blockPos.func_177963_a(d, \u2603, \u2603), SpawnReason.MOB_SUMMONED, false, false)) == null) continue;
            if (((CreatureEntity)object).func_213380_a(this.field_70170_p, SpawnReason.MOB_SUMMONED) && ((IronGolemEntity)object).func_205019_a(this.field_70170_p)) {
                this.field_70170_p.func_217376_c((Entity)object);
                return object;
            }
            ((Entity)object).func_70106_y();
        }
        return null;
    }

    @Override
    public void func_213739_a(IReputationType iReputationType, Entity entity) {
        if (iReputationType == IReputationType.field_221029_a) {
            this.field_213782_bM.func_220916_a(entity.func_110124_au(), GossipType.MAJOR_POSITIVE, 20);
            this.field_213782_bM.func_220916_a(entity.func_110124_au(), GossipType.MINOR_POSITIVE, 25);
        } else if (iReputationType == IReputationType.field_221033_e) {
            this.field_213782_bM.func_220916_a(entity.func_110124_au(), GossipType.TRADING, 2);
        } else if (iReputationType == IReputationType.field_221031_c) {
            this.field_213782_bM.func_220916_a(entity.func_110124_au(), GossipType.MINOR_NEGATIVE, 25);
        } else if (iReputationType == IReputationType.field_221032_d) {
            this.field_213782_bM.func_220916_a(entity.func_110124_au(), GossipType.MAJOR_NEGATIVE, 25);
        }
    }

    @Override
    public int func_213708_dV() {
        return this.field_213784_bO;
    }

    public void func_213761_t(int n) {
        this.field_213784_bO = n;
    }

    private void func_223718_eH() {
        this.func_223719_ex();
        this.field_223725_bO = 0;
    }

    public GossipManager func_223722_es() {
        return this.field_213782_bM;
    }

    public void func_223716_a(INBT iNBT) {
        this.field_213782_bM.func_220918_a(new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)iNBT));
    }

    @Override
    protected void func_213387_K() {
        super.func_213387_K();
        DebugPacketSender.func_218798_a(this);
    }

    @Override
    public void func_213342_e(BlockPos blockPos) {
        super.func_213342_e(blockPos);
        this.field_213378_br.func_218205_a(MemoryModuleType.field_223543_y, LongSerializable.func_223463_a(this.field_70170_p.func_82737_E()));
    }

    @Override
    public void func_213366_dy() {
        super.func_213366_dy();
        this.field_213378_br.func_218205_a(MemoryModuleType.field_226332_A_, LongSerializable.func_223463_a(this.field_70170_p.func_82737_E()));
    }

    private boolean func_223352_d(long l) {
        Optional<LongSerializable> optional = this.field_213378_br.func_218207_c(MemoryModuleType.field_223543_y);
        \u2603 = this.field_213378_br.func_218207_c(MemoryModuleType.field_223544_z);
        if (optional.isPresent() && \u2603.isPresent()) {
            return l - optional.get().func_223461_a() < 24000L && l - \u2603.get().func_223461_a() < 36000L;
        }
        return false;
    }

    @Override
    public /* synthetic */ AgeableEntity func_90011_a(AgeableEntity ageableEntity) {
        return this.func_90011_a(ageableEntity);
    }
}

