/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive.fish;

import java.util.Random;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public abstract class AbstractFishEntity
extends WaterMobEntity {
    private static final DataParameter<Boolean> field_203711_b = EntityDataManager.func_187226_a(AbstractFishEntity.class, DataSerializers.field_187198_h);

    public AbstractFishEntity(EntityType<? extends AbstractFishEntity> entityType, World world) {
        super((EntityType<? extends WaterMobEntity>)entityType, world);
        this.field_70765_h = new MoveHelperController(this);
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize entitySize) {
        return entitySize.field_220316_b * 0.65f;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(3.0);
    }

    @Override
    public boolean func_213392_I() {
        return this.func_203705_dA();
    }

    public static boolean func_223363_b(EntityType<? extends AbstractFishEntity> entityType, IWorld iWorld, SpawnReason spawnReason, BlockPos blockPos, Random random) {
        return iWorld.func_180495_p(blockPos).func_177230_c() == Blocks.field_150355_j && iWorld.func_180495_p(blockPos.func_177984_a()).func_177230_c() == Blocks.field_150355_j;
    }

    @Override
    public boolean func_213397_c(double d) {
        return !this.func_203705_dA() && !this.func_145818_k_();
    }

    @Override
    public int func_70641_bl() {
        return 8;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_203711_b, false);
    }

    private boolean func_203705_dA() {
        return this.field_70180_af.func_187225_a(field_203711_b);
    }

    public void func_203706_r(boolean bl) {
        this.field_70180_af.func_187227_b(field_203711_b, bl);
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        compoundNBT.func_74757_a("FromBucket", this.func_203705_dA());
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        this.func_203706_r(compoundNBT.func_74767_n("FromBucket"));
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, new PanicGoal(this, 1.25));
        this.field_70714_bg.func_75776_a(2, new AvoidEntityGoal<PlayerEntity>(this, PlayerEntity.class, 8.0f, 1.6, 1.4, EntityPredicates.field_180132_d::test));
        this.field_70714_bg.func_75776_a(4, new SwimGoal(this));
    }

    @Override
    protected PathNavigator func_175447_b(World world) {
        return new SwimmerPathNavigator(this, world);
    }

    @Override
    public void func_213352_e(Vec3d vec3d) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(0.01f, vec3d);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (this.func_70638_az() == null) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            }
        } else {
            super.func_213352_e(vec3d);
        }
    }

    @Override
    public void func_70636_d() {
        if (!this.func_70090_H() && this.field_70122_E && this.field_70124_G) {
            this.func_213317_d(this.func_213322_ci().func_72441_c((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.05f, 0.4f, (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.05f));
            this.field_70122_E = false;
            this.field_70160_al = true;
            this.func_184185_a(this.func_203701_dz(), this.func_70599_aP(), this.func_70647_i());
        }
        super.func_70636_d();
    }

    @Override
    protected boolean func_184645_a(PlayerEntity playerEntity, Hand hand) {
        ItemStack itemStack = playerEntity.func_184586_b(hand);
        if (itemStack.func_77973_b() == Items.field_151131_as && this.func_70089_S()) {
            this.func_184185_a(SoundEvents.field_203814_aa, 1.0f, 1.0f);
            itemStack.func_190918_g(1);
            \u2603 = this.func_203707_dx();
            this.func_204211_f(\u2603);
            if (!this.field_70170_p.field_72995_K) {
                CriteriaTriggers.field_204813_j.func_204817_a((ServerPlayerEntity)playerEntity, \u2603);
            }
            if (itemStack.func_190926_b()) {
                playerEntity.func_184611_a(hand, \u2603);
            } else if (!playerEntity.field_71071_by.func_70441_a(\u2603)) {
                playerEntity.func_71019_a(\u2603, false);
            }
            this.func_70106_y();
            return true;
        }
        return super.func_184645_a(playerEntity, hand);
    }

    protected void func_204211_f(ItemStack itemStack) {
        if (this.func_145818_k_()) {
            itemStack.func_200302_a(this.func_200201_e());
        }
    }

    protected abstract ItemStack func_203707_dx();

    protected boolean func_212800_dy() {
        return true;
    }

    protected abstract SoundEvent func_203701_dz();

    @Override
    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_203817_bZ;
    }

    static class MoveHelperController
    extends MovementController {
        private final AbstractFishEntity field_203781_i;

        MoveHelperController(AbstractFishEntity abstractFishEntity) {
            super(abstractFishEntity);
            this.field_203781_i = abstractFishEntity;
        }

        @Override
        public void func_75641_c() {
            if (this.field_203781_i.func_208600_a(FluidTags.field_206959_a)) {
                this.field_203781_i.func_213317_d(this.field_203781_i.func_213322_ci().func_72441_c(0.0, 0.005, 0.0));
            }
            if (this.field_188491_h != MovementController.Action.MOVE_TO || this.field_203781_i.func_70661_as().func_75500_f()) {
                this.field_203781_i.func_70659_e(0.0f);
                return;
            }
            double d = this.field_75646_b - this.field_203781_i.func_226277_ct_();
            \u2603 = this.field_75647_c - this.field_203781_i.func_226278_cu_();
            \u2603 = this.field_75644_d - this.field_203781_i.func_226281_cx_();
            \u2603 = MathHelper.func_76133_a(d * d + \u2603 * \u2603 + \u2603 * \u2603);
            float \u26032 = (float)(MathHelper.func_181159_b(\u2603, d) * 57.2957763671875) - 90.0f;
            this.field_203781_i.field_70761_aq = this.field_203781_i.field_70177_z = this.func_75639_a(this.field_203781_i.field_70177_z, \u26032, 90.0f);
            float \u26033 = (float)(this.field_75645_e * this.field_203781_i.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
            this.field_203781_i.func_70659_e(MathHelper.func_219799_g(0.125f, this.field_203781_i.func_70689_ay(), \u26033));
            this.field_203781_i.func_213317_d(this.field_203781_i.func_213322_ci().func_72441_c(0.0, (double)this.field_203781_i.func_70689_ay() * (\u2603 /= \u2603) * 0.1, 0.0));
        }
    }

    static class SwimGoal
    extends RandomSwimmingGoal {
        private final AbstractFishEntity field_203788_h;

        public SwimGoal(AbstractFishEntity abstractFishEntity) {
            super(abstractFishEntity, 1.0, 40);
            this.field_203788_h = abstractFishEntity;
        }

        @Override
        public boolean func_75250_a() {
            return this.field_203788_h.func_212800_dy() && super.func_75250_a();
        }
    }
}

