/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import net.minecraft.network.NetworkSystem;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LegacyPingHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger field_151258_a = LogManager.getLogger();
    private final NetworkSystem field_151257_b;

    public LegacyPingHandler(NetworkSystem networkSystem) {
        this.field_151257_b = networkSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        ByteBuf byteBuf = (ByteBuf)object;
        byteBuf.markReaderIndex();
        boolean \u26032 = true;
        try {
            if (byteBuf.readUnsignedByte() != 254) {
                return;
            }
            InetSocketAddress inetSocketAddress = (InetSocketAddress)channelHandlerContext.channel().remoteAddress();
            MinecraftServer \u26033 = this.field_151257_b.func_151267_d();
            int \u26034 = byteBuf.readableBytes();
            switch (\u26034) {
                case 0: {
                    field_151258_a.debug("Ping: (<1.3.x) from {}:{}", (Object)inetSocketAddress.getAddress(), (Object)inetSocketAddress.getPort());
                    String string = String.format("%s\u00a7%d\u00a7%d", \u26033.func_71273_Y(), \u26033.func_71233_x(), \u26033.func_71275_y());
                    this.func_151256_a(channelHandlerContext, this.func_151255_a(string));
                    break;
                }
                case 1: {
                    if (byteBuf.readUnsignedByte() != 1) {
                        return;
                    }
                    field_151258_a.debug("Ping: (1.4-1.5.x) from {}:{}", (Object)inetSocketAddress.getAddress(), (Object)inetSocketAddress.getPort());
                    String \u26035 = String.format("\u00a71\u0000%d\u0000%s\u0000%s\u0000%d\u0000%d", 127, \u26033.func_71249_w(), \u26033.func_71273_Y(), \u26033.func_71233_x(), \u26033.func_71275_y());
                    this.func_151256_a(channelHandlerContext, this.func_151255_a(\u26035));
                    break;
                }
                default: {
                    boolean \u26036 = byteBuf.readUnsignedByte() == 1;
                    \u26036 &= byteBuf.readUnsignedByte() == 250;
                    \u26036 &= "MC|PingHost".equals(new String(byteBuf.readBytes(byteBuf.readShort() * 2).array(), StandardCharsets.UTF_16BE));
                    int \u26037 = byteBuf.readUnsignedShort();
                    \u26036 &= byteBuf.readUnsignedByte() >= 73;
                    \u26036 &= 3 + byteBuf.readBytes(byteBuf.readShort() * 2).array().length + 4 == \u26037;
                    \u26036 &= byteBuf.readInt() <= 65535;
                    if (!(\u26036 &= byteBuf.readableBytes() == 0)) {
                        return;
                    }
                    field_151258_a.debug("Ping: (1.6) from {}:{}", (Object)inetSocketAddress.getAddress(), (Object)inetSocketAddress.getPort());
                    String \u26038 = String.format("\u00a71\u0000%d\u0000%s\u0000%s\u0000%d\u0000%d", 127, \u26033.func_71249_w(), \u26033.func_71273_Y(), \u26033.func_71233_x(), \u26033.func_71275_y());
                    \u2603 = this.func_151255_a(\u26038);
                    try {
                        this.func_151256_a(channelHandlerContext, \u2603);
                        break;
                    }
                    finally {
                        \u2603.release();
                    }
                }
            }
            byteBuf.release();
            \u26032 = false;
        }
        catch (RuntimeException runtimeException) {
        }
        finally {
            if (\u26032) {
                byteBuf.resetReaderIndex();
                channelHandlerContext.channel().pipeline().remove("legacy_query");
                channelHandlerContext.fireChannelRead(object);
            }
        }
    }

    private void func_151256_a(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        channelHandlerContext.pipeline().firstContext().writeAndFlush((Object)byteBuf).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private ByteBuf func_151255_a(String string) {
        ByteBuf byteBuf = Unpooled.buffer();
        byteBuf.writeByte(255);
        char[] \u26032 = string.toCharArray();
        byteBuf.writeShort(\u26032.length);
        for (char c : \u26032) {
            byteBuf.writeChar((int)c);
        }
        return byteBuf;
    }
}

