/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.test;

import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.command.arguments.BlockStateInput;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.state.properties.StructureMode;
import net.minecraft.tileentity.CommandBlockTileEntity;
import net.minecraft.tileentity.StructureBlockTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.gen.FlatGenerationSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerTickList;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.io.IOUtils;

public class StructureHelper {
    public static String field_229590_a_ = "gameteststructures";

    public static AxisAlignedBB func_229594_a_(StructureBlockTileEntity structureBlockTileEntity) {
        BlockPos blockPos = structureBlockTileEntity.func_174877_v().func_177971_a(structureBlockTileEntity.func_189711_e());
        return new AxisAlignedBB(blockPos, blockPos.func_177971_a(structureBlockTileEntity.func_189717_g()));
    }

    public static void func_229600_a_(BlockPos blockPos, ServerWorld serverWorld) {
        serverWorld.func_175656_a(blockPos, Blocks.field_150483_bI.func_176223_P());
        CommandBlockTileEntity commandBlockTileEntity = (CommandBlockTileEntity)serverWorld.func_175625_s(blockPos);
        commandBlockTileEntity.func_145993_a().func_145752_a("test runthis");
        serverWorld.func_175656_a(blockPos.func_177982_a(0, 0, -1), Blocks.field_150430_aB.func_176223_P());
    }

    public static void func_229603_a_(String string, BlockPos blockPos, BlockPos blockPos2, int n, ServerWorld serverWorld) {
        MutableBoundingBox mutableBoundingBox = StructureHelper.func_229598_a_(blockPos, blockPos2, n);
        StructureHelper.func_229595_a_(mutableBoundingBox, blockPos.func_177956_o(), serverWorld);
        serverWorld.func_175656_a(blockPos, Blocks.field_185779_df.func_176223_P());
        StructureBlockTileEntity \u26032 = (StructureBlockTileEntity)serverWorld.func_175625_s(blockPos);
        \u26032.func_184406_a(false);
        \u26032.func_210163_a(new ResourceLocation(string));
        \u26032.func_184409_c(blockPos2);
        \u26032.func_184405_a(StructureMode.SAVE);
        \u26032.func_189710_f(true);
    }

    public static StructureBlockTileEntity func_229602_a_(String string, BlockPos blockPos, int n, ServerWorld serverWorld, boolean bl) {
        MutableBoundingBox mutableBoundingBox = StructureHelper.func_229598_a_(blockPos, StructureHelper.func_229605_a_(string, serverWorld).func_186259_a(), n);
        StructureHelper.func_229608_b_(blockPos, serverWorld);
        StructureHelper.func_229595_a_(mutableBoundingBox, blockPos.func_177956_o(), serverWorld);
        StructureBlockTileEntity \u26032 = StructureHelper.func_229604_a_(string, blockPos, serverWorld, bl);
        ((ServerTickList)serverWorld.func_205220_G_()).func_205366_a(mutableBoundingBox, true, false);
        serverWorld.func_229854_a_(mutableBoundingBox);
        return \u26032;
    }

    private static void func_229608_b_(BlockPos blockPos, ServerWorld serverWorld) {
        ChunkPos chunkPos = new ChunkPos(blockPos);
        for (int i = -1; i < 4; ++i) {
            for (\u2603 = -1; \u2603 < 4; ++\u2603) {
                \u2603 = chunkPos.field_77276_a + i;
                \u2603 = chunkPos.field_77275_b + \u2603;
                serverWorld.func_217458_b(\u2603, \u2603, true);
            }
        }
    }

    public static void func_229595_a_(MutableBoundingBox mutableBoundingBox, int n, ServerWorld serverWorld) {
        BlockPos.func_229383_a_(mutableBoundingBox).forEach(blockPos -> StructureHelper.func_229591_a_(n, blockPos, serverWorld));
        ((ServerTickList)serverWorld.func_205220_G_()).func_205366_a(mutableBoundingBox, true, false);
        serverWorld.func_229854_a_(mutableBoundingBox);
        AxisAlignedBB axisAlignedBB = new AxisAlignedBB(mutableBoundingBox.field_78897_a, mutableBoundingBox.field_78895_b, mutableBoundingBox.field_78896_c, mutableBoundingBox.field_78893_d, mutableBoundingBox.field_78894_e, mutableBoundingBox.field_78892_f);
        List<Entity> \u26032 = serverWorld.func_175647_a(Entity.class, axisAlignedBB, entity -> !(entity instanceof PlayerEntity));
        \u26032.forEach(Entity::func_70106_y);
    }

    public static MutableBoundingBox func_229598_a_(BlockPos blockPos, BlockPos blockPos2, int n) {
        BlockPos blockPos3 = blockPos.func_177982_a(-n, -3, -n);
        \u2603 = blockPos.func_177971_a(blockPos2).func_177982_a(n - 1, 30, n - 1);
        return MutableBoundingBox.func_175899_a(blockPos3.func_177958_n(), blockPos3.func_177956_o(), blockPos3.func_177952_p(), \u2603.func_177958_n(), \u2603.func_177956_o(), \u2603.func_177952_p());
    }

    public static Optional<BlockPos> func_229596_a_(BlockPos blockPos, int n, ServerWorld serverWorld) {
        return StructureHelper.func_229609_c_(blockPos, n, serverWorld).stream().filter(blockPos2 -> StructureHelper.func_229599_a_(blockPos2, blockPos, serverWorld)).findFirst();
    }

    @Nullable
    public static BlockPos func_229607_b_(BlockPos blockPos, int n, ServerWorld serverWorld) {
        Comparator<BlockPos> comparator = Comparator.comparingInt(blockPos2 -> blockPos2.func_218139_n(blockPos));
        Collection<BlockPos> \u26032 = StructureHelper.func_229609_c_(blockPos, n, serverWorld);
        Optional<BlockPos> \u26033 = \u26032.stream().min(comparator);
        return \u26033.orElse(null);
    }

    public static Collection<BlockPos> func_229609_c_(BlockPos blockPos, int n, ServerWorld serverWorld) {
        ArrayList arrayList = Lists.newArrayList();
        AxisAlignedBB \u26032 = new AxisAlignedBB(blockPos);
        \u26032 = \u26032.func_186662_g(n);
        for (int i = (int)\u26032.field_72340_a; i <= (int)\u26032.field_72336_d; ++i) {
            for (\u2603 = (int)\u26032.field_72338_b; \u2603 <= (int)\u26032.field_72337_e; ++\u2603) {
                for (\u2603 = (int)\u26032.field_72339_c; \u2603 <= (int)\u26032.field_72334_f; ++\u2603) {
                    BlockPos blockPos2 = new BlockPos(i, \u2603, \u2603);
                    BlockState \u26033 = serverWorld.func_180495_p(blockPos2);
                    if (\u26033.func_177230_c() != Blocks.field_185779_df) continue;
                    arrayList.add(blockPos2);
                }
            }
        }
        return arrayList;
    }

    private static Template func_229605_a_(String string, ServerWorld serverWorld) {
        TemplateManager templateManager = serverWorld.func_184163_y();
        Template \u26032 = templateManager.func_200219_b(new ResourceLocation(string));
        if (\u26032 != null) {
            return \u26032;
        }
        String \u26033 = string + ".snbt";
        Path \u26034 = Paths.get(field_229590_a_, \u26033);
        CompoundNBT \u26035 = StructureHelper.func_229606_a_(\u26034);
        if (\u26035 == null) {
            throw new RuntimeException("Could not find structure file " + \u26034 + ", and the structure is not available in the world structures either.");
        }
        return templateManager.func_227458_a_(\u26035);
    }

    private static StructureBlockTileEntity func_229604_a_(String string, BlockPos blockPos, ServerWorld serverWorld, boolean bl) {
        serverWorld.func_175656_a(blockPos, Blocks.field_185779_df.func_176223_P());
        StructureBlockTileEntity structureBlockTileEntity = (StructureBlockTileEntity)serverWorld.func_175625_s(blockPos);
        structureBlockTileEntity.func_184405_a(StructureMode.LOAD);
        structureBlockTileEntity.func_184406_a(false);
        structureBlockTileEntity.func_210163_a(new ResourceLocation(string));
        structureBlockTileEntity.func_189714_c(bl);
        if (structureBlockTileEntity.func_189717_g() != BlockPos.field_177992_a) {
            return structureBlockTileEntity;
        }
        Template \u26032 = StructureHelper.func_229605_a_(string, serverWorld);
        structureBlockTileEntity.func_227013_a_(bl, \u26032);
        if (structureBlockTileEntity.func_189717_g() == BlockPos.field_177992_a) {
            throw new RuntimeException("Failed to load structure " + string);
        }
        return structureBlockTileEntity;
    }

    @Nullable
    private static CompoundNBT func_229606_a_(Path path) {
        try {
            BufferedReader bufferedReader = Files.newBufferedReader(path);
            String \u26032 = IOUtils.toString((Reader)bufferedReader);
            return JsonToNBT.func_180713_a(\u26032);
        }
        catch (IOException iOException) {
            return null;
        }
        catch (CommandSyntaxException commandSyntaxException) {
            throw new RuntimeException("Error while trying to load structure " + path, commandSyntaxException);
        }
    }

    private static void func_229591_a_(int n, BlockPos blockPos, ServerWorld serverWorld) {
        BlockState \u26032;
        Object obj = serverWorld.func_72863_F().func_201711_g().func_201496_a_();
        if (obj instanceof FlatGenerationSettings) {
            Object object = ((FlatGenerationSettings)obj).func_202233_q();
            \u26032 = blockPos.func_177956_o() < n ? object[blockPos.func_177956_o() - 1] : Blocks.field_150350_a.func_176223_P();
        } else {
            \u26032 = blockPos.func_177956_o() == n - 1 ? serverWorld.func_226691_t_(blockPos).func_203944_q().func_204108_a() : (blockPos.func_177956_o() < n - 1 ? serverWorld.func_226691_t_(blockPos).func_203944_q().func_204109_b() : Blocks.field_150350_a.func_176223_P());
        }
        object = new BlockStateInput(\u26032, Collections.emptySet(), null);
        ((BlockStateInput)object).func_197230_a(serverWorld, blockPos, 2);
        serverWorld.func_195592_c(blockPos, \u26032.func_177230_c());
    }

    private static boolean func_229599_a_(BlockPos blockPos, BlockPos blockPos2, ServerWorld serverWorld) {
        StructureBlockTileEntity structureBlockTileEntity = (StructureBlockTileEntity)serverWorld.func_175625_s(blockPos);
        AxisAlignedBB \u26032 = StructureHelper.func_229594_a_(structureBlockTileEntity);
        return \u26032.func_72318_a(new Vec3d(blockPos2));
    }
}

