/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class BeehiveTileEntity
extends TileEntity
implements ITickableTileEntity {
    private final List<Bee> field_226958_a_ = Lists.newArrayList();
    @Nullable
    private BlockPos field_226959_b_ = null;

    public BeehiveTileEntity() {
        super(TileEntityType.field_226985_G_);
    }

    @Override
    public void func_70296_d() {
        if (this.func_226968_d_()) {
            this.func_226963_a_(null, this.field_145850_b.func_180495_p(this.func_174877_v()), State.EMERGENCY);
        }
        super.func_70296_d();
    }

    public boolean func_226968_d_() {
        if (this.field_145850_b == null) {
            return false;
        }
        for (BlockPos blockPos : BlockPos.func_218278_a(this.field_174879_c.func_177982_a(-1, -1, -1), this.field_174879_c.func_177982_a(1, 1, 1))) {
            if (!(this.field_145850_b.func_180495_p(blockPos).func_177230_c() instanceof FireBlock)) continue;
            return true;
        }
        return false;
    }

    public boolean func_226969_f_() {
        return this.field_226958_a_.isEmpty();
    }

    public boolean func_226970_h_() {
        return this.field_226958_a_.size() == 3;
    }

    public void func_226963_a_(@Nullable PlayerEntity playerEntity, BlockState blockState, State state) {
        List<Entity> list = this.func_226965_a_(blockState, state);
        if (playerEntity != null) {
            for (Entity entity : list) {
                if (!(entity instanceof BeeEntity)) continue;
                BeeEntity beeEntity = (BeeEntity)entity;
                if (!(playerEntity.func_213303_ch().func_72436_e(entity.func_213303_ch()) <= 16.0)) continue;
                if (!this.func_226972_k_()) {
                    beeEntity.func_226391_a_(playerEntity);
                    continue;
                }
                beeEntity.func_226450_t_(400);
            }
        }
    }

    private List<Entity> func_226965_a_(BlockState blockState, State state) {
        ArrayList arrayList = Lists.newArrayList();
        this.field_226958_a_.removeIf(bee -> this.func_226967_a_(blockState, ((Bee)bee).field_226977_a_, arrayList, state));
        return arrayList;
    }

    public void func_226961_a_(Entity entity, boolean bl) {
        this.func_226962_a_(entity, bl, 0);
    }

    public int func_226971_j_() {
        return this.field_226958_a_.size();
    }

    public static int func_226964_a_(BlockState blockState) {
        return blockState.func_177229_b(BeehiveBlock.field_226873_c_);
    }

    public boolean func_226972_k_() {
        return CampfireBlock.func_226914_b_(this.field_145850_b, this.func_174877_v(), 5);
    }

    protected void func_226973_l_() {
        DebugPacketSender.func_229750_a_(this);
    }

    public void func_226962_a_(Entity entity2, boolean bl, int n) {
        Entity entity2;
        if (this.field_226958_a_.size() >= 3) {
            return;
        }
        entity2.func_184226_ay();
        CompoundNBT compoundNBT = new CompoundNBT();
        entity2.func_70039_c(compoundNBT);
        this.field_226958_a_.add(new Bee(compoundNBT, n, bl ? 2400 : 600));
        if (this.field_145850_b != null) {
            if (entity2 instanceof BeeEntity && ((BeeEntity)(object = (BeeEntity)entity2)).func_226425_er_() && (!this.func_226975_x_() || this.field_145850_b.field_73012_v.nextBoolean())) {
                this.field_226959_b_ = ((BeeEntity)object).func_226424_eq_();
            }
            Object object = this.func_174877_v();
            this.field_145850_b.func_184148_a(null, ((Vec3i)object).func_177958_n(), ((Vec3i)object).func_177956_o(), ((Vec3i)object).func_177952_p(), SoundEvents.field_226131_af_, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        entity2.func_70106_y();
    }

    private boolean func_226967_a_(BlockState blockState, CompoundNBT compoundNBT, @Nullable List<Entity> list, State state) {
        BlockPos blockPos = this.func_174877_v();
        if ((this.field_145850_b.func_226690_K_() || this.field_145850_b.func_72896_J()) && state != State.EMERGENCY) {
            return false;
        }
        compoundNBT.func_82580_o("Passengers");
        compoundNBT.func_82580_o("Leash");
        compoundNBT.func_229681_c_("UUID");
        Direction \u26032 = blockState.func_177229_b(BeehiveBlock.field_226872_b_);
        \u2603 = blockPos.func_177972_a(\u26032);
        if (!this.field_145850_b.func_180495_p(\u2603).func_196952_d(this.field_145850_b, \u2603).func_197766_b()) {
            return false;
        }
        Entity \u26033 = EntityType.func_220335_a(compoundNBT, this.field_145850_b, entity -> entity);
        if (\u26033 != null) {
            Object object;
            float f = \u26033.func_213311_cf();
            double \u26034 = 0.55 + (double)(f / 2.0f);
            double \u26035 = (double)blockPos.func_177958_n() + 0.5 + \u26034 * (double)\u26032.func_82601_c();
            double \u26036 = (double)blockPos.func_177956_o() + 0.5 - (double)(\u26033.func_213302_cg() / 2.0f);
            double \u26037 = (double)blockPos.func_177952_p() + 0.5 + \u26034 * (double)\u26032.func_82599_e();
            \u26033.func_70012_b(\u26035, \u26036, \u26037, \u26033.field_70177_z, \u26033.field_70125_A);
            if (!\u26033.func_200600_R().func_220341_a(EntityTypeTags.field_226155_c_)) {
                return false;
            }
            if (\u26033 instanceof BeeEntity) {
                object = (BeeEntity)\u26033;
                if (this.func_226975_x_() && !((BeeEntity)object).func_226425_er_() && this.field_145850_b.field_73012_v.nextFloat() < 0.9f) {
                    ((BeeEntity)object).func_226431_g_(this.field_226959_b_);
                }
                if (state == State.HONEY_DELIVERED) {
                    ((BeeEntity)object).func_226413_eG_();
                    if (blockState.func_177230_c().func_203417_a(BlockTags.field_226151_aa_) && (\u2603 = BeehiveTileEntity.func_226964_a_(blockState)) < 5) {
                        int n = \u2603 = this.field_145850_b.field_73012_v.nextInt(100) == 0 ? 2 : 1;
                        if (\u2603 + \u2603 > 5) {
                            --\u2603;
                        }
                        this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)blockState.func_206870_a(BeehiveBlock.field_226873_c_, \u2603 + \u2603));
                    }
                }
                ((BeeEntity)object).func_226426_eu_();
                if (list != null) {
                    list.add((Entity)object);
                }
            }
            object = this.func_174877_v();
            this.field_145850_b.func_184148_a(null, ((Vec3i)object).func_177958_n(), ((Vec3i)object).func_177956_o(), ((Vec3i)object).func_177952_p(), SoundEvents.field_226132_ag_, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return this.field_145850_b.func_217376_c(\u26033);
        }
        return false;
    }

    private boolean func_226975_x_() {
        return this.field_226959_b_ != null;
    }

    private void func_226976_y_() {
        Iterator<Bee> iterator = this.field_226958_a_.iterator();
        BlockState \u26032 = this.func_195044_w();
        while (iterator.hasNext()) {
            Bee bee = iterator.next();
            if (bee.field_226978_b_ > bee.field_226979_c_) {
                State state = (\u2603 = bee.field_226977_a_).func_74767_n("HasNectar") ? State.HONEY_DELIVERED : State.BEE_RELEASED;
                if (!this.func_226967_a_(\u26032, \u2603, null, state)) continue;
                iterator.remove();
                continue;
            }
            bee.field_226978_b_++;
        }
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.func_226976_y_();
        BlockPos blockPos = this.func_174877_v();
        if (this.field_226958_a_.size() > 0 && this.field_145850_b.func_201674_k().nextDouble() < 0.005) {
            double d = (double)blockPos.func_177958_n() + 0.5;
            \u2603 = blockPos.func_177956_o();
            \u2603 = (double)blockPos.func_177952_p() + 0.5;
            this.field_145850_b.func_184148_a(null, d, \u2603, \u2603, SoundEvents.field_226134_ai_, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        this.func_226973_l_();
    }

    @Override
    public void func_145839_a(CompoundNBT compoundNBT) {
        super.func_145839_a(compoundNBT);
        this.field_226958_a_.clear();
        ListNBT listNBT = compoundNBT.func_150295_c("Bees", 10);
        for (int i = 0; i < listNBT.size(); ++i) {
            CompoundNBT compoundNBT2 = listNBT.func_150305_b(i);
            Bee \u26032 = new Bee(compoundNBT2.func_74775_l("EntityData"), compoundNBT2.func_74762_e("TicksInHive"), compoundNBT2.func_74762_e("MinOccupationTicks"));
            this.field_226958_a_.add(\u26032);
        }
        this.field_226959_b_ = null;
        if (compoundNBT.func_74764_b("FlowerPos")) {
            this.field_226959_b_ = NBTUtil.func_186861_c(compoundNBT.func_74775_l("FlowerPos"));
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compoundNBT) {
        super.func_189515_b(compoundNBT);
        compoundNBT.func_218657_a("Bees", this.func_226974_m_());
        if (this.func_226975_x_()) {
            compoundNBT.func_218657_a("FlowerPos", NBTUtil.func_186859_a(this.field_226959_b_));
        }
        return compoundNBT;
    }

    public ListNBT func_226974_m_() {
        ListNBT listNBT = new ListNBT();
        for (Bee bee : this.field_226958_a_) {
            bee.field_226977_a_.func_229681_c_("UUID");
            CompoundNBT compoundNBT = new CompoundNBT();
            compoundNBT.func_218657_a("EntityData", bee.field_226977_a_);
            compoundNBT.func_74768_a("TicksInHive", bee.field_226978_b_);
            compoundNBT.func_74768_a("MinOccupationTicks", bee.field_226979_c_);
            listNBT.add(compoundNBT);
        }
        return listNBT;
    }

    static class Bee {
        private final CompoundNBT field_226977_a_;
        private int field_226978_b_;
        private final int field_226979_c_;

        private Bee(CompoundNBT compoundNBT, int n, int n2) {
            compoundNBT.func_229681_c_("UUID");
            this.field_226977_a_ = compoundNBT;
            this.field_226978_b_ = n;
            this.field_226979_c_ = n2;
        }
    }

    public static enum State {
        HONEY_DELIVERED,
        BEE_RELEASED,
        EMERGENCY;

    }
}

