/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Comparator;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.network.play.server.SEntityStatusPacket;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GameRules {
    private static final Logger field_223622_y = LogManager.getLogger();
    private static final Map<RuleKey<?>, RuleType<?>> field_223623_z = Maps.newTreeMap(Comparator.comparing(ruleKey -> RuleKey.func_223577_a(ruleKey)));
    public static final RuleKey<BooleanValue> field_223598_a = GameRules.func_223595_a("doFireTick", BooleanValue.func_223571_a(true));
    public static final RuleKey<BooleanValue> field_223599_b = GameRules.func_223595_a("mobGriefing", BooleanValue.func_223571_a(true));
    public static final RuleKey<BooleanValue> field_223600_c = GameRules.func_223595_a("keepInventory", BooleanValue.func_223571_a(false));
    public static final RuleKey<BooleanValue> field_223601_d = GameRules.func_223595_a("doMobSpawning", BooleanValue.func_223571_a(true));
    public static final RuleKey<BooleanValue> field_223602_e = GameRules.func_223595_a("doMobLoot", BooleanValue.func_223571_a(true));
    public static final RuleKey<BooleanValue> field_223603_f = GameRules.func_223595_a("doTileDrops", BooleanValue.func_223571_a(true));
    public static final RuleKey<BooleanValue> field_223604_g = GameRules.func_223595_a("doEntityDrops", BooleanValue.func_223571_a(true));
    public static final RuleKey<BooleanValue> field_223605_h = GameRules.func_223595_a("commandBlockOutput", BooleanValue.func_223571_a(true));
    public static final RuleKey<BooleanValue> field_223606_i = GameRules.func_223595_a("naturalRegeneration", BooleanValue.func_223571_a(true));
    public static final RuleKey<BooleanValue> field_223607_j = GameRules.func_223595_a("doDaylightCycle", BooleanValue.func_223571_a(true));
    public static final RuleKey<BooleanValue> field_223608_k = GameRules.func_223595_a("logAdminCommands", BooleanValue.func_223571_a(true));
    public static final RuleKey<BooleanValue> field_223609_l = GameRules.func_223595_a("showDeathMessages", BooleanValue.func_223571_a(true));
    public static final RuleKey<IntegerValue> field_223610_m = GameRules.func_223595_a("randomTickSpeed", IntegerValue.func_223562_a(3));
    public static final RuleKey<BooleanValue> field_223611_n = GameRules.func_223595_a("sendCommandFeedback", BooleanValue.func_223571_a(true));
    public static final RuleKey<BooleanValue> field_223612_o = GameRules.func_223595_a("reducedDebugInfo", BooleanValue.func_223573_a(false, (minecraftServer, booleanValue) -> {
        byte by = booleanValue.func_223572_a() ? (byte)22 : (byte)23;
        for (ServerPlayerEntity serverPlayerEntity : minecraftServer.func_184103_al().func_181057_v()) {
            serverPlayerEntity.field_71135_a.func_147359_a(new SEntityStatusPacket(serverPlayerEntity, by));
        }
    }));
    public static final RuleKey<BooleanValue> field_223613_p = GameRules.func_223595_a("spectatorsGenerateChunks", BooleanValue.func_223571_a(true));
    public static final RuleKey<IntegerValue> field_223614_q = GameRules.func_223595_a("spawnRadius", IntegerValue.func_223562_a(10));
    public static final RuleKey<BooleanValue> field_223615_r = GameRules.func_223595_a("disableElytraMovementCheck", BooleanValue.func_223571_a(false));
    public static final RuleKey<IntegerValue> field_223616_s = GameRules.func_223595_a("maxEntityCramming", IntegerValue.func_223562_a(24));
    public static final RuleKey<BooleanValue> field_223617_t = GameRules.func_223595_a("doWeatherCycle", BooleanValue.func_223571_a(true));
    public static final RuleKey<BooleanValue> field_223618_u = GameRules.func_223595_a("doLimitedCrafting", BooleanValue.func_223571_a(false));
    public static final RuleKey<IntegerValue> field_223619_v = GameRules.func_223595_a("maxCommandChainLength", IntegerValue.func_223562_a(65536));
    public static final RuleKey<BooleanValue> field_223620_w = GameRules.func_223595_a("announceAdvancements", BooleanValue.func_223571_a(true));
    public static final RuleKey<BooleanValue> field_223621_x = GameRules.func_223595_a("disableRaids", BooleanValue.func_223571_a(false));
    public static final RuleKey<BooleanValue> field_226682_y_ = GameRules.func_223595_a("doInsomnia", BooleanValue.func_223571_a(true));
    public static final RuleKey<BooleanValue> field_226683_z_ = GameRules.func_223595_a("doImmediateRespawn", BooleanValue.func_223573_a(false, (minecraftServer, booleanValue) -> {
        for (ServerPlayerEntity serverPlayerEntity : minecraftServer.func_184103_al().func_181057_v()) {
            serverPlayerEntity.field_71135_a.func_147359_a(new SChangeGameStatePacket(11, booleanValue.func_223572_a() ? 1.0f : 0.0f));
        }
    }));
    public static final RuleKey<BooleanValue> field_226679_A_ = GameRules.func_223595_a("drowningDamage", BooleanValue.func_223571_a(true));
    public static final RuleKey<BooleanValue> field_226680_B_ = GameRules.func_223595_a("fallDamage", BooleanValue.func_223571_a(true));
    public static final RuleKey<BooleanValue> field_226681_C_ = GameRules.func_223595_a("fireDamage", BooleanValue.func_223571_a(true));
    private final Map<RuleKey<?>, RuleValue<?>> field_82771_a = (Map)field_223623_z.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((RuleType)entry.getValue()).func_223579_a()));

    private static <T extends RuleValue<T>> RuleKey<T> func_223595_a(String string, RuleType<T> ruleType) {
        RuleKey ruleKey = new RuleKey(string);
        RuleType<T> \u26032 = field_223623_z.put(ruleKey, ruleType);
        if (\u26032 != null) {
            throw new IllegalStateException("Duplicate game rule registration for " + string);
        }
        return ruleKey;
    }

    public <T extends RuleValue<T>> T func_223585_a(RuleKey<T> ruleKey) {
        return (T)this.field_82771_a.get(ruleKey);
    }

    public CompoundNBT func_82770_a() {
        CompoundNBT compoundNBT = new CompoundNBT();
        this.field_82771_a.forEach((ruleKey, ruleValue) -> compoundNBT.func_74778_a(((RuleKey)ruleKey).field_223578_a, ruleValue.func_223552_b()));
        return compoundNBT;
    }

    public void func_82768_a(CompoundNBT compoundNBT) {
        this.field_82771_a.forEach((ruleKey, ruleValue) -> {
            if (compoundNBT.func_74764_b(((RuleKey)ruleKey).field_223578_a)) {
                ruleValue.func_223553_a(compoundNBT.func_74779_i(((RuleKey)ruleKey).field_223578_a));
            }
        });
    }

    public static void func_223590_a(IRuleEntryVisitor iRuleEntryVisitor) {
        field_223623_z.forEach((ruleKey, ruleType) -> GameRules.func_223596_a(iRuleEntryVisitor, ruleKey, ruleType));
    }

    private static <T extends RuleValue<T>> void func_223596_a(IRuleEntryVisitor iRuleEntryVisitor, RuleKey<?> ruleKey, RuleType<?> ruleType) {
        RuleKey<?> ruleKey2 = ruleKey;
        RuleType<?> \u26032 = ruleType;
        iRuleEntryVisitor.func_223481_a(ruleKey2, \u26032);
    }

    public boolean func_223586_b(RuleKey<BooleanValue> ruleKey) {
        return this.func_223585_a(ruleKey).func_223572_a();
    }

    public int func_223592_c(RuleKey<IntegerValue> ruleKey) {
        return this.func_223585_a(ruleKey).func_223560_a();
    }

    public static class BooleanValue
    extends RuleValue<BooleanValue> {
        private boolean field_223575_a;

        private static RuleType<BooleanValue> func_223567_b(boolean bl, BiConsumer<MinecraftServer, BooleanValue> biConsumer) {
            return new RuleType<BooleanValue>(BoolArgumentType::bool, ruleType -> new BooleanValue((RuleType<BooleanValue>)ruleType, bl), biConsumer);
        }

        private static RuleType<BooleanValue> func_223568_b(boolean bl) {
            return BooleanValue.func_223567_b(bl, (minecraftServer, booleanValue) -> {});
        }

        public BooleanValue(RuleType<BooleanValue> ruleType, boolean bl) {
            super(ruleType);
            this.field_223575_a = bl;
        }

        @Override
        protected void func_223555_a(CommandContext<CommandSource> commandContext, String string) {
            this.field_223575_a = BoolArgumentType.getBool(commandContext, (String)string);
        }

        public boolean func_223572_a() {
            return this.field_223575_a;
        }

        public void func_223570_a(boolean bl, @Nullable MinecraftServer minecraftServer) {
            this.field_223575_a = bl;
            this.func_223556_a(minecraftServer);
        }

        @Override
        protected String func_223552_b() {
            return Boolean.toString(this.field_223575_a);
        }

        @Override
        protected void func_223553_a(String string) {
            this.field_223575_a = Boolean.parseBoolean(string);
        }

        @Override
        public int func_223557_c() {
            return this.field_223575_a ? 1 : 0;
        }

        @Override
        protected BooleanValue func_223213_e_() {
            return this;
        }

        @Override
        protected /* synthetic */ RuleValue func_223213_e_() {
            return this.func_223213_e_();
        }

        static /* synthetic */ RuleType func_223571_a(boolean bl) {
            return BooleanValue.func_223568_b(bl);
        }

        static /* synthetic */ RuleType func_223573_a(boolean bl, BiConsumer biConsumer) {
            return BooleanValue.func_223567_b(bl, biConsumer);
        }
    }

    public static class IntegerValue
    extends RuleValue<IntegerValue> {
        private int field_223566_a;

        private static RuleType<IntegerValue> func_223564_a(int n, BiConsumer<MinecraftServer, IntegerValue> biConsumer) {
            return new RuleType<IntegerValue>(IntegerArgumentType::integer, ruleType -> new IntegerValue((RuleType<IntegerValue>)ruleType, n), biConsumer);
        }

        private static RuleType<IntegerValue> func_223559_b(int n) {
            return IntegerValue.func_223564_a(n, (minecraftServer, integerValue) -> {});
        }

        public IntegerValue(RuleType<IntegerValue> ruleType, int n) {
            super(ruleType);
            this.field_223566_a = n;
        }

        @Override
        protected void func_223555_a(CommandContext<CommandSource> commandContext, String string) {
            this.field_223566_a = IntegerArgumentType.getInteger(commandContext, (String)string);
        }

        public int func_223560_a() {
            return this.field_223566_a;
        }

        @Override
        protected String func_223552_b() {
            return Integer.toString(this.field_223566_a);
        }

        @Override
        protected void func_223553_a(String string) {
            this.field_223566_a = IntegerValue.func_223563_b(string);
        }

        private static int func_223563_b(String string) {
            if (!string.isEmpty()) {
                try {
                    return Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    field_223622_y.warn("Failed to parse integer {}", (Object)string);
                }
            }
            return 0;
        }

        @Override
        public int func_223557_c() {
            return this.field_223566_a;
        }

        @Override
        protected IntegerValue func_223213_e_() {
            return this;
        }

        @Override
        protected /* synthetic */ RuleValue func_223213_e_() {
            return this.func_223213_e_();
        }

        static /* synthetic */ RuleType func_223562_a(int n) {
            return IntegerValue.func_223559_b(n);
        }
    }

    public static abstract class RuleValue<T extends RuleValue<T>> {
        private final RuleType<T> field_223558_a;

        public RuleValue(RuleType<T> ruleType) {
            this.field_223558_a = ruleType;
        }

        protected abstract void func_223555_a(CommandContext<CommandSource> var1, String var2);

        public void func_223554_b(CommandContext<CommandSource> commandContext, String string) {
            this.func_223555_a(commandContext, string);
            this.func_223556_a(((CommandSource)commandContext.getSource()).func_197028_i());
        }

        protected void func_223556_a(@Nullable MinecraftServer minecraftServer) {
            if (minecraftServer != null) {
                ((RuleType)this.field_223558_a).field_223584_c.accept(minecraftServer, this.func_223213_e_());
            }
        }

        protected abstract void func_223553_a(String var1);

        protected abstract String func_223552_b();

        public String toString() {
            return this.func_223552_b();
        }

        public abstract int func_223557_c();

        protected abstract T func_223213_e_();
    }

    public static class RuleType<T extends RuleValue<T>> {
        private final Supplier<ArgumentType<?>> field_223582_a;
        private final Function<RuleType<T>, T> field_223583_b;
        private final BiConsumer<MinecraftServer, T> field_223584_c;

        private RuleType(Supplier<ArgumentType<?>> supplier, Function<RuleType<T>, T> function, BiConsumer<MinecraftServer, T> biConsumer) {
            this.field_223582_a = supplier;
            this.field_223583_b = function;
            this.field_223584_c = biConsumer;
        }

        public RequiredArgumentBuilder<CommandSource, ?> func_223581_a(String string) {
            return Commands.func_197056_a(string, this.field_223582_a.get());
        }

        public T func_223579_a() {
            return (T)((RuleValue)this.field_223583_b.apply(this));
        }
    }

    public static final class RuleKey<T extends RuleValue<T>> {
        private final String field_223578_a;

        public RuleKey(String string) {
            this.field_223578_a = string;
        }

        public String toString() {
            return this.field_223578_a;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            return object instanceof RuleKey && ((RuleKey)object).field_223578_a.equals(this.field_223578_a);
        }

        public int hashCode() {
            return this.field_223578_a.hashCode();
        }

        public String func_223576_a() {
            return this.field_223578_a;
        }
    }

    @FunctionalInterface
    public static interface IRuleEntryVisitor {
        public <T extends RuleValue<T>> void func_223481_a(RuleKey<T> var1, RuleType<T> var2);
    }
}

