/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Map;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.AlternativesLootEntry;
import net.minecraft.world.storage.loot.DynamicLootEntry;
import net.minecraft.world.storage.loot.EmptyLootEntry;
import net.minecraft.world.storage.loot.GroupLootEntry;
import net.minecraft.world.storage.loot.ItemLootEntry;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.ParentedLootEntry;
import net.minecraft.world.storage.loot.SequenceLootEntry;
import net.minecraft.world.storage.loot.TableLootEntry;
import net.minecraft.world.storage.loot.TagLootEntry;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import org.apache.commons.lang3.ArrayUtils;

public class LootEntryManager {
    private static final Map<ResourceLocation, LootEntry.Serializer<?>> field_216197_a = Maps.newHashMap();
    private static final Map<Class<?>, LootEntry.Serializer<?>> field_216198_b = Maps.newHashMap();

    private static void func_216194_a(LootEntry.Serializer<?> serializer) {
        field_216197_a.put(serializer.func_216182_a(), serializer);
        field_216198_b.put(serializer.func_216183_b(), serializer);
    }

    static {
        LootEntryManager.func_216194_a(ParentedLootEntry.func_216145_a(new ResourceLocation("alternatives"), AlternativesLootEntry.class, AlternativesLootEntry::new));
        LootEntryManager.func_216194_a(ParentedLootEntry.func_216145_a(new ResourceLocation("sequence"), SequenceLootEntry.class, SequenceLootEntry::new));
        LootEntryManager.func_216194_a(ParentedLootEntry.func_216145_a(new ResourceLocation("group"), GroupLootEntry.class, GroupLootEntry::new));
        LootEntryManager.func_216194_a(new EmptyLootEntry.Serializer());
        LootEntryManager.func_216194_a(new ItemLootEntry.Serializer());
        LootEntryManager.func_216194_a(new TableLootEntry.Serializer());
        LootEntryManager.func_216194_a(new DynamicLootEntry.Serializer());
        LootEntryManager.func_216194_a(new TagLootEntry.Serializer());
    }

    public static class Serializer
    implements JsonDeserializer<LootEntry>,
    JsonSerializer<LootEntry> {
        public LootEntry deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) {
            JsonObject jsonObject = JSONUtils.func_151210_l(jsonElement, "entry");
            ResourceLocation \u26032 = new ResourceLocation(JSONUtils.func_151200_h(jsonObject, "type"));
            LootEntry.Serializer \u26033 = (LootEntry.Serializer)field_216197_a.get(\u26032);
            if (\u26033 == null) {
                throw new JsonParseException("Unknown item type: " + \u26032);
            }
            ILootCondition[] \u26034 = JSONUtils.func_188177_a(jsonObject, "conditions", new ILootCondition[0], jsonDeserializationContext, ILootCondition[].class);
            return \u26033.func_212865_b_(jsonObject, jsonDeserializationContext, \u26034);
        }

        public JsonElement serialize(LootEntry lootEntry, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject jsonObject = new JsonObject();
            LootEntry.Serializer<LootEntry> \u26032 = Serializer.func_216193_a(lootEntry.getClass());
            jsonObject.addProperty("type", \u26032.func_216182_a().toString());
            if (!ArrayUtils.isEmpty((Object[])lootEntry.field_216144_d)) {
                jsonObject.add("conditions", jsonSerializationContext.serialize((Object)lootEntry.field_216144_d));
            }
            \u26032.func_212830_a_(jsonObject, lootEntry, jsonSerializationContext);
            return jsonObject;
        }

        private static LootEntry.Serializer<LootEntry> func_216193_a(Class<?> clazz) {
            LootEntry.Serializer serializer = (LootEntry.Serializer)field_216198_b.get(clazz);
            if (serializer == null) {
                throw new JsonParseException("Unknown item type: " + clazz);
            }
            return serializer;
        }

        public /* synthetic */ JsonElement serialize(Object object, Type type, JsonSerializationContext jsonSerializationContext) {
            return this.serialize((LootEntry)object, type, jsonSerializationContext);
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }
}

