/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootFunction;
import net.minecraft.world.storage.loot.LootParameter;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.functions.ILootFunction;

public class LootingEnchantBonus
extends LootFunction {
    private final RandomValueRange field_186563_a;
    private final int field_189971_b;

    private LootingEnchantBonus(ILootCondition[] iLootConditionArray, RandomValueRange randomValueRange, int n) {
        super(iLootConditionArray);
        this.field_186563_a = randomValueRange;
        this.field_189971_b = n;
    }

    @Override
    public Set<LootParameter<?>> func_215855_a() {
        return ImmutableSet.of(LootParameters.field_216284_d);
    }

    private boolean func_215917_b() {
        return this.field_189971_b > 0;
    }

    @Override
    public ItemStack func_215859_a(ItemStack itemStack, LootContext lootContext) {
        Entity entity = lootContext.func_216031_c(LootParameters.field_216284_d);
        if (entity instanceof LivingEntity) {
            int n = EnchantmentHelper.func_185283_h((LivingEntity)entity);
            if (n == 0) {
                return itemStack;
            }
            float \u26032 = (float)n * this.field_186563_a.func_186507_b(lootContext.func_216032_b());
            itemStack.func_190917_f(Math.round(\u26032));
            if (this.func_215917_b() && itemStack.func_190916_E() > this.field_189971_b) {
                itemStack.func_190920_e(this.field_189971_b);
            }
        }
        return itemStack;
    }

    public static Builder func_215915_a(RandomValueRange randomValueRange) {
        return new Builder(randomValueRange);
    }

    public static class Serializer
    extends LootFunction.Serializer<LootingEnchantBonus> {
        protected Serializer() {
            super(new ResourceLocation("looting_enchant"), LootingEnchantBonus.class);
        }

        @Override
        public void func_186532_a(JsonObject jsonObject, LootingEnchantBonus lootingEnchantBonus, JsonSerializationContext jsonSerializationContext) {
            super.func_186532_a(jsonObject, lootingEnchantBonus, jsonSerializationContext);
            jsonObject.add("count", jsonSerializationContext.serialize((Object)lootingEnchantBonus.field_186563_a));
            if (lootingEnchantBonus.func_215917_b()) {
                jsonObject.add("limit", jsonSerializationContext.serialize((Object)lootingEnchantBonus.field_189971_b));
            }
        }

        @Override
        public LootingEnchantBonus func_186530_b(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, ILootCondition[] iLootConditionArray) {
            int n = JSONUtils.func_151208_a(jsonObject, "limit", 0);
            return new LootingEnchantBonus(iLootConditionArray, JSONUtils.func_188174_a(jsonObject, "count", jsonDeserializationContext, RandomValueRange.class), n);
        }

        @Override
        public /* synthetic */ LootFunction func_186530_b(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, ILootCondition[] iLootConditionArray) {
            return this.func_186530_b(jsonObject, jsonDeserializationContext, iLootConditionArray);
        }
    }

    public static class Builder
    extends LootFunction.Builder<Builder> {
        private final RandomValueRange field_216073_a;
        private int field_216074_b = 0;

        public Builder(RandomValueRange randomValueRange) {
            this.field_216073_a = randomValueRange;
        }

        @Override
        protected Builder func_212826_d_() {
            return this;
        }

        public Builder func_216072_a(int n) {
            this.field_216074_b = n;
            return this;
        }

        @Override
        public ILootFunction func_216052_b() {
            return new LootingEnchantBonus(this.func_216053_g(), this.field_216073_a, this.field_216074_b);
        }

        @Override
        protected /* synthetic */ LootFunction.Builder func_212826_d_() {
            return this.func_212826_d_();
        }
    }
}

