/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.RedstoneDiodeBlock;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.ComparatorMode;
import net.minecraft.tileentity.ComparatorTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.TickPriority;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ComparatorBlock
extends RedstoneDiodeBlock
implements ITileEntityProvider {
    public static final EnumProperty<ComparatorMode> field_176463_b = BlockStateProperties.field_208141_ap;

    public ComparatorBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_185512_D, (Comparable)((Object)Direction.NORTH)))).func_206870_a((IProperty)field_196348_c, Boolean.valueOf(false)))).func_206870_a((IProperty)field_176463_b, (Comparable)ComparatorMode.COMPARE)));
    }

    @Override
    protected int func_196346_i(BlockState p_196346_1_) {
        return 2;
    }

    @Override
    protected int func_176408_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity instanceof ComparatorTileEntity ? ((ComparatorTileEntity)tileentity).func_145996_a() : 0;
    }

    private int func_176460_j(World worldIn, BlockPos pos, BlockState state) {
        return state.func_177229_b((IProperty)field_176463_b) == ComparatorMode.SUBTRACT ? Math.max(this.func_176397_f(worldIn, pos, state) - this.func_176407_c(worldIn, pos, state), 0) : this.func_176397_f(worldIn, pos, state);
    }

    @Override
    protected boolean func_176404_e(World worldIn, BlockPos pos, BlockState state) {
        int i = this.func_176397_f(worldIn, pos, state);
        if (i == 0) {
            return false;
        }
        int j = this.func_176407_c(worldIn, pos, state);
        if (i > j) {
            return true;
        }
        return i == j && state.func_177229_b((IProperty)field_176463_b) == ComparatorMode.COMPARE;
    }

    @Override
    protected int func_176397_f(World worldIn, BlockPos pos, BlockState state) {
        int i = super.func_176397_f(worldIn, pos, state);
        Direction direction = (Direction)((Object)state.func_177229_b((IProperty)field_185512_D));
        BlockPos blockpos = pos.func_177972_a(direction);
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        if (blockstate.func_185912_n()) {
            i = blockstate.func_185888_a(worldIn, blockpos);
        } else if (i < 15 && blockstate.func_215686_e((IBlockReader)((Object)worldIn), blockpos)) {
            ItemFrameEntity itemframeentity;
            blockstate = worldIn.func_180495_p(blockpos = blockpos.func_177972_a(direction));
            if (blockstate.func_185912_n()) {
                i = blockstate.func_185888_a(worldIn, blockpos);
            } else if (blockstate.isAir((IBlockReader)((Object)worldIn), blockpos) && (itemframeentity = this.func_176461_a(worldIn, direction, blockpos)) != null) {
                i = itemframeentity.func_174866_q();
            }
        }
        return i;
    }

    @Nullable
    private ItemFrameEntity func_176461_a(World worldIn, Direction facing, BlockPos pos) {
        List<ItemFrameEntity> list = worldIn.func_175647_a(ItemFrameEntity.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1)), p_210304_1_ -> p_210304_1_ != null && p_210304_1_.func_174811_aO() == facing);
        return list.size() == 1 ? list.get(0) : null;
    }

    public ActionResultType func_225533_a_(BlockState p_225533_1_, World p_225533_2_, BlockPos p_225533_3_, PlayerEntity p_225533_4_, Hand p_225533_5_, BlockRayTraceResult p_225533_6_) {
        if (!p_225533_4_.field_71075_bZ.field_75099_e) {
            return ActionResultType.PASS;
        }
        float f = (p_225533_1_ = (BlockState)((Object)p_225533_1_.func_177231_a((IProperty)field_176463_b))).func_177229_b((IProperty)field_176463_b) == ComparatorMode.SUBTRACT ? 0.55f : 0.5f;
        p_225533_2_.func_184133_a(p_225533_4_, p_225533_3_, SoundEvents.field_187556_aj, SoundCategory.BLOCKS, 0.3f, f);
        p_225533_2_.func_180501_a(p_225533_3_, p_225533_1_, 2);
        this.func_176462_k(p_225533_2_, p_225533_3_, p_225533_1_);
        return ActionResultType.SUCCESS;
    }

    @Override
    protected void func_176398_g(World worldIn, BlockPos pos, BlockState state) {
        if (!worldIn.func_205220_G_().func_205361_b(pos, (Object)this)) {
            int j;
            int i = this.func_176460_j(worldIn, pos, state);
            TileEntity tileentity = worldIn.func_175625_s(pos);
            int n = j = tileentity instanceof ComparatorTileEntity ? ((ComparatorTileEntity)tileentity).func_145996_a() : 0;
            if (i != j || ((Boolean)state.func_177229_b((IProperty)field_196348_c)).booleanValue() != this.func_176404_e(worldIn, pos, state)) {
                TickPriority tickpriority = this.func_176402_i((IBlockReader)((Object)worldIn), pos, state) ? TickPriority.HIGH : TickPriority.NORMAL;
                worldIn.func_205220_G_().func_205362_a(pos, (Object)this, 2, tickpriority);
            }
        }
    }

    private void func_176462_k(World worldIn, BlockPos pos, BlockState state) {
        int i = this.func_176460_j(worldIn, pos, state);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        int j = 0;
        if (tileentity instanceof ComparatorTileEntity) {
            ComparatorTileEntity comparatortileentity = (ComparatorTileEntity)tileentity;
            j = comparatortileentity.func_145996_a();
            comparatortileentity.func_145995_a(i);
        }
        if (j != i || state.func_177229_b((IProperty)field_176463_b) == ComparatorMode.COMPARE) {
            boolean flag1 = this.func_176404_e(worldIn, pos, state);
            boolean flag = (Boolean)state.func_177229_b((IProperty)field_196348_c);
            if (flag && !flag1) {
                worldIn.func_180501_a(pos, (BlockState)((Object)state.func_206870_a((IProperty)field_196348_c, Boolean.valueOf(false))), 2);
            } else if (!flag && flag1) {
                worldIn.func_180501_a(pos, (BlockState)((Object)state.func_206870_a((IProperty)field_196348_c, Boolean.valueOf(true))), 2);
            }
            this.func_176400_h(worldIn, pos, state);
        }
    }

    @Override
    public void func_225534_a_(BlockState p_225534_1_, ServerWorld p_225534_2_, BlockPos p_225534_3_, Random p_225534_4_) {
        this.func_176462_k(p_225534_2_, p_225534_3_, p_225534_1_);
    }

    public boolean func_189539_a(BlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity != null && tileentity.func_145842_c(id, param);
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new ComparatorTileEntity();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_185512_D, field_176463_b, field_196348_c});
    }

    public boolean getWeakChanges(BlockState state, IWorldReader world, BlockPos pos) {
        return true;
    }

    public void onNeighborChange(BlockState state, IWorldReader world, BlockPos pos, BlockPos neighbor) {
        if (pos.func_177956_o() == neighbor.func_177956_o() && world instanceof World && !((World)world).func_201670_d()) {
            state.func_215697_a((World)world, pos, world.func_180495_p(neighbor).func_177230_c(), neighbor, false);
        }
    }
}

