/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.color;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.block.ShearableDoublePlantBlock;
import net.minecraft.block.StemBlock;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.FoliageColors;
import net.minecraft.world.GrassColors;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ILightReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.registries.IRegistryDelegate;

@OnlyIn(value=Dist.CLIENT)
public class BlockColors {
    private final Map<IRegistryDelegate<Block>, IBlockColor> field_186725_a = new HashMap<IRegistryDelegate<Block>, IBlockColor>();
    private final Map<Block, Set<IProperty<?>>> field_225311_b = Maps.newHashMap();

    public static BlockColors func_186723_a() {
        BlockColors blockcolors = new BlockColors();
        blockcolors.func_186722_a((p_228065_0_, p_228065_1_, p_228065_2_, p_228065_3_) -> p_228065_1_ != null && p_228065_2_ != null ? BiomeColors.func_228358_a_((ILightReader)p_228065_1_, (BlockPos)(p_228065_0_.func_177229_b((IProperty)ShearableDoublePlantBlock.field_208063_b) == DoubleBlockHalf.UPPER ? p_228065_2_.func_177977_b() : p_228065_2_)) : -1, Blocks.field_196805_gi, Blocks.field_196804_gh);
        blockcolors.func_225308_a((IProperty<?>)ShearableDoublePlantBlock.field_208063_b, Blocks.field_196805_gi, Blocks.field_196804_gh);
        blockcolors.func_186722_a((p_228064_0_, p_228064_1_, p_228064_2_, p_228064_3_) -> p_228064_1_ != null && p_228064_2_ != null ? BiomeColors.func_228358_a_((ILightReader)p_228064_1_, (BlockPos)p_228064_2_) : GrassColors.func_77480_a((double)0.5, (double)1.0), Blocks.field_196658_i, Blocks.field_196554_aH, Blocks.field_150349_c, Blocks.field_196683_eB);
        blockcolors.func_186722_a((p_228063_0_, p_228063_1_, p_228063_2_, p_228063_3_) -> FoliageColors.func_77466_a(), Blocks.field_196645_X);
        blockcolors.func_186722_a((p_228062_0_, p_228062_1_, p_228062_2_, p_228062_3_) -> FoliageColors.func_77469_b(), Blocks.field_196647_Y);
        blockcolors.func_186722_a((p_228061_0_, p_228061_1_, p_228061_2_, p_228061_3_) -> p_228061_1_ != null && p_228061_2_ != null ? BiomeColors.func_228361_b_((ILightReader)p_228061_1_, (BlockPos)p_228061_2_) : FoliageColors.func_77468_c(), Blocks.field_196642_W, Blocks.field_196648_Z, Blocks.field_196572_aa, Blocks.field_196574_ab, Blocks.field_150395_bd);
        blockcolors.func_186722_a((p_228060_0_, p_228060_1_, p_228060_2_, p_228060_3_) -> p_228060_1_ != null && p_228060_2_ != null ? BiomeColors.func_228363_c_((ILightReader)p_228060_1_, (BlockPos)p_228060_2_) : -1, Blocks.field_150355_j, Blocks.field_203203_C, Blocks.field_150383_bp);
        blockcolors.func_186722_a((p_228059_0_, p_228059_1_, p_228059_2_, p_228059_3_) -> RedstoneWireBlock.func_176337_b((Integer)p_228059_0_.func_177229_b((IProperty)RedstoneWireBlock.field_176351_O)), Blocks.field_150488_af);
        blockcolors.func_225308_a((IProperty<?>)RedstoneWireBlock.field_176351_O, Blocks.field_150488_af);
        blockcolors.func_186722_a((p_228058_0_, p_228058_1_, p_228058_2_, p_228058_3_) -> p_228058_1_ != null && p_228058_2_ != null ? BiomeColors.func_228358_a_((ILightReader)p_228058_1_, (BlockPos)p_228058_2_) : -1, Blocks.field_196608_cF);
        blockcolors.func_186722_a((p_228057_0_, p_228057_1_, p_228057_2_, p_228057_3_) -> 14731036, Blocks.field_196713_dt, Blocks.field_196711_ds);
        blockcolors.func_186722_a((p_228056_0_, p_228056_1_, p_228056_2_, p_228056_3_) -> {
            int i = (Integer)p_228056_0_.func_177229_b((IProperty)StemBlock.field_176484_a);
            int j = i * 32;
            int k = 255 - i * 8;
            int l = i * 4;
            return j << 16 | k << 8 | l;
        }, Blocks.field_150394_bc, Blocks.field_150393_bb);
        blockcolors.func_225308_a((IProperty<?>)StemBlock.field_176484_a, Blocks.field_150394_bc, Blocks.field_150393_bb);
        blockcolors.func_186722_a((p_228055_0_, p_228055_1_, p_228055_2_, p_228055_3_) -> p_228055_1_ != null && p_228055_2_ != null ? 2129968 : 7455580, Blocks.field_196651_dG);
        ForgeHooksClient.onBlockColorsInit((BlockColors)blockcolors);
        return blockcolors;
    }

    public int func_189991_a(BlockState state, World p_189991_2_, BlockPos p_189991_3_) {
        IBlockColor iblockcolor = this.field_186725_a.get(state.func_177230_c().delegate);
        if (iblockcolor != null) {
            return iblockcolor.getColor(state, (ILightReader)null, (BlockPos)null, 0);
        }
        MaterialColor materialcolor = state.func_185909_g((IBlockReader)((Object)p_189991_2_), p_189991_3_);
        return materialcolor != null ? materialcolor.field_76291_p : -1;
    }

    public int func_228054_a_(BlockState p_228054_1_, @Nullable ILightReader p_228054_2_, @Nullable BlockPos p_228054_3_, int p_228054_4_) {
        IBlockColor iblockcolor = this.field_186725_a.get(p_228054_1_.func_177230_c().delegate);
        return iblockcolor == null ? -1 : iblockcolor.getColor(p_228054_1_, p_228054_2_, p_228054_3_, p_228054_4_);
    }

    public void func_186722_a(IBlockColor blockColor, Block ... blocksIn) {
        for (Block block : blocksIn) {
            this.field_186725_a.put((IRegistryDelegate<Block>)block.delegate, blockColor);
        }
    }

    private void func_225309_a(Set<IProperty<?>> p_225309_1_, Block ... p_225309_2_) {
        for (Block block : p_225309_2_) {
            this.field_225311_b.put(block, p_225309_1_);
        }
    }

    private void func_225308_a(IProperty<?> p_225308_1_, Block ... p_225308_2_) {
        this.func_225309_a((Set<IProperty<?>>)ImmutableSet.of(p_225308_1_), p_225308_2_);
    }

    public Set<IProperty<?>> func_225310_a(Block p_225310_1_) {
        return (Set)this.field_225311_b.getOrDefault((Object)p_225310_1_, (Set<IProperty<?>>)ImmutableSet.of());
    }
}

