/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverride;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.texture.SpriteMap;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ItemOverrideList {
    public static final ItemOverrideList field_188022_a = new ItemOverrideList();
    private final List<ItemOverride> field_188023_b = Lists.newArrayList();
    private final List<IBakedModel> field_209582_c;

    protected ItemOverrideList() {
        this.field_209582_c = Collections.emptyList();
    }

    @Deprecated
    public ItemOverrideList(ModelBakery p_i50984_1_, BlockModel p_i50984_2_, Function<ResourceLocation, IUnbakedModel> p_i50984_3_, List<ItemOverride> p_i50984_4_) {
        this(p_i50984_1_, p_i50984_2_, p_i50984_3_, arg_0 -> ((SpriteMap)p_i50984_1_.getSpriteMap()).func_229151_a_(arg_0), p_i50984_4_);
    }

    public ItemOverrideList(ModelBakery p_i50984_1_, IUnbakedModel p_i50984_2_, Function<ResourceLocation, IUnbakedModel> p_i50984_3_, Function<Material, TextureAtlasSprite> textureGetter, List<ItemOverride> p_i50984_4_) {
        this.field_209582_c = p_i50984_4_.stream().map(p_217649_3_ -> {
            IUnbakedModel iunbakedmodel = (IUnbakedModel)p_i50984_3_.apply(p_217649_3_.func_188026_a());
            return Objects.equals(iunbakedmodel, p_i50984_2_) ? null : p_i50984_1_.getBakedModel(p_217649_3_.func_188026_a(), (IModelTransform)ModelRotation.X0_Y0, textureGetter);
        }).collect(Collectors.toList());
        Collections.reverse(this.field_209582_c);
        for (int i = p_i50984_4_.size() - 1; i >= 0; --i) {
            this.field_188023_b.add(p_i50984_4_.get(i));
        }
    }

    @Nullable
    public IBakedModel func_209581_a(IBakedModel model, ItemStack stack, @Nullable World worldIn, @Nullable LivingEntity entityIn) {
        if (!this.field_188023_b.isEmpty()) {
            for (int i = 0; i < this.field_188023_b.size(); ++i) {
                ItemOverride itemoverride = this.field_188023_b.get(i);
                if (!itemoverride.func_188027_a(stack, worldIn, entityIn)) continue;
                IBakedModel ibakedmodel = this.field_209582_c.get(i);
                if (ibakedmodel == null) {
                    return model;
                }
                return ibakedmodel;
            }
        }
        return model;
    }

    public ImmutableList<ItemOverride> getOverrides() {
        return ImmutableList.copyOf(this.field_188023_b);
    }
}

