/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.EnterBlockTrigger;
import net.minecraft.advancements.criterion.ImpossibleTrigger;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.CookingRecipeBuilder;
import net.minecraft.data.CustomRecipeBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.data.SingleItemRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.CookingRecipeSerializer;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecipeProvider
implements IDataProvider {
    private static final Logger field_200411_a = LogManager.getLogger();
    private static final Gson field_200412_b = new GsonBuilder().setPrettyPrinting().create();
    protected final DataGenerator field_200413_c;

    public RecipeProvider(DataGenerator generatorIn) {
        this.field_200413_c = generatorIn;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        Path path = this.field_200413_c.func_200391_b();
        HashSet set = Sets.newHashSet();
        this.func_200404_a(p_200410_4_ -> {
            if (!set.add(p_200410_4_.func_200442_b())) {
                throw new IllegalStateException("Duplicate recipe " + p_200410_4_.func_200442_b());
            }
            this.func_208311_a(cache, p_200410_4_.func_200441_a(), path.resolve("data/" + p_200410_4_.func_200442_b().func_110624_b() + "/recipes/" + p_200410_4_.func_200442_b().func_110623_a() + ".json"));
            JsonObject jsonobject = p_200410_4_.func_200440_c();
            if (jsonobject != null) {
                this.func_208310_b(cache, jsonobject, path.resolve("data/" + p_200410_4_.func_200442_b().func_110624_b() + "/advancements/" + p_200410_4_.func_200443_d().func_110623_a() + ".json"));
            }
        });
        if (this.getClass() == RecipeProvider.class) {
            this.func_208310_b(cache, Advancement.Builder.func_200278_a().func_200275_a("impossible", (ICriterionInstance)new ImpossibleTrigger.Instance()).func_200273_b(), path.resolve("data/minecraft/advancements/recipes/root.json"));
        }
    }

    private void func_208311_a(DirectoryCache cache, JsonObject recipeJson, Path pathIn) {
        try {
            String s = field_200412_b.toJson((JsonElement)recipeJson);
            String s1 = field_208307_a.hashUnencodedChars((CharSequence)s).toString();
            if (!Objects.equals(cache.func_208323_a(pathIn), s1) || !Files.exists(pathIn, new LinkOption[0])) {
                Files.createDirectories(pathIn.getParent(), new FileAttribute[0]);
                try (BufferedWriter bufferedwriter = Files.newBufferedWriter(pathIn, new OpenOption[0]);){
                    bufferedwriter.write(s);
                }
            }
            cache.func_208316_a(pathIn, s1);
        }
        catch (IOException ioexception) {
            field_200411_a.error("Couldn't save recipe {}", (Object)pathIn, (Object)ioexception);
        }
    }

    protected void func_208310_b(DirectoryCache cache, JsonObject advancementJson, Path pathIn) {
        try {
            String s = field_200412_b.toJson((JsonElement)advancementJson);
            String s1 = field_208307_a.hashUnencodedChars((CharSequence)s).toString();
            if (!Objects.equals(cache.func_208323_a(pathIn), s1) || !Files.exists(pathIn, new LinkOption[0])) {
                Files.createDirectories(pathIn.getParent(), new FileAttribute[0]);
                try (BufferedWriter bufferedwriter = Files.newBufferedWriter(pathIn, new OpenOption[0]);){
                    bufferedwriter.write(s);
                }
            }
            cache.func_208316_a(pathIn, s1);
        }
        catch (IOException ioexception) {
            field_200411_a.error("Couldn't save recipe advancement {}", (Object)pathIn, (Object)ioexception);
        }
    }

    /*
     * Opcode count of 15425 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196637_U, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196621_O).func_200472_a("##").func_200472_a("##").func_200473_b("bark").func_200465_a("has_log", (ICriterionInstance)this.func_200403_a(Blocks.field_196621_O)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_209393_af, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_203208_V).func_200472_a("##").func_200472_a("##").func_200473_b("bark").func_200465_a("has_log", (ICriterionInstance)this.func_200403_a(Blocks.field_203208_V)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_185153_aK).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196670_r).func_200472_a("# #").func_200472_a("###").func_200473_b("boat").func_200465_a("in_water", (ICriterionInstance)this.func_200407_a(Blocks.field_150355_j)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Blocks.field_196697_eJ).func_200487_b((IItemProvider)Blocks.field_196670_r).func_200490_a("wooden_button").func_200483_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196670_r)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_180410_as, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196670_r).func_200472_a("##").func_200472_a("##").func_200472_a("##").func_200473_b("wooden_door").func_200465_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196670_r)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_180405_aT, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('W'), (IItemProvider)Blocks.field_196670_r).func_200472_a("W#W").func_200472_a("W#W").func_200473_b("wooden_fence").func_200465_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196670_r)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_180387_bt).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('W'), (IItemProvider)Blocks.field_196670_r).func_200472_a("#W#").func_200472_a("#W#").func_200473_b("wooden_fence_gate").func_200465_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196670_r)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Blocks.field_196670_r, (int)4).func_203221_a(ItemTags.field_203297_q).func_200490_a("planks").func_200483_a("has_logs", (ICriterionInstance)this.func_200409_a(ItemTags.field_203297_q)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_196671_cu).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196670_r).func_200472_a("##").func_200473_b("wooden_pressure_plate").func_200465_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196670_r)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196632_bu, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196670_r).func_200472_a("###").func_200473_b("wooden_slab").func_200465_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196670_r)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_150400_ck, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196670_r).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200473_b("wooden_stairs").func_200465_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196670_r)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196682_da, (int)2).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196670_r).func_200472_a("###").func_200472_a("###").func_200473_b("wooden_trapdoor").func_200465_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196670_r)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_150408_cc, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150429_aA).func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151042_j).func_200472_a("XSX").func_200472_a("X#X").func_200472_a("XSX").func_200465_a("has_rail", (ICriterionInstance)this.func_200403_a(Blocks.field_150448_aq)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Blocks.field_196656_g, (int)2).func_200487_b((IItemProvider)Blocks.field_196654_e).func_200487_b((IItemProvider)Blocks.field_150347_e).func_200483_a("has_stone", (ICriterionInstance)this.func_200403_a(Blocks.field_196654_e)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150467_bQ).func_200462_a(Character.valueOf('I'), (IItemProvider)Blocks.field_150339_S).func_200462_a(Character.valueOf('i'), (IItemProvider)Items.field_151042_j).func_200472_a("III").func_200472_a(" i ").func_200472_a("iii").func_200465_a("has_iron_block", (ICriterionInstance)this.func_200403_a(Blocks.field_150339_S)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_179565_cj).func_200462_a(Character.valueOf('/'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('_'), (IItemProvider)Blocks.field_222401_hJ).func_200472_a("///").func_200472_a(" / ").func_200472_a("/_/").func_200465_a("has_stone_slab", (ICriterionInstance)this.func_200403_a(Blocks.field_222401_hJ)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Items.field_151032_g, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151145_ak).func_200462_a(Character.valueOf('Y'), (IItemProvider)Items.field_151008_G).func_200472_a("X").func_200472_a("#").func_200472_a("Y").func_200465_a("has_feather", (ICriterionInstance)this.func_200403_a(Items.field_151008_G)).func_200465_a("has_flint", (ICriterionInstance)this.func_200403_a(Items.field_151145_ak)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222422_lK, (int)1).func_200469_a(Character.valueOf('P'), ItemTags.field_199905_b).func_200469_a(Character.valueOf('S'), ItemTags.field_202899_i).func_200472_a("PSP").func_200472_a("P P").func_200472_a("PSP").func_200465_a("has_planks", (ICriterionInstance)this.func_200409_a(ItemTags.field_199905_b)).func_200465_a("has_wood_slab", (ICriterionInstance)this.func_200409_a(ItemTags.field_202899_i)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150461_bJ).func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_151156_bN).func_200462_a(Character.valueOf('G'), (IItemProvider)Blocks.field_150359_w).func_200462_a(Character.valueOf('O'), (IItemProvider)Blocks.field_150343_Z).func_200472_a("GGG").func_200472_a("GSG").func_200472_a("OOO").func_200465_a("has_nether_star", (ICriterionInstance)this.func_200403_a(Items.field_151156_bN)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_226906_mb_).func_200469_a(Character.valueOf('P'), ItemTags.field_199905_b).func_200462_a(Character.valueOf('H'), (IItemProvider)Items.field_226635_pU_).func_200472_a("PPP").func_200472_a("HHH").func_200472_a("PPP").func_200465_a("has_honeycomb", (ICriterionInstance)this.func_200403_a(Items.field_226635_pU_)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_185165_cW).func_200487_b((IItemProvider)Items.field_151054_z).func_200491_b((IItemProvider)Items.field_185164_cV, 6).func_200483_a("has_beetroot", (ICriterionInstance)this.func_200403_a(Items.field_185164_cV)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196631_S, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196619_M).func_200472_a("##").func_200472_a("##").func_200473_b("bark").func_200465_a("has_log", (ICriterionInstance)this.func_200403_a(Blocks.field_196619_M)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_209391_ad, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_203206_T).func_200472_a("##").func_200472_a("##").func_200473_b("bark").func_200465_a("has_log", (ICriterionInstance)this.func_200403_a(Blocks.field_203206_T)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_185151_aI).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196666_p).func_200472_a("# #").func_200472_a("###").func_200473_b("boat").func_200465_a("in_water", (ICriterionInstance)this.func_200407_a(Blocks.field_150355_j)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Blocks.field_196693_eH).func_200487_b((IItemProvider)Blocks.field_196666_p).func_200490_a("wooden_button").func_200483_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196666_p)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_180412_aq, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196666_p).func_200472_a("##").func_200472_a("##").func_200472_a("##").func_200473_b("wooden_door").func_200465_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196666_p)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_180404_aQ, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('W'), (IItemProvider)Blocks.field_196666_p).func_200472_a("W#W").func_200472_a("W#W").func_200473_b("wooden_fence").func_200465_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196666_p)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_180392_bq).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('W'), (IItemProvider)Blocks.field_196666_p).func_200472_a("#W#").func_200472_a("#W#").func_200473_b("wooden_fence_gate").func_200465_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196666_p)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Blocks.field_196666_p, (int)4).func_203221_a(ItemTags.field_203296_p).func_200490_a("planks").func_200483_a("has_log", (ICriterionInstance)this.func_200409_a(ItemTags.field_203296_p)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_196667_cs).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196666_p).func_200472_a("##").func_200473_b("wooden_pressure_plate").func_200465_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196666_p)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196627_bs, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196666_p).func_200472_a("###").func_200473_b("wooden_slab").func_200465_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196666_p)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_150487_bG, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196666_p).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200473_b("wooden_stairs").func_200465_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196666_p)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196641_cY, (int)2).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196666_p).func_200472_a("###").func_200472_a("###").func_200473_b("wooden_trapdoor").func_200465_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196666_p)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_196206_ev).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196602_ba).func_200462_a(Character.valueOf('|'), (IItemProvider)Items.field_151055_y).func_200472_a("###").func_200472_a("###").func_200472_a(" | ").func_200473_b("banner").func_200465_a("has_black_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196602_ba)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_196099_bJ).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196602_ba).func_200469_a(Character.valueOf('X'), ItemTags.field_199905_b).func_200472_a("###").func_200472_a("XXX").func_200473_b("bed").func_200465_a("has_black_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196602_ba)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_196099_bJ).func_200487_b((IItemProvider)Items.field_196140_bu).func_200487_b((IItemProvider)Items.field_222086_lz).func_200490_a("dyed_bed").func_200483_a("has_bed", (ICriterionInstance)this.func_200403_a(Items.field_196140_bu)).func_200484_a(consumer, "black_bed_from_white_bed");
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196753_fW, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196602_ba).func_200472_a("##").func_200473_b("carpet").func_200465_a("has_black_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196602_ba)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196753_fW, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196724_fH).func_200462_a(Character.valueOf('$'), (IItemProvider)Items.field_222086_lz).func_200472_a("###").func_200472_a("#$#").func_200472_a("###").func_200473_b("carpet").func_200465_a("has_white_carpet", (ICriterionInstance)this.func_200403_a(Blocks.field_196724_fH)).func_200465_a("has_black_dye", (ICriterionInstance)this.func_200403_a(Items.field_222086_lz)).func_200466_a(consumer, "black_carpet_from_white_carpet");
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Blocks.field_196884_jh, (int)8).func_200487_b((IItemProvider)Items.field_222086_lz).func_200491_b((IItemProvider)Blocks.field_150354_m, 4).func_200491_b((IItemProvider)Blocks.field_150351_n, 4).func_200490_a("concrete_powder").func_200483_a("has_sand", (ICriterionInstance)this.func_200403_a(Blocks.field_150354_m)).func_200483_a("has_gravel", (ICriterionInstance)this.func_200403_a(Blocks.field_150351_n)).func_200482_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_222086_lz).func_200487_b((IItemProvider)Items.field_196136_br).func_200490_a("black_dye").func_200483_a("has_ink_sac", (ICriterionInstance)this.func_200403_a(Items.field_196136_br)).func_200482_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_222086_lz).func_200487_b((IItemProvider)Blocks.field_222388_bz).func_200490_a("black_dye").func_200483_a("has_black_flower", (ICriterionInstance)this.func_200403_a(Blocks.field_222388_bz)).func_200484_a(consumer, "black_dye_from_wither_rose");
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196824_gy, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150359_w).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_222086_lz).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200473_b("stained_glass").func_200465_a("has_glass", (ICriterionInstance)this.func_200403_a(Blocks.field_150359_w)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196776_gO, (int)16).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196824_gy).func_200472_a("###").func_200472_a("###").func_200473_b("stained_glass_pane").func_200465_a("has_glass", (ICriterionInstance)this.func_200403_a(Blocks.field_150359_w)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196776_gO, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150410_aZ).func_200462_a(Character.valueOf('$'), (IItemProvider)Items.field_222086_lz).func_200472_a("###").func_200472_a("#$#").func_200472_a("###").func_200473_b("stained_glass_pane").func_200465_a("has_glass_pane", (ICriterionInstance)this.func_200403_a(Blocks.field_150410_aZ)).func_200465_a("has_black_dye", (ICriterionInstance)this.func_200403_a(Items.field_222086_lz)).func_200466_a(consumer, "black_stained_glass_pane_from_glass_pane");
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196722_fD, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150405_ch).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_222086_lz).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200473_b("stained_terracotta").func_200465_a("has_terracotta", (ICriterionInstance)this.func_200403_a(Blocks.field_150405_ch)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Blocks.field_196602_ba).func_200487_b((IItemProvider)Items.field_222086_lz).func_200487_b((IItemProvider)Blocks.field_196556_aL).func_200490_a("wool").func_200483_a("has_white_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196556_aL)).func_200482_a(consumer);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_151065_br, (int)2).func_200487_b((IItemProvider)Items.field_151072_bj).func_200483_a("has_blaze_rod", (ICriterionInstance)this.func_200403_a(Items.field_151072_bj)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_196202_er).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196567_aW).func_200462_a(Character.valueOf('|'), (IItemProvider)Items.field_151055_y).func_200472_a("###").func_200472_a("###").func_200472_a(" | ").func_200473_b("banner").func_200465_a("has_blue_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196567_aW)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_196095_bF).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196567_aW).func_200469_a(Character.valueOf('X'), ItemTags.field_199905_b).func_200472_a("###").func_200472_a("XXX").func_200473_b("bed").func_200465_a("has_blue_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196567_aW)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_196095_bF).func_200487_b((IItemProvider)Items.field_196140_bu).func_200487_b((IItemProvider)Items.field_222083_lx).func_200490_a("dyed_bed").func_200483_a("has_bed", (ICriterionInstance)this.func_200403_a(Items.field_196140_bu)).func_200484_a(consumer, "blue_bed_from_white_bed");
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196745_fS, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196567_aW).func_200472_a("##").func_200473_b("carpet").func_200465_a("has_blue_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196567_aW)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196745_fS, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196724_fH).func_200462_a(Character.valueOf('$'), (IItemProvider)Items.field_222083_lx).func_200472_a("###").func_200472_a("#$#").func_200472_a("###").func_200473_b("carpet").func_200465_a("has_white_carpet", (ICriterionInstance)this.func_200403_a(Blocks.field_196724_fH)).func_200465_a("has_blue_dye", (ICriterionInstance)this.func_200403_a(Items.field_222083_lx)).func_200466_a(consumer, "blue_carpet_from_white_carpet");
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Blocks.field_196880_jd, (int)8).func_200487_b((IItemProvider)Items.field_222083_lx).func_200491_b((IItemProvider)Blocks.field_150354_m, 4).func_200491_b((IItemProvider)Blocks.field_150351_n, 4).func_200490_a("concrete_powder").func_200483_a("has_sand", (ICriterionInstance)this.func_200403_a(Blocks.field_150354_m)).func_200483_a("has_gravel", (ICriterionInstance)this.func_200403_a(Blocks.field_150351_n)).func_200482_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_222083_lx).func_200487_b((IItemProvider)Items.field_196128_bn).func_200490_a("blue_dye").func_200483_a("has_lapis_lazuli", (ICriterionInstance)this.func_200403_a(Items.field_196128_bn)).func_200482_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_222083_lx).func_200487_b((IItemProvider)Blocks.field_222387_by).func_200490_a("blue_dye").func_200483_a("has_blue_flower", (ICriterionInstance)this.func_200403_a(Blocks.field_222387_by)).func_200484_a(consumer, "blue_dye_from_cornflower");
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_205164_gk).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150403_cj).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200465_a("has_packed_ice", (ICriterionInstance)this.func_200403_a(Blocks.field_150403_cj)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196820_gu, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150359_w).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_222083_lx).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200473_b("stained_glass").func_200465_a("has_glass", (ICriterionInstance)this.func_200403_a(Blocks.field_150359_w)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196771_gK, (int)16).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196820_gu).func_200472_a("###").func_200472_a("###").func_200473_b("stained_glass_pane").func_200465_a("has_glass", (ICriterionInstance)this.func_200403_a(Blocks.field_150359_w)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196771_gK, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150410_aZ).func_200462_a(Character.valueOf('$'), (IItemProvider)Items.field_222083_lx).func_200472_a("###").func_200472_a("#$#").func_200472_a("###").func_200473_b("stained_glass_pane").func_200465_a("has_glass_pane", (ICriterionInstance)this.func_200403_a(Blocks.field_150410_aZ)).func_200465_a("has_blue_dye", (ICriterionInstance)this.func_200403_a(Items.field_222083_lx)).func_200466_a(consumer, "blue_stained_glass_pane_from_glass_pane");
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196797_fz, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150405_ch).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_222083_lx).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200473_b("stained_terracotta").func_200465_a("has_terracotta", (ICriterionInstance)this.func_200403_a(Blocks.field_150405_ch)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Blocks.field_196567_aW).func_200487_b((IItemProvider)Items.field_222083_lx).func_200487_b((IItemProvider)Blocks.field_196556_aL).func_200490_a("wool").func_200483_a("has_white_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196556_aL)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151124_az).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196662_n).func_200472_a("# #").func_200472_a("###").func_200473_b("boat").func_200465_a("in_water", (ICriterionInstance)this.func_200407_a(Blocks.field_150355_j)).func_200464_a(consumer);
        Item item = Items.field_196106_bc;
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_189880_di).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_196106_bc).func_200472_a("XXX").func_200472_a("XXX").func_200472_a("XXX").func_200465_a("has_bonemeal", (ICriterionInstance)this.func_200403_a(item)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_196106_bc, (int)3).func_200487_b((IItemProvider)Items.field_151103_aS).func_200490_a("bonemeal").func_200483_a("has_bone", (ICriterionInstance)this.func_200403_a(Items.field_151103_aS)).func_200482_a(consumer);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_196106_bc, (int)9).func_200487_b((IItemProvider)Blocks.field_189880_di).func_200490_a("bonemeal").func_200483_a("has_bone_block", (ICriterionInstance)this.func_200403_a(Blocks.field_189880_di)).func_200484_a(consumer, "bone_meal_from_bone_block");
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_151122_aG).func_200491_b((IItemProvider)Items.field_151121_aF, 3).func_200487_b((IItemProvider)Items.field_151116_aA).func_200483_a("has_paper", (ICriterionInstance)this.func_200403_a(Items.field_151121_aF)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150342_X).func_200469_a(Character.valueOf('#'), ItemTags.field_199905_b).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151122_aG).func_200472_a("###").func_200472_a("XXX").func_200472_a("###").func_200465_a("has_book", (ICriterionInstance)this.func_200403_a(Items.field_151122_aG)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151031_f).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151007_F).func_200472_a(" #X").func_200472_a("# X").func_200472_a(" #X").func_200465_a("has_string", (ICriterionInstance)this.func_200403_a(Items.field_151007_F)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Items.field_151054_z, (int)4).func_200469_a(Character.valueOf('#'), ItemTags.field_199905_b).func_200472_a("# #").func_200472_a(" # ").func_200465_a("has_brown_mushroom", (ICriterionInstance)this.func_200403_a(Blocks.field_150338_P)).func_200465_a("has_red_mushroom", (ICriterionInstance)this.func_200403_a(Blocks.field_150337_Q)).func_200465_a("has_mushroom_stew", (ICriterionInstance)this.func_200403_a(Items.field_151009_A)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151025_P).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151015_O).func_200472_a("###").func_200465_a("has_wheat", (ICriterionInstance)this.func_200403_a(Items.field_151015_O)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150382_bo).func_200462_a(Character.valueOf('B'), (IItemProvider)Items.field_151072_bj).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150347_e).func_200472_a(" B ").func_200472_a("###").func_200465_a("has_blaze_rod", (ICriterionInstance)this.func_200403_a(Items.field_151072_bj)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_196584_bK).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151118_aC).func_200472_a("##").func_200472_a("##").func_200465_a("has_brick", (ICriterionInstance)this.func_200403_a(Items.field_151118_aC)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196571_bA, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196584_bK).func_200472_a("###").func_200465_a("has_brick_block", (ICriterionInstance)this.func_200403_a(Blocks.field_196584_bK)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_150389_bf, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196584_bK).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_brick_block", (ICriterionInstance)this.func_200403_a(Blocks.field_196584_bK)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_196203_es).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196568_aX).func_200462_a(Character.valueOf('|'), (IItemProvider)Items.field_151055_y).func_200472_a("###").func_200472_a("###").func_200472_a(" | ").func_200473_b("banner").func_200465_a("has_brown_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196568_aX)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_196096_bG).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196568_aX).func_200469_a(Character.valueOf('X'), ItemTags.field_199905_b).func_200472_a("###").func_200472_a("XXX").func_200473_b("bed").func_200465_a("has_brown_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196568_aX)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_196096_bG).func_200487_b((IItemProvider)Items.field_196140_bu).func_200487_b((IItemProvider)Items.field_222085_ly).func_200490_a("dyed_bed").func_200483_a("has_bed", (ICriterionInstance)this.func_200403_a(Items.field_196140_bu)).func_200484_a(consumer, "brown_bed_from_white_bed");
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196747_fT, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196568_aX).func_200472_a("##").func_200473_b("carpet").func_200465_a("has_brown_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196568_aX)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196747_fT, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196724_fH).func_200462_a(Character.valueOf('$'), (IItemProvider)Items.field_222085_ly).func_200472_a("###").func_200472_a("#$#").func_200472_a("###").func_200473_b("carpet").func_200465_a("has_white_carpet", (ICriterionInstance)this.func_200403_a(Blocks.field_196724_fH)).func_200465_a("has_brown_dye", (ICriterionInstance)this.func_200403_a(Items.field_222085_ly)).func_200466_a(consumer, "brown_carpet_from_white_carpet");
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Blocks.field_196881_je, (int)8).func_200487_b((IItemProvider)Items.field_222085_ly).func_200491_b((IItemProvider)Blocks.field_150354_m, 4).func_200491_b((IItemProvider)Blocks.field_150351_n, 4).func_200490_a("concrete_powder").func_200483_a("has_sand", (ICriterionInstance)this.func_200403_a(Blocks.field_150354_m)).func_200483_a("has_gravel", (ICriterionInstance)this.func_200403_a(Blocks.field_150351_n)).func_200482_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_222085_ly).func_200487_b((IItemProvider)Items.field_196130_bo).func_200490_a("brown_dye").func_200483_a("has_cocoa_beans", (ICriterionInstance)this.func_200403_a(Items.field_196130_bo)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196821_gv, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150359_w).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_222085_ly).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200473_b("stained_glass").func_200465_a("has_glass", (ICriterionInstance)this.func_200403_a(Blocks.field_150359_w)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196773_gL, (int)16).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196821_gv).func_200472_a("###").func_200472_a("###").func_200473_b("stained_glass_pane").func_200465_a("has_glass", (ICriterionInstance)this.func_200403_a(Blocks.field_150359_w)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196773_gL, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150410_aZ).func_200462_a(Character.valueOf('$'), (IItemProvider)Items.field_222085_ly).func_200472_a("###").func_200472_a("#$#").func_200472_a("###").func_200473_b("stained_glass_pane").func_200465_a("has_glass_pane", (ICriterionInstance)this.func_200403_a(Blocks.field_150410_aZ)).func_200465_a("has_brown_dye", (ICriterionInstance)this.func_200403_a(Items.field_222085_ly)).func_200466_a(consumer, "brown_stained_glass_pane_from_glass_pane");
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196719_fA, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150405_ch).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_222085_ly).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200473_b("stained_terracotta").func_200465_a("has_terracotta", (ICriterionInstance)this.func_200403_a(Blocks.field_150405_ch)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Blocks.field_196568_aX).func_200487_b((IItemProvider)Items.field_222085_ly).func_200487_b((IItemProvider)Blocks.field_196556_aL).func_200490_a("wool").func_200483_a("has_white_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196556_aL)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151133_ar).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151042_j).func_200472_a("# #").func_200472_a(" # ").func_200465_a("has_iron_ingot", (ICriterionInstance)this.func_200403_a(Items.field_151042_j)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150414_aQ).func_200462_a(Character.valueOf('A'), (IItemProvider)Items.field_151117_aB).func_200462_a(Character.valueOf('B'), (IItemProvider)Items.field_151102_aT).func_200462_a(Character.valueOf('C'), (IItemProvider)Items.field_151015_O).func_200462_a(Character.valueOf('E'), (IItemProvider)Items.field_151110_aK).func_200472_a("AAA").func_200472_a("BEB").func_200472_a("CCC").func_200465_a("has_egg", (ICriterionInstance)this.func_200403_a(Items.field_151110_aK)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_222433_lV).func_200469_a(Character.valueOf('L'), ItemTags.field_200038_h).func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_151055_y).func_200469_a(Character.valueOf('C'), ItemTags.field_219775_L).func_200472_a(" S ").func_200472_a("SCS").func_200472_a("LLL").func_200465_a("has_stick", (ICriterionInstance)this.func_200403_a(Items.field_151055_y)).func_200465_a("has_coal", (ICriterionInstance)this.func_200409_a(ItemTags.field_219775_L)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151146_bM).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151112_aM).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151172_bF).func_200472_a("# ").func_200472_a(" X").func_200465_a("has_carrot", (ICriterionInstance)this.func_200403_a(Items.field_151172_bF)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150383_bp).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151042_j).func_200472_a("# #").func_200472_a("# #").func_200472_a("###").func_200465_a("has_water_bucket", (ICriterionInstance)this.func_200403_a(Items.field_151131_as)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_222436_lZ).func_200469_a(Character.valueOf('#'), ItemTags.field_202899_i).func_200472_a("# #").func_200472_a("# #").func_200472_a("###").func_200465_a("has_wood_slab", (ICriterionInstance)this.func_200409_a(ItemTags.field_202899_i)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150486_ae).func_200469_a(Character.valueOf('#'), ItemTags.field_199905_b).func_200472_a("###").func_200472_a("# #").func_200472_a("###").func_200465_a("has_lots_of_items", (ICriterionInstance)new InventoryChangeTrigger.Instance(MinMaxBounds.IntBound.func_211340_b((int)10), MinMaxBounds.IntBound.field_211347_e, MinMaxBounds.IntBound.field_211347_e, new ItemPredicate[0])).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151108_aI).func_200462_a(Character.valueOf('A'), (IItemProvider)Blocks.field_150486_ae).func_200462_a(Character.valueOf('B'), (IItemProvider)Items.field_151143_au).func_200472_a("A").func_200472_a("B").func_200465_a("has_minecart", (ICriterionInstance)this.func_200403_a(Items.field_151143_au)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_196772_fk).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196576_bD).func_200472_a("#").func_200472_a("#").func_200465_a("has_chiseled_quartz_block", (ICriterionInstance)this.func_200403_a(Blocks.field_196772_fk)).func_200465_a("has_quartz_block", (ICriterionInstance)this.func_200403_a(Blocks.field_150371_ca)).func_200465_a("has_quartz_pillar", (ICriterionInstance)this.func_200403_a(Blocks.field_196770_fj)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_196702_dl).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196573_bB).func_200472_a("#").func_200472_a("#").func_200465_a("has_stone_bricks", (ICriterionInstance)this.func_200409_a(ItemTags.field_200033_c)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150435_aG).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151119_aD).func_200472_a("##").func_200472_a("##").func_200465_a("has_clay_ball", (ICriterionInstance)this.func_200403_a(Items.field_151119_aD)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151113_aN).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151043_k).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151137_ax).func_200472_a(" # ").func_200472_a("#X#").func_200472_a(" # ").func_200465_a("has_redstone", (ICriterionInstance)this.func_200403_a(Items.field_151137_ax)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_151044_h, (int)9).func_200487_b((IItemProvider)Blocks.field_150402_ci).func_200483_a("has_coal_block", (ICriterionInstance)this.func_200403_a(Blocks.field_150402_ci)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150402_ci).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151044_h).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200465_a("has_coal", (ICriterionInstance)this.func_200403_a(Items.field_151044_h)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196660_k, (int)4).func_200462_a(Character.valueOf('D'), (IItemProvider)Blocks.field_150346_d).func_200462_a(Character.valueOf('G'), (IItemProvider)Blocks.field_150351_n).func_200472_a("DG").func_200472_a("GD").func_200465_a("has_gravel", (ICriterionInstance)this.func_200403_a(Blocks.field_150351_n)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196646_bz, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150347_e).func_200472_a("###").func_200465_a("has_cobblestone", (ICriterionInstance)this.func_200403_a(Blocks.field_150347_e)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_150463_bK, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150347_e).func_200472_a("###").func_200472_a("###").func_200465_a("has_cobblestone", (ICriterionInstance)this.func_200403_a(Blocks.field_150347_e)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_196762_fd).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150429_aA).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151128_bU).func_200462_a(Character.valueOf('I'), (IItemProvider)Blocks.field_150348_b).func_200472_a(" # ").func_200472_a("#X#").func_200472_a("III").func_200465_a("has_quartz", (ICriterionInstance)this.func_200403_a(Items.field_151128_bU)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151111_aL).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151042_j).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151137_ax).func_200472_a(" # ").func_200472_a("#X#").func_200472_a(" # ").func_200465_a("has_redstone", (ICriterionInstance)this.func_200403_a(Items.field_151137_ax)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Items.field_151106_aX, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151015_O).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_196130_bo).func_200472_a("#X#").func_200465_a("has_cocoa", (ICriterionInstance)this.func_200403_a(Items.field_196130_bo)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150462_ai).func_200469_a(Character.valueOf('#'), ItemTags.field_199905_b).func_200472_a("##").func_200472_a("##").func_200465_a("has_planks", (ICriterionInstance)this.func_200409_a(ItemTags.field_199905_b)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_222114_py).func_200462_a(Character.valueOf('~'), (IItemProvider)Items.field_151007_F).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('&'), (IItemProvider)Items.field_151042_j).func_200462_a(Character.valueOf('$'), (IItemProvider)Blocks.field_150479_bC).func_200472_a("#&#").func_200472_a("~$~").func_200472_a(" # ").func_200465_a("has_string", (ICriterionInstance)this.func_200403_a(Items.field_151007_F)).func_200465_a("has_stick", (ICriterionInstance)this.func_200403_a(Items.field_151055_y)).func_200465_a("has_iron_ingot", (ICriterionInstance)this.func_200403_a(Items.field_151042_j)).func_200465_a("has_tripwire_hook", (ICriterionInstance)this.func_200403_a(Blocks.field_150479_bC)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_222421_lJ).func_200469_a(Character.valueOf('#'), ItemTags.field_199905_b).func_200462_a(Character.valueOf('@'), (IItemProvider)Items.field_151007_F).func_200472_a("@@").func_200472_a("##").func_200465_a("has_string", (ICriterionInstance)this.func_200403_a(Items.field_151007_F)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_196798_hA).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196578_bE).func_200472_a("#").func_200472_a("#").func_200465_a("has_red_sandstone", (ICriterionInstance)this.func_200403_a(Blocks.field_180395_cM)).func_200465_a("has_chiseled_red_sandstone", (ICriterionInstance)this.func_200403_a(Blocks.field_196798_hA)).func_200465_a("has_cut_red_sandstone", (ICriterionInstance)this.func_200403_a(Blocks.field_196799_hB)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_196583_aj).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196640_bx).func_200472_a("#").func_200472_a("#").func_200465_a("has_stone_slab", (ICriterionInstance)this.func_200403_a(Blocks.field_196640_bx)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_196200_ep).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196565_aU).func_200462_a(Character.valueOf('|'), (IItemProvider)Items.field_151055_y).func_200472_a("###").func_200472_a("###").func_200472_a(" | ").func_200473_b("banner").func_200465_a("has_cyan_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196565_aU)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_196093_bD).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196565_aU).func_200469_a(Character.valueOf('X'), ItemTags.field_199905_b).func_200472_a("###").func_200472_a("XXX").func_200473_b("bed").func_200465_a("has_cyan_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196565_aU)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_196093_bD).func_200487_b((IItemProvider)Items.field_196140_bu).func_200487_b((IItemProvider)Items.field_196124_bl).func_200490_a("dyed_bed").func_200483_a("has_bed", (ICriterionInstance)this.func_200403_a(Items.field_196140_bu)).func_200484_a(consumer, "cyan_bed_from_white_bed");
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196741_fQ, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196565_aU).func_200472_a("##").func_200473_b("carpet").func_200465_a("has_cyan_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196565_aU)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196741_fQ, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196724_fH).func_200462_a(Character.valueOf('$'), (IItemProvider)Items.field_196124_bl).func_200472_a("###").func_200472_a("#$#").func_200472_a("###").func_200473_b("carpet").func_200465_a("has_white_carpet", (ICriterionInstance)this.func_200403_a(Blocks.field_196724_fH)).func_200465_a("has_cyan_dye", (ICriterionInstance)this.func_200403_a(Items.field_196124_bl)).func_200466_a(consumer, "cyan_carpet_from_white_carpet");
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Blocks.field_196878_jb, (int)8).func_200487_b((IItemProvider)Items.field_196124_bl).func_200491_b((IItemProvider)Blocks.field_150354_m, 4).func_200491_b((IItemProvider)Blocks.field_150351_n, 4).func_200490_a("concrete_powder").func_200483_a("has_sand", (ICriterionInstance)this.func_200403_a(Blocks.field_150354_m)).func_200483_a("has_gravel", (ICriterionInstance)this.func_200403_a(Blocks.field_150351_n)).func_200482_a(consumer);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_196124_bl, (int)2).func_200487_b((IItemProvider)Items.field_222083_lx).func_200487_b((IItemProvider)Items.field_222079_lj).func_200483_a("has_green_dye", (ICriterionInstance)this.func_200403_a(Items.field_222079_lj)).func_200483_a("has_blue_dye", (ICriterionInstance)this.func_200403_a(Items.field_222083_lx)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196818_gs, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150359_w).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_196124_bl).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200473_b("stained_glass").func_200465_a("has_glass", (ICriterionInstance)this.func_200403_a(Blocks.field_150359_w)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196768_gI, (int)16).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196818_gs).func_200472_a("###").func_200472_a("###").func_200473_b("stained_glass_pane").func_200465_a("has_glass", (ICriterionInstance)this.func_200403_a(Blocks.field_150359_w)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196768_gI, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150410_aZ).func_200462_a(Character.valueOf('$'), (IItemProvider)Items.field_196124_bl).func_200472_a("###").func_200472_a("#$#").func_200472_a("###").func_200473_b("stained_glass_pane").func_200465_a("has_glass_pane", (ICriterionInstance)this.func_200403_a(Blocks.field_150410_aZ)).func_200465_a("has_cyan_dye", (ICriterionInstance)this.func_200403_a(Items.field_196124_bl)).func_200466_a(consumer, "cyan_stained_glass_pane_from_glass_pane");
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196793_fx, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150405_ch).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_196124_bl).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200473_b("stained_terracotta").func_200465_a("has_terracotta", (ICriterionInstance)this.func_200403_a(Blocks.field_150405_ch)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Blocks.field_196565_aU).func_200487_b((IItemProvider)Items.field_196124_bl).func_200487_b((IItemProvider)Blocks.field_196556_aL).func_200490_a("wool").func_200483_a("has_white_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196556_aL)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196639_V, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196623_P).func_200472_a("##").func_200472_a("##").func_200473_b("bark").func_200465_a("has_log", (ICriterionInstance)this.func_200403_a(Blocks.field_196623_P)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_209394_ag, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_203209_W).func_200472_a("##").func_200472_a("##").func_200473_b("bark").func_200465_a("has_log", (ICriterionInstance)this.func_200403_a(Blocks.field_203209_W)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_185154_aL).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196672_s).func_200472_a("# #").func_200472_a("###").func_200473_b("boat").func_200465_a("in_water", (ICriterionInstance)this.func_200407_a(Blocks.field_150355_j)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Blocks.field_196699_eK).func_200487_b((IItemProvider)Blocks.field_196672_s).func_200490_a("wooden_button").func_200483_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196672_s)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_180409_at, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196672_s).func_200472_a("##").func_200472_a("##").func_200472_a("##").func_200473_b("wooden_door").func_200465_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196672_s)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_180406_aS, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('W'), (IItemProvider)Blocks.field_196672_s).func_200472_a("W#W").func_200472_a("W#W").func_200473_b("wooden_fence").func_200465_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196672_s)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_180385_bs).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('W'), (IItemProvider)Blocks.field_196672_s).func_200472_a("#W#").func_200472_a("#W#").func_200473_b("wooden_fence_gate").func_200465_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196672_s)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Blocks.field_196672_s, (int)4).func_203221_a(ItemTags.field_203294_n).func_200490_a("planks").func_200483_a("has_logs", (ICriterionInstance)this.func_200409_a(ItemTags.field_203294_n)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_196673_cv).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196672_s).func_200472_a("##").func_200473_b("wooden_pressure_plate").func_200465_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196672_s)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196635_bv, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196672_s).func_200472_a("###").func_200473_b("wooden_slab").func_200465_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196672_s)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_150401_cl, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196672_s).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200473_b("wooden_stairs").func_200465_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196672_s)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196684_db, (int)2).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196672_s).func_200472_a("###").func_200472_a("###").func_200473_b("wooden_trapdoor").func_200465_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196672_s)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_196781_gR).func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_179562_cC).func_200462_a(Character.valueOf('I'), (IItemProvider)Items.field_222086_lz).func_200472_a("SSS").func_200472_a("SIS").func_200472_a("SSS").func_200465_a("has_prismarine_shard", (ICriterionInstance)this.func_200403_a(Items.field_179562_cC)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_203210_he, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_180397_cI).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_prismarine", (ICriterionInstance)this.func_200403_a(Blocks.field_180397_cI)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_203211_hf, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196779_gQ).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_prismarine_bricks", (ICriterionInstance)this.func_200403_a(Blocks.field_196779_gQ)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_203212_hg, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196781_gR).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_dark_prismarine", (ICriterionInstance)this.func_200403_a(Blocks.field_196781_gR)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150453_bW).func_200462_a(Character.valueOf('Q'), (IItemProvider)Items.field_151128_bU).func_200462_a(Character.valueOf('G'), (IItemProvider)Blocks.field_150359_w).func_200471_a(Character.valueOf('W'), Ingredient.func_199805_a(ItemTags.field_202899_i)).func_200472_a("GGG").func_200472_a("QQQ").func_200472_a("WWW").func_200465_a("has_quartz", (ICriterionInstance)this.func_200403_a(Items.field_151128_bU)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_150319_E, (int)6).func_200462_a(Character.valueOf('R'), (IItemProvider)Items.field_151137_ax).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150456_au).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151042_j).func_200472_a("X X").func_200472_a("X#X").func_200472_a("XRX").func_200465_a("has_rail", (ICriterionInstance)this.func_200403_a(Blocks.field_150448_aq)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_151045_i, (int)9).func_200487_b((IItemProvider)Blocks.field_150484_ah).func_200483_a("has_diamond_block", (ICriterionInstance)this.func_200403_a(Blocks.field_150484_ah)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151056_x).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151045_i).func_200472_a("XX").func_200472_a("X#").func_200472_a(" #").func_200465_a("has_diamond", (ICriterionInstance)this.func_200403_a(Items.field_151045_i)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150484_ah).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151045_i).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200465_a("has_diamond", (ICriterionInstance)this.func_200403_a(Items.field_151045_i)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151175_af).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151045_i).func_200472_a("X X").func_200472_a("X X").func_200465_a("has_diamond", (ICriterionInstance)this.func_200403_a(Items.field_151045_i)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151163_ad).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151045_i).func_200472_a("X X").func_200472_a("XXX").func_200472_a("XXX").func_200465_a("has_diamond", (ICriterionInstance)this.func_200403_a(Items.field_151045_i)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151161_ac).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151045_i).func_200472_a("XXX").func_200472_a("X X").func_200465_a("has_diamond", (ICriterionInstance)this.func_200403_a(Items.field_151045_i)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151012_L).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151045_i).func_200472_a("XX").func_200472_a(" #").func_200472_a(" #").func_200465_a("has_diamond", (ICriterionInstance)this.func_200403_a(Items.field_151045_i)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151173_ae).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151045_i).func_200472_a("XXX").func_200472_a("X X").func_200472_a("X X").func_200465_a("has_diamond", (ICriterionInstance)this.func_200403_a(Items.field_151045_i)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151046_w).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151045_i).func_200472_a("XXX").func_200472_a(" # ").func_200472_a(" # ").func_200465_a("has_diamond", (ICriterionInstance)this.func_200403_a(Items.field_151045_i)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151047_v).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151045_i).func_200472_a("X").func_200472_a("#").func_200472_a("#").func_200465_a("has_diamond", (ICriterionInstance)this.func_200403_a(Items.field_151045_i)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151048_u).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151045_i).func_200472_a("X").func_200472_a("X").func_200472_a("#").func_200465_a("has_diamond", (ICriterionInstance)this.func_200403_a(Items.field_151045_i)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196654_e, (int)2).func_200462_a(Character.valueOf('Q'), (IItemProvider)Items.field_151128_bU).func_200462_a(Character.valueOf('C'), (IItemProvider)Blocks.field_150347_e).func_200472_a("CQ").func_200472_a("QC").func_200465_a("has_quartz", (ICriterionInstance)this.func_200403_a(Items.field_151128_bU)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150367_z).func_200462_a(Character.valueOf('R'), (IItemProvider)Items.field_151137_ax).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150347_e).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151031_f).func_200472_a("###").func_200472_a("#X#").func_200472_a("#R#").func_200465_a("has_bow", (ICriterionInstance)this.func_200403_a(Items.field_151031_f)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150409_cd).func_200462_a(Character.valueOf('R'), (IItemProvider)Items.field_151137_ax).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150347_e).func_200472_a("###").func_200472_a("# #").func_200472_a("#R#").func_200465_a("has_redstone", (ICriterionInstance)this.func_200403_a(Items.field_151137_ax)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_151166_bC, (int)9).func_200487_b((IItemProvider)Blocks.field_150475_bE).func_200483_a("has_emerald_block", (ICriterionInstance)this.func_200403_a(Blocks.field_150475_bE)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150475_bE).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151166_bC).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200465_a("has_emerald", (ICriterionInstance)this.func_200403_a(Items.field_151166_bC)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150381_bn).func_200462_a(Character.valueOf('B'), (IItemProvider)Items.field_151122_aG).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150343_Z).func_200462_a(Character.valueOf('D'), (IItemProvider)Items.field_151045_i).func_200472_a(" B ").func_200472_a("D#D").func_200472_a("###").func_200465_a("has_obsidian", (ICriterionInstance)this.func_200403_a(Blocks.field_150343_Z)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150477_bB).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150343_Z).func_200462_a(Character.valueOf('E'), (IItemProvider)Items.field_151061_bv).func_200472_a("###").func_200472_a("#E#").func_200472_a("###").func_200465_a("has_ender_eye", (ICriterionInstance)this.func_200403_a(Items.field_151061_bv)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_151061_bv).func_200487_b((IItemProvider)Items.field_151079_bi).func_200487_b((IItemProvider)Items.field_151065_br).func_200483_a("has_blaze_powder", (ICriterionInstance)this.func_200403_a(Items.field_151065_br)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196806_hJ, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150377_bs).func_200472_a("##").func_200472_a("##").func_200465_a("has_end_stone", (ICriterionInstance)this.func_200403_a(Blocks.field_150377_bs)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_185158_cP).func_200462_a(Character.valueOf('T'), (IItemProvider)Items.field_151073_bk).func_200462_a(Character.valueOf('E'), (IItemProvider)Items.field_151061_bv).func_200462_a(Character.valueOf('G'), (IItemProvider)Blocks.field_150359_w).func_200472_a("GGG").func_200472_a("GEG").func_200472_a("GTG").func_200465_a("has_ender_eye", (ICriterionInstance)this.func_200403_a(Items.field_151061_bv)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_185764_cQ, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_185162_cT).func_200462_a(Character.valueOf('/'), (IItemProvider)Items.field_151072_bj).func_200472_a("/").func_200472_a("#").func_200465_a("has_chorus_fruit_popped", (ICriterionInstance)this.func_200403_a(Items.field_185162_cT)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_180407_aO, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('W'), (IItemProvider)Blocks.field_196662_n).func_200472_a("W#W").func_200472_a("W#W").func_200473_b("wooden_fence").func_200465_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196662_n)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_180390_bo).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('W'), (IItemProvider)Blocks.field_196662_n).func_200472_a("#W#").func_200472_a("#W#").func_200473_b("wooden_fence_gate").func_200465_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196662_n)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_151071_bq).func_200487_b((IItemProvider)Items.field_151070_bp).func_200487_b((IItemProvider)Blocks.field_150338_P).func_200487_b((IItemProvider)Items.field_151102_aT).func_200483_a("has_spider_eye", (ICriterionInstance)this.func_200403_a(Items.field_151070_bp)).func_200482_a(consumer);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_151059_bz, (int)3).func_200487_b((IItemProvider)Items.field_151016_H).func_200487_b((IItemProvider)Items.field_151065_br).func_200489_a(Ingredient.func_199804_a(Items.field_151044_h, Items.field_196155_l)).func_200483_a("has_blaze_powder", (ICriterionInstance)this.func_200403_a(Items.field_151065_br)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151112_aM).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151007_F).func_200472_a("  #").func_200472_a(" #X").func_200472_a("# X").func_200465_a("has_string", (ICriterionInstance)this.func_200403_a(Items.field_151007_F)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_151033_d).func_200487_b((IItemProvider)Items.field_151042_j).func_200487_b((IItemProvider)Items.field_151145_ak).func_200483_a("has_flint", (ICriterionInstance)this.func_200403_a(Items.field_151145_ak)).func_200483_a("has_obsidian", (ICriterionInstance)this.func_200403_a(Blocks.field_150343_Z)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150457_bL).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151118_aC).func_200472_a("# #").func_200472_a(" # ").func_200465_a("has_brick", (ICriterionInstance)this.func_200403_a(Items.field_151118_aC)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150460_al).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150347_e).func_200472_a("###").func_200472_a("# #").func_200472_a("###").func_200465_a("has_cobblestone", (ICriterionInstance)this.func_200403_a(Blocks.field_150347_e)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151109_aJ).func_200462_a(Character.valueOf('A'), (IItemProvider)Blocks.field_150460_al).func_200462_a(Character.valueOf('B'), (IItemProvider)Items.field_151143_au).func_200472_a("A").func_200472_a("B").func_200465_a("has_minecart", (ICriterionInstance)this.func_200403_a(Items.field_151143_au)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Items.field_151069_bo, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150359_w).func_200472_a("# #").func_200472_a(" # ").func_200465_a("has_glass", (ICriterionInstance)this.func_200403_a(Blocks.field_150359_w)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_150410_aZ, (int)16).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150359_w).func_200472_a("###").func_200472_a("###").func_200465_a("has_glass", (ICriterionInstance)this.func_200403_a(Blocks.field_150359_w)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150426_aN).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151114_aO).func_200472_a("##").func_200472_a("##").func_200465_a("has_glowstone_dust", (ICriterionInstance)this.func_200403_a(Items.field_151114_aO)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151153_ao).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151043_k).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151034_e).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200465_a("has_gold_ingot", (ICriterionInstance)this.func_200403_a(Items.field_151043_k)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151006_E).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151043_k).func_200472_a("XX").func_200472_a("X#").func_200472_a(" #").func_200465_a("has_gold_ingot", (ICriterionInstance)this.func_200403_a(Items.field_151043_k)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151151_aj).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151043_k).func_200472_a("X X").func_200472_a("X X").func_200465_a("has_gold_ingot", (ICriterionInstance)this.func_200403_a(Items.field_151043_k)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151150_bK).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151074_bl).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151172_bF).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200465_a("has_gold_nugget", (ICriterionInstance)this.func_200403_a(Items.field_151074_bl)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151171_ah).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151043_k).func_200472_a("X X").func_200472_a("XXX").func_200472_a("XXX").func_200465_a("has_gold_ingot", (ICriterionInstance)this.func_200403_a(Items.field_151043_k)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151169_ag).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151043_k).func_200472_a("XXX").func_200472_a("X X").func_200465_a("has_gold_ingot", (ICriterionInstance)this.func_200403_a(Items.field_151043_k)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151013_M).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151043_k).func_200472_a("XX").func_200472_a(" #").func_200472_a(" #").func_200465_a("has_gold_ingot", (ICriterionInstance)this.func_200403_a(Items.field_151043_k)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151149_ai).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151043_k).func_200472_a("XXX").func_200472_a("X X").func_200472_a("X X").func_200465_a("has_gold_ingot", (ICriterionInstance)this.func_200403_a(Items.field_151043_k)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151005_D).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151043_k).func_200472_a("XXX").func_200472_a(" # ").func_200472_a(" # ").func_200465_a("has_gold_ingot", (ICriterionInstance)this.func_200403_a(Items.field_151043_k)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196552_aC, (int)6).func_200462_a(Character.valueOf('R'), (IItemProvider)Items.field_151137_ax).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151043_k).func_200472_a("X X").func_200472_a("X#X").func_200472_a("XRX").func_200465_a("has_rail", (ICriterionInstance)this.func_200403_a(Blocks.field_150448_aq)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151011_C).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151043_k).func_200472_a("X").func_200472_a("#").func_200472_a("#").func_200465_a("has_gold_ingot", (ICriterionInstance)this.func_200403_a(Items.field_151043_k)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151010_B).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151043_k).func_200472_a("X").func_200472_a("X").func_200472_a("#").func_200465_a("has_gold_ingot", (ICriterionInstance)this.func_200403_a(Items.field_151043_k)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150340_R).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151043_k).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200465_a("has_gold_ingot", (ICriterionInstance)this.func_200403_a(Items.field_151043_k)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_151043_k, (int)9).func_200487_b((IItemProvider)Blocks.field_150340_R).func_200490_a("gold_ingot").func_200483_a("has_gold_block", (ICriterionInstance)this.func_200403_a(Blocks.field_150340_R)).func_200484_a(consumer, "gold_ingot_from_gold_block");
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151043_k).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151074_bl).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200473_b("gold_ingot").func_200465_a("has_gold_nugget", (ICriterionInstance)this.func_200403_a(Items.field_151074_bl)).func_200466_a(consumer, "gold_ingot_from_nuggets");
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_151074_bl, (int)9).func_200487_b((IItemProvider)Items.field_151043_k).func_200483_a("has_gold_ingot", (ICriterionInstance)this.func_200403_a(Items.field_151043_k)).func_200482_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Blocks.field_196650_c).func_200487_b((IItemProvider)Blocks.field_196654_e).func_200487_b((IItemProvider)Items.field_151128_bU).func_200483_a("has_quartz", (ICriterionInstance)this.func_200403_a(Items.field_151128_bU)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_196198_en).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196563_aS).func_200462_a(Character.valueOf('|'), (IItemProvider)Items.field_151055_y).func_200472_a("###").func_200472_a("###").func_200472_a(" | ").func_200473_b("banner").func_200465_a("has_gray_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196563_aS)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_196091_bB).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196563_aS).func_200469_a(Character.valueOf('X'), ItemTags.field_199905_b).func_200472_a("###").func_200472_a("XXX").func_200473_b("bed").func_200465_a("has_gray_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196563_aS)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_196091_bB).func_200487_b((IItemProvider)Items.field_196140_bu).func_200487_b((IItemProvider)Items.field_196120_bj).func_200490_a("dyed_bed").func_200483_a("has_bed", (ICriterionInstance)this.func_200403_a(Items.field_196140_bu)).func_200484_a(consumer, "gray_bed_from_white_bed");
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196737_fO, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196563_aS).func_200472_a("##").func_200473_b("carpet").func_200465_a("has_gray_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196563_aS)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196737_fO, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196724_fH).func_200462_a(Character.valueOf('$'), (IItemProvider)Items.field_196120_bj).func_200472_a("###").func_200472_a("#$#").func_200472_a("###").func_200473_b("carpet").func_200465_a("has_white_carpet", (ICriterionInstance)this.func_200403_a(Blocks.field_196724_fH)).func_200465_a("has_gray_dye", (ICriterionInstance)this.func_200403_a(Items.field_196120_bj)).func_200466_a(consumer, "gray_carpet_from_white_carpet");
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Blocks.field_196874_iZ, (int)8).func_200487_b((IItemProvider)Items.field_196120_bj).func_200491_b((IItemProvider)Blocks.field_150354_m, 4).func_200491_b((IItemProvider)Blocks.field_150351_n, 4).func_200490_a("concrete_powder").func_200483_a("has_sand", (ICriterionInstance)this.func_200403_a(Blocks.field_150354_m)).func_200483_a("has_gravel", (ICriterionInstance)this.func_200403_a(Blocks.field_150351_n)).func_200482_a(consumer);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_196120_bj, (int)2).func_200487_b((IItemProvider)Items.field_222086_lz).func_200487_b((IItemProvider)Items.field_222069_lA).func_200483_a("has_white_dye", (ICriterionInstance)this.func_200403_a(Items.field_222069_lA)).func_200483_a("has_black_dye", (ICriterionInstance)this.func_200403_a(Items.field_222086_lz)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196815_gq, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150359_w).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_196120_bj).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200473_b("stained_glass").func_200465_a("has_glass", (ICriterionInstance)this.func_200403_a(Blocks.field_150359_w)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196765_gG, (int)16).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196815_gq).func_200472_a("###").func_200472_a("###").func_200473_b("stained_glass_pane").func_200465_a("has_glass", (ICriterionInstance)this.func_200403_a(Blocks.field_150359_w)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196765_gG, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150410_aZ).func_200462_a(Character.valueOf('$'), (IItemProvider)Items.field_196120_bj).func_200472_a("###").func_200472_a("#$#").func_200472_a("###").func_200473_b("stained_glass_pane").func_200465_a("has_glass_pane", (ICriterionInstance)this.func_200403_a(Blocks.field_150410_aZ)).func_200465_a("has_gray_dye", (ICriterionInstance)this.func_200403_a(Items.field_196120_bj)).func_200466_a(consumer, "gray_stained_glass_pane_from_glass_pane");
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196789_fv, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150405_ch).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_196120_bj).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200473_b("stained_terracotta").func_200465_a("has_terracotta", (ICriterionInstance)this.func_200403_a(Blocks.field_150405_ch)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Blocks.field_196563_aS).func_200487_b((IItemProvider)Items.field_196120_bj).func_200487_b((IItemProvider)Blocks.field_196556_aL).func_200490_a("wool").func_200483_a("has_white_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196556_aL)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_196204_et).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196569_aY).func_200462_a(Character.valueOf('|'), (IItemProvider)Items.field_151055_y).func_200472_a("###").func_200472_a("###").func_200472_a(" | ").func_200473_b("banner").func_200465_a("has_green_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196569_aY)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_196097_bH).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196569_aY).func_200469_a(Character.valueOf('X'), ItemTags.field_199905_b).func_200472_a("###").func_200472_a("XXX").func_200473_b("bed").func_200465_a("has_green_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196569_aY)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_196097_bH).func_200487_b((IItemProvider)Items.field_196140_bu).func_200487_b((IItemProvider)Items.field_222079_lj).func_200490_a("dyed_bed").func_200483_a("has_bed", (ICriterionInstance)this.func_200403_a(Items.field_196140_bu)).func_200484_a(consumer, "green_bed_from_white_bed");
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196749_fU, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196569_aY).func_200472_a("##").func_200473_b("carpet").func_200465_a("has_green_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196569_aY)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196749_fU, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196724_fH).func_200462_a(Character.valueOf('$'), (IItemProvider)Items.field_222079_lj).func_200472_a("###").func_200472_a("#$#").func_200472_a("###").func_200473_b("carpet").func_200465_a("has_white_carpet", (ICriterionInstance)this.func_200403_a(Blocks.field_196724_fH)).func_200465_a("has_green_dye", (ICriterionInstance)this.func_200403_a(Items.field_222079_lj)).func_200466_a(consumer, "green_carpet_from_white_carpet");
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Blocks.field_196882_jf, (int)8).func_200487_b((IItemProvider)Items.field_222079_lj).func_200491_b((IItemProvider)Blocks.field_150354_m, 4).func_200491_b((IItemProvider)Blocks.field_150351_n, 4).func_200490_a("concrete_powder").func_200483_a("has_sand", (ICriterionInstance)this.func_200403_a(Blocks.field_150354_m)).func_200483_a("has_gravel", (ICriterionInstance)this.func_200403_a(Blocks.field_150351_n)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196822_gw, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150359_w).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_222079_lj).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200473_b("stained_glass").func_200465_a("has_glass", (ICriterionInstance)this.func_200403_a(Blocks.field_150359_w)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196774_gM, (int)16).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196822_gw).func_200472_a("###").func_200472_a("###").func_200473_b("stained_glass_pane").func_200465_a("has_glass", (ICriterionInstance)this.func_200403_a(Blocks.field_150359_w)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196774_gM, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150410_aZ).func_200462_a(Character.valueOf('$'), (IItemProvider)Items.field_222079_lj).func_200472_a("###").func_200472_a("#$#").func_200472_a("###").func_200473_b("stained_glass_pane").func_200465_a("has_glass_pane", (ICriterionInstance)this.func_200403_a(Blocks.field_150410_aZ)).func_200465_a("has_green_dye", (ICriterionInstance)this.func_200403_a(Items.field_222079_lj)).func_200466_a(consumer, "green_stained_glass_pane_from_glass_pane");
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196720_fB, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150405_ch).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_222079_lj).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200473_b("stained_terracotta").func_200465_a("has_terracotta", (ICriterionInstance)this.func_200403_a(Blocks.field_150405_ch)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Blocks.field_196569_aY).func_200487_b((IItemProvider)Items.field_222079_lj).func_200487_b((IItemProvider)Blocks.field_196556_aL).func_200490_a("wool").func_200483_a("has_white_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196556_aL)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150407_cf).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151015_O).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200465_a("has_wheat", (ICriterionInstance)this.func_200403_a(Items.field_151015_O)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150443_bT).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151042_j).func_200472_a("##").func_200465_a("has_iron_ingot", (ICriterionInstance)this.func_200403_a(Items.field_151042_j)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_226638_pX_, (int)4).func_200487_b((IItemProvider)Items.field_226639_pY_).func_200491_b((IItemProvider)Items.field_151069_bo, 4).func_200483_a("has_honey_block", (ICriterionInstance)this.func_200403_a(Blocks.field_226907_mc_)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_226907_mc_, (int)1).func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_226638_pX_).func_200472_a("SS").func_200472_a("SS").func_200465_a("has_honey_bottle", (ICriterionInstance)this.func_200403_a(Items.field_226638_pX_)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_226908_md_).func_200462_a(Character.valueOf('H'), (IItemProvider)Items.field_226635_pU_).func_200472_a("HH").func_200472_a("HH").func_200465_a("has_honeycomb", (ICriterionInstance)this.func_200403_a(Items.field_226635_pU_)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150438_bZ).func_200462_a(Character.valueOf('C'), (IItemProvider)Blocks.field_150486_ae).func_200462_a(Character.valueOf('I'), (IItemProvider)Items.field_151042_j).func_200472_a("I I").func_200472_a("ICI").func_200472_a(" I ").func_200465_a("has_iron_ingot", (ICriterionInstance)this.func_200403_a(Items.field_151042_j)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151140_bW).func_200462_a(Character.valueOf('A'), (IItemProvider)Blocks.field_150438_bZ).func_200462_a(Character.valueOf('B'), (IItemProvider)Items.field_151143_au).func_200472_a("A").func_200472_a("B").func_200465_a("has_minecart", (ICriterionInstance)this.func_200403_a(Items.field_151143_au)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151036_c).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151042_j).func_200472_a("XX").func_200472_a("X#").func_200472_a(" #").func_200465_a("has_iron_ingot", (ICriterionInstance)this.func_200403_a(Items.field_151042_j)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_150411_aY, (int)16).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151042_j).func_200472_a("###").func_200472_a("###").func_200465_a("has_iron_ingot", (ICriterionInstance)this.func_200403_a(Items.field_151042_j)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150339_S).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151042_j).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200465_a("has_iron_ingot", (ICriterionInstance)this.func_200403_a(Items.field_151042_j)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151167_ab).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151042_j).func_200472_a("X X").func_200472_a("X X").func_200465_a("has_iron_ingot", (ICriterionInstance)this.func_200403_a(Items.field_151042_j)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151030_Z).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151042_j).func_200472_a("X X").func_200472_a("XXX").func_200472_a("XXX").func_200465_a("has_iron_ingot", (ICriterionInstance)this.func_200403_a(Items.field_151042_j)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_150454_av, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151042_j).func_200472_a("##").func_200472_a("##").func_200472_a("##").func_200465_a("has_iron_ingot", (ICriterionInstance)this.func_200403_a(Items.field_151042_j)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151028_Y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151042_j).func_200472_a("XXX").func_200472_a("X X").func_200465_a("has_iron_ingot", (ICriterionInstance)this.func_200403_a(Items.field_151042_j)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151019_K).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151042_j).func_200472_a("XX").func_200472_a(" #").func_200472_a(" #").func_200465_a("has_iron_ingot", (ICriterionInstance)this.func_200403_a(Items.field_151042_j)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_151042_j, (int)9).func_200487_b((IItemProvider)Blocks.field_150339_S).func_200490_a("iron_ingot").func_200483_a("has_iron_block", (ICriterionInstance)this.func_200403_a(Blocks.field_150339_S)).func_200484_a(consumer, "iron_ingot_from_iron_block");
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151042_j).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_191525_da).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200473_b("iron_ingot").func_200465_a("has_iron_nugget", (ICriterionInstance)this.func_200403_a(Items.field_191525_da)).func_200466_a(consumer, "iron_ingot_from_nuggets");
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151165_aa).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151042_j).func_200472_a("XXX").func_200472_a("X X").func_200472_a("X X").func_200465_a("has_iron_ingot", (ICriterionInstance)this.func_200403_a(Items.field_151042_j)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_191525_da, (int)9).func_200487_b((IItemProvider)Items.field_151042_j).func_200483_a("has_iron_ingot", (ICriterionInstance)this.func_200403_a(Items.field_151042_j)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151035_b).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151042_j).func_200472_a("XXX").func_200472_a(" # ").func_200472_a(" # ").func_200465_a("has_iron_ingot", (ICriterionInstance)this.func_200403_a(Items.field_151042_j)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151037_a).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151042_j).func_200472_a("X").func_200472_a("#").func_200472_a("#").func_200465_a("has_iron_ingot", (ICriterionInstance)this.func_200403_a(Items.field_151042_j)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151040_l).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151042_j).func_200472_a("X").func_200472_a("X").func_200472_a("#").func_200465_a("has_iron_ingot", (ICriterionInstance)this.func_200403_a(Items.field_151042_j)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_180400_cw).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151042_j).func_200472_a("##").func_200472_a("##").func_200465_a("has_iron_ingot", (ICriterionInstance)this.func_200403_a(Items.field_151042_j)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151160_bD).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151116_aA).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200465_a("has_leather", (ICriterionInstance)this.func_200403_a(Items.field_151116_aA)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150421_aI).func_200469_a(Character.valueOf('#'), ItemTags.field_199905_b).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151045_i).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200465_a("has_diamond", (ICriterionInstance)this.func_200403_a(Items.field_151045_i)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196634_T, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196620_N).func_200472_a("##").func_200472_a("##").func_200473_b("bark").func_200465_a("has_log", (ICriterionInstance)this.func_200403_a(Blocks.field_196620_N)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_209392_ae, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_203207_U).func_200472_a("##").func_200472_a("##").func_200473_b("bark").func_200465_a("has_log", (ICriterionInstance)this.func_200403_a(Blocks.field_203207_U)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_185152_aJ).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196668_q).func_200472_a("# #").func_200472_a("###").func_200473_b("boat").func_200465_a("in_water", (ICriterionInstance)this.func_200407_a(Blocks.field_150355_j)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Blocks.field_196695_eI).func_200487_b((IItemProvider)Blocks.field_196668_q).func_200490_a("wooden_button").func_200483_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196668_q)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_180411_ar, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196668_q).func_200472_a("##").func_200472_a("##").func_200472_a("##").func_200473_b("wooden_door").func_200465_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196668_q)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_180403_aR, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('W'), (IItemProvider)Blocks.field_196668_q).func_200472_a("W#W").func_200472_a("W#W").func_200473_b("wooden_fence").func_200465_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196668_q)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_180386_br).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('W'), (IItemProvider)Blocks.field_196668_q).func_200472_a("#W#").func_200472_a("#W#").func_200473_b("wooden_fence_gate").func_200465_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196668_q)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Blocks.field_196668_q, (int)4).func_203221_a(ItemTags.field_203298_r).func_200490_a("planks").func_200483_a("has_log", (ICriterionInstance)this.func_200409_a(ItemTags.field_203298_r)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_196669_ct).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196668_q).func_200472_a("##").func_200473_b("wooden_pressure_plate").func_200465_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196668_q)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196630_bt, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196668_q).func_200472_a("###").func_200473_b("wooden_slab").func_200465_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196668_q)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_150481_bH, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196668_q).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200473_b("wooden_stairs").func_200465_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196668_q)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196644_cZ, (int)2).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196668_q).func_200472_a("###").func_200472_a("###").func_200473_b("wooden_trapdoor").func_200465_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196668_q)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_150468_ap, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200472_a("# #").func_200472_a("###").func_200472_a("# #").func_200465_a("has_stick", (ICriterionInstance)this.func_200403_a(Items.field_151055_y)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150368_y).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_196128_bn).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200465_a("has_lapis", (ICriterionInstance)this.func_200403_a(Items.field_196128_bn)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_196128_bn, (int)9).func_200487_b((IItemProvider)Blocks.field_150368_y).func_200483_a("has_lapis_block", (ICriterionInstance)this.func_200403_a(Blocks.field_150368_y)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Items.field_151058_ca, (int)2).func_200462_a(Character.valueOf('~'), (IItemProvider)Items.field_151007_F).func_200462_a(Character.valueOf('O'), (IItemProvider)Items.field_151123_aH).func_200472_a("~~ ").func_200472_a("~O ").func_200472_a("  ~").func_200465_a("has_slime_ball", (ICriterionInstance)this.func_200403_a(Items.field_151123_aH)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151116_aA).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_179555_bs).func_200472_a("##").func_200472_a("##").func_200465_a("has_rabbit_hide", (ICriterionInstance)this.func_200403_a(Items.field_179555_bs)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151021_T).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151116_aA).func_200472_a("X X").func_200472_a("X X").func_200465_a("has_leather", (ICriterionInstance)this.func_200403_a(Items.field_151116_aA)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151027_R).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151116_aA).func_200472_a("X X").func_200472_a("XXX").func_200472_a("XXX").func_200465_a("has_leather", (ICriterionInstance)this.func_200403_a(Items.field_151116_aA)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151024_Q).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151116_aA).func_200472_a("XXX").func_200472_a("X X").func_200465_a("has_leather", (ICriterionInstance)this.func_200403_a(Items.field_151116_aA)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151026_S).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151116_aA).func_200472_a("XXX").func_200472_a("X X").func_200472_a("X X").func_200465_a("has_leather", (ICriterionInstance)this.func_200403_a(Items.field_151116_aA)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_222110_op).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151116_aA).func_200472_a("X X").func_200472_a("XXX").func_200472_a("X X").func_200465_a("has_leather", (ICriterionInstance)this.func_200403_a(Items.field_151116_aA)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_222428_lQ).func_200469_a(Character.valueOf('S'), ItemTags.field_202899_i).func_200462_a(Character.valueOf('B'), (IItemProvider)Blocks.field_150342_X).func_200472_a("SSS").func_200472_a(" B ").func_200472_a(" S ").func_200465_a("has_book", (ICriterionInstance)this.func_200403_a(Items.field_151122_aG)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150442_at).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150347_e).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151055_y).func_200472_a("X").func_200472_a("#").func_200465_a("has_cobblestone", (ICriterionInstance)this.func_200403_a(Blocks.field_150347_e)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_196194_ej).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196559_aO).func_200462_a(Character.valueOf('|'), (IItemProvider)Items.field_151055_y).func_200472_a("###").func_200472_a("###").func_200472_a(" | ").func_200473_b("banner").func_200465_a("has_light_blue_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196559_aO)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_196146_bx).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196559_aO).func_200469_a(Character.valueOf('X'), ItemTags.field_199905_b).func_200472_a("###").func_200472_a("XXX").func_200473_b("bed").func_200465_a("has_light_blue_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196559_aO)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_196146_bx).func_200487_b((IItemProvider)Items.field_196140_bu).func_200487_b((IItemProvider)Items.field_196112_bf).func_200490_a("dyed_bed").func_200483_a("has_bed", (ICriterionInstance)this.func_200403_a(Items.field_196140_bu)).func_200484_a(consumer, "light_blue_bed_from_white_bed");
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196729_fK, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196559_aO).func_200472_a("##").func_200473_b("carpet").func_200465_a("has_light_blue_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196559_aO)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196729_fK, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196724_fH).func_200462_a(Character.valueOf('$'), (IItemProvider)Items.field_196112_bf).func_200472_a("###").func_200472_a("#$#").func_200472_a("###").func_200473_b("carpet").func_200465_a("has_white_carpet", (ICriterionInstance)this.func_200403_a(Blocks.field_196724_fH)).func_200465_a("has_light_blue_dye", (ICriterionInstance)this.func_200403_a(Items.field_196112_bf)).func_200466_a(consumer, "light_blue_carpet_from_white_carpet");
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Blocks.field_196866_iV, (int)8).func_200487_b((IItemProvider)Items.field_196112_bf).func_200491_b((IItemProvider)Blocks.field_150354_m, 4).func_200491_b((IItemProvider)Blocks.field_150351_n, 4).func_200490_a("concrete_powder").func_200483_a("has_sand", (ICriterionInstance)this.func_200403_a(Blocks.field_150354_m)).func_200483_a("has_gravel", (ICriterionInstance)this.func_200403_a(Blocks.field_150351_n)).func_200482_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_196112_bf).func_200487_b((IItemProvider)Blocks.field_196607_be).func_200490_a("light_blue_dye").func_200483_a("has_red_flower", (ICriterionInstance)this.func_200403_a(Blocks.field_196607_be)).func_200484_a(consumer, "light_blue_dye_from_blue_orchid");
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_196112_bf, (int)2).func_200487_b((IItemProvider)Items.field_222083_lx).func_200487_b((IItemProvider)Items.field_222069_lA).func_200490_a("light_blue_dye").func_200483_a("has_blue_dye", (ICriterionInstance)this.func_200403_a(Items.field_222083_lx)).func_200483_a("has_white_dye", (ICriterionInstance)this.func_200403_a(Items.field_222069_lA)).func_200484_a(consumer, "light_blue_dye_from_blue_white_dye");
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196810_gm, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150359_w).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_196112_bf).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200473_b("stained_glass").func_200465_a("has_glass", (ICriterionInstance)this.func_200403_a(Blocks.field_150359_w)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196760_gC, (int)16).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196810_gm).func_200472_a("###").func_200472_a("###").func_200473_b("stained_glass_pane").func_200465_a("has_glass", (ICriterionInstance)this.func_200403_a(Blocks.field_150359_w)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196760_gC, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150410_aZ).func_200462_a(Character.valueOf('$'), (IItemProvider)Items.field_196112_bf).func_200472_a("###").func_200472_a("#$#").func_200472_a("###").func_200473_b("stained_glass_pane").func_200465_a("has_glass_pane", (ICriterionInstance)this.func_200403_a(Blocks.field_150410_aZ)).func_200465_a("has_light_blue_dye", (ICriterionInstance)this.func_200403_a(Items.field_196112_bf)).func_200466_a(consumer, "light_blue_stained_glass_pane_from_glass_pane");
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196782_fr, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150405_ch).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_196112_bf).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200473_b("stained_terracotta").func_200465_a("has_terracotta", (ICriterionInstance)this.func_200403_a(Blocks.field_150405_ch)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Blocks.field_196559_aO).func_200487_b((IItemProvider)Items.field_196112_bf).func_200487_b((IItemProvider)Blocks.field_196556_aL).func_200490_a("wool").func_200483_a("has_white_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196556_aL)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_196199_eo).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196564_aT).func_200462_a(Character.valueOf('|'), (IItemProvider)Items.field_151055_y).func_200472_a("###").func_200472_a("###").func_200472_a(" | ").func_200473_b("banner").func_200465_a("has_light_gray_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196564_aT)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_196092_bC).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196564_aT).func_200469_a(Character.valueOf('X'), ItemTags.field_199905_b).func_200472_a("###").func_200472_a("XXX").func_200473_b("bed").func_200465_a("has_light_gray_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196564_aT)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_196092_bC).func_200487_b((IItemProvider)Items.field_196140_bu).func_200487_b((IItemProvider)Items.field_196122_bk).func_200490_a("dyed_bed").func_200483_a("has_bed", (ICriterionInstance)this.func_200403_a(Items.field_196140_bu)).func_200484_a(consumer, "light_gray_bed_from_white_bed");
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196739_fP, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196564_aT).func_200472_a("##").func_200473_b("carpet").func_200465_a("has_light_gray_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196564_aT)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196739_fP, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196724_fH).func_200462_a(Character.valueOf('$'), (IItemProvider)Items.field_196122_bk).func_200472_a("###").func_200472_a("#$#").func_200472_a("###").func_200473_b("carpet").func_200465_a("has_white_carpet", (ICriterionInstance)this.func_200403_a(Blocks.field_196724_fH)).func_200465_a("has_light_gray_dye", (ICriterionInstance)this.func_200403_a(Items.field_196122_bk)).func_200466_a(consumer, "light_gray_carpet_from_white_carpet");
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Blocks.field_196877_ja, (int)8).func_200487_b((IItemProvider)Items.field_196122_bk).func_200491_b((IItemProvider)Blocks.field_150354_m, 4).func_200491_b((IItemProvider)Blocks.field_150351_n, 4).func_200490_a("concrete_powder").func_200483_a("has_sand", (ICriterionInstance)this.func_200403_a(Blocks.field_150354_m)).func_200483_a("has_gravel", (ICriterionInstance)this.func_200403_a(Blocks.field_150351_n)).func_200482_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_196122_bk).func_200487_b((IItemProvider)Blocks.field_196610_bg).func_200490_a("light_gray_dye").func_200483_a("has_red_flower", (ICriterionInstance)this.func_200403_a(Blocks.field_196610_bg)).func_200484_a(consumer, "light_gray_dye_from_azure_bluet");
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_196122_bk, (int)2).func_200487_b((IItemProvider)Items.field_196120_bj).func_200487_b((IItemProvider)Items.field_222069_lA).func_200490_a("light_gray_dye").func_200483_a("has_gray_dye", (ICriterionInstance)this.func_200403_a(Items.field_196120_bj)).func_200483_a("has_white_dye", (ICriterionInstance)this.func_200403_a(Items.field_222069_lA)).func_200484_a(consumer, "light_gray_dye_from_gray_white_dye");
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_196122_bk, (int)3).func_200487_b((IItemProvider)Items.field_222086_lz).func_200491_b((IItemProvider)Items.field_222069_lA, 2).func_200490_a("light_gray_dye").func_200483_a("has_white_dye", (ICriterionInstance)this.func_200403_a(Items.field_222069_lA)).func_200483_a("has_black_dye", (ICriterionInstance)this.func_200403_a(Items.field_222086_lz)).func_200484_a(consumer, "light_gray_dye_from_black_white_dye");
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_196122_bk).func_200487_b((IItemProvider)Blocks.field_196616_bl).func_200490_a("light_gray_dye").func_200483_a("has_red_flower", (ICriterionInstance)this.func_200403_a(Blocks.field_196616_bl)).func_200484_a(consumer, "light_gray_dye_from_oxeye_daisy");
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_196122_bk).func_200487_b((IItemProvider)Blocks.field_196614_bj).func_200490_a("light_gray_dye").func_200483_a("has_red_flower", (ICriterionInstance)this.func_200403_a(Blocks.field_196614_bj)).func_200484_a(consumer, "light_gray_dye_from_white_tulip");
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196816_gr, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150359_w).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_196122_bk).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200473_b("stained_glass").func_200465_a("has_glass", (ICriterionInstance)this.func_200403_a(Blocks.field_150359_w)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196767_gH, (int)16).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196816_gr).func_200472_a("###").func_200472_a("###").func_200473_b("stained_glass_pane").func_200465_a("has_glass", (ICriterionInstance)this.func_200403_a(Blocks.field_150359_w)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196767_gH, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150410_aZ).func_200462_a(Character.valueOf('$'), (IItemProvider)Items.field_196122_bk).func_200472_a("###").func_200472_a("#$#").func_200472_a("###").func_200473_b("stained_glass_pane").func_200465_a("has_glass_pane", (ICriterionInstance)this.func_200403_a(Blocks.field_150410_aZ)).func_200465_a("has_light_gray_dye", (ICriterionInstance)this.func_200403_a(Items.field_196122_bk)).func_200466_a(consumer, "light_gray_stained_glass_pane_from_glass_pane");
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196791_fw, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150405_ch).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_196122_bk).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200473_b("stained_terracotta").func_200465_a("has_terracotta", (ICriterionInstance)this.func_200403_a(Blocks.field_150405_ch)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Blocks.field_196564_aT).func_200487_b((IItemProvider)Items.field_196122_bk).func_200487_b((IItemProvider)Blocks.field_196556_aL).func_200490_a("wool").func_200483_a("has_white_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196556_aL)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150445_bS).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151043_k).func_200472_a("##").func_200465_a("has_gold_ingot", (ICriterionInstance)this.func_200403_a(Items.field_151043_k)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_196196_el).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196561_aQ).func_200462_a(Character.valueOf('|'), (IItemProvider)Items.field_151055_y).func_200472_a("###").func_200472_a("###").func_200472_a(" | ").func_200473_b("banner").func_200465_a("has_lime_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196561_aQ)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_196150_bz).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196561_aQ).func_200469_a(Character.valueOf('X'), ItemTags.field_199905_b).func_200472_a("###").func_200472_a("XXX").func_200473_b("bed").func_200465_a("has_lime_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196561_aQ)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_196150_bz).func_200487_b((IItemProvider)Items.field_196140_bu).func_200487_b((IItemProvider)Items.field_196116_bh).func_200490_a("dyed_bed").func_200483_a("has_bed", (ICriterionInstance)this.func_200403_a(Items.field_196140_bu)).func_200484_a(consumer, "lime_bed_from_white_bed");
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196733_fM, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196561_aQ).func_200472_a("##").func_200473_b("carpet").func_200465_a("has_lime_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196561_aQ)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196733_fM, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196724_fH).func_200462_a(Character.valueOf('$'), (IItemProvider)Items.field_196116_bh).func_200472_a("###").func_200472_a("#$#").func_200472_a("###").func_200473_b("carpet").func_200465_a("has_white_carpet", (ICriterionInstance)this.func_200403_a(Blocks.field_196724_fH)).func_200465_a("has_lime_dye", (ICriterionInstance)this.func_200403_a(Items.field_196116_bh)).func_200466_a(consumer, "lime_carpet_from_white_carpet");
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Blocks.field_196870_iX, (int)8).func_200487_b((IItemProvider)Items.field_196116_bh).func_200491_b((IItemProvider)Blocks.field_150354_m, 4).func_200491_b((IItemProvider)Blocks.field_150351_n, 4).func_200490_a("concrete_powder").func_200483_a("has_sand", (ICriterionInstance)this.func_200403_a(Blocks.field_150354_m)).func_200483_a("has_gravel", (ICriterionInstance)this.func_200403_a(Blocks.field_150351_n)).func_200482_a(consumer);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_196116_bh, (int)2).func_200487_b((IItemProvider)Items.field_222079_lj).func_200487_b((IItemProvider)Items.field_222069_lA).func_200483_a("has_green_dye", (ICriterionInstance)this.func_200403_a(Items.field_222079_lj)).func_200483_a("has_white_dye", (ICriterionInstance)this.func_200403_a(Items.field_222069_lA)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196812_go, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150359_w).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_196116_bh).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200473_b("stained_glass").func_200465_a("has_glass", (ICriterionInstance)this.func_200403_a(Blocks.field_150359_w)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196763_gE, (int)16).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196812_go).func_200472_a("###").func_200472_a("###").func_200473_b("stained_glass_pane").func_200465_a("has_glass", (ICriterionInstance)this.func_200403_a(Blocks.field_150359_w)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196763_gE, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150410_aZ).func_200462_a(Character.valueOf('$'), (IItemProvider)Items.field_196116_bh).func_200472_a("###").func_200472_a("#$#").func_200472_a("###").func_200473_b("stained_glass_pane").func_200465_a("has_glass_pane", (ICriterionInstance)this.func_200403_a(Blocks.field_150410_aZ)).func_200465_a("has_lime_dye", (ICriterionInstance)this.func_200403_a(Items.field_196116_bh)).func_200466_a(consumer, "lime_stained_glass_pane_from_glass_pane");
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196785_ft, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150405_ch).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_196116_bh).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200473_b("stained_terracotta").func_200465_a("has_terracotta", (ICriterionInstance)this.func_200403_a(Blocks.field_150405_ch)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Blocks.field_196561_aQ).func_200487_b((IItemProvider)Items.field_196116_bh).func_200487_b((IItemProvider)Blocks.field_196556_aL).func_200490_a("wool").func_200483_a("has_white_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196556_aL)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_196628_cT).func_200462_a(Character.valueOf('A'), (IItemProvider)Blocks.field_196625_cS).func_200462_a(Character.valueOf('B'), (IItemProvider)Blocks.field_150478_aa).func_200472_a("A").func_200472_a("B").func_200465_a("has_carved_pumpkin", (ICriterionInstance)this.func_200403_a(Blocks.field_196625_cS)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_196193_ei).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196558_aN).func_200462_a(Character.valueOf('|'), (IItemProvider)Items.field_151055_y).func_200472_a("###").func_200472_a("###").func_200472_a(" | ").func_200473_b("banner").func_200465_a("has_magenta_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196558_aN)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_196144_bw).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196558_aN).func_200469_a(Character.valueOf('X'), ItemTags.field_199905_b).func_200472_a("###").func_200472_a("XXX").func_200473_b("bed").func_200465_a("has_magenta_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196558_aN)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_196144_bw).func_200487_b((IItemProvider)Items.field_196140_bu).func_200487_b((IItemProvider)Items.field_196110_be).func_200490_a("dyed_bed").func_200483_a("has_bed", (ICriterionInstance)this.func_200403_a(Items.field_196140_bu)).func_200484_a(consumer, "magenta_bed_from_white_bed");
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196727_fJ, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196558_aN).func_200472_a("##").func_200473_b("carpet").func_200465_a("has_magenta_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196558_aN)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196727_fJ, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196724_fH).func_200462_a(Character.valueOf('$'), (IItemProvider)Items.field_196110_be).func_200472_a("###").func_200472_a("#$#").func_200472_a("###").func_200473_b("carpet").func_200465_a("has_white_carpet", (ICriterionInstance)this.func_200403_a(Blocks.field_196724_fH)).func_200465_a("has_magenta_dye", (ICriterionInstance)this.func_200403_a(Items.field_196110_be)).func_200466_a(consumer, "magenta_carpet_from_white_carpet");
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Blocks.field_196864_iU, (int)8).func_200487_b((IItemProvider)Items.field_196110_be).func_200491_b((IItemProvider)Blocks.field_150354_m, 4).func_200491_b((IItemProvider)Blocks.field_150351_n, 4).func_200490_a("concrete_powder").func_200483_a("has_sand", (ICriterionInstance)this.func_200403_a(Blocks.field_150354_m)).func_200483_a("has_gravel", (ICriterionInstance)this.func_200403_a(Blocks.field_150351_n)).func_200482_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_196110_be).func_200487_b((IItemProvider)Blocks.field_196609_bf).func_200490_a("magenta_dye").func_200483_a("has_red_flower", (ICriterionInstance)this.func_200403_a(Blocks.field_196609_bf)).func_200484_a(consumer, "magenta_dye_from_allium");
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_196110_be, (int)4).func_200487_b((IItemProvider)Items.field_222083_lx).func_200491_b((IItemProvider)Items.field_222078_li, 2).func_200487_b((IItemProvider)Items.field_222069_lA).func_200490_a("magenta_dye").func_200483_a("has_blue_dye", (ICriterionInstance)this.func_200403_a(Items.field_222083_lx)).func_200483_a("has_rose_red", (ICriterionInstance)this.func_200403_a(Items.field_222078_li)).func_200483_a("has_white_dye", (ICriterionInstance)this.func_200403_a(Items.field_222069_lA)).func_200484_a(consumer, "magenta_dye_from_blue_red_white_dye");
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_196110_be, (int)3).func_200487_b((IItemProvider)Items.field_222083_lx).func_200487_b((IItemProvider)Items.field_222078_li).func_200487_b((IItemProvider)Items.field_196118_bi).func_200490_a("magenta_dye").func_200483_a("has_pink_dye", (ICriterionInstance)this.func_200403_a(Items.field_196118_bi)).func_200483_a("has_blue_dye", (ICriterionInstance)this.func_200403_a(Items.field_222083_lx)).func_200483_a("has_red_dye", (ICriterionInstance)this.func_200403_a(Items.field_222078_li)).func_200484_a(consumer, "magenta_dye_from_blue_red_pink");
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_196110_be, (int)2).func_200487_b((IItemProvider)Blocks.field_196801_ge).func_200490_a("magenta_dye").func_200483_a("has_double_plant", (ICriterionInstance)this.func_200403_a(Blocks.field_196801_ge)).func_200484_a(consumer, "magenta_dye_from_lilac");
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_196110_be, (int)2).func_200487_b((IItemProvider)Items.field_196126_bm).func_200487_b((IItemProvider)Items.field_196118_bi).func_200490_a("magenta_dye").func_200483_a("has_pink_dye", (ICriterionInstance)this.func_200403_a(Items.field_196118_bi)).func_200483_a("has_purple_dye", (ICriterionInstance)this.func_200403_a(Items.field_196126_bm)).func_200484_a(consumer, "magenta_dye_from_purple_and_pink");
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196809_gl, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150359_w).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_196110_be).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200473_b("stained_glass").func_200465_a("has_glass", (ICriterionInstance)this.func_200403_a(Blocks.field_150359_w)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196759_gB, (int)16).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196809_gl).func_200472_a("###").func_200472_a("###").func_200473_b("stained_glass_pane").func_200465_a("has_glass", (ICriterionInstance)this.func_200403_a(Blocks.field_150359_w)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196759_gB, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150410_aZ).func_200462_a(Character.valueOf('$'), (IItemProvider)Items.field_196110_be).func_200472_a("###").func_200472_a("#$#").func_200472_a("###").func_200473_b("stained_glass_pane").func_200465_a("has_glass_pane", (ICriterionInstance)this.func_200403_a(Blocks.field_150410_aZ)).func_200465_a("has_magenta_dye", (ICriterionInstance)this.func_200403_a(Items.field_196110_be)).func_200466_a(consumer, "magenta_stained_glass_pane_from_glass_pane");
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196780_fq, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150405_ch).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_196110_be).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200473_b("stained_terracotta").func_200465_a("has_terracotta", (ICriterionInstance)this.func_200403_a(Blocks.field_150405_ch)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Blocks.field_196558_aN).func_200487_b((IItemProvider)Items.field_196110_be).func_200487_b((IItemProvider)Blocks.field_196556_aL).func_200490_a("wool").func_200483_a("has_white_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196556_aL)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_196814_hQ).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151064_bs).func_200472_a("##").func_200472_a("##").func_200465_a("has_magma_cream", (ICriterionInstance)this.func_200403_a(Items.field_151064_bs)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_151064_bs).func_200487_b((IItemProvider)Items.field_151065_br).func_200487_b((IItemProvider)Items.field_151123_aH).func_200483_a("has_blaze_powder", (ICriterionInstance)this.func_200403_a(Items.field_151065_br)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151148_bJ).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151121_aF).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151111_aL).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200465_a("has_compass", (ICriterionInstance)this.func_200403_a(Items.field_151111_aL)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150440_ba).func_200462_a(Character.valueOf('M'), (IItemProvider)Items.field_151127_ba).func_200472_a("MMM").func_200472_a("MMM").func_200472_a("MMM").func_200465_a("has_melon", (ICriterionInstance)this.func_200403_a(Items.field_151127_ba)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_151081_bc).func_200487_b((IItemProvider)Items.field_151127_ba).func_200483_a("has_melon", (ICriterionInstance)this.func_200403_a(Items.field_151127_ba)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151143_au).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151042_j).func_200472_a("# #").func_200472_a("###").func_200465_a("has_iron_ingot", (ICriterionInstance)this.func_200403_a(Items.field_151042_j)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Blocks.field_150341_Y).func_200487_b((IItemProvider)Blocks.field_150347_e).func_200487_b((IItemProvider)Blocks.field_150395_bd).func_200483_a("has_vine", (ICriterionInstance)this.func_200403_a(Blocks.field_150395_bd)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196723_eg, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150341_Y).func_200472_a("###").func_200472_a("###").func_200465_a("has_mossy_cobblestone", (ICriterionInstance)this.func_200403_a(Blocks.field_150341_Y)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Blocks.field_196698_dj).func_200487_b((IItemProvider)Blocks.field_196696_di).func_200487_b((IItemProvider)Blocks.field_150395_bd).func_200483_a("has_mossy_cobblestone", (ICriterionInstance)this.func_200403_a(Blocks.field_150341_Y)).func_200482_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_151009_A).func_200487_b((IItemProvider)Blocks.field_150338_P).func_200487_b((IItemProvider)Blocks.field_150337_Q).func_200487_b((IItemProvider)Items.field_151054_z).func_200483_a("has_mushroom_stew", (ICriterionInstance)this.func_200403_a(Items.field_151009_A)).func_200483_a("has_bowl", (ICriterionInstance)this.func_200403_a(Items.field_151054_z)).func_200483_a("has_brown_mushroom", (ICriterionInstance)this.func_200403_a(Blocks.field_150338_P)).func_200483_a("has_red_mushroom", (ICriterionInstance)this.func_200403_a(Blocks.field_150337_Q)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_196653_dH).func_200462_a(Character.valueOf('N'), (IItemProvider)Items.field_196154_dH).func_200472_a("NN").func_200472_a("NN").func_200465_a("has_netherbrick", (ICriterionInstance)this.func_200403_a(Items.field_196154_dH)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_150386_bk, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196653_dH).func_200462_a(Character.valueOf('-'), (IItemProvider)Items.field_196154_dH).func_200472_a("#-#").func_200472_a("#-#").func_200465_a("has_nether_brick", (ICriterionInstance)this.func_200403_a(Blocks.field_196653_dH)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196575_bC, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196653_dH).func_200472_a("###").func_200465_a("has_nether_brick", (ICriterionInstance)this.func_200403_a(Blocks.field_196653_dH)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_150387_bl, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196653_dH).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_nether_brick", (ICriterionInstance)this.func_200403_a(Blocks.field_196653_dH)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_189878_dg).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151075_bm).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200465_a("has_nether_wart", (ICriterionInstance)this.func_200403_a(Items.field_151075_bm)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_196586_al).func_200469_a(Character.valueOf('#'), ItemTags.field_199905_b).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151137_ax).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200465_a("has_redstone", (ICriterionInstance)this.func_200403_a(Items.field_151137_ax)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196626_Q, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196617_K).func_200472_a("##").func_200472_a("##").func_200473_b("bark").func_200465_a("has_log", (ICriterionInstance)this.func_200403_a(Blocks.field_196617_K)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_209389_ab, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_203204_R).func_200472_a("##").func_200472_a("##").func_200473_b("bark").func_200465_a("has_log", (ICriterionInstance)this.func_200403_a(Blocks.field_203204_R)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Blocks.field_196689_eF).func_200487_b((IItemProvider)Blocks.field_196662_n).func_200490_a("wooden_button").func_200483_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196662_n)).func_200482_a(consumer);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Blocks.field_196662_n, (int)4).func_203221_a(ItemTags.field_203295_o).func_200490_a("planks").func_200483_a("has_log", (ICriterionInstance)this.func_200409_a(ItemTags.field_203295_o)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_196663_cq).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196662_n).func_200472_a("##").func_200473_b("wooden_pressure_plate").func_200465_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196662_n)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196622_bq, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196662_n).func_200472_a("###").func_200473_b("wooden_slab").func_200465_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196662_n)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_150476_ad, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196662_n).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200473_b("wooden_stairs").func_200465_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196662_n)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196636_cW, (int)2).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196662_n).func_200472_a("###").func_200472_a("###").func_200473_b("wooden_trapdoor").func_200465_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196662_n)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_190976_dk).func_200462_a(Character.valueOf('Q'), (IItemProvider)Items.field_151128_bU).func_200462_a(Character.valueOf('R'), (IItemProvider)Items.field_151137_ax).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150347_e).func_200472_a("###").func_200472_a("RRQ").func_200472_a("###").func_200465_a("has_quartz", (ICriterionInstance)this.func_200403_a(Items.field_151128_bU)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_196192_eh).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196557_aM).func_200462_a(Character.valueOf('|'), (IItemProvider)Items.field_151055_y).func_200472_a("###").func_200472_a("###").func_200472_a(" | ").func_200473_b("banner").func_200465_a("has_orange_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196557_aM)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_196142_bv).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196557_aM).func_200469_a(Character.valueOf('X'), ItemTags.field_199905_b).func_200472_a("###").func_200472_a("XXX").func_200473_b("bed").func_200465_a("has_orange_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196557_aM)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_196142_bv).func_200487_b((IItemProvider)Items.field_196140_bu).func_200487_b((IItemProvider)Items.field_196108_bd).func_200490_a("dyed_bed").func_200483_a("has_bed", (ICriterionInstance)this.func_200403_a(Items.field_196140_bu)).func_200484_a(consumer, "orange_bed_from_white_bed");
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196725_fI, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196557_aM).func_200472_a("##").func_200473_b("carpet").func_200465_a("has_orange_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196557_aM)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196725_fI, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196724_fH).func_200462_a(Character.valueOf('$'), (IItemProvider)Items.field_196108_bd).func_200472_a("###").func_200472_a("#$#").func_200472_a("###").func_200473_b("carpet").func_200465_a("has_white_carpet", (ICriterionInstance)this.func_200403_a(Blocks.field_196724_fH)).func_200465_a("has_oramge_dye", (ICriterionInstance)this.func_200403_a(Items.field_196108_bd)).func_200466_a(consumer, "orange_carpet_from_white_carpet");
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Blocks.field_196862_iT, (int)8).func_200487_b((IItemProvider)Items.field_196108_bd).func_200491_b((IItemProvider)Blocks.field_150354_m, 4).func_200491_b((IItemProvider)Blocks.field_150351_n, 4).func_200490_a("concrete_powder").func_200483_a("has_sand", (ICriterionInstance)this.func_200403_a(Blocks.field_150354_m)).func_200483_a("has_gravel", (ICriterionInstance)this.func_200403_a(Blocks.field_150351_n)).func_200482_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_196108_bd).func_200487_b((IItemProvider)Blocks.field_196613_bi).func_200490_a("orange_dye").func_200483_a("has_red_flower", (ICriterionInstance)this.func_200403_a(Blocks.field_196613_bi)).func_200484_a(consumer, "orange_dye_from_orange_tulip");
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_196108_bd, (int)2).func_200487_b((IItemProvider)Items.field_222078_li).func_200487_b((IItemProvider)Items.field_222081_ls).func_200490_a("orange_dye").func_200483_a("has_red_dye", (ICriterionInstance)this.func_200403_a(Items.field_222078_li)).func_200483_a("has_yellow_dye", (ICriterionInstance)this.func_200403_a(Items.field_222081_ls)).func_200484_a(consumer, "orange_dye_from_red_yellow");
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196808_gk, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150359_w).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_196108_bd).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200473_b("stained_glass").func_200465_a("has_glass", (ICriterionInstance)this.func_200403_a(Blocks.field_150359_w)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196758_gA, (int)16).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196808_gk).func_200472_a("###").func_200472_a("###").func_200473_b("stained_glass_pane").func_200465_a("has_glass", (ICriterionInstance)this.func_200403_a(Blocks.field_150359_w)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196758_gA, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150410_aZ).func_200462_a(Character.valueOf('$'), (IItemProvider)Items.field_196108_bd).func_200472_a("###").func_200472_a("#$#").func_200472_a("###").func_200473_b("stained_glass_pane").func_200465_a("has_glass_pane", (ICriterionInstance)this.func_200403_a(Blocks.field_150410_aZ)).func_200465_a("has_orange_dye", (ICriterionInstance)this.func_200403_a(Items.field_196108_bd)).func_200466_a(consumer, "orange_stained_glass_pane_from_glass_pane");
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196778_fp, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150405_ch).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_196108_bd).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200473_b("stained_terracotta").func_200465_a("has_terracotta", (ICriterionInstance)this.func_200403_a(Blocks.field_150405_ch)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Blocks.field_196557_aM).func_200487_b((IItemProvider)Items.field_196108_bd).func_200487_b((IItemProvider)Blocks.field_196556_aL).func_200490_a("wool").func_200483_a("has_white_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196556_aL)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151159_an).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200471_a(Character.valueOf('X'), Ingredient.func_199805_a(ItemTags.field_199904_a)).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200465_a("has_wool", (ICriterionInstance)this.func_200409_a(ItemTags.field_199904_a)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Items.field_151121_aF, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196608_cF).func_200472_a("###").func_200465_a("has_reeds", (ICriterionInstance)this.func_200403_a(Blocks.field_196608_cF)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196770_fj, (int)2).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150371_ca).func_200472_a("#").func_200472_a("#").func_200465_a("has_chiseled_quartz_block", (ICriterionInstance)this.func_200403_a(Blocks.field_196772_fk)).func_200465_a("has_quartz_block", (ICriterionInstance)this.func_200403_a(Blocks.field_150371_ca)).func_200465_a("has_quartz_pillar", (ICriterionInstance)this.func_200403_a(Blocks.field_196770_fj)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Blocks.field_150403_cj).func_200491_b((IItemProvider)Blocks.field_150432_aD, 9).func_200483_a("has_ice", (ICriterionInstance)this.func_200403_a(Blocks.field_150432_aD)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_196197_em).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196562_aR).func_200462_a(Character.valueOf('|'), (IItemProvider)Items.field_151055_y).func_200472_a("###").func_200472_a("###").func_200472_a(" | ").func_200473_b("banner").func_200465_a("has_pink_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196562_aR)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_196090_bA).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196562_aR).func_200469_a(Character.valueOf('X'), ItemTags.field_199905_b).func_200472_a("###").func_200472_a("XXX").func_200473_b("bed").func_200465_a("has_pink_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196562_aR)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_196090_bA).func_200487_b((IItemProvider)Items.field_196140_bu).func_200487_b((IItemProvider)Items.field_196118_bi).func_200490_a("dyed_bed").func_200483_a("has_bed", (ICriterionInstance)this.func_200403_a(Items.field_196140_bu)).func_200484_a(consumer, "pink_bed_from_white_bed");
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196735_fN, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196562_aR).func_200472_a("##").func_200473_b("carpet").func_200465_a("has_pink_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196562_aR)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196735_fN, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196724_fH).func_200462_a(Character.valueOf('$'), (IItemProvider)Items.field_196118_bi).func_200472_a("###").func_200472_a("#$#").func_200472_a("###").func_200473_b("carpet").func_200465_a("has_white_carpet", (ICriterionInstance)this.func_200403_a(Blocks.field_196724_fH)).func_200465_a("has_pink_dye", (ICriterionInstance)this.func_200403_a(Items.field_196118_bi)).func_200466_a(consumer, "pink_carpet_from_white_carpet");
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Blocks.field_196872_iY, (int)8).func_200487_b((IItemProvider)Items.field_196118_bi).func_200491_b((IItemProvider)Blocks.field_150354_m, 4).func_200491_b((IItemProvider)Blocks.field_150351_n, 4).func_200490_a("concrete_powder").func_200483_a("has_sand", (ICriterionInstance)this.func_200403_a(Blocks.field_150354_m)).func_200483_a("has_gravel", (ICriterionInstance)this.func_200403_a(Blocks.field_150351_n)).func_200482_a(consumer);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_196118_bi, (int)2).func_200487_b((IItemProvider)Blocks.field_196803_gg).func_200490_a("pink_dye").func_200483_a("has_double_plant", (ICriterionInstance)this.func_200403_a(Blocks.field_196803_gg)).func_200484_a(consumer, "pink_dye_from_peony");
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_196118_bi).func_200487_b((IItemProvider)Blocks.field_196615_bk).func_200490_a("pink_dye").func_200483_a("has_red_flower", (ICriterionInstance)this.func_200403_a(Blocks.field_196615_bk)).func_200484_a(consumer, "pink_dye_from_pink_tulip");
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_196118_bi, (int)2).func_200487_b((IItemProvider)Items.field_222078_li).func_200487_b((IItemProvider)Items.field_222069_lA).func_200490_a("pink_dye").func_200483_a("has_white_dye", (ICriterionInstance)this.func_200403_a(Items.field_222069_lA)).func_200483_a("has_red_dye", (ICriterionInstance)this.func_200403_a(Items.field_222078_li)).func_200484_a(consumer, "pink_dye_from_red_white_dye");
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196813_gp, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150359_w).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_196118_bi).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200473_b("stained_glass").func_200465_a("has_glass", (ICriterionInstance)this.func_200403_a(Blocks.field_150359_w)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196764_gF, (int)16).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196813_gp).func_200472_a("###").func_200472_a("###").func_200473_b("stained_glass_pane").func_200465_a("has_glass", (ICriterionInstance)this.func_200403_a(Blocks.field_150359_w)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196764_gF, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150410_aZ).func_200462_a(Character.valueOf('$'), (IItemProvider)Items.field_196118_bi).func_200472_a("###").func_200472_a("#$#").func_200472_a("###").func_200473_b("stained_glass_pane").func_200465_a("has_glass_pane", (ICriterionInstance)this.func_200403_a(Blocks.field_150410_aZ)).func_200465_a("has_pink_dye", (ICriterionInstance)this.func_200403_a(Items.field_196118_bi)).func_200466_a(consumer, "pink_stained_glass_pane_from_glass_pane");
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196787_fu, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150405_ch).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_196118_bi).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200473_b("stained_terracotta").func_200465_a("has_terracotta", (ICriterionInstance)this.func_200403_a(Blocks.field_150405_ch)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Blocks.field_196562_aR).func_200487_b((IItemProvider)Items.field_196118_bi).func_200487_b((IItemProvider)Blocks.field_196556_aL).func_200490_a("wool").func_200483_a("has_white_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196556_aL)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150331_J).func_200462_a(Character.valueOf('R'), (IItemProvider)Items.field_151137_ax).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150347_e).func_200469_a(Character.valueOf('T'), ItemTags.field_199905_b).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151042_j).func_200472_a("TTT").func_200472_a("#X#").func_200472_a("#R#").func_200465_a("has_redstone", (ICriterionInstance)this.func_200403_a(Items.field_151137_ax)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196652_d, (int)4).func_200462_a(Character.valueOf('S'), (IItemProvider)Blocks.field_196650_c).func_200472_a("SS").func_200472_a("SS").func_200465_a("has_stone", (ICriterionInstance)this.func_200403_a(Blocks.field_196650_c)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196655_f, (int)4).func_200462_a(Character.valueOf('S'), (IItemProvider)Blocks.field_196654_e).func_200472_a("SS").func_200472_a("SS").func_200465_a("has_stone", (ICriterionInstance)this.func_200403_a(Blocks.field_196654_e)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196657_h, (int)4).func_200462_a(Character.valueOf('S'), (IItemProvider)Blocks.field_196656_g).func_200472_a("SS").func_200472_a("SS").func_200465_a("has_stone", (ICriterionInstance)this.func_200403_a(Blocks.field_196656_g)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_180397_cI).func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_179562_cC).func_200472_a("SS").func_200472_a("SS").func_200465_a("has_prismarine_shard", (ICriterionInstance)this.func_200403_a(Items.field_179562_cC)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_196779_gQ).func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_179562_cC).func_200472_a("SSS").func_200472_a("SSS").func_200472_a("SSS").func_200465_a("has_prismarine_shard", (ICriterionInstance)this.func_200403_a(Items.field_179562_cC)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_203200_bP, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_180397_cI).func_200472_a("###").func_200465_a("has_prismarine", (ICriterionInstance)this.func_200403_a(Blocks.field_180397_cI)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_203201_bQ, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196779_gQ).func_200472_a("###").func_200465_a("has_prismarine_bricks", (ICriterionInstance)this.func_200403_a(Blocks.field_196779_gQ)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_203202_bR, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196781_gR).func_200472_a("###").func_200465_a("has_dark_prismarine", (ICriterionInstance)this.func_200403_a(Blocks.field_196781_gR)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_151158_bO).func_200487_b((IItemProvider)Blocks.field_150423_aK).func_200487_b((IItemProvider)Items.field_151102_aT).func_200487_b((IItemProvider)Items.field_151110_aK).func_200483_a("has_carved_pumpkin", (ICriterionInstance)this.func_200403_a(Blocks.field_196625_cS)).func_200483_a("has_pumpkin", (ICriterionInstance)this.func_200403_a(Blocks.field_150423_aK)).func_200482_a(consumer);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_151080_bb, (int)4).func_200487_b((IItemProvider)Blocks.field_150423_aK).func_200483_a("has_pumpkin", (ICriterionInstance)this.func_200403_a(Blocks.field_150423_aK)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_196201_eq).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196566_aV).func_200462_a(Character.valueOf('|'), (IItemProvider)Items.field_151055_y).func_200472_a("###").func_200472_a("###").func_200472_a(" | ").func_200473_b("banner").func_200465_a("has_purple_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196566_aV)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_196094_bE).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196566_aV).func_200469_a(Character.valueOf('X'), ItemTags.field_199905_b).func_200472_a("###").func_200472_a("XXX").func_200473_b("bed").func_200465_a("has_purple_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196566_aV)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_196094_bE).func_200487_b((IItemProvider)Items.field_196140_bu).func_200487_b((IItemProvider)Items.field_196126_bm).func_200490_a("dyed_bed").func_200483_a("has_bed", (ICriterionInstance)this.func_200403_a(Items.field_196140_bu)).func_200484_a(consumer, "purple_bed_from_white_bed");
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196743_fR, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196566_aV).func_200472_a("##").func_200473_b("carpet").func_200465_a("has_purple_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196566_aV)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196743_fR, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196724_fH).func_200462_a(Character.valueOf('$'), (IItemProvider)Items.field_196126_bm).func_200472_a("###").func_200472_a("#$#").func_200472_a("###").func_200473_b("carpet").func_200465_a("has_white_carpet", (ICriterionInstance)this.func_200403_a(Blocks.field_196724_fH)).func_200465_a("has_purple_dye", (ICriterionInstance)this.func_200403_a(Items.field_196126_bm)).func_200466_a(consumer, "purple_carpet_from_white_carpet");
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Blocks.field_196879_jc, (int)8).func_200487_b((IItemProvider)Items.field_196126_bm).func_200491_b((IItemProvider)Blocks.field_150354_m, 4).func_200491_b((IItemProvider)Blocks.field_150351_n, 4).func_200490_a("concrete_powder").func_200483_a("has_sand", (ICriterionInstance)this.func_200403_a(Blocks.field_150354_m)).func_200483_a("has_gravel", (ICriterionInstance)this.func_200403_a(Blocks.field_150351_n)).func_200482_a(consumer);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_196126_bm, (int)2).func_200487_b((IItemProvider)Items.field_222083_lx).func_200487_b((IItemProvider)Items.field_222078_li).func_200483_a("has_blue_dye", (ICriterionInstance)this.func_200403_a(Items.field_222083_lx)).func_200483_a("has_red_dye", (ICriterionInstance)this.func_200403_a(Items.field_222078_li)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_204409_il).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150486_ae).func_200462_a(Character.valueOf('-'), (IItemProvider)Items.field_190930_cZ).func_200472_a("-").func_200472_a("#").func_200472_a("-").func_200465_a("has_shulker_shell", (ICriterionInstance)this.func_200403_a(Items.field_190930_cZ)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196819_gt, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150359_w).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_196126_bm).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200473_b("stained_glass").func_200465_a("has_glass", (ICriterionInstance)this.func_200403_a(Blocks.field_150359_w)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196769_gJ, (int)16).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196819_gt).func_200472_a("###").func_200472_a("###").func_200473_b("stained_glass_pane").func_200465_a("has_glass", (ICriterionInstance)this.func_200403_a(Blocks.field_150359_w)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196769_gJ, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150410_aZ).func_200462_a(Character.valueOf('$'), (IItemProvider)Items.field_196126_bm).func_200472_a("###").func_200472_a("#$#").func_200472_a("###").func_200473_b("stained_glass_pane").func_200465_a("has_glass_pane", (ICriterionInstance)this.func_200403_a(Blocks.field_150410_aZ)).func_200465_a("has_purple_dye", (ICriterionInstance)this.func_200403_a(Items.field_196126_bm)).func_200466_a(consumer, "purple_stained_glass_pane_from_glass_pane");
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196795_fy, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150405_ch).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_196126_bm).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200473_b("stained_terracotta").func_200465_a("has_terracotta", (ICriterionInstance)this.func_200403_a(Blocks.field_150405_ch)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Blocks.field_196566_aV).func_200487_b((IItemProvider)Items.field_196126_bm).func_200487_b((IItemProvider)Blocks.field_196556_aL).func_200490_a("wool").func_200483_a("has_white_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196556_aL)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_185767_cT, (int)4).func_200462_a(Character.valueOf('F'), (IItemProvider)Items.field_185162_cT).func_200472_a("FF").func_200472_a("FF").func_200465_a("has_chorus_fruit_popped", (ICriterionInstance)this.func_200403_a(Items.field_185162_cT)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_185768_cU).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_185771_cX).func_200472_a("#").func_200472_a("#").func_200465_a("has_purpur_block", (ICriterionInstance)this.func_200403_a(Blocks.field_185767_cT)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_185771_cX, (int)6).func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a(Blocks.field_185767_cT, Blocks.field_185768_cU)).func_200472_a("###").func_200465_a("has_purpur_block", (ICriterionInstance)this.func_200403_a(Blocks.field_185767_cT)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_185769_cV, (int)4).func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a(Blocks.field_185767_cT, Blocks.field_185768_cU)).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_purpur_block", (ICriterionInstance)this.func_200403_a(Blocks.field_185767_cT)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150371_ca).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151128_bU).func_200472_a("##").func_200472_a("##").func_200465_a("has_quartz", (ICriterionInstance)this.func_200403_a(Items.field_151128_bU)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196576_bD, (int)6).func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a(Blocks.field_196772_fk, Blocks.field_150371_ca, Blocks.field_196770_fj)).func_200472_a("###").func_200465_a("has_chiseled_quartz_block", (ICriterionInstance)this.func_200403_a(Blocks.field_196772_fk)).func_200465_a("has_quartz_block", (ICriterionInstance)this.func_200403_a(Blocks.field_150371_ca)).func_200465_a("has_quartz_pillar", (ICriterionInstance)this.func_200403_a(Blocks.field_196770_fj)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_150370_cb, (int)4).func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a(Blocks.field_196772_fk, Blocks.field_150371_ca, Blocks.field_196770_fj)).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_chiseled_quartz_block", (ICriterionInstance)this.func_200403_a(Blocks.field_196772_fk)).func_200465_a("has_quartz_block", (ICriterionInstance)this.func_200403_a(Blocks.field_150371_ca)).func_200465_a("has_quartz_pillar", (ICriterionInstance)this.func_200403_a(Blocks.field_196770_fj)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_179560_bq).func_200487_b((IItemProvider)Items.field_151168_bH).func_200487_b((IItemProvider)Items.field_179559_bp).func_200487_b((IItemProvider)Items.field_151054_z).func_200487_b((IItemProvider)Items.field_151172_bF).func_200487_b((IItemProvider)Blocks.field_150338_P).func_200490_a("rabbit_stew").func_200483_a("has_cooked_rabbit", (ICriterionInstance)this.func_200403_a(Items.field_179559_bp)).func_200484_a(consumer, "rabbit_stew_from_brown_mushroom");
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_179560_bq).func_200487_b((IItemProvider)Items.field_151168_bH).func_200487_b((IItemProvider)Items.field_179559_bp).func_200487_b((IItemProvider)Items.field_151054_z).func_200487_b((IItemProvider)Items.field_151172_bF).func_200487_b((IItemProvider)Blocks.field_150337_Q).func_200490_a("rabbit_stew").func_200483_a("has_cooked_rabbit", (ICriterionInstance)this.func_200403_a(Items.field_179559_bp)).func_200484_a(consumer, "rabbit_stew_from_red_mushroom");
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_150448_aq, (int)16).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151042_j).func_200472_a("X X").func_200472_a("X#X").func_200472_a("X X").func_200465_a("has_minecart", (ICriterionInstance)this.func_200403_a(Items.field_151143_au)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_151137_ax, (int)9).func_200487_b((IItemProvider)Blocks.field_150451_bX).func_200483_a("has_redstone_block", (ICriterionInstance)this.func_200403_a(Blocks.field_150451_bX)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150451_bX).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151137_ax).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200465_a("has_redstone", (ICriterionInstance)this.func_200403_a(Items.field_151137_ax)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150379_bu).func_200462_a(Character.valueOf('R'), (IItemProvider)Items.field_151137_ax).func_200462_a(Character.valueOf('G'), (IItemProvider)Blocks.field_150426_aN).func_200472_a(" R ").func_200472_a("RGR").func_200472_a(" R ").func_200465_a("has_glowstone", (ICriterionInstance)this.func_200403_a(Blocks.field_150426_aN)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150429_aA).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151137_ax).func_200472_a("X").func_200472_a("#").func_200465_a("has_redstone", (ICriterionInstance)this.func_200403_a(Items.field_151137_ax)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_196205_eu).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196570_aZ).func_200462_a(Character.valueOf('|'), (IItemProvider)Items.field_151055_y).func_200472_a("###").func_200472_a("###").func_200472_a(" | ").func_200473_b("banner").func_200465_a("has_red_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196570_aZ)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_196098_bI).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196570_aZ).func_200469_a(Character.valueOf('X'), ItemTags.field_199905_b).func_200472_a("###").func_200472_a("XXX").func_200473_b("bed").func_200465_a("has_red_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196570_aZ)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_196098_bI).func_200487_b((IItemProvider)Items.field_196140_bu).func_200487_b((IItemProvider)Items.field_222078_li).func_200490_a("dyed_bed").func_200483_a("has_bed", (ICriterionInstance)this.func_200403_a(Items.field_196140_bu)).func_200484_a(consumer, "red_bed_from_white_bed");
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196751_fV, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196570_aZ).func_200472_a("##").func_200473_b("carpet").func_200465_a("has_red_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196570_aZ)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196751_fV, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196724_fH).func_200462_a(Character.valueOf('$'), (IItemProvider)Items.field_222078_li).func_200472_a("###").func_200472_a("#$#").func_200472_a("###").func_200473_b("carpet").func_200465_a("has_white_carpet", (ICriterionInstance)this.func_200403_a(Blocks.field_196724_fH)).func_200465_a("has_red_dye", (ICriterionInstance)this.func_200403_a(Items.field_222078_li)).func_200466_a(consumer, "red_carpet_from_white_carpet");
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Blocks.field_196883_jg, (int)8).func_200487_b((IItemProvider)Items.field_222078_li).func_200491_b((IItemProvider)Blocks.field_150354_m, 4).func_200491_b((IItemProvider)Blocks.field_150351_n, 4).func_200490_a("concrete_powder").func_200483_a("has_sand", (ICriterionInstance)this.func_200403_a(Blocks.field_150354_m)).func_200483_a("has_gravel", (ICriterionInstance)this.func_200403_a(Blocks.field_150351_n)).func_200482_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_222078_li).func_200487_b((IItemProvider)Items.field_185164_cV).func_200490_a("red_dye").func_200483_a("has_beetroot", (ICriterionInstance)this.func_200403_a(Items.field_185164_cV)).func_200484_a(consumer, "red_dye_from_beetroot");
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_222078_li).func_200487_b((IItemProvider)Blocks.field_196606_bd).func_200490_a("red_dye").func_200483_a("has_red_flower", (ICriterionInstance)this.func_200403_a(Blocks.field_196606_bd)).func_200484_a(consumer, "red_dye_from_poppy");
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_222078_li, (int)2).func_200487_b((IItemProvider)Blocks.field_196802_gf).func_200490_a("red_dye").func_200483_a("has_double_plant", (ICriterionInstance)this.func_200403_a(Blocks.field_196802_gf)).func_200484_a(consumer, "red_dye_from_rose_bush");
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_222078_li).func_200487_b((IItemProvider)Blocks.field_196612_bh).func_200490_a("red_dye").func_200483_a("has_red_flower", (ICriterionInstance)this.func_200403_a(Blocks.field_196612_bh)).func_200484_a(consumer, "red_dye_from_tulip");
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_196817_hS).func_200462_a(Character.valueOf('W'), (IItemProvider)Items.field_151075_bm).func_200462_a(Character.valueOf('N'), (IItemProvider)Items.field_196154_dH).func_200472_a("NW").func_200472_a("WN").func_200465_a("has_nether_wart", (ICriterionInstance)this.func_200403_a(Items.field_151075_bm)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_180395_cM).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196611_F).func_200472_a("##").func_200472_a("##").func_200465_a("has_sand", (ICriterionInstance)this.func_200403_a(Blocks.field_196611_F)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196578_bE, (int)6).func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a(Blocks.field_180395_cM, Blocks.field_196798_hA)).func_200472_a("###").func_200465_a("has_red_sandstone", (ICriterionInstance)this.func_200403_a(Blocks.field_180395_cM)).func_200465_a("has_chiseled_red_sandstone", (ICriterionInstance)this.func_200403_a(Blocks.field_196798_hA)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222403_hT, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196799_hB).func_200472_a("###").func_200465_a("has_cut_red_sandstone", (ICriterionInstance)this.func_200403_a(Blocks.field_196799_hB)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_180396_cN, (int)4).func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a(Blocks.field_180395_cM, Blocks.field_196798_hA, Blocks.field_196799_hB)).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_red_sandstone", (ICriterionInstance)this.func_200403_a(Blocks.field_180395_cM)).func_200465_a("has_chiseled_red_sandstone", (ICriterionInstance)this.func_200403_a(Blocks.field_196798_hA)).func_200465_a("has_cut_red_sandstone", (ICriterionInstance)this.func_200403_a(Blocks.field_196799_hB)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196823_gx, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150359_w).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_222078_li).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200473_b("stained_glass").func_200465_a("has_glass", (ICriterionInstance)this.func_200403_a(Blocks.field_150359_w)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196775_gN, (int)16).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196823_gx).func_200472_a("###").func_200472_a("###").func_200473_b("stained_glass_pane").func_200465_a("has_glass", (ICriterionInstance)this.func_200403_a(Blocks.field_150359_w)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196775_gN, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150410_aZ).func_200462_a(Character.valueOf('$'), (IItemProvider)Items.field_222078_li).func_200472_a("###").func_200472_a("#$#").func_200472_a("###").func_200473_b("stained_glass_pane").func_200465_a("has_glass_pane", (ICriterionInstance)this.func_200403_a(Blocks.field_150410_aZ)).func_200465_a("has_red_dye", (ICriterionInstance)this.func_200403_a(Items.field_222078_li)).func_200466_a(consumer, "red_stained_glass_pane_from_glass_pane");
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196721_fC, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150405_ch).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_222078_li).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200473_b("stained_terracotta").func_200465_a("has_terracotta", (ICriterionInstance)this.func_200403_a(Blocks.field_150405_ch)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Blocks.field_196570_aZ).func_200487_b((IItemProvider)Items.field_222078_li).func_200487_b((IItemProvider)Blocks.field_196556_aL).func_200490_a("wool").func_200483_a("has_white_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196556_aL)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_196633_cV).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150429_aA).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151137_ax).func_200462_a(Character.valueOf('I'), (IItemProvider)Blocks.field_150348_b).func_200472_a("#X#").func_200472_a("III").func_200465_a("has_redstone_torch", (ICriterionInstance)this.func_200403_a(Blocks.field_150429_aA)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150322_A).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150354_m).func_200472_a("##").func_200472_a("##").func_200465_a("has_sand", (ICriterionInstance)this.func_200403_a(Blocks.field_150354_m)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196640_bx, (int)6).func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a(Blocks.field_150322_A, Blocks.field_196583_aj)).func_200472_a("###").func_200465_a("has_sandstone", (ICriterionInstance)this.func_200403_a(Blocks.field_150322_A)).func_200465_a("has_chiseled_sandstone", (ICriterionInstance)this.func_200403_a(Blocks.field_196583_aj)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222402_hL, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196585_ak).func_200472_a("###").func_200465_a("has_cut_sandstone", (ICriterionInstance)this.func_200403_a(Blocks.field_196585_ak)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_150372_bz, (int)4).func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a(Blocks.field_150322_A, Blocks.field_196583_aj, Blocks.field_196585_ak)).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_sandstone", (ICriterionInstance)this.func_200403_a(Blocks.field_150322_A)).func_200465_a("has_chiseled_sandstone", (ICriterionInstance)this.func_200403_a(Blocks.field_196583_aj)).func_200465_a("has_cut_sandstone", (ICriterionInstance)this.func_200403_a(Blocks.field_196585_ak)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_180398_cJ).func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_179562_cC).func_200462_a(Character.valueOf('C'), (IItemProvider)Items.field_179563_cD).func_200472_a("SCS").func_200472_a("CCC").func_200472_a("SCS").func_200465_a("has_prismarine_crystals", (ICriterionInstance)this.func_200403_a(Items.field_179563_cD)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151097_aZ).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151042_j).func_200472_a(" #").func_200472_a("# ").func_200465_a("has_iron_ingot", (ICriterionInstance)this.func_200403_a(Items.field_151042_j)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_185159_cQ).func_200469_a(Character.valueOf('W'), ItemTags.field_199905_b).func_200462_a(Character.valueOf('o'), (IItemProvider)Items.field_151042_j).func_200472_a("WoW").func_200472_a("WWW").func_200472_a(" W ").func_200465_a("has_iron_ingot", (ICriterionInstance)this.func_200403_a(Items.field_151042_j)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Items.field_222071_kr, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_221586_n).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151055_y).func_200472_a("###").func_200472_a("###").func_200472_a(" X ").func_200465_a("has_oak_planks", (ICriterionInstance)this.func_200403_a(Items.field_221586_n)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Items.field_222072_ks, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_221587_o).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151055_y).func_200472_a("###").func_200472_a("###").func_200472_a(" X ").func_200465_a("has_spruce_planks", (ICriterionInstance)this.func_200403_a(Items.field_221587_o)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Items.field_222073_kt, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_221588_p).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151055_y).func_200472_a("###").func_200472_a("###").func_200472_a(" X ").func_200465_a("has_birch_planks", (ICriterionInstance)this.func_200403_a(Items.field_221588_p)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Items.field_222075_kv, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_221590_r).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151055_y).func_200472_a("###").func_200472_a("###").func_200472_a(" X ").func_200465_a("has_acacia_planks", (ICriterionInstance)this.func_200403_a(Items.field_221590_r)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Items.field_222074_ku, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_221589_q).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151055_y).func_200472_a("###").func_200472_a("###").func_200472_a(" X ").func_200465_a("has_jungle_planks", (ICriterionInstance)this.func_200403_a(Items.field_221589_q)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Items.field_222076_kw, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_221591_s).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151055_y).func_200472_a("###").func_200472_a("###").func_200472_a(" X ").func_200465_a("has_dark_oak_planks", (ICriterionInstance)this.func_200403_a(Items.field_221591_s)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_180399_cE).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151123_aH).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200465_a("has_slime_ball", (ICriterionInstance)this.func_200403_a(Items.field_151123_aH)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_151123_aH, (int)9).func_200487_b((IItemProvider)Blocks.field_180399_cE).func_200483_a("has_slime", (ICriterionInstance)this.func_200403_a(Blocks.field_180399_cE)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196799_hB, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_180395_cM).func_200472_a("##").func_200472_a("##").func_200465_a("has_red_sandstone", (ICriterionInstance)this.func_200403_a(Blocks.field_180395_cM)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196585_ak, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150322_A).func_200472_a("##").func_200472_a("##").func_200465_a("has_sandstone", (ICriterionInstance)this.func_200403_a(Blocks.field_150322_A)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_196604_cC).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151126_ay).func_200472_a("##").func_200472_a("##").func_200465_a("has_snowball", (ICriterionInstance)this.func_200403_a(Items.field_151126_ay)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_150433_aE, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196604_cC).func_200472_a("###").func_200465_a("has_snowball", (ICriterionInstance)this.func_200403_a(Items.field_151126_ay)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151060_bw).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151074_bl).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151127_ba).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200465_a("has_melon", (ICriterionInstance)this.func_200403_a(Items.field_151127_ba)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Items.field_185166_h, (int)2).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151114_aO).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151032_g).func_200472_a(" # ").func_200472_a("#X#").func_200472_a(" # ").func_200465_a("has_glowstone_dust", (ICriterionInstance)this.func_200403_a(Items.field_151114_aO)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196629_R, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196618_L).func_200472_a("##").func_200472_a("##").func_200473_b("bark").func_200465_a("has_log", (ICriterionInstance)this.func_200403_a(Blocks.field_196618_L)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_209390_ac, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_203205_S).func_200472_a("##").func_200472_a("##").func_200473_b("bark").func_200465_a("has_log", (ICriterionInstance)this.func_200403_a(Blocks.field_203205_S)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_185150_aH).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196664_o).func_200472_a("# #").func_200472_a("###").func_200473_b("boat").func_200465_a("in_water", (ICriterionInstance)this.func_200407_a(Blocks.field_150355_j)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Blocks.field_196691_eG).func_200487_b((IItemProvider)Blocks.field_196664_o).func_200490_a("wooden_button").func_200483_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196664_o)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_180414_ap, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196664_o).func_200472_a("##").func_200472_a("##").func_200472_a("##").func_200473_b("wooden_door").func_200465_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196664_o)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_180408_aP, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('W'), (IItemProvider)Blocks.field_196664_o).func_200472_a("W#W").func_200472_a("W#W").func_200473_b("wooden_fence").func_200465_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196664_o)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_180391_bp).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('W'), (IItemProvider)Blocks.field_196664_o).func_200472_a("#W#").func_200472_a("#W#").func_200473_b("wooden_fence_gate").func_200465_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196664_o)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Blocks.field_196664_o, (int)4).func_203221_a(ItemTags.field_203299_s).func_200490_a("planks").func_200483_a("has_log", (ICriterionInstance)this.func_200409_a(ItemTags.field_203299_s)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_196665_cr).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196664_o).func_200472_a("##").func_200473_b("wooden_pressure_plate").func_200465_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196664_o)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196624_br, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196664_o).func_200472_a("###").func_200473_b("wooden_slab").func_200465_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196664_o)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_150485_bF, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196664_o).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200473_b("wooden_stairs").func_200465_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196664_o)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196638_cX, (int)2).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196664_o).func_200472_a("###").func_200472_a("###").func_200473_b("wooden_trapdoor").func_200465_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196664_o)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Items.field_151055_y, (int)4).func_200469_a(Character.valueOf('#'), ItemTags.field_199905_b).func_200472_a("#").func_200472_a("#").func_200473_b("sticks").func_200465_a("has_planks", (ICriterionInstance)this.func_200409_a(ItemTags.field_199905_b)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Items.field_151055_y, (int)1).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_222405_kQ).func_200472_a("#").func_200472_a("#").func_200473_b("sticks").func_200465_a("has_bamboo", (ICriterionInstance)this.func_200403_a(Blocks.field_222405_kQ)).func_200466_a(consumer, "stick_from_bamboo_item");
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150320_F).func_200462_a(Character.valueOf('P'), (IItemProvider)Blocks.field_150331_J).func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_151123_aH).func_200472_a("S").func_200472_a("P").func_200465_a("has_slime_ball", (ICriterionInstance)this.func_200403_a(Items.field_151123_aH)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196696_di, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150348_b).func_200472_a("##").func_200472_a("##").func_200465_a("has_stone", (ICriterionInstance)this.func_200403_a(Blocks.field_150348_b)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151049_t).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Blocks.field_150347_e).func_200472_a("XX").func_200472_a("X#").func_200472_a(" #").func_200465_a("has_cobblestone", (ICriterionInstance)this.func_200403_a(Blocks.field_150347_e)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196573_bB, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196696_di).func_200472_a("###").func_200465_a("has_stone_bricks", (ICriterionInstance)this.func_200409_a(ItemTags.field_200033_c)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_150390_bg, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196696_di).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_stone_bricks", (ICriterionInstance)this.func_200409_a(ItemTags.field_200033_c)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Blocks.field_150430_aB).func_200487_b((IItemProvider)Blocks.field_150348_b).func_200483_a("has_stone", (ICriterionInstance)this.func_200403_a(Blocks.field_150348_b)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151018_J).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Blocks.field_150347_e).func_200472_a("XX").func_200472_a(" #").func_200472_a(" #").func_200465_a("has_cobblestone", (ICriterionInstance)this.func_200403_a(Blocks.field_150347_e)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151050_s).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Blocks.field_150347_e).func_200472_a("XXX").func_200472_a(" # ").func_200472_a(" # ").func_200465_a("has_cobblestone", (ICriterionInstance)this.func_200403_a(Blocks.field_150347_e)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150456_au).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150348_b).func_200472_a("##").func_200465_a("has_stone", (ICriterionInstance)this.func_200403_a(Blocks.field_150348_b)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151051_r).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Blocks.field_150347_e).func_200472_a("X").func_200472_a("#").func_200472_a("#").func_200465_a("has_cobblestone", (ICriterionInstance)this.func_200403_a(Blocks.field_150347_e)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_150333_U, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150348_b).func_200472_a("###").func_200465_a("has_stone", (ICriterionInstance)this.func_200403_a(Blocks.field_150348_b)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222401_hJ, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196579_bG).func_200472_a("###").func_200465_a("has_smooth_stone", (ICriterionInstance)this.func_200403_a(Blocks.field_196579_bG)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196659_cl, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150347_e).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_cobblestone", (ICriterionInstance)this.func_200403_a(Blocks.field_150347_e)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151052_q).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('X'), (IItemProvider)Blocks.field_150347_e).func_200472_a("X").func_200472_a("X").func_200472_a("#").func_200465_a("has_cobblestone", (ICriterionInstance)this.func_200403_a(Blocks.field_150347_e)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_196556_aL).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151007_F).func_200472_a("##").func_200472_a("##").func_200465_a("has_string", (ICriterionInstance)this.func_200403_a(Items.field_151007_F)).func_200466_a(consumer, "white_wool_from_string");
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_151102_aT).func_200487_b((IItemProvider)Blocks.field_196608_cF).func_200490_a("sugar").func_200483_a("has_reeds", (ICriterionInstance)this.func_200403_a(Blocks.field_196608_cF)).func_200484_a(consumer, "sugar_from_sugar_cane");
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_151102_aT, (int)3).func_200487_b((IItemProvider)Items.field_226638_pX_).func_200490_a("sugar").func_200483_a("has_honey_bottle", (ICriterionInstance)this.func_200403_a(Items.field_226638_pX_)).func_200484_a(consumer, "sugar_from_honey_bottle");
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_150335_W).func_200471_a(Character.valueOf('#'), Ingredient.func_199804_a(Blocks.field_150354_m, Blocks.field_196611_F)).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_151016_H).func_200472_a("X#X").func_200472_a("#X#").func_200472_a("X#X").func_200465_a("has_gunpowder", (ICriterionInstance)this.func_200403_a(Items.field_151016_H)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151142_bV).func_200462_a(Character.valueOf('A'), (IItemProvider)Blocks.field_150335_W).func_200462_a(Character.valueOf('B'), (IItemProvider)Items.field_151143_au).func_200472_a("A").func_200472_a("B").func_200465_a("has_minecart", (ICriterionInstance)this.func_200403_a(Items.field_151143_au)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_150478_aa, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200471_a(Character.valueOf('X'), Ingredient.func_199804_a(Items.field_151044_h, Items.field_196155_l)).func_200472_a("X").func_200472_a("#").func_200465_a("has_stone_pickaxe", (ICriterionInstance)this.func_200403_a(Items.field_151050_s)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_222432_lU).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_221657_bQ).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_191525_da).func_200472_a("XXX").func_200472_a("X#X").func_200472_a("XXX").func_200465_a("has_iron_nugget", (ICriterionInstance)this.func_200403_a(Items.field_191525_da)).func_200465_a("has_iron_ingot", (ICriterionInstance)this.func_200403_a(Items.field_151042_j)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Blocks.field_150447_bR).func_200487_b((IItemProvider)Blocks.field_150486_ae).func_200487_b((IItemProvider)Blocks.field_150479_bC).func_200483_a("has_tripwire_hook", (ICriterionInstance)this.func_200403_a(Blocks.field_150479_bC)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_150479_bC, (int)2).func_200469_a(Character.valueOf('#'), ItemTags.field_199905_b).func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('I'), (IItemProvider)Items.field_151042_j).func_200472_a("I").func_200472_a("S").func_200472_a("#").func_200465_a("has_string", (ICriterionInstance)this.func_200403_a(Items.field_151007_F)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_203179_ao).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_203183_eM).func_200472_a("XXX").func_200472_a("X X").func_200465_a("has_scute", (ICriterionInstance)this.func_200403_a(Items.field_203183_eM)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_151015_O, (int)9).func_200487_b((IItemProvider)Blocks.field_150407_cf).func_200483_a("has_hay_block", (ICriterionInstance)this.func_200403_a(Blocks.field_150407_cf)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_196191_eg).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196556_aL).func_200462_a(Character.valueOf('|'), (IItemProvider)Items.field_151055_y).func_200472_a("###").func_200472_a("###").func_200472_a(" | ").func_200473_b("banner").func_200465_a("has_white_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196556_aL)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_196140_bu).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196556_aL).func_200469_a(Character.valueOf('X'), ItemTags.field_199905_b).func_200472_a("###").func_200472_a("XXX").func_200473_b("bed").func_200465_a("has_white_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196556_aL)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196724_fH, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196556_aL).func_200472_a("##").func_200473_b("carpet").func_200465_a("has_white_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196556_aL)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Blocks.field_196860_iS, (int)8).func_200487_b((IItemProvider)Items.field_222069_lA).func_200491_b((IItemProvider)Blocks.field_150354_m, 4).func_200491_b((IItemProvider)Blocks.field_150351_n, 4).func_200490_a("concrete_powder").func_200483_a("has_sand", (ICriterionInstance)this.func_200403_a(Blocks.field_150354_m)).func_200483_a("has_gravel", (ICriterionInstance)this.func_200403_a(Blocks.field_150351_n)).func_200482_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_222069_lA).func_200487_b((IItemProvider)Items.field_196106_bc).func_200490_a("white_dye").func_200483_a("has_bone_meal", (ICriterionInstance)this.func_200403_a(Items.field_196106_bc)).func_200482_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_222069_lA).func_200487_b((IItemProvider)Blocks.field_222383_bA).func_200490_a("white_dye").func_200483_a("has_white_flower", (ICriterionInstance)this.func_200403_a(Blocks.field_222383_bA)).func_200484_a(consumer, "white_dye_from_lily_of_the_valley");
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196807_gj, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150359_w).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_222069_lA).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200473_b("stained_glass").func_200465_a("has_glass", (ICriterionInstance)this.func_200403_a(Blocks.field_150359_w)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196825_gz, (int)16).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196807_gj).func_200472_a("###").func_200472_a("###").func_200473_b("stained_glass_pane").func_200465_a("has_glass", (ICriterionInstance)this.func_200403_a(Blocks.field_150359_w)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196825_gz, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150410_aZ).func_200462_a(Character.valueOf('$'), (IItemProvider)Items.field_222069_lA).func_200472_a("###").func_200472_a("#$#").func_200472_a("###").func_200473_b("stained_glass_pane").func_200465_a("has_glass_pane", (ICriterionInstance)this.func_200403_a(Blocks.field_150410_aZ)).func_200465_a("has_white_dye", (ICriterionInstance)this.func_200403_a(Items.field_222069_lA)).func_200466_a(consumer, "white_stained_glass_pane_from_glass_pane");
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196777_fo, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150405_ch).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_222069_lA).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200473_b("stained_terracotta").func_200465_a("has_terracotta", (ICriterionInstance)this.func_200403_a(Blocks.field_150405_ch)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151053_p).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200469_a(Character.valueOf('X'), ItemTags.field_199905_b).func_200472_a("XX").func_200472_a("X#").func_200472_a(" #").func_200465_a("has_stick", (ICriterionInstance)this.func_200403_a(Items.field_151055_y)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_180413_ao, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196662_n).func_200472_a("##").func_200472_a("##").func_200472_a("##").func_200473_b("wooden_door").func_200465_a("has_planks", (ICriterionInstance)this.func_200403_a(Blocks.field_196662_n)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151017_I).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200469_a(Character.valueOf('X'), ItemTags.field_199905_b).func_200472_a("XX").func_200472_a(" #").func_200472_a(" #").func_200465_a("has_stick", (ICriterionInstance)this.func_200403_a(Items.field_151055_y)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151039_o).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200469_a(Character.valueOf('X'), ItemTags.field_199905_b).func_200472_a("XXX").func_200472_a(" # ").func_200472_a(" # ").func_200465_a("has_stick", (ICriterionInstance)this.func_200403_a(Items.field_151055_y)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151038_n).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200469_a(Character.valueOf('X'), ItemTags.field_199905_b).func_200472_a("X").func_200472_a("#").func_200472_a("#").func_200465_a("has_stick", (ICriterionInstance)this.func_200403_a(Items.field_151055_y)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_151041_m).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_151055_y).func_200469_a(Character.valueOf('X'), ItemTags.field_199905_b).func_200472_a("X").func_200472_a("X").func_200472_a("#").func_200465_a("has_stick", (ICriterionInstance)this.func_200403_a(Items.field_151055_y)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_151099_bA).func_200487_b((IItemProvider)Items.field_151122_aG).func_200487_b((IItemProvider)Items.field_196136_br).func_200487_b((IItemProvider)Items.field_151008_G).func_200483_a("has_book", (ICriterionInstance)this.func_200403_a(Items.field_151122_aG)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_196195_ek).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196560_aP).func_200462_a(Character.valueOf('|'), (IItemProvider)Items.field_151055_y).func_200472_a("###").func_200472_a("###").func_200472_a(" | ").func_200473_b("banner").func_200465_a("has_yellow_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196560_aP)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Items.field_196148_by).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196560_aP).func_200469_a(Character.valueOf('X'), ItemTags.field_199905_b).func_200472_a("###").func_200472_a("XXX").func_200473_b("bed").func_200465_a("has_yellow_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196560_aP)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_196148_by).func_200487_b((IItemProvider)Items.field_196140_bu).func_200487_b((IItemProvider)Items.field_222081_ls).func_200490_a("dyed_bed").func_200483_a("has_bed", (ICriterionInstance)this.func_200403_a(Items.field_196140_bu)).func_200484_a(consumer, "yellow_bed_from_white_bed");
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196731_fL, (int)3).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196560_aP).func_200472_a("##").func_200473_b("carpet").func_200465_a("has_yellow_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196560_aP)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196731_fL, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196724_fH).func_200462_a(Character.valueOf('$'), (IItemProvider)Items.field_222081_ls).func_200472_a("###").func_200472_a("#$#").func_200472_a("###").func_200473_b("carpet").func_200465_a("has_white_carpet", (ICriterionInstance)this.func_200403_a(Blocks.field_196724_fH)).func_200465_a("has_yellow_dye", (ICriterionInstance)this.func_200403_a(Items.field_222081_ls)).func_200466_a(consumer, "yellow_carpet_from_white_carpet");
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Blocks.field_196868_iW, (int)8).func_200487_b((IItemProvider)Items.field_222081_ls).func_200491_b((IItemProvider)Blocks.field_150354_m, 4).func_200491_b((IItemProvider)Blocks.field_150351_n, 4).func_200490_a("concrete_powder").func_200483_a("has_sand", (ICriterionInstance)this.func_200403_a(Blocks.field_150354_m)).func_200483_a("has_gravel", (ICriterionInstance)this.func_200403_a(Blocks.field_150351_n)).func_200482_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_222081_ls).func_200487_b((IItemProvider)Blocks.field_196605_bc).func_200490_a("yellow_dye").func_200483_a("has_yellow_flower", (ICriterionInstance)this.func_200403_a(Blocks.field_196605_bc)).func_200484_a(consumer, "yellow_dye_from_dandelion");
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_222081_ls, (int)2).func_200487_b((IItemProvider)Blocks.field_196800_gd).func_200490_a("yellow_dye").func_200483_a("has_double_plant", (ICriterionInstance)this.func_200403_a(Blocks.field_196800_gd)).func_200484_a(consumer, "yellow_dye_from_sunflower");
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196811_gn, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150359_w).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_222081_ls).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200473_b("stained_glass").func_200465_a("has_glass", (ICriterionInstance)this.func_200403_a(Blocks.field_150359_w)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196761_gD, (int)16).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196811_gn).func_200472_a("###").func_200472_a("###").func_200473_b("stained_glass_pane").func_200465_a("has_glass", (ICriterionInstance)this.func_200403_a(Blocks.field_150359_w)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196761_gD, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150410_aZ).func_200462_a(Character.valueOf('$'), (IItemProvider)Items.field_222081_ls).func_200472_a("###").func_200472_a("#$#").func_200472_a("###").func_200473_b("stained_glass_pane").func_200465_a("has_glass_pane", (ICriterionInstance)this.func_200403_a(Blocks.field_150410_aZ)).func_200465_a("has_yellow_dye", (ICriterionInstance)this.func_200403_a(Items.field_222081_ls)).func_200466_a(consumer, "yellow_stained_glass_pane_from_glass_pane");
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_196783_fs, (int)8).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150405_ch).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_222081_ls).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200473_b("stained_terracotta").func_200465_a("has_terracotta", (ICriterionInstance)this.func_200403_a(Blocks.field_150405_ch)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Blocks.field_196560_aP).func_200487_b((IItemProvider)Items.field_222081_ls).func_200487_b((IItemProvider)Blocks.field_196556_aL).func_200490_a("wool").func_200483_a("has_white_wool", (ICriterionInstance)this.func_200403_a(Blocks.field_196556_aL)).func_200482_a(consumer);
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)Items.field_203180_bP, (int)9).func_200487_b((IItemProvider)Blocks.field_203216_jz).func_200483_a("has_dried_kelp_block", (ICriterionInstance)this.func_200403_a(Blocks.field_203216_jz)).func_200482_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Blocks.field_203216_jz).func_200491_b((IItemProvider)Items.field_203180_bP, 9).func_200483_a("has_dried_kelp", (ICriterionInstance)this.func_200403_a(Items.field_203180_bP)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_205165_jY).func_200462_a(Character.valueOf('#'), (IItemProvider)Items.field_205157_eZ).func_200462_a(Character.valueOf('X'), (IItemProvider)Items.field_205158_fa).func_200472_a("###").func_200472_a("#X#").func_200472_a("###").func_200465_a("has_nautilus_core", (ICriterionInstance)this.func_200403_a(Items.field_205158_fa)).func_200465_a("has_nautilus_shell", (ICriterionInstance)this.func_200403_a(Items.field_205157_eZ)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222407_kV, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196652_d).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_polished_granite", (ICriterionInstance)this.func_200403_a(Blocks.field_196652_d)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222408_kW, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196582_bJ).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_smooth_red_sandstone", (ICriterionInstance)this.func_200403_a(Blocks.field_196582_bJ)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222409_kX, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196698_dj).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_mossy_stone_bricks", (ICriterionInstance)this.func_200403_a(Blocks.field_196698_dj)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222410_kY, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196655_f).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_polished_diorite", (ICriterionInstance)this.func_200403_a(Blocks.field_196655_f)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222411_kZ, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150341_Y).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_mossy_cobblestone", (ICriterionInstance)this.func_200403_a(Blocks.field_150341_Y)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222437_la, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196806_hJ).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_end_stone_bricks", (ICriterionInstance)this.func_200403_a(Blocks.field_196806_hJ)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222438_lb, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150348_b).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_stone", (ICriterionInstance)this.func_200403_a(Blocks.field_150348_b)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222439_lc, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196580_bH).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_smooth_sandstone", (ICriterionInstance)this.func_200403_a(Blocks.field_196580_bH)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222440_ld, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196581_bI).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_smooth_quartz", (ICriterionInstance)this.func_200403_a(Blocks.field_196581_bI)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222441_le, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196650_c).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_granite", (ICriterionInstance)this.func_200403_a(Blocks.field_196650_c)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222442_lf, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196656_g).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_andesite", (ICriterionInstance)this.func_200403_a(Blocks.field_196656_g)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222443_lg, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196817_hS).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_red_nether_bricks", (ICriterionInstance)this.func_200403_a(Blocks.field_196817_hS)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222444_lh, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196657_h).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_polished_andesite", (ICriterionInstance)this.func_200403_a(Blocks.field_196657_h)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222445_li, (int)4).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196654_e).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200465_a("has_diorite", (ICriterionInstance)this.func_200403_a(Blocks.field_196654_e)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222446_lj, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196652_d).func_200472_a("###").func_200465_a("has_polished_granite", (ICriterionInstance)this.func_200403_a(Blocks.field_196652_d)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222447_lk, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196582_bJ).func_200472_a("###").func_200465_a("has_smooth_red_sandstone", (ICriterionInstance)this.func_200403_a(Blocks.field_196582_bJ)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222448_ll, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196698_dj).func_200472_a("###").func_200465_a("has_mossy_stone_bricks", (ICriterionInstance)this.func_200403_a(Blocks.field_196698_dj)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222449_lm, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196655_f).func_200472_a("###").func_200465_a("has_polished_diorite", (ICriterionInstance)this.func_200403_a(Blocks.field_196655_f)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222450_ln, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150341_Y).func_200472_a("###").func_200465_a("has_mossy_cobblestone", (ICriterionInstance)this.func_200403_a(Blocks.field_150341_Y)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222451_lo, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196806_hJ).func_200472_a("###").func_200465_a("has_end_stone_bricks", (ICriterionInstance)this.func_200403_a(Blocks.field_196806_hJ)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222452_lp, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196580_bH).func_200472_a("###").func_200465_a("has_smooth_sandstone", (ICriterionInstance)this.func_200403_a(Blocks.field_196580_bH)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222453_lq, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196581_bI).func_200472_a("###").func_200465_a("has_smooth_quartz", (ICriterionInstance)this.func_200403_a(Blocks.field_196581_bI)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222454_lr, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196650_c).func_200472_a("###").func_200465_a("has_granite", (ICriterionInstance)this.func_200403_a(Blocks.field_196650_c)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222455_ls, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196656_g).func_200472_a("###").func_200465_a("has_andesite", (ICriterionInstance)this.func_200403_a(Blocks.field_196656_g)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222456_lt, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196817_hS).func_200472_a("###").func_200465_a("has_red_nether_bricks", (ICriterionInstance)this.func_200403_a(Blocks.field_196817_hS)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222457_lu, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196657_h).func_200472_a("###").func_200465_a("has_polished_andesite", (ICriterionInstance)this.func_200403_a(Blocks.field_196657_h)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222458_lv, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196654_e).func_200472_a("###").func_200465_a("has_diorite", (ICriterionInstance)this.func_200403_a(Blocks.field_196654_e)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222459_lw, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196584_bK).func_200472_a("###").func_200472_a("###").func_200465_a("has_bricks", (ICriterionInstance)this.func_200403_a(Blocks.field_196584_bK)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222460_lx, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_180397_cI).func_200472_a("###").func_200472_a("###").func_200465_a("has_prismarine", (ICriterionInstance)this.func_200403_a(Blocks.field_180397_cI)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222461_ly, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_180395_cM).func_200472_a("###").func_200472_a("###").func_200465_a("has_red_sandstone", (ICriterionInstance)this.func_200403_a(Blocks.field_180395_cM)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222462_lz, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196698_dj).func_200472_a("###").func_200472_a("###").func_200465_a("has_mossy_stone_bricks", (ICriterionInstance)this.func_200403_a(Blocks.field_196698_dj)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222412_lA, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196650_c).func_200472_a("###").func_200472_a("###").func_200465_a("has_granite", (ICriterionInstance)this.func_200403_a(Blocks.field_196650_c)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222413_lB, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196696_di).func_200472_a("###").func_200472_a("###").func_200465_a("has_stone_bricks", (ICriterionInstance)this.func_200403_a(Blocks.field_196696_di)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222414_lC, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196653_dH).func_200472_a("###").func_200472_a("###").func_200465_a("has_nether_bricks", (ICriterionInstance)this.func_200403_a(Blocks.field_196653_dH)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222415_lD, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196656_g).func_200472_a("###").func_200472_a("###").func_200465_a("has_andesite", (ICriterionInstance)this.func_200403_a(Blocks.field_196656_g)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222416_lE, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196817_hS).func_200472_a("###").func_200472_a("###").func_200465_a("has_red_nether_bricks", (ICriterionInstance)this.func_200403_a(Blocks.field_196817_hS)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222417_lF, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150322_A).func_200472_a("###").func_200472_a("###").func_200465_a("has_sandstone", (ICriterionInstance)this.func_200403_a(Blocks.field_150322_A)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222418_lG, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196806_hJ).func_200472_a("###").func_200472_a("###").func_200465_a("has_end_stone_bricks", (ICriterionInstance)this.func_200403_a(Blocks.field_196806_hJ)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222419_lH, (int)6).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196654_e).func_200472_a("###").func_200472_a("###").func_200465_a("has_diorite", (ICriterionInstance)this.func_200403_a(Blocks.field_196654_e)).func_200464_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_222096_pC).func_200487_b((IItemProvider)Items.field_151121_aF).func_200487_b((IItemProvider)Items.field_196185_dy).func_200483_a("has_creeper_head", (ICriterionInstance)this.func_200403_a(Items.field_196185_dy)).func_200482_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_222097_pD).func_200487_b((IItemProvider)Items.field_151121_aF).func_200487_b((IItemProvider)Items.field_196183_dw).func_200483_a("has_wither_skeleton_skull", (ICriterionInstance)this.func_200403_a(Items.field_196183_dw)).func_200482_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_222095_pB).func_200487_b((IItemProvider)Items.field_151121_aF).func_200487_b((IItemProvider)Blocks.field_196616_bl).func_200483_a("has_oxeye_daisy", (ICriterionInstance)this.func_200403_a(Blocks.field_196616_bl)).func_200482_a(consumer);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_222098_pE).func_200487_b((IItemProvider)Items.field_151121_aF).func_200487_b((IItemProvider)Items.field_196100_at).func_200483_a("has_enchanted_golden_apple", (ICriterionInstance)this.func_200403_a(Items.field_196100_at)).func_200482_a(consumer);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)Blocks.field_222420_lI, (int)6).func_200462_a(Character.valueOf('~'), (IItemProvider)Items.field_151007_F).func_200462_a(Character.valueOf('I'), (IItemProvider)Blocks.field_222405_kQ).func_200472_a("I~I").func_200472_a("I I").func_200472_a("I I").func_200465_a("has_bamboo", (ICriterionInstance)this.func_200403_a(Blocks.field_222405_kQ)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_222427_lP).func_200462_a(Character.valueOf('I'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('-'), (IItemProvider)Blocks.field_150333_U).func_200469_a(Character.valueOf('#'), ItemTags.field_199905_b).func_200472_a("I-I").func_200472_a("# #").func_200465_a("has_stone_slab", (ICriterionInstance)this.func_200403_a(Blocks.field_150333_U)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_222424_lM).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_196579_bG).func_200462_a(Character.valueOf('X'), (IItemProvider)Blocks.field_150460_al).func_200462_a(Character.valueOf('I'), (IItemProvider)Items.field_151042_j).func_200472_a("III").func_200472_a("IXI").func_200472_a("###").func_200465_a("has_smooth_stone", (ICriterionInstance)this.func_200403_a(Blocks.field_196579_bG)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_222423_lL).func_200469_a(Character.valueOf('#'), ItemTags.field_200038_h).func_200462_a(Character.valueOf('X'), (IItemProvider)Blocks.field_150460_al).func_200472_a(" # ").func_200472_a("#X#").func_200472_a(" # ").func_200465_a("has_furnace", (ICriterionInstance)this.func_200403_a(Blocks.field_150460_al)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_222425_lN).func_200469_a(Character.valueOf('#'), ItemTags.field_199905_b).func_200462_a(Character.valueOf('@'), (IItemProvider)Items.field_151121_aF).func_200472_a("@@").func_200472_a("##").func_200472_a("##").func_200465_a("has_string", (ICriterionInstance)this.func_200403_a(Items.field_151007_F)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_222429_lR).func_200469_a(Character.valueOf('#'), ItemTags.field_199905_b).func_200462_a(Character.valueOf('@'), (IItemProvider)Items.field_151042_j).func_200472_a("@@").func_200472_a("##").func_200472_a("##").func_200465_a("has_iron_ingot", (ICriterionInstance)this.func_200403_a(Items.field_151042_j)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_222426_lO).func_200469_a(Character.valueOf('#'), ItemTags.field_199905_b).func_200462_a(Character.valueOf('@'), (IItemProvider)Items.field_151145_ak).func_200472_a("@@").func_200472_a("##").func_200472_a("##").func_200465_a("has_flint", (ICriterionInstance)this.func_200403_a(Items.field_151145_ak)).func_200464_a(consumer);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)Blocks.field_222430_lS).func_200462_a(Character.valueOf('I'), (IItemProvider)Items.field_151042_j).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_150348_b).func_200472_a(" I ").func_200472_a("###").func_200465_a("has_stone", (ICriterionInstance)this.func_200403_a(Blocks.field_150348_b)).func_200464_a(consumer);
        CustomRecipeBuilder.func_218656_a(IRecipeSerializer.field_222159_c).func_200499_a(consumer, "armor_dye");
        CustomRecipeBuilder.func_218656_a(IRecipeSerializer.field_222167_k).func_200499_a(consumer, "banner_duplicate");
        CustomRecipeBuilder.func_218656_a(IRecipeSerializer.field_222160_d).func_200499_a(consumer, "book_cloning");
        CustomRecipeBuilder.func_218656_a(IRecipeSerializer.field_222163_g).func_200499_a(consumer, "firework_rocket");
        CustomRecipeBuilder.func_218656_a(IRecipeSerializer.field_222164_h).func_200499_a(consumer, "firework_star");
        CustomRecipeBuilder.func_218656_a(IRecipeSerializer.field_222165_i).func_200499_a(consumer, "firework_star_fade");
        CustomRecipeBuilder.func_218656_a(IRecipeSerializer.field_222161_e).func_200499_a(consumer, "map_cloning");
        CustomRecipeBuilder.func_218656_a(IRecipeSerializer.field_222162_f).func_200499_a(consumer, "map_extending");
        CustomRecipeBuilder.func_218656_a(IRecipeSerializer.field_223550_o).func_200499_a(consumer, "repair_item");
        CustomRecipeBuilder.func_218656_a(IRecipeSerializer.field_222168_l).func_200499_a(consumer, "shield_decoration");
        CustomRecipeBuilder.func_218656_a(IRecipeSerializer.field_222169_m).func_200499_a(consumer, "shulker_box_coloring");
        CustomRecipeBuilder.func_218656_a(IRecipeSerializer.field_222166_j).func_200499_a(consumer, "tipped_arrow");
        CustomRecipeBuilder.func_218656_a(IRecipeSerializer.field_222170_n).func_200499_a(consumer, "suspicious_stew");
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Items.field_151174_bG), (IItemProvider)Items.field_151168_bH, (float)0.35f, (int)200).func_218628_a("has_potato", (ICriterionInstance)this.func_200403_a(Items.field_151174_bG)).func_218630_a(consumer);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Items.field_151119_aD), (IItemProvider)Items.field_151118_aC, (float)0.3f, (int)200).func_218628_a("has_clay_ball", (ICriterionInstance)this.func_200403_a(Items.field_151119_aD)).func_218630_a(consumer);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199805_a(ItemTags.field_200038_h), (IItemProvider)Items.field_196155_l, (float)0.15f, (int)200).func_218628_a("has_log", (ICriterionInstance)this.func_200409_a(ItemTags.field_200038_h)).func_218630_a(consumer);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Items.field_185161_cS), (IItemProvider)Items.field_185162_cT, (float)0.1f, (int)200).func_218628_a("has_chorus_fruit", (ICriterionInstance)this.func_200403_a(Items.field_185161_cS)).func_218630_a(consumer);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_150365_q.func_199767_j()), (IItemProvider)Items.field_151044_h, (float)0.1f, (int)200).func_218628_a("has_coal_ore", (ICriterionInstance)this.func_200403_a(Blocks.field_150365_q)).func_218632_a(consumer, "coal_from_smelting");
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Items.field_151082_bd), (IItemProvider)Items.field_151083_be, (float)0.35f, (int)200).func_218628_a("has_beef", (ICriterionInstance)this.func_200403_a(Items.field_151082_bd)).func_218630_a(consumer);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Items.field_151076_bf), (IItemProvider)Items.field_151077_bg, (float)0.35f, (int)200).func_218628_a("has_chicken", (ICriterionInstance)this.func_200403_a(Items.field_151076_bf)).func_218630_a(consumer);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Items.field_196086_aW), (IItemProvider)Items.field_196102_ba, (float)0.35f, (int)200).func_218628_a("has_cod", (ICriterionInstance)this.func_200403_a(Items.field_196086_aW)).func_218630_a(consumer);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_203214_jx), (IItemProvider)Items.field_203180_bP, (float)0.1f, (int)200).func_218628_a("has_kelp", (ICriterionInstance)this.func_200403_a(Blocks.field_203214_jx)).func_218632_a(consumer, "dried_kelp_from_smelting");
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Items.field_196087_aX), (IItemProvider)Items.field_196104_bb, (float)0.35f, (int)200).func_218628_a("has_salmon", (ICriterionInstance)this.func_200403_a(Items.field_196087_aX)).func_218630_a(consumer);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Items.field_179561_bm), (IItemProvider)Items.field_179557_bn, (float)0.35f, (int)200).func_218628_a("has_mutton", (ICriterionInstance)this.func_200403_a(Items.field_179561_bm)).func_218630_a(consumer);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Items.field_151147_al), (IItemProvider)Items.field_151157_am, (float)0.35f, (int)200).func_218628_a("has_porkchop", (ICriterionInstance)this.func_200403_a(Items.field_151147_al)).func_218630_a(consumer);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Items.field_179558_bo), (IItemProvider)Items.field_179559_bp, (float)0.35f, (int)200).func_218628_a("has_rabbit", (ICriterionInstance)this.func_200403_a(Items.field_179558_bo)).func_218630_a(consumer);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_150482_ag.func_199767_j()), (IItemProvider)Items.field_151045_i, (float)1.0f, (int)200).func_218628_a("has_diamond_ore", (ICriterionInstance)this.func_200403_a(Blocks.field_150482_ag)).func_218632_a(consumer, "diamond_from_smelting");
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_150369_x.func_199767_j()), (IItemProvider)Items.field_196128_bn, (float)0.2f, (int)200).func_218628_a("has_lapis_ore", (ICriterionInstance)this.func_200403_a(Blocks.field_150369_x)).func_218632_a(consumer, "lapis_from_smelting");
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_150412_bA.func_199767_j()), (IItemProvider)Items.field_151166_bC, (float)1.0f, (int)200).func_218628_a("has_emerald_ore", (ICriterionInstance)this.func_200403_a(Blocks.field_150412_bA)).func_218632_a(consumer, "emerald_from_smelting");
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199805_a(ItemTags.field_203440_u), (IItemProvider)Blocks.field_150359_w.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_sand", (ICriterionInstance)this.func_200409_a(ItemTags.field_203440_u)).func_218630_a(consumer);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_150352_o.func_199767_j()), (IItemProvider)Items.field_151043_k, (float)1.0f, (int)200).func_218628_a("has_gold_ore", (ICriterionInstance)this.func_200403_a(Blocks.field_150352_o)).func_218630_a(consumer);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_204913_jW.func_199767_j()), (IItemProvider)Items.field_196116_bh, (float)0.1f, (int)200).func_218628_a("has_sea_pickle", (ICriterionInstance)this.func_200403_a(Blocks.field_204913_jW)).func_218632_a(consumer, "lime_dye_from_smelting");
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_150434_aF.func_199767_j()), (IItemProvider)Items.field_222079_lj, (float)1.0f, (int)200).func_218628_a("has_cactus", (ICriterionInstance)this.func_200403_a(Blocks.field_150434_aF)).func_218630_a(consumer);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Items.field_151005_D, Items.field_151011_C, Items.field_151006_E, Items.field_151013_M, Items.field_151010_B, Items.field_151169_ag, Items.field_151171_ah, Items.field_151149_ai, Items.field_151151_aj, Items.field_151136_bY), (IItemProvider)Items.field_151074_bl, (float)0.1f, (int)200).func_218628_a("has_golden_pickaxe", (ICriterionInstance)this.func_200403_a(Items.field_151005_D)).func_218628_a("has_golden_shovel", (ICriterionInstance)this.func_200403_a(Items.field_151011_C)).func_218628_a("has_golden_axe", (ICriterionInstance)this.func_200403_a(Items.field_151006_E)).func_218628_a("has_golden_hoe", (ICriterionInstance)this.func_200403_a(Items.field_151013_M)).func_218628_a("has_golden_sword", (ICriterionInstance)this.func_200403_a(Items.field_151010_B)).func_218628_a("has_golden_helmet", (ICriterionInstance)this.func_200403_a(Items.field_151169_ag)).func_218628_a("has_golden_chestplate", (ICriterionInstance)this.func_200403_a(Items.field_151171_ah)).func_218628_a("has_golden_leggings", (ICriterionInstance)this.func_200403_a(Items.field_151149_ai)).func_218628_a("has_golden_boots", (ICriterionInstance)this.func_200403_a(Items.field_151151_aj)).func_218628_a("has_golden_horse_armor", (ICriterionInstance)this.func_200403_a(Items.field_151136_bY)).func_218632_a(consumer, "gold_nugget_from_smelting");
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Items.field_151035_b, Items.field_151037_a, Items.field_151036_c, Items.field_151019_K, Items.field_151040_l, Items.field_151028_Y, Items.field_151030_Z, Items.field_151165_aa, Items.field_151167_ab, Items.field_151138_bX, Items.field_151020_U, Items.field_151023_V, Items.field_151022_W, Items.field_151029_X), (IItemProvider)Items.field_191525_da, (float)0.1f, (int)200).func_218628_a("has_iron_pickaxe", (ICriterionInstance)this.func_200403_a(Items.field_151035_b)).func_218628_a("has_iron_shovel", (ICriterionInstance)this.func_200403_a(Items.field_151037_a)).func_218628_a("has_iron_axe", (ICriterionInstance)this.func_200403_a(Items.field_151036_c)).func_218628_a("has_iron_hoe", (ICriterionInstance)this.func_200403_a(Items.field_151019_K)).func_218628_a("has_iron_sword", (ICriterionInstance)this.func_200403_a(Items.field_151040_l)).func_218628_a("has_iron_helmet", (ICriterionInstance)this.func_200403_a(Items.field_151028_Y)).func_218628_a("has_iron_chestplate", (ICriterionInstance)this.func_200403_a(Items.field_151030_Z)).func_218628_a("has_iron_leggings", (ICriterionInstance)this.func_200403_a(Items.field_151165_aa)).func_218628_a("has_iron_boots", (ICriterionInstance)this.func_200403_a(Items.field_151167_ab)).func_218628_a("has_iron_horse_armor", (ICriterionInstance)this.func_200403_a(Items.field_151138_bX)).func_218628_a("has_chainmail_helmet", (ICriterionInstance)this.func_200403_a(Items.field_151020_U)).func_218628_a("has_chainmail_chestplate", (ICriterionInstance)this.func_200403_a(Items.field_151023_V)).func_218628_a("has_chainmail_leggings", (ICriterionInstance)this.func_200403_a(Items.field_151022_W)).func_218628_a("has_chainmail_boots", (ICriterionInstance)this.func_200403_a(Items.field_151029_X)).func_218632_a(consumer, "iron_nugget_from_smelting");
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_150366_p.func_199767_j()), (IItemProvider)Items.field_151042_j, (float)0.7f, (int)200).func_218628_a("has_iron_ore", (ICriterionInstance)this.func_200403_a(Blocks.field_150366_p.func_199767_j())).func_218630_a(consumer);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_150435_aG), (IItemProvider)Blocks.field_150405_ch.func_199767_j(), (float)0.35f, (int)200).func_218628_a("has_clay_block", (ICriterionInstance)this.func_200403_a(Blocks.field_150435_aG)).func_218630_a(consumer);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_150424_aL), (IItemProvider)Items.field_196154_dH, (float)0.1f, (int)200).func_218628_a("has_netherrack", (ICriterionInstance)this.func_200403_a(Blocks.field_150424_aL)).func_218630_a(consumer);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_196766_fg), (IItemProvider)Items.field_151128_bU, (float)0.2f, (int)200).func_218628_a("has_nether_quartz_ore", (ICriterionInstance)this.func_200403_a(Blocks.field_196766_fg)).func_218630_a(consumer);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_150450_ax), (IItemProvider)Items.field_151137_ax, (float)0.7f, (int)200).func_218628_a("has_redstone_ore", (ICriterionInstance)this.func_200403_a(Blocks.field_150450_ax)).func_218632_a(consumer, "redstone_from_smelting");
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_196577_ad), (IItemProvider)Blocks.field_150360_v.func_199767_j(), (float)0.15f, (int)200).func_218628_a("has_wet_sponge", (ICriterionInstance)this.func_200403_a(Blocks.field_196577_ad)).func_218630_a(consumer);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_150347_e), (IItemProvider)Blocks.field_150348_b.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_cobblestone", (ICriterionInstance)this.func_200403_a(Blocks.field_150347_e)).func_218630_a(consumer);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_150348_b), (IItemProvider)Blocks.field_196579_bG.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_stone", (ICriterionInstance)this.func_200403_a(Blocks.field_150348_b)).func_218630_a(consumer);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_150322_A), (IItemProvider)Blocks.field_196580_bH.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_sandstone", (ICriterionInstance)this.func_200403_a(Blocks.field_150322_A)).func_218630_a(consumer);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_180395_cM), (IItemProvider)Blocks.field_196582_bJ.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_red_sandstone", (ICriterionInstance)this.func_200403_a(Blocks.field_180395_cM)).func_218630_a(consumer);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_150371_ca), (IItemProvider)Blocks.field_196581_bI.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_quartz_block", (ICriterionInstance)this.func_200403_a(Blocks.field_150371_ca)).func_218630_a(consumer);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_196696_di), (IItemProvider)Blocks.field_196700_dk.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_stone_bricks", (ICriterionInstance)this.func_200403_a(Blocks.field_196696_di)).func_218630_a(consumer);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_196722_fD), (IItemProvider)Blocks.field_192442_dQ.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_black_terracotta", (ICriterionInstance)this.func_200403_a(Blocks.field_196722_fD)).func_218630_a(consumer);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_196797_fz), (IItemProvider)Blocks.field_192438_dM.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_blue_terracotta", (ICriterionInstance)this.func_200403_a(Blocks.field_196797_fz)).func_218630_a(consumer);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_196719_fA), (IItemProvider)Blocks.field_192439_dN.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_brown_terracotta", (ICriterionInstance)this.func_200403_a(Blocks.field_196719_fA)).func_218630_a(consumer);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_196793_fx), (IItemProvider)Blocks.field_192436_dK.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_cyan_terracotta", (ICriterionInstance)this.func_200403_a(Blocks.field_196793_fx)).func_218630_a(consumer);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_196789_fv), (IItemProvider)Blocks.field_192434_dI.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_gray_terracotta", (ICriterionInstance)this.func_200403_a(Blocks.field_196789_fv)).func_218630_a(consumer);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_196720_fB), (IItemProvider)Blocks.field_192440_dO.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_green_terracotta", (ICriterionInstance)this.func_200403_a(Blocks.field_196720_fB)).func_218630_a(consumer);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_196782_fr), (IItemProvider)Blocks.field_192430_dE.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_light_blue_terracotta", (ICriterionInstance)this.func_200403_a(Blocks.field_196782_fr)).func_218630_a(consumer);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_196791_fw), (IItemProvider)Blocks.field_196876_iu.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_light_gray_terracotta", (ICriterionInstance)this.func_200403_a(Blocks.field_196791_fw)).func_218630_a(consumer);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_196785_ft), (IItemProvider)Blocks.field_192432_dG.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_lime_terracotta", (ICriterionInstance)this.func_200403_a(Blocks.field_196785_ft)).func_218630_a(consumer);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_196780_fq), (IItemProvider)Blocks.field_192429_dD.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_magenta_terracotta", (ICriterionInstance)this.func_200403_a(Blocks.field_196780_fq)).func_218630_a(consumer);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_196778_fp), (IItemProvider)Blocks.field_192428_dC.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_orange_terracotta", (ICriterionInstance)this.func_200403_a(Blocks.field_196778_fp)).func_218630_a(consumer);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_196787_fu), (IItemProvider)Blocks.field_192433_dH.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_pink_terracotta", (ICriterionInstance)this.func_200403_a(Blocks.field_196787_fu)).func_218630_a(consumer);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_196795_fy), (IItemProvider)Blocks.field_192437_dL.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_purple_terracotta", (ICriterionInstance)this.func_200403_a(Blocks.field_196795_fy)).func_218630_a(consumer);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_196721_fC), (IItemProvider)Blocks.field_192441_dP.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_red_terracotta", (ICriterionInstance)this.func_200403_a(Blocks.field_196721_fC)).func_218630_a(consumer);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_196777_fo), (IItemProvider)Blocks.field_192427_dB.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_white_terracotta", (ICriterionInstance)this.func_200403_a(Blocks.field_196777_fo)).func_218630_a(consumer);
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a(Blocks.field_196783_fs), (IItemProvider)Blocks.field_192431_dF.func_199767_j(), (float)0.1f, (int)200).func_218628_a("has_yellow_terracotta", (ICriterionInstance)this.func_200403_a(Blocks.field_196783_fs)).func_218630_a(consumer);
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a(Blocks.field_150366_p.func_199767_j()), (IItemProvider)Items.field_151042_j, (float)0.7f, (int)100).func_218628_a("has_iron_ore", (ICriterionInstance)this.func_200403_a(Blocks.field_150366_p.func_199767_j())).func_218632_a(consumer, "iron_ingot_from_blasting");
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a(Blocks.field_150352_o.func_199767_j()), (IItemProvider)Items.field_151043_k, (float)1.0f, (int)100).func_218628_a("has_gold_ore", (ICriterionInstance)this.func_200403_a(Blocks.field_150352_o)).func_218632_a(consumer, "gold_ingot_from_blasting");
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a(Blocks.field_150482_ag.func_199767_j()), (IItemProvider)Items.field_151045_i, (float)1.0f, (int)100).func_218628_a("has_diamond_ore", (ICriterionInstance)this.func_200403_a(Blocks.field_150482_ag)).func_218632_a(consumer, "diamond_from_blasting");
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a(Blocks.field_150369_x.func_199767_j()), (IItemProvider)Items.field_196128_bn, (float)0.2f, (int)100).func_218628_a("has_lapis_ore", (ICriterionInstance)this.func_200403_a(Blocks.field_150369_x)).func_218632_a(consumer, "lapis_from_blasting");
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a(Blocks.field_150450_ax), (IItemProvider)Items.field_151137_ax, (float)0.7f, (int)100).func_218628_a("has_redstone_ore", (ICriterionInstance)this.func_200403_a(Blocks.field_150450_ax)).func_218632_a(consumer, "redstone_from_blasting");
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a(Blocks.field_150365_q.func_199767_j()), (IItemProvider)Items.field_151044_h, (float)0.1f, (int)100).func_218628_a("has_coal_ore", (ICriterionInstance)this.func_200403_a(Blocks.field_150365_q)).func_218632_a(consumer, "coal_from_blasting");
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a(Blocks.field_150412_bA.func_199767_j()), (IItemProvider)Items.field_151166_bC, (float)1.0f, (int)100).func_218628_a("has_emerald_ore", (ICriterionInstance)this.func_200403_a(Blocks.field_150412_bA)).func_218632_a(consumer, "emerald_from_blasting");
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a(Blocks.field_196766_fg), (IItemProvider)Items.field_151128_bU, (float)0.2f, (int)100).func_218628_a("has_nether_quartz_ore", (ICriterionInstance)this.func_200403_a(Blocks.field_196766_fg)).func_218632_a(consumer, "quartz_from_blasting");
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a(Items.field_151005_D, Items.field_151011_C, Items.field_151006_E, Items.field_151013_M, Items.field_151010_B, Items.field_151169_ag, Items.field_151171_ah, Items.field_151149_ai, Items.field_151151_aj, Items.field_151136_bY), (IItemProvider)Items.field_151074_bl, (float)0.1f, (int)100).func_218628_a("has_golden_pickaxe", (ICriterionInstance)this.func_200403_a(Items.field_151005_D)).func_218628_a("has_golden_shovel", (ICriterionInstance)this.func_200403_a(Items.field_151011_C)).func_218628_a("has_golden_axe", (ICriterionInstance)this.func_200403_a(Items.field_151006_E)).func_218628_a("has_golden_hoe", (ICriterionInstance)this.func_200403_a(Items.field_151013_M)).func_218628_a("has_golden_sword", (ICriterionInstance)this.func_200403_a(Items.field_151010_B)).func_218628_a("has_golden_helmet", (ICriterionInstance)this.func_200403_a(Items.field_151169_ag)).func_218628_a("has_golden_chestplate", (ICriterionInstance)this.func_200403_a(Items.field_151171_ah)).func_218628_a("has_golden_leggings", (ICriterionInstance)this.func_200403_a(Items.field_151149_ai)).func_218628_a("has_golden_boots", (ICriterionInstance)this.func_200403_a(Items.field_151151_aj)).func_218628_a("has_golden_horse_armor", (ICriterionInstance)this.func_200403_a(Items.field_151136_bY)).func_218632_a(consumer, "gold_nugget_from_blasting");
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a(Items.field_151035_b, Items.field_151037_a, Items.field_151036_c, Items.field_151019_K, Items.field_151040_l, Items.field_151028_Y, Items.field_151030_Z, Items.field_151165_aa, Items.field_151167_ab, Items.field_151138_bX, Items.field_151020_U, Items.field_151023_V, Items.field_151022_W, Items.field_151029_X), (IItemProvider)Items.field_191525_da, (float)0.1f, (int)100).func_218628_a("has_iron_pickaxe", (ICriterionInstance)this.func_200403_a(Items.field_151035_b)).func_218628_a("has_iron_shovel", (ICriterionInstance)this.func_200403_a(Items.field_151037_a)).func_218628_a("has_iron_axe", (ICriterionInstance)this.func_200403_a(Items.field_151036_c)).func_218628_a("has_iron_hoe", (ICriterionInstance)this.func_200403_a(Items.field_151019_K)).func_218628_a("has_iron_sword", (ICriterionInstance)this.func_200403_a(Items.field_151040_l)).func_218628_a("has_iron_helmet", (ICriterionInstance)this.func_200403_a(Items.field_151028_Y)).func_218628_a("has_iron_chestplate", (ICriterionInstance)this.func_200403_a(Items.field_151030_Z)).func_218628_a("has_iron_leggings", (ICriterionInstance)this.func_200403_a(Items.field_151165_aa)).func_218628_a("has_iron_boots", (ICriterionInstance)this.func_200403_a(Items.field_151167_ab)).func_218628_a("has_iron_horse_armor", (ICriterionInstance)this.func_200403_a(Items.field_151138_bX)).func_218628_a("has_chainmail_helmet", (ICriterionInstance)this.func_200403_a(Items.field_151020_U)).func_218628_a("has_chainmail_chestplate", (ICriterionInstance)this.func_200403_a(Items.field_151023_V)).func_218628_a("has_chainmail_leggings", (ICriterionInstance)this.func_200403_a(Items.field_151022_W)).func_218628_a("has_chainmail_boots", (ICriterionInstance)this.func_200403_a(Items.field_151029_X)).func_218632_a(consumer, "iron_nugget_from_blasting");
        this.func_218445_a(consumer, "smoking", IRecipeSerializer.field_222173_q, 100);
        this.func_218445_a(consumer, "campfire_cooking", IRecipeSerializer.field_222174_r, 600);
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150348_b), (IItemProvider)Blocks.field_150333_U, (int)2).func_218643_a("has_stone", (ICriterionInstance)this.func_200403_a(Blocks.field_150348_b)).func_218645_a(consumer, "stone_slab_from_stone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150348_b), (IItemProvider)Blocks.field_222438_lb).func_218643_a("has_stone", (ICriterionInstance)this.func_200403_a(Blocks.field_150348_b)).func_218645_a(consumer, "stone_stairs_from_stone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150348_b), (IItemProvider)Blocks.field_196696_di).func_218643_a("has_stone", (ICriterionInstance)this.func_200403_a(Blocks.field_150348_b)).func_218645_a(consumer, "stone_bricks_from_stone_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150348_b), (IItemProvider)Blocks.field_196573_bB, (int)2).func_218643_a("has_stone", (ICriterionInstance)this.func_200403_a(Blocks.field_150348_b)).func_218645_a(consumer, "stone_brick_slab_from_stone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150348_b), (IItemProvider)Blocks.field_150390_bg).func_218643_a("has_stone", (ICriterionInstance)this.func_200403_a(Blocks.field_150348_b)).func_218645_a(consumer, "stone_brick_stairs_from_stone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150348_b), (IItemProvider)Blocks.field_196702_dl).func_218643_a("has_stone", (ICriterionInstance)this.func_200403_a(Blocks.field_150348_b)).func_218645_a(consumer, "chiseled_stone_bricks_stone_from_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150348_b), (IItemProvider)Blocks.field_222413_lB).func_218643_a("has_stone", (ICriterionInstance)this.func_200403_a(Blocks.field_150348_b)).func_218645_a(consumer, "stone_brick_walls_from_stone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150322_A), (IItemProvider)Blocks.field_196585_ak).func_218643_a("has_sandstone", (ICriterionInstance)this.func_200403_a(Blocks.field_150322_A)).func_218645_a(consumer, "cut_sandstone_from_sandstone_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150322_A), (IItemProvider)Blocks.field_196640_bx, (int)2).func_218643_a("has_sandstone", (ICriterionInstance)this.func_200403_a(Blocks.field_150322_A)).func_218645_a(consumer, "sandstone_slab_from_sandstone_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150322_A), (IItemProvider)Blocks.field_222402_hL, (int)2).func_218643_a("has_sandstone", (ICriterionInstance)this.func_200403_a(Blocks.field_150322_A)).func_218645_a(consumer, "cut_sandstone_slab_from_sandstone_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196585_ak), (IItemProvider)Blocks.field_222402_hL, (int)2).func_218643_a("has_cut_sandstone", (ICriterionInstance)this.func_200403_a(Blocks.field_150322_A)).func_218645_a(consumer, "cut_sandstone_slab_from_cut_sandstone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150322_A), (IItemProvider)Blocks.field_150372_bz).func_218643_a("has_sandstone", (ICriterionInstance)this.func_200403_a(Blocks.field_150322_A)).func_218645_a(consumer, "sandstone_stairs_from_sandstone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150322_A), (IItemProvider)Blocks.field_222417_lF).func_218643_a("has_sandstone", (ICriterionInstance)this.func_200403_a(Blocks.field_150322_A)).func_218645_a(consumer, "sandstone_wall_from_sandstone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150322_A), (IItemProvider)Blocks.field_196583_aj).func_218643_a("has_sandstone", (ICriterionInstance)this.func_200403_a(Blocks.field_150322_A)).func_218645_a(consumer, "chiseled_sandstone_from_sandstone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_180395_cM), (IItemProvider)Blocks.field_196799_hB).func_218643_a("has_red_sandstone", (ICriterionInstance)this.func_200403_a(Blocks.field_180395_cM)).func_218645_a(consumer, "cut_red_sandstone_from_red_sandstone_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_180395_cM), (IItemProvider)Blocks.field_196578_bE, (int)2).func_218643_a("has_red_sandstone", (ICriterionInstance)this.func_200403_a(Blocks.field_180395_cM)).func_218645_a(consumer, "red_sandstone_slab_from_red_sandstone_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_180395_cM), (IItemProvider)Blocks.field_222403_hT, (int)2).func_218643_a("has_red_sandstone", (ICriterionInstance)this.func_200403_a(Blocks.field_180395_cM)).func_218645_a(consumer, "cut_red_sandstone_slab_from_red_sandstone_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196799_hB), (IItemProvider)Blocks.field_222403_hT, (int)2).func_218643_a("has_cut_red_sandstone", (ICriterionInstance)this.func_200403_a(Blocks.field_180395_cM)).func_218645_a(consumer, "cut_red_sandstone_slab_from_cut_red_sandstone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_180395_cM), (IItemProvider)Blocks.field_180396_cN).func_218643_a("has_red_sandstone", (ICriterionInstance)this.func_200403_a(Blocks.field_180395_cM)).func_218645_a(consumer, "red_sandstone_stairs_from_red_sandstone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_180395_cM), (IItemProvider)Blocks.field_222461_ly).func_218643_a("has_red_sandstone", (ICriterionInstance)this.func_200403_a(Blocks.field_180395_cM)).func_218645_a(consumer, "red_sandstone_wall_from_red_sandstone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_180395_cM), (IItemProvider)Blocks.field_196798_hA).func_218643_a("has_red_sandstone", (ICriterionInstance)this.func_200403_a(Blocks.field_180395_cM)).func_218645_a(consumer, "chiseled_red_sandstone_from_red_sandstone_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150371_ca), (IItemProvider)Blocks.field_196576_bD, (int)2).func_218643_a("has_quartz_block", (ICriterionInstance)this.func_200403_a(Blocks.field_150371_ca)).func_218645_a(consumer, "quartz_slab_from_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150371_ca), (IItemProvider)Blocks.field_150370_cb).func_218643_a("has_quartz_block", (ICriterionInstance)this.func_200403_a(Blocks.field_150371_ca)).func_218645_a(consumer, "quartz_stairs_from_quartz_block_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150371_ca), (IItemProvider)Blocks.field_196770_fj).func_218643_a("has_quartz_block", (ICriterionInstance)this.func_200403_a(Blocks.field_150371_ca)).func_218645_a(consumer, "quartz_pillar_from_quartz_block_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150371_ca), (IItemProvider)Blocks.field_196772_fk).func_218643_a("has_quartz_block", (ICriterionInstance)this.func_200403_a(Blocks.field_150371_ca)).func_218645_a(consumer, "chiseled_quartz_block_from_quartz_block_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150347_e), (IItemProvider)Blocks.field_196659_cl).func_218643_a("has_cobblestone", (ICriterionInstance)this.func_200403_a(Blocks.field_150347_e)).func_218645_a(consumer, "cobblestone_stairs_from_cobblestone_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150347_e), (IItemProvider)Blocks.field_196646_bz, (int)2).func_218643_a("has_cobblestone", (ICriterionInstance)this.func_200403_a(Blocks.field_150347_e)).func_218645_a(consumer, "cobblestone_slab_from_cobblestone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150347_e), (IItemProvider)Blocks.field_150463_bK).func_218643_a("has_cobblestone", (ICriterionInstance)this.func_200403_a(Blocks.field_150347_e)).func_218645_a(consumer, "cobblestone_wall_from_cobblestone_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196696_di), (IItemProvider)Blocks.field_196573_bB, (int)2).func_218643_a("has_stone_bricks", (ICriterionInstance)this.func_200403_a(Blocks.field_196696_di)).func_218645_a(consumer, "stone_brick_slab_from_stone_bricks_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196696_di), (IItemProvider)Blocks.field_150390_bg).func_218643_a("has_stone_bricks", (ICriterionInstance)this.func_200403_a(Blocks.field_196696_di)).func_218645_a(consumer, "stone_brick_stairs_from_stone_bricks_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196696_di), (IItemProvider)Blocks.field_222413_lB).func_218643_a("has_stone_bricks", (ICriterionInstance)this.func_200403_a(Blocks.field_196696_di)).func_218645_a(consumer, "stone_brick_wall_from_stone_bricks_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196696_di), (IItemProvider)Blocks.field_196702_dl).func_218643_a("has_stone_bricks", (ICriterionInstance)this.func_200403_a(Blocks.field_196696_di)).func_218645_a(consumer, "chiseled_stone_bricks_from_stone_bricks_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196584_bK), (IItemProvider)Blocks.field_196571_bA, (int)2).func_218643_a("has_bricks", (ICriterionInstance)this.func_200403_a(Blocks.field_196584_bK)).func_218645_a(consumer, "brick_slab_from_bricks_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196584_bK), (IItemProvider)Blocks.field_150389_bf).func_218643_a("has_bricks", (ICriterionInstance)this.func_200403_a(Blocks.field_196584_bK)).func_218645_a(consumer, "brick_stairs_from_bricks_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196584_bK), (IItemProvider)Blocks.field_222459_lw).func_218643_a("has_bricks", (ICriterionInstance)this.func_200403_a(Blocks.field_196584_bK)).func_218645_a(consumer, "brick_wall_from_bricks_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196653_dH), (IItemProvider)Blocks.field_196575_bC, (int)2).func_218643_a("has_nether_bricks", (ICriterionInstance)this.func_200403_a(Blocks.field_196653_dH)).func_218645_a(consumer, "nether_brick_slab_from_nether_bricks_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196653_dH), (IItemProvider)Blocks.field_150387_bl).func_218643_a("has_nether_bricks", (ICriterionInstance)this.func_200403_a(Blocks.field_196653_dH)).func_218645_a(consumer, "nether_brick_stairs_from_nether_bricks_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196653_dH), (IItemProvider)Blocks.field_222414_lC).func_218643_a("has_nether_bricks", (ICriterionInstance)this.func_200403_a(Blocks.field_196653_dH)).func_218645_a(consumer, "nether_brick_wall_from_nether_bricks_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196817_hS), (IItemProvider)Blocks.field_222456_lt, (int)2).func_218643_a("has_nether_bricks", (ICriterionInstance)this.func_200403_a(Blocks.field_196817_hS)).func_218645_a(consumer, "red_nether_brick_slab_from_red_nether_bricks_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196817_hS), (IItemProvider)Blocks.field_222443_lg).func_218643_a("has_nether_bricks", (ICriterionInstance)this.func_200403_a(Blocks.field_196817_hS)).func_218645_a(consumer, "red_nether_brick_stairs_from_red_nether_bricks_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196817_hS), (IItemProvider)Blocks.field_222416_lE).func_218643_a("has_nether_bricks", (ICriterionInstance)this.func_200403_a(Blocks.field_196817_hS)).func_218645_a(consumer, "red_nether_brick_wall_from_red_nether_bricks_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_185767_cT), (IItemProvider)Blocks.field_185771_cX, (int)2).func_218643_a("has_purpur_block", (ICriterionInstance)this.func_200403_a(Blocks.field_185767_cT)).func_218645_a(consumer, "purpur_slab_from_purpur_block_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_185767_cT), (IItemProvider)Blocks.field_185769_cV).func_218643_a("has_purpur_block", (ICriterionInstance)this.func_200403_a(Blocks.field_185767_cT)).func_218645_a(consumer, "purpur_stairs_from_purpur_block_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_185767_cT), (IItemProvider)Blocks.field_185768_cU).func_218643_a("has_purpur_block", (ICriterionInstance)this.func_200403_a(Blocks.field_185767_cT)).func_218645_a(consumer, "purpur_pillar_from_purpur_block_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_180397_cI), (IItemProvider)Blocks.field_203200_bP, (int)2).func_218643_a("has_prismarine", (ICriterionInstance)this.func_200403_a(Blocks.field_180397_cI)).func_218645_a(consumer, "prismarine_slab_from_prismarine_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_180397_cI), (IItemProvider)Blocks.field_203210_he).func_218643_a("has_prismarine", (ICriterionInstance)this.func_200403_a(Blocks.field_180397_cI)).func_218645_a(consumer, "prismarine_stairs_from_prismarine_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_180397_cI), (IItemProvider)Blocks.field_222460_lx).func_218643_a("has_prismarine", (ICriterionInstance)this.func_200403_a(Blocks.field_180397_cI)).func_218645_a(consumer, "prismarine_wall_from_prismarine_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196779_gQ), (IItemProvider)Blocks.field_203201_bQ, (int)2).func_218643_a("has_prismarine_brick", (ICriterionInstance)this.func_200403_a(Blocks.field_196779_gQ)).func_218645_a(consumer, "prismarine_brick_slab_from_prismarine_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196779_gQ), (IItemProvider)Blocks.field_203211_hf).func_218643_a("has_prismarine_brick", (ICriterionInstance)this.func_200403_a(Blocks.field_196779_gQ)).func_218645_a(consumer, "prismarine_brick_stairs_from_prismarine_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196781_gR), (IItemProvider)Blocks.field_203202_bR, (int)2).func_218643_a("has_dark_prismarine", (ICriterionInstance)this.func_200403_a(Blocks.field_196781_gR)).func_218645_a(consumer, "dark_prismarine_slab_from_dark_prismarine_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196781_gR), (IItemProvider)Blocks.field_203212_hg).func_218643_a("has_dark_prismarine", (ICriterionInstance)this.func_200403_a(Blocks.field_196781_gR)).func_218645_a(consumer, "dark_prismarine_stairs_from_dark_prismarine_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196656_g), (IItemProvider)Blocks.field_222455_ls, (int)2).func_218643_a("has_andesite", (ICriterionInstance)this.func_200403_a(Blocks.field_196656_g)).func_218645_a(consumer, "andesite_slab_from_andesite_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196656_g), (IItemProvider)Blocks.field_222442_lf).func_218643_a("has_andesite", (ICriterionInstance)this.func_200403_a(Blocks.field_196656_g)).func_218645_a(consumer, "andesite_stairs_from_andesite_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196656_g), (IItemProvider)Blocks.field_222415_lD).func_218643_a("has_andesite", (ICriterionInstance)this.func_200403_a(Blocks.field_196656_g)).func_218645_a(consumer, "andesite_wall_from_andesite_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196656_g), (IItemProvider)Blocks.field_196657_h).func_218643_a("has_andesite", (ICriterionInstance)this.func_200403_a(Blocks.field_196656_g)).func_218645_a(consumer, "polished_andesite_from_andesite_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196656_g), (IItemProvider)Blocks.field_222457_lu, (int)2).func_218643_a("has_andesite", (ICriterionInstance)this.func_200403_a(Blocks.field_196656_g)).func_218645_a(consumer, "polished_andesite_slab_from_andesite_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196656_g), (IItemProvider)Blocks.field_222444_lh).func_218643_a("has_andesite", (ICriterionInstance)this.func_200403_a(Blocks.field_196656_g)).func_218645_a(consumer, "polished_andesite_stairs_from_andesite_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196657_h), (IItemProvider)Blocks.field_222457_lu, (int)2).func_218643_a("has_polished_andesite", (ICriterionInstance)this.func_200403_a(Blocks.field_196657_h)).func_218645_a(consumer, "polished_andesite_slab_from_polished_andesite_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196657_h), (IItemProvider)Blocks.field_222444_lh).func_218643_a("has_polished_andesite", (ICriterionInstance)this.func_200403_a(Blocks.field_196657_h)).func_218645_a(consumer, "polished_andesite_stairs_from_polished_andesite_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196650_c), (IItemProvider)Blocks.field_222454_lr, (int)2).func_218643_a("has_granite", (ICriterionInstance)this.func_200403_a(Blocks.field_196650_c)).func_218645_a(consumer, "granite_slab_from_granite_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196650_c), (IItemProvider)Blocks.field_222441_le).func_218643_a("has_granite", (ICriterionInstance)this.func_200403_a(Blocks.field_196650_c)).func_218645_a(consumer, "granite_stairs_from_granite_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196650_c), (IItemProvider)Blocks.field_222412_lA).func_218643_a("has_granite", (ICriterionInstance)this.func_200403_a(Blocks.field_196650_c)).func_218645_a(consumer, "granite_wall_from_granite_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196650_c), (IItemProvider)Blocks.field_196652_d).func_218643_a("has_granite", (ICriterionInstance)this.func_200403_a(Blocks.field_196650_c)).func_218645_a(consumer, "polished_granite_from_granite_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196650_c), (IItemProvider)Blocks.field_222446_lj, (int)2).func_218643_a("has_granite", (ICriterionInstance)this.func_200403_a(Blocks.field_196650_c)).func_218645_a(consumer, "polished_granite_slab_from_granite_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196650_c), (IItemProvider)Blocks.field_222407_kV).func_218643_a("has_granite", (ICriterionInstance)this.func_200403_a(Blocks.field_196650_c)).func_218645_a(consumer, "polished_granite_stairs_from_granite_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196652_d), (IItemProvider)Blocks.field_222446_lj, (int)2).func_218643_a("has_polished_granite", (ICriterionInstance)this.func_200403_a(Blocks.field_196652_d)).func_218645_a(consumer, "polished_granite_slab_from_polished_granite_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196652_d), (IItemProvider)Blocks.field_222407_kV).func_218643_a("has_polished_granite", (ICriterionInstance)this.func_200403_a(Blocks.field_196652_d)).func_218645_a(consumer, "polished_granite_stairs_from_polished_granite_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196654_e), (IItemProvider)Blocks.field_222458_lv, (int)2).func_218643_a("has_diorite", (ICriterionInstance)this.func_200403_a(Blocks.field_196654_e)).func_218645_a(consumer, "diorite_slab_from_diorite_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196654_e), (IItemProvider)Blocks.field_222445_li).func_218643_a("has_diorite", (ICriterionInstance)this.func_200403_a(Blocks.field_196654_e)).func_218645_a(consumer, "diorite_stairs_from_diorite_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196654_e), (IItemProvider)Blocks.field_222419_lH).func_218643_a("has_diorite", (ICriterionInstance)this.func_200403_a(Blocks.field_196654_e)).func_218645_a(consumer, "diorite_wall_from_diorite_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196654_e), (IItemProvider)Blocks.field_196655_f).func_218643_a("has_diorite", (ICriterionInstance)this.func_200403_a(Blocks.field_196654_e)).func_218645_a(consumer, "polished_diorite_from_diorite_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196654_e), (IItemProvider)Blocks.field_222449_lm, (int)2).func_218643_a("has_diorite", (ICriterionInstance)this.func_200403_a(Blocks.field_196655_f)).func_218645_a(consumer, "polished_diorite_slab_from_diorite_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196654_e), (IItemProvider)Blocks.field_222410_kY).func_218643_a("has_diorite", (ICriterionInstance)this.func_200403_a(Blocks.field_196655_f)).func_218645_a(consumer, "polished_diorite_stairs_from_diorite_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196655_f), (IItemProvider)Blocks.field_222449_lm, (int)2).func_218643_a("has_polished_diorite", (ICriterionInstance)this.func_200403_a(Blocks.field_196655_f)).func_218645_a(consumer, "polished_diorite_slab_from_polished_diorite_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196655_f), (IItemProvider)Blocks.field_222410_kY).func_218643_a("has_polished_diorite", (ICriterionInstance)this.func_200403_a(Blocks.field_196655_f)).func_218645_a(consumer, "polished_diorite_stairs_from_polished_diorite_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196698_dj), (IItemProvider)Blocks.field_222448_ll, (int)2).func_218643_a("has_mossy_stone_bricks", (ICriterionInstance)this.func_200403_a(Blocks.field_196698_dj)).func_218645_a(consumer, "mossy_stone_brick_slab_from_mossy_stone_brick_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196698_dj), (IItemProvider)Blocks.field_222409_kX).func_218643_a("has_mossy_stone_bricks", (ICriterionInstance)this.func_200403_a(Blocks.field_196698_dj)).func_218645_a(consumer, "mossy_stone_brick_stairs_from_mossy_stone_brick_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196698_dj), (IItemProvider)Blocks.field_222462_lz).func_218643_a("has_mossy_stone_bricks", (ICriterionInstance)this.func_200403_a(Blocks.field_196698_dj)).func_218645_a(consumer, "mossy_stone_brick_wall_from_mossy_stone_brick_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150341_Y), (IItemProvider)Blocks.field_222450_ln, (int)2).func_218643_a("has_mossy_cobblestone", (ICriterionInstance)this.func_200403_a(Blocks.field_150341_Y)).func_218645_a(consumer, "mossy_cobblestone_slab_from_mossy_cobblestone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150341_Y), (IItemProvider)Blocks.field_222411_kZ).func_218643_a("has_mossy_cobblestone", (ICriterionInstance)this.func_200403_a(Blocks.field_150341_Y)).func_218645_a(consumer, "mossy_cobblestone_stairs_from_mossy_cobblestone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150341_Y), (IItemProvider)Blocks.field_196723_eg).func_218643_a("has_mossy_cobblestone", (ICriterionInstance)this.func_200403_a(Blocks.field_150341_Y)).func_218645_a(consumer, "mossy_cobblestone_wall_from_mossy_cobblestone_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196580_bH), (IItemProvider)Blocks.field_222452_lp, (int)2).func_218643_a("has_smooth_sandstone", (ICriterionInstance)this.func_200403_a(Blocks.field_196580_bH)).func_218645_a(consumer, "smooth_sandstone_slab_from_smooth_sandstone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196580_bH), (IItemProvider)Blocks.field_222439_lc).func_218643_a("has_mossy_cobblestone", (ICriterionInstance)this.func_200403_a(Blocks.field_196580_bH)).func_218645_a(consumer, "smooth_sandstone_stairs_from_smooth_sandstone_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196582_bJ), (IItemProvider)Blocks.field_222447_lk, (int)2).func_218643_a("has_smooth_red_sandstone", (ICriterionInstance)this.func_200403_a(Blocks.field_196582_bJ)).func_218645_a(consumer, "smooth_red_sandstone_slab_from_smooth_red_sandstone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196582_bJ), (IItemProvider)Blocks.field_222408_kW).func_218643_a("has_smooth_red_sandstone", (ICriterionInstance)this.func_200403_a(Blocks.field_196582_bJ)).func_218645_a(consumer, "smooth_red_sandstone_stairs_from_smooth_red_sandstone_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196581_bI), (IItemProvider)Blocks.field_222453_lq, (int)2).func_218643_a("has_smooth_quartz", (ICriterionInstance)this.func_200403_a(Blocks.field_196581_bI)).func_218645_a(consumer, "smooth_quartz_slab_from_smooth_quartz_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196581_bI), (IItemProvider)Blocks.field_222440_ld).func_218643_a("has_smooth_quartz", (ICriterionInstance)this.func_200403_a(Blocks.field_196581_bI)).func_218645_a(consumer, "smooth_quartz_stairs_from_smooth_quartz_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196806_hJ), (IItemProvider)Blocks.field_222451_lo, (int)2).func_218643_a("has_end_stone_brick", (ICriterionInstance)this.func_200403_a(Blocks.field_196806_hJ)).func_218645_a(consumer, "end_stone_brick_slab_from_end_stone_brick_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196806_hJ), (IItemProvider)Blocks.field_222437_la).func_218643_a("has_end_stone_brick", (ICriterionInstance)this.func_200403_a(Blocks.field_196806_hJ)).func_218645_a(consumer, "end_stone_brick_stairs_from_end_stone_brick_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196806_hJ), (IItemProvider)Blocks.field_222418_lG).func_218643_a("has_end_stone_brick", (ICriterionInstance)this.func_200403_a(Blocks.field_196806_hJ)).func_218645_a(consumer, "end_stone_brick_wall_from_end_stone_brick_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150377_bs), (IItemProvider)Blocks.field_196806_hJ).func_218643_a("has_end_stone", (ICriterionInstance)this.func_200403_a(Blocks.field_150377_bs)).func_218645_a(consumer, "end_stone_bricks_from_end_stone_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150377_bs), (IItemProvider)Blocks.field_222451_lo, (int)2).func_218643_a("has_end_stone", (ICriterionInstance)this.func_200403_a(Blocks.field_150377_bs)).func_218645_a(consumer, "end_stone_brick_slab_from_end_stone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150377_bs), (IItemProvider)Blocks.field_222437_la).func_218643_a("has_end_stone", (ICriterionInstance)this.func_200403_a(Blocks.field_150377_bs)).func_218645_a(consumer, "end_stone_brick_stairs_from_end_stone_stonecutting");
        SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a(Blocks.field_150377_bs), (IItemProvider)Blocks.field_222418_lG).func_218643_a("has_end_stone", (ICriterionInstance)this.func_200403_a(Blocks.field_150377_bs)).func_218645_a(consumer, "end_stone_brick_wall_from_end_stone_stonecutting");
        SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a(Blocks.field_196579_bG), (IItemProvider)Blocks.field_222401_hJ, (int)2).func_218643_a("has_smooth_stone", (ICriterionInstance)this.func_200403_a(Blocks.field_196579_bG)).func_218645_a(consumer, "smooth_stone_slab_from_smooth_stone_stonecutting");
    }

    private void func_218445_a(Consumer<IFinishedRecipe> recipeConsumerIn, String cookingMethod, CookingRecipeSerializer<?> serializerIn, int cookingTimeIn) {
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a(Items.field_151082_bd), (IItemProvider)Items.field_151083_be, (float)0.35f, (int)cookingTimeIn, serializerIn).func_218628_a("has_beef", (ICriterionInstance)this.func_200403_a(Items.field_151082_bd)).func_218632_a(recipeConsumerIn, "cooked_beef_from_" + cookingMethod);
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a(Items.field_151076_bf), (IItemProvider)Items.field_151077_bg, (float)0.35f, (int)cookingTimeIn, serializerIn).func_218628_a("has_chicken", (ICriterionInstance)this.func_200403_a(Items.field_151076_bf)).func_218632_a(recipeConsumerIn, "cooked_chicken_from_" + cookingMethod);
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a(Items.field_196086_aW), (IItemProvider)Items.field_196102_ba, (float)0.35f, (int)cookingTimeIn, serializerIn).func_218628_a("has_cod", (ICriterionInstance)this.func_200403_a(Items.field_196086_aW)).func_218632_a(recipeConsumerIn, "cooked_cod_from_" + cookingMethod);
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a(Blocks.field_203214_jx), (IItemProvider)Items.field_203180_bP, (float)0.1f, (int)cookingTimeIn, serializerIn).func_218628_a("has_kelp", (ICriterionInstance)this.func_200403_a(Blocks.field_203214_jx)).func_218632_a(recipeConsumerIn, "dried_kelp_from_" + cookingMethod);
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a(Items.field_196087_aX), (IItemProvider)Items.field_196104_bb, (float)0.35f, (int)cookingTimeIn, serializerIn).func_218628_a("has_salmon", (ICriterionInstance)this.func_200403_a(Items.field_196087_aX)).func_218632_a(recipeConsumerIn, "cooked_salmon_from_" + cookingMethod);
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a(Items.field_179561_bm), (IItemProvider)Items.field_179557_bn, (float)0.35f, (int)cookingTimeIn, serializerIn).func_218628_a("has_mutton", (ICriterionInstance)this.func_200403_a(Items.field_179561_bm)).func_218632_a(recipeConsumerIn, "cooked_mutton_from_" + cookingMethod);
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a(Items.field_151147_al), (IItemProvider)Items.field_151157_am, (float)0.35f, (int)cookingTimeIn, serializerIn).func_218628_a("has_porkchop", (ICriterionInstance)this.func_200403_a(Items.field_151147_al)).func_218632_a(recipeConsumerIn, "cooked_porkchop_from_" + cookingMethod);
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a(Items.field_151174_bG), (IItemProvider)Items.field_151168_bH, (float)0.35f, (int)cookingTimeIn, serializerIn).func_218628_a("has_potato", (ICriterionInstance)this.func_200403_a(Items.field_151174_bG)).func_218632_a(recipeConsumerIn, "baked_potato_from_" + cookingMethod);
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a(Items.field_179558_bo), (IItemProvider)Items.field_179559_bp, (float)0.35f, (int)cookingTimeIn, serializerIn).func_218628_a("has_rabbit", (ICriterionInstance)this.func_200403_a(Items.field_179558_bo)).func_218632_a(recipeConsumerIn, "cooked_rabbit_from_" + cookingMethod);
    }

    protected EnterBlockTrigger.Instance func_200407_a(Block blockIn) {
        return new EnterBlockTrigger.Instance(blockIn, StatePropertiesPredicate.field_227178_a_);
    }

    protected InventoryChangeTrigger.Instance func_200403_a(IItemProvider itemIn) {
        return this.func_200405_a(ItemPredicate.Builder.func_200309_a().func_200308_a(itemIn).func_200310_b());
    }

    protected InventoryChangeTrigger.Instance func_200409_a(Tag<Item> tagIn) {
        return this.func_200405_a(ItemPredicate.Builder.func_200309_a().func_200307_a(tagIn).func_200310_b());
    }

    protected InventoryChangeTrigger.Instance func_200405_a(ItemPredicate ... predicates) {
        return new InventoryChangeTrigger.Instance(MinMaxBounds.IntBound.field_211347_e, MinMaxBounds.IntBound.field_211347_e, MinMaxBounds.IntBound.field_211347_e, predicates);
    }

    public String func_200397_b() {
        return "Recipes";
    }
}

