/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import java.util.UUID;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class LlamaSpitEntity
extends Entity
implements IProjectile {
    public LlamaEntity field_190539_a;
    private CompoundNBT field_190540_b;

    public LlamaSpitEntity(EntityType<? extends LlamaSpitEntity> p_i50162_1_, World p_i50162_2_) {
        super(p_i50162_1_, p_i50162_2_);
    }

    public LlamaSpitEntity(World worldIn, LlamaEntity p_i47273_2_) {
        this((EntityType<? extends LlamaSpitEntity>)EntityType.field_200770_J, worldIn);
        this.field_190539_a = p_i47273_2_;
        this.func_70107_b(p_i47273_2_.func_226277_ct_() - (double)(p_i47273_2_.func_213311_cf() + 1.0f) * 0.5 * (double)MathHelper.func_76126_a((float)(p_i47273_2_.field_70761_aq * ((float)Math.PI / 180))), p_i47273_2_.func_226280_cw_() - (double)0.1f, p_i47273_2_.func_226281_cx_() + (double)(p_i47273_2_.func_213311_cf() + 1.0f) * 0.5 * (double)MathHelper.func_76134_b((float)(p_i47273_2_.field_70761_aq * ((float)Math.PI / 180))));
    }

    @OnlyIn(value=Dist.CLIENT)
    public LlamaSpitEntity(World worldIn, double x, double y, double z, double p_i47274_8_, double p_i47274_10_, double p_i47274_12_) {
        this((EntityType<? extends LlamaSpitEntity>)EntityType.field_200770_J, worldIn);
        this.func_70107_b(x, y, z);
        for (int i = 0; i < 7; ++i) {
            double d0 = 0.4 + 0.1 * (double)i;
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197602_M, x, y, z, p_i47274_8_ * d0, p_i47274_10_, p_i47274_12_ * d0);
        }
        this.func_213293_j(p_i47274_8_, p_i47274_10_, p_i47274_12_);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_190540_b != null) {
            this.func_190537_j();
        }
        Vec3d vec3d = this.func_213322_ci();
        RayTraceResult raytraceresult = ProjectileHelper.func_221267_a(this, this.func_174813_aQ().func_216361_a(vec3d).func_186662_g(1.0), p_213879_1_ -> !p_213879_1_.func_175149_v() && p_213879_1_ != this.field_190539_a, RayTraceContext.BlockMode.OUTLINE, true);
        if (raytraceresult != null && raytraceresult.func_216346_c() != RayTraceResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
            this.func_190536_a(raytraceresult);
        }
        double d0 = this.func_226277_ct_() + vec3d.field_72450_a;
        double d1 = this.func_226278_cu_() + vec3d.field_72448_b;
        double d2 = this.func_226281_cx_() + vec3d.field_72449_c;
        float f = MathHelper.func_76133_a((double)LlamaSpitEntity.func_213296_b(vec3d));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)f) * 57.2957763671875);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = MathHelper.func_219799_g((float)0.2f, (float)this.field_70127_C, (float)this.field_70125_A);
        this.field_70177_z = MathHelper.func_219799_g((float)0.2f, (float)this.field_70126_B, (float)this.field_70177_z);
        float f1 = 0.99f;
        float f2 = 0.06f;
        if (!this.field_70170_p.func_72875_a(this.func_174813_aQ(), Material.field_151579_a)) {
            this.func_70106_y();
        } else if (this.func_203005_aq()) {
            this.func_70106_y();
        } else {
            this.func_213317_d(vec3d.func_186678_a(0.99f));
            if (!this.func_189652_ae()) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.06f, 0.0));
            }
            this.func_70107_b(d0, d1, d2);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.func_213293_j(x, y, z);
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.2957763671875);
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.2957763671875);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
        }
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3d vec3d = new Vec3d(x, y, z).func_72432_b().func_72441_c(this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy).func_186678_a(velocity);
        this.func_213317_d(vec3d);
        float f = MathHelper.func_76133_a((double)LlamaSpitEntity.func_213296_b(vec3d));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)z) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)f) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    public void func_190536_a(RayTraceResult p_190536_1_) {
        RayTraceResult.Type raytraceresult$type = p_190536_1_.func_216346_c();
        if (raytraceresult$type == RayTraceResult.Type.ENTITY && this.field_190539_a != null) {
            ((EntityRayTraceResult)p_190536_1_).func_216348_a().func_70097_a(DamageSource.func_188403_a((Entity)this, (LivingEntity)this.field_190539_a).func_76349_b(), 1.0f);
        } else if (raytraceresult$type == RayTraceResult.Type.BLOCK && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }

    @Override
    protected void func_70088_a() {
    }

    @Override
    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_150297_b("Owner", 10)) {
            this.field_190540_b = compound.func_74775_l("Owner");
        }
    }

    @Override
    protected void func_213281_b(CompoundNBT compound) {
        if (this.field_190539_a != null) {
            CompoundNBT compoundnbt = new CompoundNBT();
            UUID uuid = this.field_190539_a.func_110124_au();
            compoundnbt.func_186854_a("OwnerUUID", uuid);
            compound.func_218657_a("Owner", compoundnbt);
        }
    }

    private void func_190537_j() {
        if (this.field_190540_b != null && this.field_190540_b.func_186855_b("OwnerUUID")) {
            UUID uuid = this.field_190540_b.func_186857_a("OwnerUUID");
            for (LlamaEntity llamaentity : this.field_70170_p.func_217357_a(LlamaEntity.class, this.func_174813_aQ().func_186662_g(15.0))) {
                if (!llamaentity.func_110124_au().equals(uuid)) continue;
                this.field_190539_a = llamaentity;
                break;
            }
        }
        this.field_190540_b = null;
    }

    @Override
    public IPacket<?> func_213297_N() {
        return new SSpawnObjectPacket((Entity)this);
    }
}

