/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class ProjectileHelper {
    public static RayTraceResult func_221266_a(Entity p_221266_0_, boolean p_221266_1_, boolean p_221266_2_, @Nullable Entity p_221266_3_, RayTraceContext.BlockMode p_221266_4_) {
        return ProjectileHelper.func_221268_a(p_221266_0_, p_221266_1_, p_221266_2_, p_221266_3_, p_221266_4_, true, p_221270_2_ -> !p_221270_2_.func_175149_v() && p_221270_2_.func_70067_L() && (p_221266_2_ || !p_221270_2_.func_70028_i(p_221266_3_)) && !p_221270_2_.field_70145_X, p_221266_0_.func_174813_aQ().func_216361_a(p_221266_0_.func_213322_ci()).func_186662_g(1.0));
    }

    public static RayTraceResult func_221267_a(Entity p_221267_0_, AxisAlignedBB p_221267_1_, Predicate<Entity> p_221267_2_, RayTraceContext.BlockMode p_221267_3_, boolean p_221267_4_) {
        return ProjectileHelper.func_221268_a(p_221267_0_, p_221267_4_, false, null, p_221267_3_, false, p_221267_2_, p_221267_1_);
    }

    @Nullable
    public static EntityRayTraceResult func_221271_a(World p_221271_0_, Entity p_221271_1_, Vec3d p_221271_2_, Vec3d p_221271_3_, AxisAlignedBB p_221271_4_, Predicate<Entity> p_221271_5_) {
        return ProjectileHelper.func_221269_a(p_221271_0_, p_221271_1_, p_221271_2_, p_221271_3_, p_221271_4_, p_221271_5_, Double.MAX_VALUE);
    }

    private static RayTraceResult func_221268_a(Entity p_221268_0_, boolean p_221268_1_, boolean p_221268_2_, @Nullable Entity p_221268_3_, RayTraceContext.BlockMode p_221268_4_, boolean p_221268_5_, Predicate<Entity> p_221268_6_, AxisAlignedBB p_221268_7_) {
        Vec3d vec3d = p_221268_0_.func_213322_ci();
        World world = p_221268_0_.field_70170_p;
        Vec3d vec3d1 = p_221268_0_.func_213303_ch();
        if (p_221268_5_ && !world.func_226662_a_(p_221268_0_, p_221268_0_.func_174813_aQ(), !p_221268_2_ && p_221268_3_ != null ? ProjectileHelper.func_211325_a(p_221268_3_) : ImmutableSet.of())) {
            return new BlockRayTraceResult(vec3d1, Direction.func_210769_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c), new BlockPos(p_221268_0_), false);
        }
        Vec3d vec3d2 = vec3d1.func_178787_e(vec3d);
        BlockRayTraceResult raytraceresult = world.func_217299_a(new RayTraceContext(vec3d1, vec3d2, p_221268_4_, RayTraceContext.FluidMode.NONE, p_221268_0_));
        if (p_221268_1_) {
            EntityRayTraceResult raytraceresult1;
            if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
                vec3d2 = raytraceresult.func_216347_e();
            }
            if ((raytraceresult1 = ProjectileHelper.func_221271_a(world, p_221268_0_, vec3d1, vec3d2, p_221268_7_, p_221268_6_)) != null) {
                raytraceresult = raytraceresult1;
            }
        }
        return raytraceresult;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public static EntityRayTraceResult func_221273_a(Entity p_221273_0_, Vec3d p_221273_1_, Vec3d p_221273_2_, AxisAlignedBB p_221273_3_, Predicate<Entity> p_221273_4_, double p_221273_5_) {
        World world = p_221273_0_.field_70170_p;
        double d0 = p_221273_5_;
        Entity entity = null;
        Vec3d vec3d = null;
        for (Entity entity1 : world.func_175674_a(p_221273_0_, p_221273_3_, p_221273_4_)) {
            Vec3d vec3d1;
            double d1;
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)entity1.func_70111_Y());
            Optional optional = axisalignedbb.func_216365_b(p_221273_1_, p_221273_2_);
            if (axisalignedbb.func_72318_a(p_221273_1_)) {
                if (!(d0 >= 0.0)) continue;
                entity = entity1;
                vec3d = optional.orElse(p_221273_1_);
                d0 = 0.0;
                continue;
            }
            if (!optional.isPresent() || !((d1 = p_221273_1_.func_72436_e(vec3d1 = (Vec3d)optional.get())) < d0) && d0 != 0.0) continue;
            if (entity1.func_184208_bv() == p_221273_0_.func_184208_bv() && !entity1.canRiderInteract()) {
                if (d0 != 0.0) continue;
                entity = entity1;
                vec3d = vec3d1;
                continue;
            }
            entity = entity1;
            vec3d = vec3d1;
            d0 = d1;
        }
        return entity == null ? null : new EntityRayTraceResult(entity, vec3d);
    }

    @Nullable
    public static EntityRayTraceResult func_221269_a(World p_221269_0_, Entity p_221269_1_, Vec3d p_221269_2_, Vec3d p_221269_3_, AxisAlignedBB p_221269_4_, Predicate<Entity> p_221269_5_, double p_221269_6_) {
        double d0 = p_221269_6_;
        Entity entity = null;
        for (Entity entity1 : p_221269_0_.func_175674_a(p_221269_1_, p_221269_4_, p_221269_5_)) {
            double d1;
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)0.3f);
            Optional optional = axisalignedbb.func_216365_b(p_221269_2_, p_221269_3_);
            if (!optional.isPresent() || !((d1 = p_221269_2_.func_72436_e((Vec3d)optional.get())) < d0)) continue;
            entity = entity1;
            d0 = d1;
        }
        return entity == null ? null : new EntityRayTraceResult(entity);
    }

    private static Set<Entity> func_211325_a(Entity p_211325_0_) {
        Entity entity = p_211325_0_.func_184187_bx();
        return entity != null ? ImmutableSet.of((Object)((Object)p_211325_0_), (Object)((Object)entity)) : ImmutableSet.of((Object)((Object)p_211325_0_));
    }

    public static final void func_188803_a(Entity projectile, float rotationSpeed) {
        Vec3d vec3d = projectile.func_213322_ci();
        float f = MathHelper.func_76133_a((double)Entity.func_213296_b(vec3d));
        projectile.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72449_c, (double)vec3d.field_72450_a) * 57.2957763671875) + 90.0f;
        projectile.field_70125_A = (float)(MathHelper.func_181159_b((double)f, (double)vec3d.field_72448_b) * 57.2957763671875) - 90.0f;
        while (projectile.field_70125_A - projectile.field_70127_C < -180.0f) {
            projectile.field_70127_C -= 360.0f;
        }
        while (projectile.field_70125_A - projectile.field_70127_C >= 180.0f) {
            projectile.field_70127_C += 360.0f;
        }
        while (projectile.field_70177_z - projectile.field_70126_B < -180.0f) {
            projectile.field_70126_B -= 360.0f;
        }
        while (projectile.field_70177_z - projectile.field_70126_B >= 180.0f) {
            projectile.field_70126_B += 360.0f;
        }
        projectile.field_70125_A = MathHelper.func_219799_g((float)rotationSpeed, (float)projectile.field_70127_C, (float)projectile.field_70125_A);
        projectile.field_70177_z = MathHelper.func_219799_g((float)rotationSpeed, (float)projectile.field_70126_B, (float)projectile.field_70177_z);
    }

    public static Hand func_221274_a(LivingEntity living, Item itemIn) {
        return living.func_184614_ca().func_77973_b() == itemIn ? Hand.MAIN_HAND : Hand.OFF_HAND;
    }

    public static AbstractArrowEntity func_221272_a(LivingEntity p_221272_0_, ItemStack p_221272_1_, float p_221272_2_) {
        ArrowItem arrowitem = (ArrowItem)(p_221272_1_.func_77973_b() instanceof ArrowItem ? p_221272_1_.func_77973_b() : Items.field_151032_g);
        AbstractArrowEntity abstractarrowentity = arrowitem.func_200887_a(p_221272_0_.field_70170_p, p_221272_1_, p_221272_0_);
        abstractarrowentity.func_190547_a(p_221272_0_, p_221272_2_);
        if (p_221272_1_.func_77973_b() == Items.field_185167_i && abstractarrowentity instanceof ArrowEntity) {
            ((ArrowEntity)abstractarrowentity).func_184555_a(p_221272_1_);
        }
        return abstractarrowentity;
    }
}

