/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.integrated;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.LanServerPingThread;
import net.minecraft.command.Commands;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.profiler.DebugProfiler;
import net.minecraft.profiler.Snooper;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedPlayerList;
import net.minecraft.server.management.PlayerList;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.CryptManager;
import net.minecraft.util.SharedConstants;
import net.minecraft.world.Difficulty;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.listener.IChunkStatusListener;
import net.minecraft.world.chunk.listener.IChunkStatusListenerFactory;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.SaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class IntegratedServer
extends MinecraftServer {
    private static final Logger field_147148_h = LogManager.getLogger();
    private final Minecraft field_71349_l;
    private final WorldSettings field_71350_m;
    private boolean field_71348_o;
    private int field_195580_l = -1;
    private LanServerPingThread field_71345_q;
    private UUID field_211528_n;

    public IntegratedServer(Minecraft p_i50895_1_, String worldName, String p_i50895_3_, WorldSettings p_i50895_4_, YggdrasilAuthenticationService p_i50895_5_, MinecraftSessionService p_i50895_6_, GameProfileRepository p_i50895_7_, PlayerProfileCache p_i50895_8_, IChunkStatusListenerFactory p_i50895_9_) {
        super(new File(p_i50895_1_.field_71412_D, "saves"), p_i50895_1_.func_110437_J(), p_i50895_1_.func_184126_aj(), new Commands(false), p_i50895_5_, p_i50895_6_, p_i50895_7_, p_i50895_8_, p_i50895_9_, worldName);
        this.func_71224_l(p_i50895_1_.func_110432_I().func_111285_a());
        this.func_71246_n(p_i50895_3_);
        this.func_71204_b(p_i50895_1_.func_71355_q());
        this.func_71194_c(p_i50895_4_.func_77167_c());
        this.func_71191_d(256);
        this.func_184105_a((PlayerList)new IntegratedPlayerList(this));
        this.field_71349_l = p_i50895_1_;
        this.field_71350_m = this.func_71242_L() ? MinecraftServer.field_213219_c : p_i50895_4_;
    }

    @Override
    public void func_71247_a(String saveName, String worldNameIn, long seed, WorldType type, JsonElement generatorOptions) {
        this.func_71237_c(saveName);
        SaveHandler savehandler = this.func_71254_M().func_197715_a(saveName, this);
        this.func_175584_a(this.func_71270_I(), savehandler);
        IChunkStatusListener ichunkstatuslistener = this.field_213220_d.create(11);
        WorldInfo worldinfo = savehandler.func_75757_d();
        if (worldinfo == null) {
            worldinfo = new WorldInfo(this.field_71350_m, worldNameIn);
        } else {
            worldinfo.func_76062_a(worldNameIn);
        }
        this.func_195560_a(savehandler.func_75765_b(), worldinfo);
        this.func_213194_a(savehandler, worldinfo, this.field_71350_m, ichunkstatuslistener);
        if (this.func_71218_a(DimensionType.field_223227_a_).func_72912_H().func_176130_y() == null) {
            this.func_147139_a(this.field_71349_l.field_71474_y.field_74318_M, true);
        }
        this.func_213186_a(ichunkstatuslistener);
    }

    @Override
    public boolean func_71197_b() throws IOException {
        field_147148_h.info("Starting integrated minecraft server version " + SharedConstants.func_215069_a().getName());
        this.func_71229_d(true);
        this.func_71251_e(true);
        this.func_71257_f(true);
        this.func_71188_g(true);
        this.func_71245_h(true);
        field_147148_h.info("Generating keypair");
        this.func_71253_a(CryptManager.func_75891_b());
        if (!ServerLifecycleHooks.handleServerAboutToStart((MinecraftServer)this)) {
            return false;
        }
        this.func_71247_a(this.func_71270_I(), this.func_71221_J(), this.field_71350_m.func_77160_d(), this.field_71350_m.func_77165_h(), this.field_71350_m.func_205391_j());
        this.func_71205_p(this.func_71214_G() + " - " + this.func_71218_a(DimensionType.field_223227_a_).func_72912_H().func_76065_j());
        return ServerLifecycleHooks.handleServerStarting((MinecraftServer)this);
    }

    @Override
    public void func_71217_p(BooleanSupplier hasTimeLeft) {
        boolean flag = this.field_71348_o;
        this.field_71348_o = Minecraft.func_71410_x().func_147114_u() != null && Minecraft.func_71410_x().func_147113_T();
        DebugProfiler debugprofiler = this.func_213185_aS();
        if (!flag && this.field_71348_o) {
            debugprofiler.func_76320_a("autoSave");
            field_147148_h.info("Saving and pausing game...");
            this.func_184103_al().func_72389_g();
            this.func_213211_a(false, false, false);
            debugprofiler.func_76319_b();
        }
        if (!this.field_71348_o) {
            super.func_71217_p(hasTimeLeft);
            int i = Math.max(2, this.field_71349_l.field_71474_y.field_151451_c + -1);
            if (i != this.func_184103_al().func_72395_o()) {
                field_147148_h.info("Changing view distance to {}, from {}", (Object)i, (Object)this.func_184103_al().func_72395_o());
                this.func_184103_al().func_217884_a(i);
            }
        }
    }

    @Override
    public boolean func_71225_e() {
        return false;
    }

    @Override
    public GameType func_71265_f() {
        return this.field_71350_m.func_77162_e();
    }

    @Override
    public Difficulty func_147135_j() {
        if (this.field_71349_l.field_71441_e == null) {
            return this.field_71349_l.field_71474_y.field_74318_M;
        }
        return this.field_71349_l.field_71441_e.func_72912_H().func_176130_y();
    }

    @Override
    public boolean func_71199_h() {
        return this.field_71350_m.func_77158_f();
    }

    @Override
    public boolean func_195569_l() {
        return true;
    }

    public boolean func_195041_r_() {
        return true;
    }

    @Override
    public File func_71238_n() {
        return this.field_71349_l.field_71412_D;
    }

    @Override
    public boolean func_71262_S() {
        return false;
    }

    @Override
    public boolean func_181035_ah() {
        return false;
    }

    @Override
    public void func_71228_a(CrashReport report) {
        this.field_71349_l.func_71404_a(report);
    }

    @Override
    public CrashReport func_71230_b(CrashReport report) {
        report = super.func_71230_b(report);
        report.func_85056_g().func_71507_a("Type", "Integrated Server (map_client.txt)");
        report.func_85056_g().func_189529_a("Is Modded", (ICrashReportDetail<String>)((ICrashReportDetail)() -> {
            String s = ClientBrandRetriever.getClientModName();
            if (!s.equals("vanilla")) {
                return "Definitely; Client brand changed to '" + s + "'";
            }
            s = this.getServerModName();
            if (!"vanilla".equals(s)) {
                return "Definitely; Server brand changed to '" + s + "'";
            }
            return Minecraft.class.getSigners() == null ? "Very likely; Jar signature invalidated" : "Probably not. Jar signature remains and both client + server brands are untouched.";
        }));
        return report;
    }

    @Override
    public void func_70000_a(Snooper snooper) {
        super.func_70000_a(snooper);
        snooper.func_152768_a("snooper_partner", (Object)this.field_71349_l.func_71378_E().func_80006_f());
    }

    @Override
    public boolean func_195565_a(GameType gameMode, boolean cheats, int port) {
        try {
            this.func_147137_ag().func_151265_a(null, port);
            field_147148_h.info("Started serving on {}", (Object)port);
            this.field_195580_l = port;
            this.field_71345_q = new LanServerPingThread(this.func_71273_Y(), port + "");
            this.field_71345_q.start();
            this.func_184103_al().func_152604_a(gameMode);
            this.func_184103_al().func_72387_b(cheats);
            int i = this.func_211833_a(this.field_71349_l.field_71439_g.func_146103_bH());
            this.field_71349_l.field_71439_g.func_184839_n(i);
            for (ServerPlayerEntity serverplayerentity : this.func_184103_al().func_181057_v()) {
                this.func_195571_aL().func_197051_a(serverplayerentity);
            }
            return true;
        }
        catch (IOException var7) {
            return false;
        }
    }

    @Override
    public void func_71260_j() {
        super.func_71260_j();
        if (this.field_71345_q != null) {
            this.field_71345_q.interrupt();
            this.field_71345_q = null;
        }
    }

    @Override
    public void func_71263_m(boolean p_71263_1_) {
        if (this.func_71278_l()) {
            this.func_213167_f(() -> {
                for (ServerPlayerEntity serverplayerentity : Lists.newArrayList(this.func_184103_al().func_181057_v())) {
                    if (serverplayerentity.func_110124_au().equals(this.field_211528_n)) continue;
                    this.func_184103_al().func_72367_e(serverplayerentity);
                }
            });
        }
        super.func_71263_m(p_71263_1_);
        if (this.field_71345_q != null) {
            this.field_71345_q.interrupt();
            this.field_71345_q = null;
        }
    }

    @Override
    public boolean func_71344_c() {
        return this.field_195580_l > -1;
    }

    @Override
    public int func_71215_F() {
        return this.field_195580_l;
    }

    @Override
    public void func_71235_a(GameType gameMode) {
        super.func_71235_a(gameMode);
        this.func_184103_al().func_152604_a(gameMode);
    }

    @Override
    public boolean func_82356_Z() {
        return true;
    }

    @Override
    public int func_110455_j() {
        return 2;
    }

    @Override
    public int func_223707_k() {
        return 2;
    }

    public void func_211527_b(UUID uuid) {
        this.field_211528_n = uuid;
    }

    @Override
    public boolean func_213199_b(GameProfile p_213199_1_) {
        return p_213199_1_.getName().equalsIgnoreCase(this.func_71214_G());
    }
}

