/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.item.minecart.TNTMinecartEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.WitherSkullEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.BeehiveTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;

public class BeehiveBlock
extends ContainerBlock {
    public static final Direction[] field_226871_a_ = new Direction[]{Direction.WEST, Direction.EAST, Direction.SOUTH};
    public static final DirectionProperty field_226872_b_ = HorizontalBlock.field_185512_D;
    public static final IntegerProperty field_226873_c_ = BlockStateProperties.field_227036_ao_;

    public BeehiveBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_226873_c_, 0)).func_206870_a(field_226872_b_, Direction.NORTH));
    }

    @Override
    public boolean func_149740_M(BlockState blockState) {
        return true;
    }

    @Override
    public int func_180641_l(BlockState blockState, World world, BlockPos blockPos) {
        return blockState.func_177229_b(field_226873_c_);
    }

    @Override
    public void func_180657_a(World world, PlayerEntity playerEntity, BlockPos blockPos, BlockState blockState, @Nullable TileEntity tileEntity, ItemStack itemStack) {
        super.func_180657_a(world, playerEntity, blockPos, blockState, tileEntity, itemStack);
        if (!world.field_72995_K && tileEntity instanceof BeehiveTileEntity) {
            BeehiveTileEntity beehiveTileEntity = (BeehiveTileEntity)tileEntity;
            if (EnchantmentHelper.func_77506_a(Enchantments.field_185306_r, itemStack) == 0) {
                beehiveTileEntity.func_226963_a_(playerEntity, blockState, BeehiveTileEntity.State.EMERGENCY);
                world.func_175666_e(blockPos, this);
                this.func_226881_b_(world, blockPos);
            }
            CriteriaTriggers.field_229865_L_.func_226223_a_((ServerPlayerEntity)playerEntity, blockState.func_177230_c(), itemStack, beehiveTileEntity.func_226971_j_());
        }
    }

    private void func_226881_b_(World world, BlockPos blockPos) {
        List<BeeEntity> list = world.func_217357_a(BeeEntity.class, new AxisAlignedBB(blockPos).func_72314_b(8.0, 6.0, 8.0));
        if (!list.isEmpty()) {
            List<PlayerEntity> list2 = world.func_217357_a(PlayerEntity.class, new AxisAlignedBB(blockPos).func_72314_b(8.0, 6.0, 8.0));
            int \u26032 = list2.size();
            for (BeeEntity beeEntity : list) {
                if (beeEntity.func_70638_az() != null) continue;
                beeEntity.func_226391_a_(list2.get(world.field_73012_v.nextInt(\u26032)));
            }
        }
    }

    public static void func_226878_a_(World world, BlockPos blockPos) {
        BeehiveBlock.func_180635_a(world, blockPos, new ItemStack(Items.field_226635_pU_, 3));
    }

    @Override
    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos blockPos, PlayerEntity playerEntity2, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        ItemStack itemStack = playerEntity2.func_184586_b(hand);
        \u2603 = itemStack.func_77946_l();
        int \u26032 = blockState.func_177229_b(field_226873_c_);
        boolean \u26033 = false;
        if (\u26032 >= 5) {
            if (itemStack.func_77973_b() == Items.field_151097_aZ) {
                world.func_184148_a(playerEntity2, playerEntity2.func_226277_ct_(), playerEntity2.func_226278_cu_(), playerEntity2.func_226281_cx_(), SoundEvents.field_226133_ah_, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                BeehiveBlock.func_226878_a_(world, blockPos);
                itemStack.func_222118_a(1, playerEntity2, playerEntity -> playerEntity.func_213334_d(hand));
                \u26033 = true;
            } else if (itemStack.func_77973_b() == Items.field_151069_bo) {
                itemStack.func_190918_g(1);
                world.func_184148_a(playerEntity2, playerEntity2.func_226277_ct_(), playerEntity2.func_226278_cu_(), playerEntity2.func_226281_cx_(), SoundEvents.field_187615_H, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                if (itemStack.func_190926_b()) {
                    playerEntity2.func_184611_a(hand, new ItemStack(Items.field_226638_pX_));
                } else if (!playerEntity2.field_71071_by.func_70441_a(new ItemStack(Items.field_226638_pX_))) {
                    playerEntity2.func_71019_a(new ItemStack(Items.field_226638_pX_), false);
                }
                \u26033 = true;
            }
        }
        if (\u26033) {
            if (!CampfireBlock.func_226914_b_(world, blockPos, 5)) {
                if (this.func_226882_d_(world, blockPos)) {
                    this.func_226881_b_(world, blockPos);
                }
                this.func_226877_a_(world, blockState, blockPos, playerEntity2, BeehiveTileEntity.State.EMERGENCY);
            } else {
                this.func_226876_a_(world, blockState, blockPos);
                if (playerEntity2 instanceof ServerPlayerEntity) {
                    CriteriaTriggers.field_229863_J_.func_226695_a_((ServerPlayerEntity)playerEntity2, blockPos, \u2603);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(blockState, world, blockPos, playerEntity2, hand, blockRayTraceResult);
    }

    private boolean func_226882_d_(World world, BlockPos blockPos) {
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (tileEntity instanceof BeehiveTileEntity) {
            BeehiveTileEntity beehiveTileEntity = (BeehiveTileEntity)tileEntity;
            return !beehiveTileEntity.func_226969_f_();
        }
        return false;
    }

    public void func_226877_a_(World world, BlockState blockState, BlockPos blockPos, @Nullable PlayerEntity playerEntity, BeehiveTileEntity.State state) {
        this.func_226876_a_(world, blockState, blockPos);
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (tileEntity instanceof BeehiveTileEntity) {
            BeehiveTileEntity beehiveTileEntity = (BeehiveTileEntity)tileEntity;
            beehiveTileEntity.func_226963_a_(playerEntity, blockState, state);
        }
    }

    public void func_226876_a_(World world, BlockState blockState, BlockPos blockPos) {
        world.func_180501_a(blockPos, (BlockState)blockState.func_206870_a(field_226873_c_, 0), 3);
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext blockItemUseContext) {
        return (BlockState)this.func_176223_P().func_206870_a(field_226872_b_, blockItemUseContext.func_195992_f().func_176734_d());
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(field_226873_c_, field_226872_b_);
    }

    @Override
    public BlockRenderType func_149645_b(BlockState blockState) {
        return BlockRenderType.MODEL;
    }

    @Override
    @Nullable
    public TileEntity func_196283_a_(IBlockReader iBlockReader) {
        return new BeehiveTileEntity();
    }

    @Override
    public void func_176208_a(World world, BlockPos blockPos, BlockState blockState, PlayerEntity playerEntity) {
        if (!world.field_72995_K && playerEntity.func_184812_l_() && world.func_82736_K().func_223586_b(GameRules.field_223603_f) && (\u2603 = world.func_175625_s(blockPos)) instanceof BeehiveTileEntity) {
            CompoundNBT compoundNBT;
            BeehiveTileEntity beehiveTileEntity = (BeehiveTileEntity)\u2603;
            ItemStack \u26032 = new ItemStack(this);
            int \u26033 = blockState.func_177229_b(field_226873_c_);
            boolean bl = \u2603 = !beehiveTileEntity.func_226969_f_();
            if (!\u2603 && \u26033 == 0) {
                return;
            }
            if (\u2603) {
                compoundNBT = new CompoundNBT();
                compoundNBT.func_218657_a("Bees", beehiveTileEntity.func_226974_m_());
                \u26032.func_77983_a("BlockEntityTag", compoundNBT);
            }
            compoundNBT = new CompoundNBT();
            compoundNBT.func_74768_a("honey_level", \u26033);
            \u26032.func_77983_a("BlockStateTag", compoundNBT);
            ItemEntity \u26034 = new ItemEntity(world, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), \u26032);
            \u26034.func_174869_p();
            world.func_217376_c(\u26034);
        }
        super.func_176208_a(world, blockPos, blockState, playerEntity);
    }

    @Override
    public List<ItemStack> func_220076_a(BlockState blockState2, LootContext.Builder builder) {
        BlockState blockState2;
        Entity entity = builder.func_216019_b(LootParameters.field_216281_a);
        if ((entity instanceof TNTEntity || entity instanceof CreeperEntity || entity instanceof WitherSkullEntity || entity instanceof WitherEntity || entity instanceof TNTMinecartEntity) && (\u2603 = builder.func_216019_b(LootParameters.field_216288_h)) instanceof BeehiveTileEntity) {
            BeehiveTileEntity beehiveTileEntity = (BeehiveTileEntity)\u2603;
            beehiveTileEntity.func_226963_a_(null, blockState2, BeehiveTileEntity.State.EMERGENCY);
        }
        return super.func_220076_a(blockState2, builder);
    }

    @Override
    public BlockState func_196271_a(BlockState blockState3, Direction direction, BlockState blockState2, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
        BlockState blockState3;
        if (iWorld.func_180495_p(blockPos2).func_177230_c() instanceof FireBlock && (\u2603 = iWorld.func_175625_s(blockPos)) instanceof BeehiveTileEntity) {
            BeehiveTileEntity beehiveTileEntity = (BeehiveTileEntity)\u2603;
            beehiveTileEntity.func_226963_a_(null, blockState3, BeehiveTileEntity.State.EMERGENCY);
        }
        return super.func_196271_a(blockState3, direction, blockState2, iWorld, blockPos, blockPos2);
    }
}

