/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;

public class FlowingFluidBlock
extends Block
implements IBucketPickupHandler {
    public static final IntegerProperty field_176367_b = BlockStateProperties.field_208132_ag;
    protected final FlowingFluid field_204517_c;
    private final List<IFluidState> field_212565_c;

    protected FlowingFluidBlock(FlowingFluid flowingFluid2, Block.Properties properties) {
        super(properties);
        FlowingFluid flowingFluid2;
        this.field_204517_c = flowingFluid2;
        this.field_212565_c = Lists.newArrayList();
        this.field_212565_c.add(flowingFluid2.func_207204_a(false));
        for (int i = 1; i < 8; ++i) {
            this.field_212565_c.add(flowingFluid2.func_207207_a(8 - i, false));
        }
        this.field_212565_c.add(flowingFluid2.func_207207_a(8, true));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_176367_b, 0));
    }

    @Override
    public void func_225542_b_(BlockState blockState, ServerWorld serverWorld, BlockPos blockPos, Random random) {
        serverWorld.func_204610_c(blockPos).func_206891_b(serverWorld, blockPos, random);
    }

    @Override
    public boolean func_200123_i(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos) {
        return false;
    }

    @Override
    public boolean func_196266_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, PathType pathType) {
        return !this.field_204517_c.func_207185_a(FluidTags.field_206960_b);
    }

    @Override
    public IFluidState func_204507_t(BlockState blockState) {
        int n = blockState.func_177229_b(field_176367_b);
        return this.field_212565_c.get(Math.min(n, 8));
    }

    @Override
    public BlockRenderType func_149645_b(BlockState blockState) {
        return BlockRenderType.INVISIBLE;
    }

    @Override
    public List<ItemStack> func_220076_a(BlockState blockState, LootContext.Builder builder) {
        return Collections.emptyList();
    }

    @Override
    public VoxelShape func_220053_a(BlockState blockState, IBlockReader iBlockReader, BlockPos blockPos, ISelectionContext iSelectionContext) {
        return VoxelShapes.func_197880_a();
    }

    @Override
    public int func_149738_a(IWorldReader iWorldReader) {
        return this.field_204517_c.func_205569_a(iWorldReader);
    }

    @Override
    public void func_220082_b(BlockState blockState, World world, BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (this.func_204515_c(world, blockPos, blockState)) {
            world.func_205219_F_().func_205360_a(blockPos, blockState.func_204520_s().func_206886_c(), this.func_149738_a(world));
        }
    }

    @Override
    public BlockState func_196271_a(BlockState blockState, Direction direction, BlockState blockState2, IWorld iWorld, BlockPos blockPos, BlockPos blockPos2) {
        if (blockState.func_204520_s().func_206889_d() || blockState2.func_204520_s().func_206889_d()) {
            iWorld.func_205219_F_().func_205360_a(blockPos, blockState.func_204520_s().func_206886_c(), this.func_149738_a(iWorld));
        }
        return super.func_196271_a(blockState, direction, blockState2, iWorld, blockPos, blockPos2);
    }

    @Override
    public void func_220069_a(BlockState blockState, World world, BlockPos blockPos, Block block, BlockPos blockPos2, boolean bl) {
        if (this.func_204515_c(world, blockPos, blockState)) {
            world.func_205219_F_().func_205360_a(blockPos, blockState.func_204520_s().func_206886_c(), this.func_149738_a(world));
        }
    }

    public boolean func_204515_c(World world, BlockPos blockPos, BlockState blockState) {
        if (this.field_204517_c.func_207185_a(FluidTags.field_206960_b)) {
            boolean bl = false;
            for (Direction direction : Direction.values()) {
                if (direction == Direction.DOWN || !world.func_204610_c(blockPos.func_177972_a(direction)).func_206884_a(FluidTags.field_206959_a)) continue;
                bl = true;
                break;
            }
            if (bl) {
                IFluidState iFluidState = world.func_204610_c(blockPos);
                if (iFluidState.func_206889_d()) {
                    world.func_175656_a(blockPos, Blocks.field_150343_Z.func_176223_P());
                    this.func_180688_d(world, blockPos);
                    return false;
                }
                if (iFluidState.func_215679_a(world, blockPos) >= 0.44444445f) {
                    world.func_175656_a(blockPos, Blocks.field_150347_e.func_176223_P());
                    this.func_180688_d(world, blockPos);
                    return false;
                }
            }
        }
        return true;
    }

    private void func_180688_d(IWorld iWorld, BlockPos blockPos) {
        iWorld.func_217379_c(1501, blockPos, 0);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(field_176367_b);
    }

    @Override
    public Fluid func_204508_a(IWorld iWorld, BlockPos blockPos, BlockState blockState) {
        if (blockState.func_177229_b(field_176367_b) == 0) {
            iWorld.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 11);
            return this.field_204517_c;
        }
        return Fluids.field_204541_a;
    }

    @Override
    public void func_196262_a(BlockState blockState, World world, BlockPos blockPos, Entity entity) {
        if (this.field_204517_c.func_207185_a(FluidTags.field_206960_b)) {
            entity.func_213292_aB();
        }
    }
}

