/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.EnumSet;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.SmallFireballEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class BlazeEntity
extends MonsterEntity {
    private float field_70847_d = 0.5f;
    private int field_70848_e;
    private static final DataParameter<Byte> field_184712_c = EntityDataManager.func_187226_a(BlazeEntity.class, DataSerializers.field_187191_a);

    public BlazeEntity(EntityType<? extends BlazeEntity> entityType, World world) {
        super((EntityType<? extends MonsterEntity>)entityType, world);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.LAVA, 8.0f);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 0.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, 0.0f);
        this.field_70728_aV = 10;
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(4, new FireballAttackGoal(this));
        this.field_70714_bg.func_75776_a(5, new MoveTowardsRestrictionGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(7, new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0, 0.0f));
        this.field_70714_bg.func_75776_a(8, new LookAtGoal(this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, new LookRandomlyGoal(this));
        this.field_70715_bh.func_75776_a(1, new HurtByTargetGoal(this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, new NearestAttackableTargetGoal<PlayerEntity>((MobEntity)this, PlayerEntity.class, true));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.23f);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(48.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184712_c, (byte)0);
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187594_A;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187603_D;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187600_C;
    }

    @Override
    public float func_70013_c() {
        return 1.0f;
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70122_E && this.func_213322_ci().field_72448_b < 0.0) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.6, 1.0));
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70146_Z.nextInt(24) == 0 && !this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_() + 0.5, this.func_226278_cu_() + 0.5, this.func_226281_cx_() + 0.5, SoundEvents.field_187597_B, this.func_184176_by(), 1.0f + this.field_70146_Z.nextFloat(), this.field_70146_Z.nextFloat() * 0.7f + 0.3f, false);
            }
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_195594_a(ParticleTypes.field_197594_E, this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), 0.0, 0.0, 0.0);
            }
        }
        super.func_70636_d();
    }

    @Override
    protected void func_70619_bc() {
        LivingEntity livingEntity;
        if (this.func_203008_ap()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        --this.field_70848_e;
        if (this.field_70848_e <= 0) {
            this.field_70848_e = 100;
            this.field_70847_d = 0.5f + (float)this.field_70146_Z.nextGaussian() * 3.0f;
        }
        if ((livingEntity = this.func_70638_az()) != null && livingEntity.func_226280_cw_() > this.func_226280_cw_() + (double)this.field_70847_d && this.func_213336_c(livingEntity)) {
            Vec3d vec3d = this.func_213322_ci();
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, ((double)0.3f - vec3d.field_72448_b) * (double)0.3f, 0.0));
            this.field_70160_al = true;
        }
        super.func_70619_bc();
    }

    @Override
    public boolean func_225503_b_(float f, float f2) {
        return false;
    }

    @Override
    public boolean func_70027_ad() {
        return this.func_70845_n();
    }

    private boolean func_70845_n() {
        return (this.field_70180_af.func_187225_a(field_184712_c) & 1) != 0;
    }

    private void func_70844_e(boolean bl) {
        byte by = this.field_70180_af.func_187225_a(field_184712_c);
        by = bl ? (byte)(by | 1) : (byte)(by & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(field_184712_c, by);
    }

    static class FireballAttackGoal
    extends Goal {
        private final BlazeEntity field_179469_a;
        private int field_179467_b;
        private int field_179468_c;
        private int field_223527_d;

        public FireballAttackGoal(BlazeEntity blazeEntity) {
            this.field_179469_a = blazeEntity;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        public boolean func_75250_a() {
            LivingEntity livingEntity = this.field_179469_a.func_70638_az();
            return livingEntity != null && livingEntity.func_70089_S() && this.field_179469_a.func_213336_c(livingEntity);
        }

        @Override
        public void func_75249_e() {
            this.field_179467_b = 0;
        }

        @Override
        public void func_75251_c() {
            this.field_179469_a.func_70844_e(false);
            this.field_223527_d = 0;
        }

        @Override
        public void func_75246_d() {
            --this.field_179468_c;
            LivingEntity livingEntity = this.field_179469_a.func_70638_az();
            if (livingEntity == null) {
                return;
            }
            boolean \u26032 = this.field_179469_a.func_70635_at().func_75522_a(livingEntity);
            this.field_223527_d = \u26032 ? 0 : ++this.field_223527_d;
            double \u26033 = this.field_179469_a.func_70068_e(livingEntity);
            if (\u26033 < 4.0) {
                if (!\u26032) {
                    return;
                }
                if (this.field_179468_c <= 0) {
                    this.field_179468_c = 20;
                    this.field_179469_a.func_70652_k(livingEntity);
                }
                this.field_179469_a.func_70605_aq().func_75642_a(livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_(), livingEntity.func_226281_cx_(), 1.0);
            } else if (\u26033 < this.func_191523_f() * this.func_191523_f() && \u26032) {
                double d = livingEntity.func_226277_ct_() - this.field_179469_a.func_226277_ct_();
                \u2603 = livingEntity.func_226283_e_(0.5) - this.field_179469_a.func_226283_e_(0.5);
                \u2603 = livingEntity.func_226281_cx_() - this.field_179469_a.func_226281_cx_();
                if (this.field_179468_c <= 0) {
                    ++this.field_179467_b;
                    if (this.field_179467_b == 1) {
                        this.field_179468_c = 60;
                        this.field_179469_a.func_70844_e(true);
                    } else if (this.field_179467_b <= 4) {
                        this.field_179468_c = 6;
                    } else {
                        this.field_179468_c = 100;
                        this.field_179467_b = 0;
                        this.field_179469_a.func_70844_e(false);
                    }
                    if (this.field_179467_b > 1) {
                        float f = MathHelper.func_76129_c(MathHelper.func_76133_a(\u26033)) * 0.5f;
                        this.field_179469_a.field_70170_p.func_217378_a(null, 1018, new BlockPos(this.field_179469_a), 0);
                        for (int i = 0; i < 1; ++i) {
                            SmallFireballEntity smallFireballEntity = new SmallFireballEntity(this.field_179469_a.field_70170_p, this.field_179469_a, d + this.field_179469_a.func_70681_au().nextGaussian() * (double)f, \u2603, \u2603 + this.field_179469_a.func_70681_au().nextGaussian() * (double)f);
                            smallFireballEntity.func_70107_b(smallFireballEntity.func_226277_ct_(), this.field_179469_a.func_226283_e_(0.5) + 0.5, smallFireballEntity.func_226281_cx_());
                            this.field_179469_a.field_70170_p.func_217376_c(smallFireballEntity);
                        }
                    }
                }
                this.field_179469_a.func_70671_ap().func_75651_a(livingEntity, 10.0f, 10.0f);
            } else if (this.field_223527_d < 5) {
                this.field_179469_a.func_70605_aq().func_75642_a(livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_(), livingEntity.func_226281_cx_(), 1.0);
            }
            super.func_75246_d();
        }

        private double func_191523_f() {
            return this.field_179469_a.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e();
        }
    }
}

