/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.network.play.IClientPlayNetHandler;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.gen.Heightmap;

public class SChunkDataPacket
implements IPacket<IClientPlayNetHandler> {
    private int field_149284_a;
    private int field_149282_b;
    private int field_186948_c;
    private CompoundNBT field_218711_d;
    @Nullable
    private BiomeContainer field_229738_e_;
    private byte[] field_186949_d;
    private List<CompoundNBT> field_189557_e;
    private boolean field_149279_g;

    public SChunkDataPacket() {
    }

    public SChunkDataPacket(Chunk chunk2, int n) {
        ChunkPos chunkPos = chunk2.func_76632_l();
        this.field_149284_a = chunkPos.field_77276_a;
        this.field_149282_b = chunkPos.field_77275_b;
        this.field_149279_g = n == 65535;
        this.field_218711_d = new CompoundNBT();
        for (Map.Entry<Heightmap.Type, Heightmap> entry : chunk2.func_217311_f()) {
            if (!entry.getKey().func_222681_b()) continue;
            this.field_218711_d.func_218657_a(entry.getKey().func_203500_b(), new LongArrayNBT(entry.getValue().func_202269_a()));
        }
        if (this.field_149279_g) {
            this.field_229738_e_ = chunk2.func_225549_i_().func_227057_b_();
        }
        this.field_186949_d = new byte[this.func_218709_a(chunk2, n)];
        this.field_186948_c = this.func_218708_a(new PacketBuffer(this.func_186945_f()), chunk2, n);
        this.field_189557_e = Lists.newArrayList();
        for (Map.Entry<Object, Object> entry : chunk2.func_177434_r().entrySet()) {
            BlockPos blockPos = (BlockPos)entry.getKey();
            TileEntity \u26032 = (TileEntity)entry.getValue();
            int \u26033 = blockPos.func_177956_o() >> 4;
            if (!this.func_149274_i() && (n & 1 << \u26033) == 0) continue;
            CompoundNBT \u26034 = \u26032.func_189517_E_();
            this.field_189557_e.add(\u26034);
        }
    }

    @Override
    public void func_148837_a(PacketBuffer packetBuffer) throws IOException {
        this.field_149284_a = packetBuffer.readInt();
        this.field_149282_b = packetBuffer.readInt();
        this.field_149279_g = packetBuffer.readBoolean();
        this.field_186948_c = packetBuffer.func_150792_a();
        this.field_218711_d = packetBuffer.func_150793_b();
        if (this.field_149279_g) {
            this.field_229738_e_ = new BiomeContainer(packetBuffer);
        }
        if ((\u2603 = packetBuffer.func_150792_a()) > 0x200000) {
            throw new RuntimeException("Chunk Packet trying to allocate too much memory on read.");
        }
        this.field_186949_d = new byte[\u2603];
        packetBuffer.readBytes(this.field_186949_d);
        int n = packetBuffer.func_150792_a();
        this.field_189557_e = Lists.newArrayList();
        for (\u2603 = 0; \u2603 < n; ++\u2603) {
            this.field_189557_e.add(packetBuffer.func_150793_b());
        }
    }

    @Override
    public void func_148840_b(PacketBuffer packetBuffer) throws IOException {
        packetBuffer.writeInt(this.field_149284_a);
        packetBuffer.writeInt(this.field_149282_b);
        packetBuffer.writeBoolean(this.field_149279_g);
        packetBuffer.func_150787_b(this.field_186948_c);
        packetBuffer.func_150786_a(this.field_218711_d);
        if (this.field_229738_e_ != null) {
            this.field_229738_e_.func_227056_a_(packetBuffer);
        }
        packetBuffer.func_150787_b(this.field_186949_d.length);
        packetBuffer.writeBytes(this.field_186949_d);
        packetBuffer.func_150787_b(this.field_189557_e.size());
        for (CompoundNBT compoundNBT : this.field_189557_e) {
            packetBuffer.func_150786_a(compoundNBT);
        }
    }

    @Override
    public void func_148833_a(IClientPlayNetHandler iClientPlayNetHandler) {
        iClientPlayNetHandler.func_147263_a(this);
    }

    private ByteBuf func_186945_f() {
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])this.field_186949_d);
        byteBuf.writerIndex(0);
        return byteBuf;
    }

    public int func_218708_a(PacketBuffer packetBuffer, Chunk chunk, int n) {
        int n2;
        n2 = 0;
        ChunkSection[] chunkSectionArray = chunk.func_76587_i();
        int \u26032 = chunkSectionArray.length;
        for (int i = 0; i < \u26032; ++i) {
            ChunkSection chunkSection = chunkSectionArray[i];
            if (chunkSection == Chunk.field_186036_a || this.func_149274_i() && chunkSection.func_76663_a() || (n & 1 << i) == 0) continue;
            n2 |= 1 << i;
            chunkSection.func_222630_b(packetBuffer);
        }
        return n2;
    }

    protected int func_218709_a(Chunk chunk, int n) {
        int n2;
        n2 = 0;
        ChunkSection[] chunkSectionArray = chunk.func_76587_i();
        int \u26032 = chunkSectionArray.length;
        for (int i = 0; i < \u26032; ++i) {
            ChunkSection chunkSection = chunkSectionArray[i];
            if (chunkSection == Chunk.field_186036_a || this.func_149274_i() && chunkSection.func_76663_a() || (n & 1 << i) == 0) continue;
            n2 += chunkSection.func_222633_j();
        }
        return n2;
    }

    public boolean func_149274_i() {
        return this.field_149279_g;
    }
}

