/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.village;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.Util;
import net.minecraft.village.GossipType;

public class GossipManager {
    private final Map<UUID, Gossips> field_220928_a = Maps.newHashMap();

    public void func_223538_b() {
        Iterator<Gossips> iterator = this.field_220928_a.values().iterator();
        while (iterator.hasNext()) {
            Gossips gossips = iterator.next();
            gossips.func_223529_a();
            if (!gossips.func_223530_b()) continue;
            iterator.remove();
        }
    }

    private Stream<GossipEntry> func_220911_b() {
        return this.field_220928_a.entrySet().stream().flatMap(entry -> ((Gossips)entry.getValue()).func_220895_a((UUID)entry.getKey()));
    }

    private Collection<GossipEntry> func_220920_a(Random random, int n) {
        List list = this.func_220911_b().collect(Collectors.toList());
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        int[] \u26032 = new int[list.size()];
        int \u26033 = 0;
        for (int i = 0; i < list.size(); ++i) {
            GossipEntry gossipEntry = (GossipEntry)list.get(i);
            \u26032[i] = (\u26033 += Math.abs(gossipEntry.func_220904_a())) - 1;
        }
        Set set = Sets.newIdentityHashSet();
        for (int i = 0; i < n; ++i) {
            \u2603 = random.nextInt(\u26033);
            \u2603 = Arrays.binarySearch(\u26032, \u2603);
            set.add(list.get(\u2603 < 0 ? -\u2603 - 1 : \u2603));
        }
        return set;
    }

    private Gossips func_220926_a(UUID uUID2) {
        return this.field_220928_a.computeIfAbsent(uUID2, uUID -> new Gossips());
    }

    public void func_220912_a(GossipManager gossipManager, Random random, int n) {
        Collection<GossipEntry> collection = gossipManager.func_220920_a(random, n);
        collection.forEach(gossipEntry -> {
            int n = gossipEntry.field_220909_c - gossipEntry.field_220908_b.field_220935_k;
            if (n >= 2) {
                this.func_220926_a(gossipEntry.field_220907_a).field_220900_a.mergeInt((Object)gossipEntry.field_220908_b, n, GossipManager::func_220924_a);
            }
        });
    }

    public int func_220921_a(UUID uUID, Predicate<GossipType> predicate) {
        Gossips gossips = this.field_220928_a.get(uUID);
        return gossips != null ? gossips.func_220896_a(predicate) : 0;
    }

    public void func_220916_a(UUID uUID, GossipType gossipType, int n3) {
        Gossips gossips = this.func_220926_a(uUID);
        gossips.field_220900_a.mergeInt((Object)gossipType, n3, (n, n2) -> this.func_220925_a(gossipType, (int)n, (int)n2));
        gossips.func_223531_a(gossipType);
        if (gossips.func_223530_b()) {
            this.field_220928_a.remove(uUID);
        }
    }

    public <T> Dynamic<T> func_220914_a(DynamicOps<T> dynamicOps) {
        return new Dynamic(dynamicOps, dynamicOps.createList(this.func_220911_b().map(gossipEntry -> gossipEntry.func_220905_a(dynamicOps)).map(Dynamic::getValue)));
    }

    public void func_220918_a(Dynamic<?> dynamic) {
        dynamic.asStream().map(GossipEntry::func_220902_a).flatMap(Util::func_215081_a).forEach(gossipEntry -> this.func_220926_a(gossipEntry.field_220907_a).field_220900_a.put((Object)gossipEntry.field_220908_b, gossipEntry.field_220909_c));
    }

    private static int func_220924_a(int n, int n2) {
        return Math.max(n, n2);
    }

    private int func_220925_a(GossipType gossipType, int n, int n2) {
        \u2603 = n + n2;
        return \u2603 > gossipType.field_220933_i ? Math.max(gossipType.field_220933_i, n) : \u2603;
    }

    static class Gossips {
        private final Object2IntMap<GossipType> field_220900_a = new Object2IntOpenHashMap();

        private Gossips() {
        }

        public int func_220896_a(Predicate<GossipType> predicate) {
            return this.field_220900_a.object2IntEntrySet().stream().filter(entry -> predicate.test((GossipType)((Object)entry.getKey()))).mapToInt(entry -> entry.getIntValue() * ((GossipType)((Object)((Object)entry.getKey()))).field_220932_h).sum();
        }

        public Stream<GossipEntry> func_220895_a(UUID uUID) {
            return this.field_220900_a.object2IntEntrySet().stream().map(entry -> new GossipEntry(uUID, (GossipType)((Object)((Object)entry.getKey())), entry.getIntValue()));
        }

        public void func_223529_a() {
            ObjectIterator objectIterator = this.field_220900_a.object2IntEntrySet().iterator();
            while (objectIterator.hasNext()) {
                Object2IntMap.Entry entry = (Object2IntMap.Entry)objectIterator.next();
                int \u26032 = entry.getIntValue() - ((GossipType)((Object)entry.getKey())).field_220934_j;
                if (\u26032 < 2) {
                    objectIterator.remove();
                    continue;
                }
                entry.setValue(\u26032);
            }
        }

        public boolean func_223530_b() {
            return this.field_220900_a.isEmpty();
        }

        public void func_223531_a(GossipType gossipType) {
            int n = this.field_220900_a.getInt((Object)gossipType);
            if (n > gossipType.field_220933_i) {
                this.field_220900_a.put((Object)gossipType, gossipType.field_220933_i);
            }
            if (n < 2) {
                this.func_223528_b(gossipType);
            }
        }

        public void func_223528_b(GossipType gossipType) {
            this.field_220900_a.removeInt((Object)gossipType);
        }
    }

    static class GossipEntry {
        public final UUID field_220907_a;
        public final GossipType field_220908_b;
        public final int field_220909_c;

        public GossipEntry(UUID uUID, GossipType gossipType, int n) {
            this.field_220907_a = uUID;
            this.field_220908_b = gossipType;
            this.field_220909_c = n;
        }

        public int func_220904_a() {
            return this.field_220909_c * this.field_220908_b.field_220932_h;
        }

        public String toString() {
            return "GossipEntry{target=" + this.field_220907_a + ", type=" + (Object)((Object)this.field_220908_b) + ", value=" + this.field_220909_c + '}';
        }

        public <T> Dynamic<T> func_220905_a(DynamicOps<T> dynamicOps) {
            return Util.func_215084_a("Target", this.field_220907_a, new Dynamic(dynamicOps, dynamicOps.createMap((Map)ImmutableMap.of((Object)dynamicOps.createString("Type"), (Object)dynamicOps.createString(this.field_220908_b.field_220931_g), (Object)dynamicOps.createString("Value"), (Object)dynamicOps.createInt(this.field_220909_c)))));
        }

        public static Optional<GossipEntry> func_220902_a(Dynamic<?> dynamic) {
            return dynamic.get("Type").asString().map(GossipType::func_220929_a).flatMap(gossipType -> Util.func_215074_a("Target", dynamic).flatMap(uUID -> dynamic.get("Value").asNumber().map(number -> new GossipEntry((UUID)uUID, (GossipType)((Object)gossipType), number.intValue()))));
        }
    }
}

