/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import java.util.BitSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.EntityClassification;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;

public abstract class ChunkGenerator<C extends GenerationSettings> {
    protected final IWorld field_222540_a;
    protected final long field_222541_b;
    protected final BiomeProvider field_222542_c;
    protected final C field_222543_d;

    public ChunkGenerator(IWorld iWorld, BiomeProvider biomeProvider, C c) {
        this.field_222540_a = iWorld;
        this.field_222541_b = iWorld.func_72905_C();
        this.field_222542_c = biomeProvider;
        this.field_222543_d = c;
    }

    public void func_222539_a(IChunk iChunk) {
        ChunkPos chunkPos = iChunk.func_76632_l();
        ((ChunkPrimer)iChunk).func_225548_a_(new BiomeContainer(chunkPos, this.field_222542_c));
    }

    protected Biome func_225552_a_(BiomeManager biomeManager, BlockPos blockPos) {
        return biomeManager.func_226836_a_(blockPos);
    }

    public void func_225550_a_(BiomeManager biomeManager, IChunk iChunk, GenerationStage.Carving carving) {
        SharedSeedRandom sharedSeedRandom = new SharedSeedRandom();
        int \u26032 = 8;
        ChunkPos \u26033 = iChunk.func_76632_l();
        int \u26034 = \u26033.field_77276_a;
        int \u26035 = \u26033.field_77275_b;
        Biome \u26036 = this.func_225552_a_(biomeManager, \u26033.func_206849_h());
        BitSet \u26037 = iChunk.func_205749_a(carving);
        for (int i = \u26034 - 8; i <= \u26034 + 8; ++i) {
            for (\u2603 = \u26035 - 8; \u2603 <= \u26035 + 8; ++\u2603) {
                List<ConfiguredCarver<?>> list = \u26036.func_203603_a(carving);
                ListIterator<ConfiguredCarver<?>> \u26038 = list.listIterator();
                while (\u26038.hasNext()) {
                    int n = \u26038.nextIndex();
                    ConfiguredCarver<?> \u26039 = \u26038.next();
                    sharedSeedRandom.func_202425_c(this.field_222541_b + (long)n, i, \u2603);
                    if (!\u26039.func_222730_a(sharedSeedRandom, i, \u2603)) continue;
                    \u26039.func_227207_a_(iChunk, blockPos -> this.func_225552_a_(biomeManager, (BlockPos)blockPos), sharedSeedRandom, this.func_222530_f(), i, \u2603, \u26034, \u26035, \u26037);
                }
            }
        }
    }

    @Nullable
    public BlockPos func_211403_a(World world, String string, BlockPos blockPos, int n, boolean bl) {
        Structure structure = (Structure)Feature.field_202300_at.get((Object)string.toLowerCase(Locale.ROOT));
        if (structure != null) {
            return structure.func_211405_a(world, this, blockPos, n, bl);
        }
        return null;
    }

    public void func_202092_b(WorldGenRegion worldGenRegion) {
        int n = worldGenRegion.func_201679_a();
        \u2603 = worldGenRegion.func_201680_b();
        \u2603 = n * 16;
        \u2603 = \u2603 * 16;
        BlockPos \u26032 = new BlockPos(\u2603, 0, \u2603);
        Biome \u26033 = this.func_225552_a_(worldGenRegion.func_225523_d_(), \u26032.func_177982_a(8, 8, 8));
        SharedSeedRandom \u26034 = new SharedSeedRandom();
        long \u26035 = \u26034.func_202424_a(worldGenRegion.func_72905_C(), \u2603, \u2603);
        for (GenerationStage.Decoration decoration : GenerationStage.Decoration.values()) {
            try {
                \u26033.func_203608_a(decoration, this, worldGenRegion, \u26035, \u26034, \u26032);
            }
            catch (Exception exception) {
                CrashReport crashReport = CrashReport.func_85055_a(exception, "Biome decoration");
                crashReport.func_85058_a("Generation").func_71507_a("CenterX", n).func_71507_a("CenterZ", \u2603).func_71507_a("Step", (Object)decoration).func_71507_a("Seed", \u26035).func_71507_a("Biome", Registry.field_212624_m.func_177774_c(\u26033));
                throw new ReportedException(crashReport);
            }
        }
    }

    public abstract void func_225551_a_(WorldGenRegion var1, IChunk var2);

    public void func_202093_c(WorldGenRegion worldGenRegion) {
    }

    public C func_201496_a_() {
        return this.field_222543_d;
    }

    public abstract int func_205470_d();

    public void func_203222_a(ServerWorld serverWorld, boolean bl, boolean bl2) {
    }

    public boolean func_202094_a(Biome biome, Structure<? extends IFeatureConfig> structure) {
        return biome.func_201858_a(structure);
    }

    @Nullable
    public <C extends IFeatureConfig> C func_202087_b(Biome biome, Structure<C> structure) {
        return biome.func_201857_b(structure);
    }

    public BiomeProvider func_202090_b() {
        return this.field_222542_c;
    }

    public long func_202089_c() {
        return this.field_222541_b;
    }

    public int func_207511_e() {
        return 256;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EntityClassification entityClassification, BlockPos blockPos) {
        return this.field_222540_a.func_226691_t_(blockPos).func_76747_a(entityClassification);
    }

    public void func_227058_a_(BiomeManager biomeManager, IChunk iChunk, ChunkGenerator<?> chunkGenerator, TemplateManager templateManager) {
        for (Structure structure : Feature.field_202300_at.values()) {
            if (!chunkGenerator.func_202090_b().func_205004_a(structure)) continue;
            StructureStart structureStart = iChunk.func_201585_a(structure.func_143025_a());
            int \u26032 = structureStart != null ? structureStart.func_227457_j_() : 0;
            SharedSeedRandom \u26033 = new SharedSeedRandom();
            ChunkPos \u26034 = iChunk.func_76632_l();
            \u2603 = StructureStart.field_214630_a;
            Biome \u26035 = biomeManager.func_226836_a_(new BlockPos(\u26034.func_180334_c() + 9, 0, \u26034.func_180333_d() + 9));
            if (structure.func_225558_a_(biomeManager, chunkGenerator, \u26033, \u26034.field_77276_a, \u26034.field_77275_b, \u26035)) {
                \u2603 = structure.func_214557_a().create(structure, \u26034.field_77276_a, \u26034.field_77275_b, MutableBoundingBox.func_78887_a(), \u26032, chunkGenerator.func_202089_c());
                \u2603.func_214625_a(this, templateManager, \u26034.field_77276_a, \u26034.field_77275_b, \u26035);
                \u2603 = \u2603.func_75069_d() ? \u2603 : StructureStart.field_214630_a;
            }
            iChunk.func_201584_a(structure.func_143025_a(), \u2603);
        }
    }

    public void func_222528_a(IWorld iWorld, IChunk iChunk) {
        int n = 8;
        \u2603 = iChunk.func_76632_l().field_77276_a;
        \u2603 = iChunk.func_76632_l().field_77275_b;
        \u2603 = \u2603 << 4;
        \u2603 = \u2603 << 4;
        for (\u2603 = \u2603 - 8; \u2603 <= \u2603 + 8; ++\u2603) {
            for (\u2603 = \u2603 - 8; \u2603 <= \u2603 + 8; ++\u2603) {
                long l = ChunkPos.func_77272_a(\u2603, \u2603);
                for (Map.Entry<String, StructureStart> entry : iWorld.func_212866_a_(\u2603, \u2603).func_201609_c().entrySet()) {
                    StructureStart structureStart = entry.getValue();
                    if (structureStart == StructureStart.field_214630_a || !structureStart.func_75071_a().func_78885_a(\u2603, \u2603, \u2603 + 15, \u2603 + 15)) continue;
                    iChunk.func_201583_a(entry.getKey(), l);
                    DebugPacketSender.func_218804_a(iWorld, structureStart);
                }
            }
        }
    }

    public abstract void func_222537_b(IWorld var1, IChunk var2);

    public int func_222530_f() {
        return 63;
    }

    public abstract int func_222529_a(int var1, int var2, Heightmap.Type var3);

    public int func_222532_b(int n, int n2, Heightmap.Type type) {
        return this.func_222529_a(n, n2, type);
    }

    public int func_222531_c(int n, int n2, Heightmap.Type type) {
        return this.func_222529_a(n, n2, type) - 1;
    }
}

