/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.raid;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.network.play.server.SEntityStatusPacket;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.village.PointOfInterest;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.GameRules;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.raid.Raid;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;

public class RaidManager
extends WorldSavedData {
    private final Map<Integer, Raid> field_215175_a = Maps.newHashMap();
    private final ServerWorld field_215176_b;
    private int field_215177_c;
    private int field_215178_d;

    public RaidManager(ServerWorld serverWorld) {
        super(RaidManager.func_215172_a(serverWorld.field_73011_w));
        this.field_215176_b = serverWorld;
        this.field_215177_c = 1;
        this.func_76185_a();
    }

    public Raid func_215167_a(int n) {
        return this.field_215175_a.get(n);
    }

    public void func_215171_a() {
        ++this.field_215178_d;
        Iterator<Raid> iterator = this.field_215175_a.values().iterator();
        while (iterator.hasNext()) {
            Raid raid = iterator.next();
            if (this.field_215176_b.func_82736_K().func_223586_b(GameRules.field_223621_x)) {
                raid.func_221295_o();
            }
            if (raid.func_221310_d()) {
                iterator.remove();
                this.func_76185_a();
                continue;
            }
            raid.func_221307_p();
        }
        if (this.field_215178_d % 200 == 0) {
            this.func_76185_a();
        }
        DebugPacketSender.func_222946_a(this.field_215176_b, this.field_215175_a.values());
    }

    public static boolean func_215165_a(AbstractRaiderEntity abstractRaiderEntity, Raid raid) {
        if (abstractRaiderEntity != null && raid != null && raid.func_221316_i() != null) {
            return abstractRaiderEntity.func_70089_S() && abstractRaiderEntity.func_213658_ej() && abstractRaiderEntity.func_70654_ax() <= 2400 && abstractRaiderEntity.field_70170_p.func_201675_m().func_186058_p() == raid.func_221316_i().func_201675_m().func_186058_p();
        }
        return false;
    }

    @Nullable
    public Raid func_215170_a(ServerPlayerEntity serverPlayerEntity2) {
        ServerPlayerEntity serverPlayerEntity2;
        BlockPos blockPos;
        if (serverPlayerEntity2.func_175149_v()) {
            return null;
        }
        if (this.field_215176_b.func_82736_K().func_223586_b(GameRules.field_223621_x)) {
            return null;
        }
        DimensionType dimensionType = serverPlayerEntity2.field_70170_p.func_201675_m().func_186058_p();
        if (dimensionType == DimensionType.field_223228_b_) {
            return null;
        }
        BlockPos \u26032 = new BlockPos(serverPlayerEntity2);
        List \u26033 = this.field_215176_b.func_217443_B().func_219146_b(PointOfInterestType.field_221053_a, \u26032, 64, PointOfInterestManager.Status.IS_OCCUPIED).collect(Collectors.toList());
        int \u26034 = 0;
        Vec3d \u26035 = Vec3d.field_186680_a;
        for (PointOfInterest pointOfInterest : \u26033) {
            BlockPos blockPos2 = pointOfInterest.func_218261_f();
            \u26035 = \u26035.func_72441_c(blockPos2.func_177958_n(), blockPos2.func_177956_o(), blockPos2.func_177952_p());
            ++\u26034;
        }
        if (\u26034 > 0) {
            \u26035 = \u26035.func_186678_a(1.0 / (double)\u26034);
            blockPos = new BlockPos(\u26035);
        } else {
            blockPos = \u26032;
        }
        Raid \u26036 = this.func_215168_a(serverPlayerEntity2.func_71121_q(), blockPos);
        boolean \u26037 = false;
        if (!\u26036.func_221301_k()) {
            if (!this.field_215175_a.containsKey(\u26036.func_221325_u())) {
                this.field_215175_a.put(\u26036.func_221325_u(), \u26036);
            }
            \u26037 = true;
        } else if (\u26036.func_221291_n() < \u26036.func_221327_m()) {
            \u26037 = true;
        } else {
            serverPlayerEntity2.func_195063_d(Effects.field_220309_E);
            serverPlayerEntity2.field_71135_a.func_147359_a(new SEntityStatusPacket(serverPlayerEntity2, 43));
        }
        if (\u26037) {
            \u26036.func_221309_a(serverPlayerEntity2);
            serverPlayerEntity2.field_71135_a.func_147359_a(new SEntityStatusPacket(serverPlayerEntity2, 43));
            if (!\u26036.func_221297_c()) {
                serverPlayerEntity2.func_195066_a(Stats.field_219741_ay);
                CriteriaTriggers.field_215102_I.func_192215_a(serverPlayerEntity2);
            }
        }
        this.func_76185_a();
        return \u26036;
    }

    private Raid func_215168_a(ServerWorld serverWorld, BlockPos blockPos) {
        Raid raid = serverWorld.func_217475_c_(blockPos);
        return raid != null ? raid : new Raid(this.func_215173_e(), serverWorld, blockPos);
    }

    @Override
    public void func_76184_a(CompoundNBT compoundNBT) {
        this.field_215177_c = compoundNBT.func_74762_e("NextAvailableID");
        this.field_215178_d = compoundNBT.func_74762_e("Tick");
        ListNBT listNBT = compoundNBT.func_150295_c("Raids", 10);
        for (int i = 0; i < listNBT.size(); ++i) {
            CompoundNBT compoundNBT2 = listNBT.func_150305_b(i);
            Raid \u26032 = new Raid(this.field_215176_b, compoundNBT2);
            this.field_215175_a.put(\u26032.func_221325_u(), \u26032);
        }
    }

    @Override
    public CompoundNBT func_189551_b(CompoundNBT compoundNBT2) {
        CompoundNBT compoundNBT2;
        compoundNBT2.func_74768_a("NextAvailableID", this.field_215177_c);
        compoundNBT2.func_74768_a("Tick", this.field_215178_d);
        ListNBT listNBT = new ListNBT();
        for (Raid raid : this.field_215175_a.values()) {
            CompoundNBT compoundNBT3 = new CompoundNBT();
            raid.func_221326_a(compoundNBT3);
            listNBT.add(compoundNBT3);
        }
        compoundNBT2.func_218657_a("Raids", listNBT);
        return compoundNBT2;
    }

    public static String func_215172_a(Dimension dimension) {
        return "raids" + dimension.func_186058_p().func_186067_c();
    }

    private int func_215173_e() {
        return ++this.field_215177_c;
    }

    @Nullable
    public Raid func_215174_a(BlockPos blockPos, int n) {
        Raid \u26033 = null;
        double \u26032 = n;
        for (Raid raid : this.field_215175_a.values()) {
            double d = raid.func_221304_t().func_177951_i(blockPos);
            if (!raid.func_221333_v() || !(d < \u26032)) continue;
            \u26033 = raid;
            \u26032 = d;
        }
        return \u26033;
    }
}

