/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.moddiscovery.ModAnnotation;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;

public class AutomaticEventSubscriber {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Type AUTO_SUBSCRIBER = Type.getType(Mod.EventBusSubscriber.class);
    private static final Type MOD_TYPE = Type.getType(Mod.class);

    public static void inject(ModContainer mod, ModFileScanData scanData, ClassLoader loader) {
        if (scanData == null) {
            return;
        }
        LOGGER.debug(Logging.LOADING, "Attempting to inject @EventBusSubscriber classes into the eventbus for {}", (Object)mod.getModId());
        List<ModFileScanData.AnnotationData> ebsTargets = scanData.getAnnotations().stream().filter(annotationData -> AUTO_SUBSCRIBER.equals((Object)annotationData.getAnnotationType())).collect(Collectors.toList());
        Map<String, String> modids = scanData.getAnnotations().stream().filter(annotationData -> MOD_TYPE.equals((Object)annotationData.getAnnotationType())).collect(Collectors.toMap(a -> a.getClassType().getClassName(), a -> (String)a.getAnnotationData().get("value")));
        ebsTargets.forEach(ad -> {
            List<ModAnnotation.EnumHolder> sidesValue = ad.getAnnotationData().getOrDefault("value", Arrays.asList(new ModAnnotation.EnumHolder(null, "CLIENT"), new ModAnnotation.EnumHolder(null, "DEDICATED_SERVER")));
            EnumSet sides = sidesValue.stream().map(eh -> Dist.valueOf((String)eh.getValue())).collect(Collectors.toCollection(() -> EnumSet.noneOf(Dist.class)));
            String modId = ad.getAnnotationData().getOrDefault("modid", modids.getOrDefault(ad.getClassType().getClassName(), mod.getModId()));
            ModAnnotation.EnumHolder busTargetHolder = ad.getAnnotationData().getOrDefault("bus", new ModAnnotation.EnumHolder(null, "FORGE"));
            Mod.EventBusSubscriber.Bus busTarget = Mod.EventBusSubscriber.Bus.valueOf(busTargetHolder.getValue());
            if (Objects.equals(mod.getModId(), modId) && sides.contains(FMLEnvironment.dist)) {
                try {
                    LOGGER.debug(Logging.LOADING, "Auto-subscribing {} to {}", (Object)ad.getClassType().getClassName(), (Object)busTarget);
                    busTarget.bus().get().register(Class.forName(ad.getClassType().getClassName(), true, loader));
                }
                catch (ClassNotFoundException e) {
                    LOGGER.fatal(Logging.LOADING, "Failed to load mod class {} for @EventBusSubscriber annotation", (Object)ad.getClassType(), (Object)e);
                    throw new RuntimeException(e);
                }
            }
        });
    }
}

