/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.culling.ClippingHelperImpl;
import net.minecraft.client.renderer.entity.AreaEffectCloudRenderer;
import net.minecraft.client.renderer.entity.ArmorStandRenderer;
import net.minecraft.client.renderer.entity.BatRenderer;
import net.minecraft.client.renderer.entity.BeeRenderer;
import net.minecraft.client.renderer.entity.BlazeRenderer;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.CatRenderer;
import net.minecraft.client.renderer.entity.CaveSpiderRenderer;
import net.minecraft.client.renderer.entity.ChestedHorseRenderer;
import net.minecraft.client.renderer.entity.ChickenRenderer;
import net.minecraft.client.renderer.entity.CodRenderer;
import net.minecraft.client.renderer.entity.CowRenderer;
import net.minecraft.client.renderer.entity.CreeperRenderer;
import net.minecraft.client.renderer.entity.DolphinRenderer;
import net.minecraft.client.renderer.entity.DragonFireballRenderer;
import net.minecraft.client.renderer.entity.DrownedRenderer;
import net.minecraft.client.renderer.entity.ElderGuardianRenderer;
import net.minecraft.client.renderer.entity.EnderCrystalRenderer;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.entity.EndermanRenderer;
import net.minecraft.client.renderer.entity.EndermiteRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EvokerFangsRenderer;
import net.minecraft.client.renderer.entity.EvokerRenderer;
import net.minecraft.client.renderer.entity.ExperienceOrbRenderer;
import net.minecraft.client.renderer.entity.FallingBlockRenderer;
import net.minecraft.client.renderer.entity.FireworkRocketRenderer;
import net.minecraft.client.renderer.entity.FishRenderer;
import net.minecraft.client.renderer.entity.FoxRenderer;
import net.minecraft.client.renderer.entity.GhastRenderer;
import net.minecraft.client.renderer.entity.GiantZombieRenderer;
import net.minecraft.client.renderer.entity.GuardianRenderer;
import net.minecraft.client.renderer.entity.HorseRenderer;
import net.minecraft.client.renderer.entity.HuskRenderer;
import net.minecraft.client.renderer.entity.IllusionerRenderer;
import net.minecraft.client.renderer.entity.IronGolemRenderer;
import net.minecraft.client.renderer.entity.ItemFrameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.LeashKnotRenderer;
import net.minecraft.client.renderer.entity.LightningBoltRenderer;
import net.minecraft.client.renderer.entity.LlamaRenderer;
import net.minecraft.client.renderer.entity.LlamaSpitRenderer;
import net.minecraft.client.renderer.entity.MagmaCubeRenderer;
import net.minecraft.client.renderer.entity.MinecartRenderer;
import net.minecraft.client.renderer.entity.MooshroomRenderer;
import net.minecraft.client.renderer.entity.OcelotRenderer;
import net.minecraft.client.renderer.entity.PaintingRenderer;
import net.minecraft.client.renderer.entity.PandaRenderer;
import net.minecraft.client.renderer.entity.ParrotRenderer;
import net.minecraft.client.renderer.entity.PhantomRenderer;
import net.minecraft.client.renderer.entity.PigRenderer;
import net.minecraft.client.renderer.entity.PigZombieRenderer;
import net.minecraft.client.renderer.entity.PillagerRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.PolarBearRenderer;
import net.minecraft.client.renderer.entity.PufferfishRenderer;
import net.minecraft.client.renderer.entity.RabbitRenderer;
import net.minecraft.client.renderer.entity.RavagerRenderer;
import net.minecraft.client.renderer.entity.SalmonRenderer;
import net.minecraft.client.renderer.entity.SheepRenderer;
import net.minecraft.client.renderer.entity.ShulkerBulletRenderer;
import net.minecraft.client.renderer.entity.ShulkerRenderer;
import net.minecraft.client.renderer.entity.SilverfishRenderer;
import net.minecraft.client.renderer.entity.SkeletonRenderer;
import net.minecraft.client.renderer.entity.SlimeRenderer;
import net.minecraft.client.renderer.entity.SnowManRenderer;
import net.minecraft.client.renderer.entity.SpectralArrowRenderer;
import net.minecraft.client.renderer.entity.SpiderRenderer;
import net.minecraft.client.renderer.entity.SpriteRenderer;
import net.minecraft.client.renderer.entity.SquidRenderer;
import net.minecraft.client.renderer.entity.StrayRenderer;
import net.minecraft.client.renderer.entity.TNTMinecartRenderer;
import net.minecraft.client.renderer.entity.TNTRenderer;
import net.minecraft.client.renderer.entity.TippedArrowRenderer;
import net.minecraft.client.renderer.entity.TridentRenderer;
import net.minecraft.client.renderer.entity.TropicalFishRenderer;
import net.minecraft.client.renderer.entity.TurtleRenderer;
import net.minecraft.client.renderer.entity.UndeadHorseRenderer;
import net.minecraft.client.renderer.entity.VexRenderer;
import net.minecraft.client.renderer.entity.VillagerRenderer;
import net.minecraft.client.renderer.entity.VindicatorRenderer;
import net.minecraft.client.renderer.entity.WanderingTraderRenderer;
import net.minecraft.client.renderer.entity.WitchRenderer;
import net.minecraft.client.renderer.entity.WitherRenderer;
import net.minecraft.client.renderer.entity.WitherSkeletonRenderer;
import net.minecraft.client.renderer.entity.WitherSkullRenderer;
import net.minecraft.client.renderer.entity.WolfRenderer;
import net.minecraft.client.renderer.entity.ZombieRenderer;
import net.minecraft.client.renderer.entity.ZombieVillagerRenderer;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.boss.dragon.EnderDragonPartEntity;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EntityRendererManager {
    private static final RenderType field_229082_e_ = RenderType.func_228650_h_((ResourceLocation)new ResourceLocation("textures/misc/shadow.png"));
    public final Map<EntityType<?>, EntityRenderer<?>> field_78729_o = Maps.newHashMap();
    private final Map<String, PlayerRenderer> field_178636_l = Maps.newHashMap();
    private final PlayerRenderer field_178637_m;
    private final FontRenderer field_78736_p;
    public final TextureManager field_78724_e;
    private World field_78722_g;
    public ActiveRenderInfo field_217783_c;
    private Quaternion field_229083_k_;
    public Entity field_147941_i;
    public final GameSettings field_78733_k;
    private boolean field_178638_s = true;
    private boolean field_85095_o;

    public <E extends Entity> int func_229085_a_(E entityIn, float partialTicks) {
        return this.func_78713_a(entityIn).func_229100_c_(entityIn, partialTicks);
    }

    public <T extends Entity> void func_229087_a_(EntityType<T> entityTypeIn, EntityRenderer<? super T> entityRendererIn) {
        this.field_78729_o.put(entityTypeIn, entityRendererIn);
    }

    private void func_229097_a_(net.minecraft.client.renderer.ItemRenderer itemRendererIn, IReloadableResourceManager resourceManagerIn) {
        this.func_229087_a_(EntityType.field_200788_b, (EntityRenderer)new AreaEffectCloudRenderer(this));
        this.func_229087_a_(EntityType.field_200789_c, (EntityRenderer)new ArmorStandRenderer(this));
        this.func_229087_a_(EntityType.field_200790_d, (EntityRenderer)new TippedArrowRenderer(this));
        this.func_229087_a_(EntityType.field_200791_e, (EntityRenderer)new BatRenderer(this));
        this.func_229087_a_(EntityType.field_226289_e_, (EntityRenderer)new BeeRenderer(this));
        this.func_229087_a_(EntityType.field_200792_f, (EntityRenderer)new BlazeRenderer(this));
        this.func_229087_a_(EntityType.field_200793_g, (EntityRenderer)new BoatRenderer(this));
        this.func_229087_a_(EntityType.field_220360_g, (EntityRenderer)new CatRenderer(this));
        this.func_229087_a_(EntityType.field_200794_h, (EntityRenderer)new CaveSpiderRenderer(this));
        this.func_229087_a_(EntityType.field_200773_M, (EntityRenderer)new MinecartRenderer(this));
        this.func_229087_a_(EntityType.field_200795_i, (EntityRenderer)new ChickenRenderer(this));
        this.func_229087_a_(EntityType.field_203780_j, (EntityRenderer)new CodRenderer(this));
        this.func_229087_a_(EntityType.field_200774_N, (EntityRenderer)new MinecartRenderer(this));
        this.func_229087_a_(EntityType.field_200796_j, (EntityRenderer)new CowRenderer(this));
        this.func_229087_a_(EntityType.field_200797_k, (EntityRenderer)new CreeperRenderer(this));
        this.func_229087_a_(EntityType.field_205137_n, (EntityRenderer)new DolphinRenderer(this));
        this.func_229087_a_(EntityType.field_200798_l, (EntityRenderer)new ChestedHorseRenderer(this, 0.87f));
        this.func_229087_a_(EntityType.field_200799_m, (EntityRenderer)new DragonFireballRenderer(this));
        this.func_229087_a_(EntityType.field_204724_o, (EntityRenderer)new DrownedRenderer(this));
        this.func_229087_a_(EntityType.field_200751_aq, (EntityRenderer)new SpriteRenderer(this, itemRendererIn));
        this.func_229087_a_(EntityType.field_200800_n, (EntityRenderer)new ElderGuardianRenderer(this));
        this.func_229087_a_(EntityType.field_200801_o, (EntityRenderer)new EnderCrystalRenderer(this));
        this.func_229087_a_(EntityType.field_200802_p, (EntityRenderer)new EnderDragonRenderer(this));
        this.func_229087_a_(EntityType.field_200803_q, (EntityRenderer)new EndermanRenderer(this));
        this.func_229087_a_(EntityType.field_200804_r, (EntityRenderer)new EndermiteRenderer(this));
        this.func_229087_a_(EntityType.field_200752_ar, (EntityRenderer)new SpriteRenderer(this, itemRendererIn));
        this.func_229087_a_(EntityType.field_200805_s, (EntityRenderer)new EvokerFangsRenderer(this));
        this.func_229087_a_(EntityType.field_200806_t, (EntityRenderer)new EvokerRenderer(this));
        this.func_229087_a_(EntityType.field_200753_as, (EntityRenderer)new SpriteRenderer(this, itemRendererIn));
        this.func_229087_a_(EntityType.field_200807_u, (EntityRenderer)new ExperienceOrbRenderer(this));
        this.func_229087_a_(EntityType.field_200808_v, (EntityRenderer)new SpriteRenderer(this, itemRendererIn, 1.0f, true));
        this.func_229087_a_(EntityType.field_200809_w, new FallingBlockRenderer(this));
        this.func_229087_a_(EntityType.field_200767_G, (EntityRenderer)new SpriteRenderer(this, itemRendererIn, 3.0f, true));
        this.func_229087_a_(EntityType.field_200810_x, (EntityRenderer)new FireworkRocketRenderer(this, itemRendererIn));
        this.func_229087_a_(EntityType.field_200730_aI, new FishRenderer(this));
        this.func_229087_a_(EntityType.field_220356_B, (EntityRenderer)new FoxRenderer(this));
        this.func_229087_a_(EntityType.field_200775_O, (EntityRenderer)new MinecartRenderer(this));
        this.func_229087_a_(EntityType.field_200811_y, (EntityRenderer)new GhastRenderer(this));
        this.func_229087_a_(EntityType.field_200812_z, (EntityRenderer)new GiantZombieRenderer(this, 6.0f));
        this.func_229087_a_(EntityType.field_200761_A, (EntityRenderer)new GuardianRenderer(this));
        this.func_229087_a_(EntityType.field_200776_P, (EntityRenderer)new MinecartRenderer(this));
        this.func_229087_a_(EntityType.field_200762_B, (EntityRenderer)new HorseRenderer(this));
        this.func_229087_a_(EntityType.field_200763_C, (EntityRenderer)new HuskRenderer(this));
        this.func_229087_a_(EntityType.field_200764_D, (EntityRenderer)new IllusionerRenderer(this));
        this.func_229087_a_(EntityType.field_200757_aw, (EntityRenderer)new IronGolemRenderer(this));
        this.func_229087_a_(EntityType.field_200766_F, new ItemFrameRenderer(this, itemRendererIn));
        this.func_229087_a_(EntityType.field_200765_E, new ItemRenderer(this, itemRendererIn));
        this.func_229087_a_(EntityType.field_200768_H, (EntityRenderer)new LeashKnotRenderer(this));
        this.func_229087_a_(EntityType.field_200728_aG, (EntityRenderer)new LightningBoltRenderer(this));
        this.func_229087_a_(EntityType.field_200769_I, (EntityRenderer)new LlamaRenderer(this));
        this.func_229087_a_(EntityType.field_200770_J, (EntityRenderer)new LlamaSpitRenderer(this));
        this.func_229087_a_(EntityType.field_200771_K, (EntityRenderer)new MagmaCubeRenderer(this));
        this.func_229087_a_(EntityType.field_200772_L, (EntityRenderer)new MinecartRenderer(this));
        this.func_229087_a_(EntityType.field_200780_T, (EntityRenderer)new MooshroomRenderer(this));
        this.func_229087_a_(EntityType.field_200779_S, (EntityRenderer)new ChestedHorseRenderer(this, 0.92f));
        this.func_229087_a_(EntityType.field_200781_U, (EntityRenderer)new OcelotRenderer(this));
        this.func_229087_a_(EntityType.field_200782_V, (EntityRenderer)new PaintingRenderer(this));
        this.func_229087_a_(EntityType.field_220353_aa, (EntityRenderer)new PandaRenderer(this));
        this.func_229087_a_(EntityType.field_200783_W, (EntityRenderer)new ParrotRenderer(this));
        this.func_229087_a_(EntityType.field_203097_aH, (EntityRenderer)new PhantomRenderer(this));
        this.func_229087_a_(EntityType.field_200784_X, (EntityRenderer)new PigRenderer(this));
        this.func_229087_a_(EntityType.field_220350_aJ, (EntityRenderer)new PillagerRenderer(this));
        this.func_229087_a_(EntityType.field_200786_Z, (EntityRenderer)new PolarBearRenderer(this));
        this.func_229087_a_(EntityType.field_200754_at, (EntityRenderer)new SpriteRenderer(this, itemRendererIn));
        this.func_229087_a_(EntityType.field_203779_Z, (EntityRenderer)new PufferfishRenderer(this));
        this.func_229087_a_(EntityType.field_200736_ab, (EntityRenderer)new RabbitRenderer(this));
        this.func_229087_a_(EntityType.field_220352_aU, (EntityRenderer)new RavagerRenderer(this));
        this.func_229087_a_(EntityType.field_203778_ae, (EntityRenderer)new SalmonRenderer(this));
        this.func_229087_a_(EntityType.field_200737_ac, (EntityRenderer)new SheepRenderer(this));
        this.func_229087_a_(EntityType.field_200739_ae, (EntityRenderer)new ShulkerBulletRenderer(this));
        this.func_229087_a_(EntityType.field_200738_ad, (EntityRenderer)new ShulkerRenderer(this));
        this.func_229087_a_(EntityType.field_200740_af, (EntityRenderer)new SilverfishRenderer(this));
        this.func_229087_a_(EntityType.field_200742_ah, (EntityRenderer)new UndeadHorseRenderer(this));
        this.func_229087_a_(EntityType.field_200741_ag, (EntityRenderer)new SkeletonRenderer(this));
        this.func_229087_a_(EntityType.field_200743_ai, (EntityRenderer)new SlimeRenderer(this));
        this.func_229087_a_(EntityType.field_200744_aj, (EntityRenderer)new SpriteRenderer(this, itemRendererIn, 0.75f, true));
        this.func_229087_a_(EntityType.field_200746_al, (EntityRenderer)new SpriteRenderer(this, itemRendererIn));
        this.func_229087_a_(EntityType.field_200745_ak, (EntityRenderer)new SnowManRenderer(this));
        this.func_229087_a_(EntityType.field_200777_Q, (EntityRenderer)new MinecartRenderer(this));
        this.func_229087_a_(EntityType.field_200747_am, (EntityRenderer)new SpectralArrowRenderer(this));
        this.func_229087_a_(EntityType.field_200748_an, (EntityRenderer)new SpiderRenderer(this));
        this.func_229087_a_(EntityType.field_200749_ao, (EntityRenderer)new SquidRenderer(this));
        this.func_229087_a_(EntityType.field_200750_ap, (EntityRenderer)new StrayRenderer(this));
        this.func_229087_a_(EntityType.field_200778_R, (EntityRenderer)new TNTMinecartRenderer(this));
        this.func_229087_a_(EntityType.field_200735_aa, (EntityRenderer)new TNTRenderer(this));
        this.func_229087_a_(EntityType.field_220354_ax, (EntityRenderer)new LlamaRenderer(this));
        this.func_229087_a_(EntityType.field_203098_aL, (EntityRenderer)new TridentRenderer(this));
        this.func_229087_a_(EntityType.field_204262_at, (EntityRenderer)new TropicalFishRenderer(this));
        this.func_229087_a_(EntityType.field_203099_aq, (EntityRenderer)new TurtleRenderer(this));
        this.func_229087_a_(EntityType.field_200755_au, (EntityRenderer)new VexRenderer(this));
        this.func_229087_a_(EntityType.field_200756_av, (EntityRenderer)new VillagerRenderer(this, resourceManagerIn));
        this.func_229087_a_(EntityType.field_200758_ax, (EntityRenderer)new VindicatorRenderer(this));
        this.func_229087_a_(EntityType.field_220351_aK, (EntityRenderer)new WanderingTraderRenderer(this));
        this.func_229087_a_(EntityType.field_200759_ay, (EntityRenderer)new WitchRenderer(this));
        this.func_229087_a_(EntityType.field_200760_az, (EntityRenderer)new WitherRenderer(this));
        this.func_229087_a_(EntityType.field_200722_aA, (EntityRenderer)new WitherSkeletonRenderer(this));
        this.func_229087_a_(EntityType.field_200723_aB, (EntityRenderer)new WitherSkullRenderer(this));
        this.func_229087_a_(EntityType.field_200724_aC, (EntityRenderer)new WolfRenderer(this));
        this.func_229087_a_(EntityType.field_200726_aE, (EntityRenderer)new UndeadHorseRenderer(this));
        this.func_229087_a_(EntityType.field_200725_aD, (EntityRenderer)new ZombieRenderer(this));
        this.func_229087_a_(EntityType.field_200785_Y, (EntityRenderer)new PigZombieRenderer(this));
        this.func_229087_a_(EntityType.field_200727_aF, (EntityRenderer)new ZombieVillagerRenderer(this, resourceManagerIn));
    }

    public EntityRendererManager(TextureManager textureManagerIn, net.minecraft.client.renderer.ItemRenderer itemRendererIn, IReloadableResourceManager resourceManagerIn, FontRenderer fontRendererIn, GameSettings gameSettingsIn) {
        this.field_78724_e = textureManagerIn;
        this.field_78736_p = fontRendererIn;
        this.field_78733_k = gameSettingsIn;
        this.func_229097_a_(itemRendererIn, resourceManagerIn);
        this.field_178637_m = new PlayerRenderer(this);
        this.field_178636_l.put("default", this.field_178637_m);
        this.field_178636_l.put("slim", new PlayerRenderer(this, true));
    }

    public void validateRendererExistence() {
        for (EntityType entitytype : Registry.field_212629_r) {
            if (entitytype == EntityType.field_200729_aH || this.field_78729_o.containsKey((Object)entitytype)) continue;
            throw new IllegalStateException("No renderer registered for " + Registry.field_212629_r.func_177774_c((Object)entitytype));
        }
    }

    public <T extends Entity> EntityRenderer<? super T> func_78713_a(T entityIn) {
        if (entityIn instanceof AbstractClientPlayerEntity) {
            String s = ((AbstractClientPlayerEntity)entityIn).func_175154_l();
            PlayerRenderer playerrenderer = this.field_178636_l.get(s);
            return playerrenderer != null ? playerrenderer : this.field_178637_m;
        }
        return this.field_78729_o.get(entityIn.func_200600_R());
    }

    public void func_229088_a_(World worldIn, ActiveRenderInfo activeRenderInfoIn, Entity entityIn) {
        this.field_78722_g = worldIn;
        this.field_217783_c = activeRenderInfoIn;
        this.field_229083_k_ = activeRenderInfoIn.func_227995_f_();
        this.field_147941_i = entityIn;
    }

    public void func_229089_a_(Quaternion quaternionIn) {
        this.field_229083_k_ = quaternionIn;
    }

    public void func_178633_a(boolean renderShadowIn) {
        this.field_178638_s = renderShadowIn;
    }

    public void func_178629_b(boolean debugBoundingBoxIn) {
        this.field_85095_o = debugBoundingBoxIn;
    }

    public boolean func_178634_b() {
        return this.field_85095_o;
    }

    public <E extends Entity> boolean func_229086_a_(E entityIn, ClippingHelperImpl frustumIn, double camX, double camY, double camZ) {
        EntityRenderer<E> entityrenderer = this.func_78713_a(entityIn);
        return entityrenderer.func_225626_a_(entityIn, frustumIn, camX, camY, camZ);
    }

    public <E extends Entity> void func_229084_a_(E entityIn, double xIn, double yIn, double zIn, float rotationYawIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        EntityRenderer<E> entityrenderer = this.func_78713_a(entityIn);
        try {
            double d1;
            float f;
            Vec3d vec3d = entityrenderer.func_225627_b_(entityIn, partialTicks);
            double d2 = xIn + vec3d.func_82615_a();
            double d3 = yIn + vec3d.func_82617_b();
            double d0 = zIn + vec3d.func_82616_c();
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(d2, d3, d0);
            entityrenderer.func_225623_a_(entityIn, rotationYawIn, partialTicks, matrixStackIn, bufferIn, packedLightIn);
            if (entityIn.func_90999_ad()) {
                this.func_229095_a_(matrixStackIn, bufferIn, entityIn);
            }
            matrixStackIn.func_227861_a_(-vec3d.func_82615_a(), -vec3d.func_82617_b(), -vec3d.func_82616_c());
            if (this.field_78733_k.field_181151_V && this.field_178638_s && entityrenderer.field_76989_e > 0.0f && !entityIn.func_82150_aj() && (f = (float)((1.0 - (d1 = this.func_78714_a(entityIn.func_226277_ct_(), entityIn.func_226278_cu_(), entityIn.func_226281_cx_())) / 256.0) * (double)entityrenderer.field_76987_f)) > 0.0f) {
                EntityRendererManager.func_229096_a_(matrixStackIn, bufferIn, entityIn, f, partialTicks, this.field_78722_g, entityrenderer.field_76989_e);
            }
            if (this.field_85095_o && !entityIn.func_82150_aj() && !Minecraft.func_71410_x().func_189648_am()) {
                this.func_229093_a_(matrixStackIn, bufferIn.getBuffer(RenderType.func_228659_m_()), entityIn, partialTicks);
            }
            matrixStackIn.func_227865_b_();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Rendering entity in world");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Entity being rendered");
            entityIn.func_85029_a(crashreportcategory);
            CrashReportCategory crashreportcategory1 = crashreport.func_85058_a("Renderer details");
            crashreportcategory1.func_71507_a("Assigned renderer", entityrenderer);
            crashreportcategory1.func_71507_a("Location", CrashReportCategory.func_85074_a(xIn, yIn, zIn));
            crashreportcategory1.func_71507_a("Rotation", Float.valueOf(rotationYawIn));
            crashreportcategory1.func_71507_a("Delta", Float.valueOf(partialTicks));
            throw new ReportedException(crashreport);
        }
    }

    private void func_229093_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, Entity entityIn, float partialTicks) {
        float f = entityIn.func_213311_cf() / 2.0f;
        this.func_229094_a_(matrixStackIn, bufferIn, entityIn, 1.0f, 1.0f, 1.0f);
        if (entityIn instanceof EnderDragonEntity) {
            double d0 = entityIn.func_226277_ct_() - MathHelper.func_219803_d((double)partialTicks, (double)entityIn.field_70142_S, (double)entityIn.func_226277_ct_());
            double d1 = entityIn.func_226278_cu_() - MathHelper.func_219803_d((double)partialTicks, (double)entityIn.field_70137_T, (double)entityIn.func_226278_cu_());
            double d2 = entityIn.func_226281_cx_() - MathHelper.func_219803_d((double)partialTicks, (double)entityIn.field_70136_U, (double)entityIn.func_226281_cx_());
            for (EnderDragonPartEntity enderdragonpartentity : ((EnderDragonEntity)entityIn).func_213404_dT()) {
                matrixStackIn.func_227860_a_();
                double d3 = d0 + MathHelper.func_219803_d((double)partialTicks, (double)enderdragonpartentity.field_70142_S, (double)enderdragonpartentity.func_226277_ct_());
                double d4 = d1 + MathHelper.func_219803_d((double)partialTicks, (double)enderdragonpartentity.field_70137_T, (double)enderdragonpartentity.func_226278_cu_());
                double d5 = d2 + MathHelper.func_219803_d((double)partialTicks, (double)enderdragonpartentity.field_70136_U, (double)enderdragonpartentity.func_226281_cx_());
                matrixStackIn.func_227861_a_(d3, d4, d5);
                this.func_229094_a_(matrixStackIn, bufferIn, (Entity)enderdragonpartentity, 0.25f, 1.0f, 0.0f);
                matrixStackIn.func_227865_b_();
            }
        }
        if (entityIn instanceof LivingEntity) {
            float f1 = 0.01f;
            WorldRenderer.func_228427_a_(matrixStackIn, bufferIn, -f, entityIn.func_70047_e() - 0.01f, -f, f, entityIn.func_70047_e() + 0.01f, f, 1.0f, 0.0f, 0.0f, 1.0f);
        }
        Vec3d vec3d = entityIn.func_70676_i(partialTicks);
        Matrix4f matrix4f = matrixStackIn.func_227866_c_().func_227870_a_();
        bufferIn.func_227888_a_(matrix4f, 0.0f, entityIn.func_70047_e(), 0.0f).func_225586_a_(0, 0, 255, 255).func_181675_d();
        bufferIn.func_227888_a_(matrix4f, (float)(vec3d.field_72450_a * 2.0), (float)((double)entityIn.func_70047_e() + vec3d.field_72448_b * 2.0), (float)(vec3d.field_72449_c * 2.0)).func_225586_a_(0, 0, 255, 255).func_181675_d();
    }

    private void func_229094_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, Entity entityIn, float red, float green, float blue) {
        AxisAlignedBB axisalignedbb = entityIn.func_174813_aQ().func_72317_d(-entityIn.func_226277_ct_(), -entityIn.func_226278_cu_(), -entityIn.func_226281_cx_());
        WorldRenderer.func_228430_a_(matrixStackIn, bufferIn, axisalignedbb, red, green, blue, 1.0f);
    }

    private void func_229095_a_(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, Entity entityIn) {
        TextureAtlasSprite textureatlassprite = ModelBakery.field_207763_a.func_229314_c_();
        TextureAtlasSprite textureatlassprite1 = ModelBakery.field_207764_b.func_229314_c_();
        matrixStackIn.func_227860_a_();
        float f = entityIn.func_213311_cf() * 1.4f;
        matrixStackIn.func_227862_a_(f, f, f);
        float f1 = 0.5f;
        float f2 = 0.0f;
        float f3 = entityIn.func_213302_cg() / f;
        float f4 = 0.0f;
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-this.field_217783_c.func_216778_f()));
        matrixStackIn.func_227861_a_(0.0, 0.0, (double)(-0.3f + (float)((int)f3) * 0.02f));
        float f5 = 0.0f;
        int i = 0;
        IVertexBuilder ivertexbuilder = bufferIn.getBuffer(Atlases.func_228783_h_());
        MatrixStack.Entry matrixstack$entry = matrixStackIn.func_227866_c_();
        while (f3 > 0.0f) {
            TextureAtlasSprite textureatlassprite2 = i % 2 == 0 ? textureatlassprite : textureatlassprite1;
            float f6 = textureatlassprite2.func_94209_e();
            float f7 = textureatlassprite2.func_94206_g();
            float f8 = textureatlassprite2.func_94212_f();
            float f9 = textureatlassprite2.func_94210_h();
            if (i / 2 % 2 == 0) {
                float f10 = f8;
                f8 = f6;
                f6 = f10;
            }
            EntityRendererManager.func_229090_a_(matrixstack$entry, ivertexbuilder, f1 - 0.0f, 0.0f - f4, f5, f8, f9);
            EntityRendererManager.func_229090_a_(matrixstack$entry, ivertexbuilder, -f1 - 0.0f, 0.0f - f4, f5, f6, f9);
            EntityRendererManager.func_229090_a_(matrixstack$entry, ivertexbuilder, -f1 - 0.0f, 1.4f - f4, f5, f6, f7);
            EntityRendererManager.func_229090_a_(matrixstack$entry, ivertexbuilder, f1 - 0.0f, 1.4f - f4, f5, f8, f7);
            f3 -= 0.45f;
            f4 -= 0.45f;
            f1 *= 0.9f;
            f5 += 0.03f;
            ++i;
        }
        matrixStackIn.func_227865_b_();
    }

    private static void func_229090_a_(MatrixStack.Entry matrixEntryIn, IVertexBuilder bufferIn, float x, float y, float z, float texU, float texV) {
        bufferIn.func_227888_a_(matrixEntryIn.func_227870_a_(), x, y, z).func_225586_a_(255, 255, 255, 255).func_225583_a_(texU, texV).func_225585_a_(0, 10).func_227886_a_(240).func_227887_a_(matrixEntryIn.func_227872_b_(), 0.0f, 1.0f, 0.0f).func_181675_d();
    }

    private static void func_229096_a_(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, Entity entityIn, float weightIn, float partialTicks, IWorldReader worldIn, float sizeIn) {
        MobEntity mobentity;
        float f = sizeIn;
        if (entityIn instanceof MobEntity && (mobentity = (MobEntity)entityIn).func_70631_g_()) {
            f = sizeIn * 0.5f;
        }
        double d2 = MathHelper.func_219803_d((double)partialTicks, (double)entityIn.field_70142_S, (double)entityIn.func_226277_ct_());
        double d0 = MathHelper.func_219803_d((double)partialTicks, (double)entityIn.field_70137_T, (double)entityIn.func_226278_cu_());
        double d1 = MathHelper.func_219803_d((double)partialTicks, (double)entityIn.field_70136_U, (double)entityIn.func_226281_cx_());
        int i = MathHelper.func_76128_c((double)(d2 - (double)f));
        int j = MathHelper.func_76128_c((double)(d2 + (double)f));
        int k = MathHelper.func_76128_c((double)(d0 - (double)f));
        int l = MathHelper.func_76128_c((double)d0);
        int i1 = MathHelper.func_76128_c((double)(d1 - (double)f));
        int j1 = MathHelper.func_76128_c((double)(d1 + (double)f));
        MatrixStack.Entry matrixstack$entry = matrixStackIn.func_227866_c_();
        IVertexBuilder ivertexbuilder = bufferIn.getBuffer(field_229082_e_);
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)new BlockPos(i, k, i1), (BlockPos)new BlockPos(j, l, j1))) {
            EntityRendererManager.func_229092_a_(matrixstack$entry, ivertexbuilder, worldIn, blockpos, d2, d0, d1, f, weightIn);
        }
    }

    private static void func_229092_a_(MatrixStack.Entry matrixEntryIn, IVertexBuilder bufferIn, IWorldReader worldIn, BlockPos blockPosIn, double xIn, double yIn, double zIn, float sizeIn, float weightIn) {
        float f;
        VoxelShape voxelshape;
        BlockPos blockpos = blockPosIn.func_177977_b();
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        if (blockstate.func_185901_i() != BlockRenderType.INVISIBLE && worldIn.func_201696_r(blockPosIn) > 3 && blockstate.func_224756_o((IBlockReader)((Object)worldIn), blockpos) && !(voxelshape = blockstate.func_196954_c((IBlockReader)((Object)worldIn), blockPosIn.func_177977_b())).func_197766_b() && (f = (float)(((double)weightIn - (yIn - (double)blockPosIn.func_177956_o()) / 2.0) * 0.5 * (double)worldIn.func_205052_D(blockPosIn))) >= 0.0f) {
            if (f > 1.0f) {
                f = 1.0f;
            }
            AxisAlignedBB axisalignedbb = voxelshape.func_197752_a();
            double d0 = (double)blockPosIn.func_177958_n() + axisalignedbb.field_72340_a;
            double d1 = (double)blockPosIn.func_177958_n() + axisalignedbb.field_72336_d;
            double d2 = (double)blockPosIn.func_177956_o() + axisalignedbb.field_72338_b;
            double d3 = (double)blockPosIn.func_177952_p() + axisalignedbb.field_72339_c;
            double d4 = (double)blockPosIn.func_177952_p() + axisalignedbb.field_72334_f;
            float f1 = (float)(d0 - xIn);
            float f2 = (float)(d1 - xIn);
            float f3 = (float)(d2 - yIn + 0.015625);
            float f4 = (float)(d3 - zIn);
            float f5 = (float)(d4 - zIn);
            float f6 = -f1 / 2.0f / sizeIn + 0.5f;
            float f7 = -f2 / 2.0f / sizeIn + 0.5f;
            float f8 = -f4 / 2.0f / sizeIn + 0.5f;
            float f9 = -f5 / 2.0f / sizeIn + 0.5f;
            EntityRendererManager.func_229091_a_(matrixEntryIn, bufferIn, f, f1, f3, f4, f6, f8);
            EntityRendererManager.func_229091_a_(matrixEntryIn, bufferIn, f, f1, f3, f5, f6, f9);
            EntityRendererManager.func_229091_a_(matrixEntryIn, bufferIn, f, f2, f3, f5, f7, f9);
            EntityRendererManager.func_229091_a_(matrixEntryIn, bufferIn, f, f2, f3, f4, f7, f8);
        }
    }

    private static void func_229091_a_(MatrixStack.Entry matrixEntryIn, IVertexBuilder bufferIn, float alphaIn, float xIn, float yIn, float zIn, float texU, float texV) {
        bufferIn.func_227888_a_(matrixEntryIn.func_227870_a_(), xIn, yIn, zIn).func_227885_a_(1.0f, 1.0f, 1.0f, alphaIn).func_225583_a_(texU, texV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_227887_a_(matrixEntryIn.func_227872_b_(), 0.0f, 1.0f, 0.0f).func_181675_d();
    }

    public void func_78717_a(@Nullable World worldIn) {
        this.field_78722_g = worldIn;
        if (worldIn == null) {
            this.field_217783_c = null;
        }
    }

    public double func_229099_b_(Entity entityIn) {
        return this.field_217783_c.func_216785_c().func_72436_e(entityIn.func_213303_ch());
    }

    public double func_78714_a(double x, double y, double z) {
        return this.field_217783_c.func_216785_c().func_186679_c(x, y, z);
    }

    public Quaternion func_229098_b_() {
        return this.field_229083_k_;
    }

    public FontRenderer func_78716_a() {
        return this.field_78736_p;
    }

    public Map<String, PlayerRenderer> getSkinMap() {
        return Collections.unmodifiableMap(this.field_178636_l);
    }
}

