/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.dispenser;

import java.util.List;
import java.util.Random;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CarvedPumpkinBlock;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.block.SkullBlock;
import net.minecraft.block.TNTBlock;
import net.minecraft.block.WitherSkeletonSkullBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.DispenseBoatBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.dispenser.OptionalDispenseBehavior;
import net.minecraft.dispenser.ProjectileDispenseBehavior;
import net.minecraft.dispenser.ShulkerBoxDispenseBehavior;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.ExperienceBottleEntity;
import net.minecraft.entity.item.FireworkRocketEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.entity.projectile.EggEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.entity.projectile.SmallFireballEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.entity.projectile.SpectralArrowEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.BoneMealItem;
import net.minecraft.item.BucketItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.FlintAndSteelItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.BeehiveTileEntity;
import net.minecraft.tileentity.DispenserTileEntity;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public interface IDispenseItemBehavior {
    public static final IDispenseItemBehavior field_223216_a_ = (p_210297_0_, p_210297_1_) -> p_210297_1_;

    public ItemStack dispense(IBlockSource var1, ItemStack var2);

    public static void func_218401_c() {
        DispenserBlock.func_199774_a((IItemProvider)Items.field_151032_g, (IDispenseItemBehavior)new ProjectileDispenseBehavior(){

            protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                ArrowEntity arrowentity = new ArrowEntity(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
                arrowentity.field_70251_a = AbstractArrowEntity.PickupStatus.ALLOWED;
                return arrowentity;
            }
        });
        DispenserBlock.func_199774_a((IItemProvider)Items.field_185167_i, (IDispenseItemBehavior)new ProjectileDispenseBehavior(){

            protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                ArrowEntity arrowentity = new ArrowEntity(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
                arrowentity.func_184555_a(stackIn);
                arrowentity.field_70251_a = AbstractArrowEntity.PickupStatus.ALLOWED;
                return arrowentity;
            }
        });
        DispenserBlock.func_199774_a((IItemProvider)Items.field_185166_h, (IDispenseItemBehavior)new ProjectileDispenseBehavior(){

            protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                SpectralArrowEntity abstractarrowentity = new SpectralArrowEntity(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
                abstractarrowentity.field_70251_a = AbstractArrowEntity.PickupStatus.ALLOWED;
                return abstractarrowentity;
            }
        });
        DispenserBlock.func_199774_a((IItemProvider)Items.field_151110_aK, (IDispenseItemBehavior)new ProjectileDispenseBehavior(){

            protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                return (IProjectile)Util.func_200696_a((Object)new EggEntity(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c()), p_218408_1_ -> p_218408_1_.func_213884_b(stackIn));
            }
        });
        DispenserBlock.func_199774_a((IItemProvider)Items.field_151126_ay, (IDispenseItemBehavior)new ProjectileDispenseBehavior(){

            protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                return (IProjectile)Util.func_200696_a((Object)new SnowballEntity(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c()), p_218409_1_ -> p_218409_1_.func_213884_b(stackIn));
            }
        });
        DispenserBlock.func_199774_a((IItemProvider)Items.field_151062_by, (IDispenseItemBehavior)new ProjectileDispenseBehavior(){

            protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                return (IProjectile)Util.func_200696_a((Object)new ExperienceBottleEntity(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c()), p_218410_1_ -> p_218410_1_.func_213884_b(stackIn));
            }

            protected float func_82498_a() {
                return super.func_82498_a() * 0.5f;
            }

            protected float func_82500_b() {
                return super.func_82500_b() * 1.25f;
            }
        });
        DispenserBlock.func_199774_a((IItemProvider)Items.field_185155_bH, (IDispenseItemBehavior)new IDispenseItemBehavior(){

            @Override
            public ItemStack dispense(IBlockSource p_dispense_1_, ItemStack p_dispense_2_) {
                return new ProjectileDispenseBehavior(){

                    protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                        return (IProjectile)Util.func_200696_a((Object)new PotionEntity(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c()), p_218411_1_ -> p_218411_1_.func_184541_a(stackIn));
                    }

                    protected float func_82498_a() {
                        return super.func_82498_a() * 0.5f;
                    }

                    protected float func_82500_b() {
                        return super.func_82500_b() * 1.25f;
                    }
                }.dispense(p_dispense_1_, p_dispense_2_);
            }
        });
        DispenserBlock.func_199774_a((IItemProvider)Items.field_185156_bI, (IDispenseItemBehavior)new IDispenseItemBehavior(){

            @Override
            public ItemStack dispense(IBlockSource p_dispense_1_, ItemStack p_dispense_2_) {
                return new ProjectileDispenseBehavior(){

                    protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                        return (IProjectile)Util.func_200696_a((Object)new PotionEntity(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c()), p_218413_1_ -> p_218413_1_.func_184541_a(stackIn));
                    }

                    protected float func_82498_a() {
                        return super.func_82498_a() * 0.5f;
                    }

                    protected float func_82500_b() {
                        return super.func_82500_b() * 1.25f;
                    }
                }.dispense(p_dispense_1_, p_dispense_2_);
            }
        });
        DefaultDispenseItemBehavior defaultdispenseitembehavior = new DefaultDispenseItemBehavior(){

            public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                Direction direction = (Direction)((Object)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a));
                EntityType entitytype = ((SpawnEggItem)stack.func_77973_b()).func_208076_b(stack.func_77978_p());
                entitytype.func_220331_a(source.func_197524_h(), stack, null, source.func_180699_d().func_177972_a(direction), SpawnReason.DISPENSER, direction != Direction.UP, false);
                stack.func_190918_g(1);
                return stack;
            }
        };
        for (SpawnEggItem spawneggitem : SpawnEggItem.func_195985_g()) {
            DispenserBlock.func_199774_a((IItemProvider)spawneggitem, (IDispenseItemBehavior)defaultdispenseitembehavior);
        }
        DispenserBlock.func_199774_a((IItemProvider)Items.field_179565_cj, (IDispenseItemBehavior)new DefaultDispenseItemBehavior(){

            public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                Direction direction = (Direction)((Object)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a));
                BlockPos blockpos = source.func_180699_d().func_177972_a(direction);
                World world = source.func_197524_h();
                ArmorStandEntity armorstandentity = new ArmorStandEntity(world, (double)blockpos.func_177958_n() + 0.5, blockpos.func_177956_o(), (double)blockpos.func_177952_p() + 0.5);
                EntityType.func_208048_a(world, null, armorstandentity, stack.func_77978_p());
                armorstandentity.field_70177_z = direction.func_185119_l();
                world.func_217376_c(armorstandentity);
                stack.func_190918_g(1);
                return stack;
            }
        });
        DispenserBlock.func_199774_a((IItemProvider)Items.field_196152_dE, (IDispenseItemBehavior)new DefaultDispenseItemBehavior(){

            public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                Direction direction = (Direction)((Object)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a));
                double d0 = direction.func_82601_c();
                double d1 = direction.func_96559_d();
                double d2 = direction.func_82599_e();
                double d3 = source.func_82615_a() + d0;
                double d4 = (float)source.func_180699_d().func_177956_o() + 0.2f;
                double d5 = source.func_82616_c() + d2;
                FireworkRocketEntity fireworkrocketentity = new FireworkRocketEntity(source.func_197524_h(), stack, d3, d4, d5, true);
                fireworkrocketentity.func_70186_c(d0, d1, d2, 0.5f, 1.0f);
                source.func_197524_h().func_217376_c(fireworkrocketentity);
                stack.func_190918_g(1);
                return stack;
            }

            protected void func_82485_a(IBlockSource source) {
                source.func_197524_h().func_217379_c(1004, source.func_180699_d(), 0);
            }
        });
        DispenserBlock.func_199774_a((IItemProvider)Items.field_151059_bz, (IDispenseItemBehavior)new DefaultDispenseItemBehavior(){

            public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                Direction direction = (Direction)((Object)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a));
                IPosition iposition = DispenserBlock.func_149939_a((IBlockSource)source);
                double d0 = iposition.func_82615_a() + (double)((float)direction.func_82601_c() * 0.3f);
                double d1 = iposition.func_82617_b() + (double)((float)direction.func_96559_d() * 0.3f);
                double d2 = iposition.func_82616_c() + (double)((float)direction.func_82599_e() * 0.3f);
                World world = source.func_197524_h();
                Random random = world.field_73012_v;
                double d3 = random.nextGaussian() * 0.05 + (double)direction.func_82601_c();
                double d4 = random.nextGaussian() * 0.05 + (double)direction.func_96559_d();
                double d5 = random.nextGaussian() * 0.05 + (double)direction.func_82599_e();
                world.func_217376_c((Entity)((Object)Util.func_200696_a((Object)((Object)new SmallFireballEntity(world, d0, d1, d2, d3, d4, d5)), p_229425_1_ -> p_229425_1_.func_213898_b(stack))));
                stack.func_190918_g(1);
                return stack;
            }

            protected void func_82485_a(IBlockSource source) {
                source.func_197524_h().func_217379_c(1018, source.func_180699_d(), 0);
            }
        });
        DispenserBlock.func_199774_a((IItemProvider)Items.field_151124_az, (IDispenseItemBehavior)new DispenseBoatBehavior(BoatEntity.Type.OAK));
        DispenserBlock.func_199774_a((IItemProvider)Items.field_185150_aH, (IDispenseItemBehavior)new DispenseBoatBehavior(BoatEntity.Type.SPRUCE));
        DispenserBlock.func_199774_a((IItemProvider)Items.field_185151_aI, (IDispenseItemBehavior)new DispenseBoatBehavior(BoatEntity.Type.BIRCH));
        DispenserBlock.func_199774_a((IItemProvider)Items.field_185152_aJ, (IDispenseItemBehavior)new DispenseBoatBehavior(BoatEntity.Type.JUNGLE));
        DispenserBlock.func_199774_a((IItemProvider)Items.field_185154_aL, (IDispenseItemBehavior)new DispenseBoatBehavior(BoatEntity.Type.DARK_OAK));
        DispenserBlock.func_199774_a((IItemProvider)Items.field_185153_aK, (IDispenseItemBehavior)new DispenseBoatBehavior(BoatEntity.Type.ACACIA));
        DefaultDispenseItemBehavior idispenseitembehavior = new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior field_218406_b = new DefaultDispenseItemBehavior();

            public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                BucketItem bucketitem = (BucketItem)stack.func_77973_b();
                BlockPos blockpos = source.func_180699_d().func_177972_a((Direction)((Object)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a)));
                World world = source.func_197524_h();
                if (bucketitem.func_180616_a(null, world, blockpos, null)) {
                    bucketitem.func_203792_a(world, stack, blockpos);
                    return new ItemStack(Items.field_151133_ar);
                }
                return this.field_218406_b.dispense(source, stack);
            }
        };
        DispenserBlock.func_199774_a((IItemProvider)Items.field_151129_at, (IDispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.func_199774_a((IItemProvider)Items.field_151131_as, (IDispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.func_199774_a((IItemProvider)Items.field_203796_aM, (IDispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.func_199774_a((IItemProvider)Items.field_203797_aN, (IDispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.func_199774_a((IItemProvider)Items.field_203795_aL, (IDispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.func_199774_a((IItemProvider)Items.field_204272_aO, (IDispenseItemBehavior)idispenseitembehavior);
        DispenserBlock.func_199774_a((IItemProvider)Items.field_151133_ar, (IDispenseItemBehavior)new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior field_229426_b_ = new DefaultDispenseItemBehavior();

            public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                BlockPos blockpos;
                World iworld = source.func_197524_h();
                BlockState blockstate = iworld.func_180495_p(blockpos = source.func_180699_d().func_177972_a((Direction)((Object)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a))));
                Block block = blockstate.func_177230_c();
                if (block instanceof IBucketPickupHandler) {
                    Fluid fluid = ((IBucketPickupHandler)block).func_204508_a((IWorld)iworld, blockpos, blockstate);
                    if (!(fluid instanceof FlowingFluid)) {
                        return super.func_82487_b(source, stack);
                    }
                    Item item = fluid.func_204524_b();
                    stack.func_190918_g(1);
                    if (stack.func_190926_b()) {
                        return new ItemStack(item);
                    }
                    if (((DispenserTileEntity)source.func_150835_j()).func_146019_a(new ItemStack(item)) < 0) {
                        this.field_229426_b_.dispense(source, new ItemStack(item));
                    }
                    return stack;
                }
                return super.func_82487_b(source, stack);
            }
        });
        DispenserBlock.func_199774_a((IItemProvider)Items.field_151033_d, (IDispenseItemBehavior)new OptionalDispenseBehavior(){

            protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                World world = source.func_197524_h();
                this.field_218407_b = true;
                BlockPos blockpos = source.func_180699_d().func_177972_a((Direction)((Object)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a)));
                BlockState blockstate = world.func_180495_p(blockpos);
                if (FlintAndSteelItem.func_219996_a(blockstate, world, blockpos)) {
                    world.func_175656_a(blockpos, Blocks.field_150480_ab.func_176223_P());
                } else if (FlintAndSteelItem.func_219997_a(blockstate)) {
                    world.func_175656_a(blockpos, (BlockState)((Object)blockstate.func_206870_a((IProperty)BlockStateProperties.field_208190_q, Boolean.valueOf(true))));
                } else if (blockstate.isFlammable((IBlockReader)((Object)world), blockpos, ((Direction)((Object)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a))).func_176734_d())) {
                    blockstate.catchFire(world, blockpos, ((Direction)((Object)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a))).func_176734_d(), null);
                    if (blockstate.func_177230_c() instanceof TNTBlock) {
                        world.func_217377_a(blockpos, false);
                    }
                } else {
                    this.field_218407_b = false;
                }
                if (this.field_218407_b && stack.func_96631_a(1, world.field_73012_v, null)) {
                    stack.func_190920_e(0);
                }
                return stack;
            }
        });
        DispenserBlock.func_199774_a((IItemProvider)Items.field_196106_bc, (IDispenseItemBehavior)new OptionalDispenseBehavior(){

            protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                BlockPos blockpos;
                this.field_218407_b = true;
                World world = source.func_197524_h();
                if (!BoneMealItem.func_195966_a(stack, world, blockpos = source.func_180699_d().func_177972_a((Direction)((Object)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a)))) && !BoneMealItem.func_203173_b(stack, world, blockpos, null)) {
                    this.field_218407_b = false;
                } else if (!world.field_72995_K) {
                    world.func_217379_c(2005, blockpos, 0);
                }
                return stack;
            }
        });
        DispenserBlock.func_199774_a((IItemProvider)Blocks.field_150335_W, (IDispenseItemBehavior)new DefaultDispenseItemBehavior(){

            protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                World world = source.func_197524_h();
                BlockPos blockpos = source.func_180699_d().func_177972_a((Direction)((Object)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a)));
                TNTEntity tntentity = new TNTEntity(world, (double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p() + 0.5, (LivingEntity)null);
                world.func_217376_c((Entity)tntentity);
                world.func_184148_a(null, tntentity.func_226277_ct_(), tntentity.func_226278_cu_(), tntentity.func_226281_cx_(), SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
                stack.func_190918_g(1);
                return stack;
            }
        });
        OptionalDispenseBehavior idispenseitembehavior1 = new OptionalDispenseBehavior(){

            protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                this.field_218407_b = ArmorItem.func_226626_a_(source, stack);
                return stack;
            }
        };
        DispenserBlock.func_199774_a((IItemProvider)Items.field_196185_dy, (IDispenseItemBehavior)idispenseitembehavior1);
        DispenserBlock.func_199774_a((IItemProvider)Items.field_196186_dz, (IDispenseItemBehavior)idispenseitembehavior1);
        DispenserBlock.func_199774_a((IItemProvider)Items.field_196151_dA, (IDispenseItemBehavior)idispenseitembehavior1);
        DispenserBlock.func_199774_a((IItemProvider)Items.field_196182_dv, (IDispenseItemBehavior)idispenseitembehavior1);
        DispenserBlock.func_199774_a((IItemProvider)Items.field_196184_dx, (IDispenseItemBehavior)idispenseitembehavior1);
        DispenserBlock.func_199774_a((IItemProvider)Items.field_196183_dw, (IDispenseItemBehavior)new OptionalDispenseBehavior(){

            protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                World world = source.func_197524_h();
                Direction direction = (Direction)((Object)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a));
                BlockPos blockpos = source.func_180699_d().func_177972_a(direction);
                if (world.func_175623_d(blockpos) && WitherSkeletonSkullBlock.func_196299_b((World)world, (BlockPos)blockpos, (ItemStack)stack)) {
                    world.func_180501_a(blockpos, (BlockState)((Object)Blocks.field_196705_eO.func_176223_P().func_206870_a((IProperty)SkullBlock.field_196294_a, Integer.valueOf(direction.func_176740_k() == Direction.Axis.Y ? 0 : direction.func_176734_d().func_176736_b() * 4))), 3);
                    TileEntity tileentity = world.func_175625_s(blockpos);
                    if (tileentity instanceof SkullTileEntity) {
                        WitherSkeletonSkullBlock.func_196298_a((World)world, (BlockPos)blockpos, (SkullTileEntity)((SkullTileEntity)tileentity));
                    }
                    stack.func_190918_g(1);
                    this.field_218407_b = true;
                } else {
                    this.field_218407_b = ArmorItem.func_226626_a_(source, stack);
                }
                return stack;
            }
        });
        DispenserBlock.func_199774_a((IItemProvider)Blocks.field_196625_cS, (IDispenseItemBehavior)new OptionalDispenseBehavior(){

            protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                World world = source.func_197524_h();
                BlockPos blockpos = source.func_180699_d().func_177972_a((Direction)((Object)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a)));
                CarvedPumpkinBlock carvedpumpkinblock = (CarvedPumpkinBlock)Blocks.field_196625_cS;
                if (world.func_175623_d(blockpos) && carvedpumpkinblock.func_196354_a((IWorldReader)world, blockpos)) {
                    if (!world.field_72995_K) {
                        world.func_180501_a(blockpos, carvedpumpkinblock.func_176223_P(), 3);
                    }
                    stack.func_190918_g(1);
                    this.field_218407_b = true;
                } else {
                    this.field_218407_b = ArmorItem.func_226626_a_(source, stack);
                }
                return stack;
            }
        });
        DispenserBlock.func_199774_a((IItemProvider)Blocks.field_204409_il.func_199767_j(), (IDispenseItemBehavior)new ShulkerBoxDispenseBehavior());
        for (DyeColor dyecolor : DyeColor.values()) {
            DispenserBlock.func_199774_a((IItemProvider)ShulkerBoxBlock.func_190952_a(dyecolor).func_199767_j(), (IDispenseItemBehavior)new ShulkerBoxDispenseBehavior());
        }
        DispenserBlock.func_199774_a((IItemProvider)Items.field_151069_bo.func_199767_j(), (IDispenseItemBehavior)new OptionalDispenseBehavior(){
            private final DefaultDispenseItemBehavior field_229423_c_ = new DefaultDispenseItemBehavior();

            private ItemStack func_229424_a_(IBlockSource p_229424_1_, ItemStack p_229424_2_, ItemStack p_229424_3_) {
                p_229424_2_.func_190918_g(1);
                if (p_229424_2_.func_190926_b()) {
                    return p_229424_3_.func_77946_l();
                }
                if (((DispenserTileEntity)p_229424_1_.func_150835_j()).func_146019_a(p_229424_3_.func_77946_l()) < 0) {
                    this.field_229423_c_.dispense(p_229424_1_, p_229424_3_.func_77946_l());
                }
                return p_229424_2_;
            }

            public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                BlockPos blockpos;
                this.field_218407_b = false;
                World iworld = source.func_197524_h();
                BlockState blockstate = iworld.func_180495_p(blockpos = source.func_180699_d().func_177972_a((Direction)((Object)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a))));
                Block block = blockstate.func_177230_c();
                if (block.func_203417_a(BlockTags.field_226151_aa_) && (Integer)blockstate.func_177229_b((IProperty)BeehiveBlock.field_226873_c_) >= 5) {
                    ((BeehiveBlock)blockstate.func_177230_c()).func_226877_a_(iworld.func_201672_e(), blockstate, blockpos, (PlayerEntity)null, BeehiveTileEntity.State.BEE_RELEASED);
                    this.field_218407_b = true;
                    return this.func_229424_a_(source, stack, new ItemStack(Items.field_226638_pX_));
                }
                if (iworld.func_204610_c(blockpos).func_206884_a(FluidTags.field_206959_a)) {
                    this.field_218407_b = true;
                    return this.func_229424_a_(source, stack, PotionUtils.func_185188_a((ItemStack)new ItemStack(Items.field_151068_bn), (Potion)Potions.field_185230_b));
                }
                return super.func_82487_b(source, stack);
            }
        });
        DispenserBlock.func_199774_a((IItemProvider)Items.field_151097_aZ.func_199767_j(), (IDispenseItemBehavior)new OptionalDispenseBehavior(){

            protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                World world = source.func_197524_h();
                if (!world.func_201670_d()) {
                    int i;
                    BlockState blockstate;
                    this.field_218407_b = false;
                    BlockPos blockpos = source.func_180699_d().func_177972_a((Direction)((Object)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a)));
                    for (Entity entity : world.func_175674_a(null, new AxisAlignedBB(blockpos), e -> !e.func_175149_v() && e instanceof IShearable)) {
                        IShearable target = (IShearable)entity;
                        if (!target.isShearable(stack, (IWorldReader)world, blockpos)) continue;
                        List drops = target.onSheared(stack, (IWorld)entity.field_70170_p, blockpos, EnchantmentHelper.func_77506_a(Enchantments.field_185308_t, stack));
                        Random rand = new Random();
                        drops.forEach(d -> {
                            ItemEntity ent = entity.func_70099_a((ItemStack)((Object)d), 1.0f);
                            ent.func_213317_d(ent.func_213322_ci().func_72441_c((rand.nextFloat() - rand.nextFloat()) * 0.1f, rand.nextFloat() * 0.05f, (rand.nextFloat() - rand.nextFloat()) * 0.1f));
                        });
                        if (stack.func_96631_a(1, world.field_73012_v, null)) {
                            stack.func_190920_e(0);
                        }
                        this.field_218407_b = true;
                        break;
                    }
                    if (!this.field_218407_b && (blockstate = world.func_180495_p(blockpos)).func_203425_a(BlockTags.field_226151_aa_) && (i = ((Integer)blockstate.func_177229_b((IProperty)BeehiveBlock.field_226873_c_)).intValue()) >= 5) {
                        if (stack.func_96631_a(1, world.field_73012_v, null)) {
                            stack.func_190920_e(0);
                        }
                        BeehiveBlock.func_226878_a_((World)world, (BlockPos)blockpos);
                        ((BeehiveBlock)blockstate.func_177230_c()).func_226877_a_(world, blockstate, blockpos, (PlayerEntity)null, BeehiveTileEntity.State.BEE_RELEASED);
                        this.field_218407_b = true;
                    }
                }
                return stack;
            }
        });
    }
}

